/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.swing.document;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class WindowsFilenameDocument
extends PlainDocument {
    private int maxLen;
    private boolean inputMode;

    public WindowsFilenameDocument(int n, boolean bl) {
        this.maxLen = n;
        this.inputMode = bl;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.maxLen - 1 < this.getLength()) {
            return;
        }
        if (!WindowsFilenameDocument.isFileNameFormat(string, this.inputMode)) {
            return;
        }
        super.insertString(n, string, attributeSet);
    }

    public static boolean isFileNameFormat(String string, boolean bl) {
        if (string.length() == 0) {
            return true;
        }
        Pattern pattern = bl ? Pattern.compile("[/:?\"<>|*]") : Pattern.compile("[/:?\"<>|\\\\*]");
        Matcher matcher = pattern.matcher(string);
        return !matcher.find();
    }
}

