/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.ACCEL;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUBARINFO;
import org.eclipse.swt.internal.win32.MENUINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    long hBitmap;
    int id;
    int accelerator;
    int userId;
    int index;
    ToolTip itemToolTip;
    static final int MARGIN_WIDTH = OS.IsWin95 ? 2 : 1;
    static final int MARGIN_HEIGHT = OS.IsWin95 ? 2 : 1;

    public MenuItem(Menu menu, int n) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.index = menu.getItemCount();
        menu.createItem(this, this.index);
    }

    public MenuItem(Menu menu, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.index = n2;
        menu.createItem(this, this.index);
    }

    MenuItem(Menu menu, Menu menu2, int n, int n2) {
        super(menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.menu = menu2;
        this.index = n2;
        if (menu2 != null) {
            menu2.cascade = this;
        }
        this.display.addMenuItem(this);
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n) {
        return MenuItem.checkBits(n, 8, 32, 16, 2, 64, 0);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    boolean fillAccel(ACCEL aCCEL) {
        aCCEL.fVirt = 0;
        aCCEL.cmd = aCCEL.key = (short)0;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return false;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return false;
        }
        boolean bl = true;
        int n = this.accelerator & 0x100FFFF;
        int n2 = Display.untranslateKey(n);
        if (n2 != 0) {
            n = n2;
        } else {
            switch (n) {
                case 27: {
                    n = 27;
                    break;
                }
                case 127: {
                    n = 46;
                    break;
                }
                default: {
                    n = Display.wcsToMbcs((char)n);
                    if (n == 0) {
                        return false;
                    }
                    if (OS.IsWinCE) {
                        n = (int)OS.CharUpper((short)n);
                        break;
                    }
                    n2 = OS.VkKeyScan((short)n);
                    if (n2 == -1) {
                        if (n == (int)OS.CharUpper((short)n)) break;
                        bl = false;
                        break;
                    }
                    n = n2 & 0xFF;
                }
            }
        }
        aCCEL.key = (short)n;
        aCCEL.cmd = (short)this.id;
        aCCEL.fVirt = (byte)(bl ? 1 : 0);
        if ((this.accelerator & 0x10000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 0x10);
        }
        if ((this.accelerator & 0x20000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 4);
        }
        if ((this.accelerator & 0x40000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 8);
        }
        return true;
    }

    void fixMenus(Decorations decorations) {
        if (this.menu != null) {
            this.menu.fixMenus(decorations);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        if ((this.parent.style & 2) != 0) {
            Decorations decorations = this.parent.parent;
            if (decorations.menuBar != this.parent) {
                return new Rectangle(0, 0, 0, 0);
            }
            long l = decorations.handle;
            MENUBARINFO mENUBARINFO = new MENUBARINFO();
            mENUBARINFO.cbSize = MENUBARINFO.sizeof;
            if (!OS.GetMenuBarInfo(l, -3, 1, mENUBARINFO)) {
                return new Rectangle(0, 0, 0, 0);
            }
            MENUBARINFO mENUBARINFO2 = new MENUBARINFO();
            mENUBARINFO2.cbSize = MENUBARINFO.sizeof;
            if (!OS.GetMenuBarInfo(l, -3, n + 1, mENUBARINFO2)) {
                return new Rectangle(0, 0, 0, 0);
            }
            int n2 = mENUBARINFO2.left - mENUBARINFO.left;
            int n3 = mENUBARINFO2.top - mENUBARINFO.top;
            int n4 = mENUBARINFO2.right - mENUBARINFO2.left;
            int n5 = mENUBARINFO2.bottom - mENUBARINFO2.top;
            return new Rectangle(n2, n3, n4, n5);
        }
        long l = this.parent.handle;
        RECT rECT = new RECT();
        if (!OS.GetMenuItemRect(0L, l, 0, rECT)) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT2 = new RECT();
        if (!OS.GetMenuItemRect(0L, l, n, rECT2)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n6 = rECT2.left - rECT.left + 2;
        int n7 = rECT2.top - rECT.top + 2;
        int n8 = rECT2.right - rECT2.left;
        int n9 = rECT2.bottom - rECT2.top;
        return new Rectangle(n6, n7, n8, n9);
    }

    public boolean getEnabled() {
        boolean bl;
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0L) {
            long l = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 4;
            OS.SendMessage(l, OS.TB_GETBUTTONINFO, (long)this.id, tBBUTTONINFO);
            return (tBBUTTONINFO.fsState & 4) != 0;
        }
        if ((this.style & 2) != 0) {
            return (this.state & 8) == 0;
        }
        long l = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        if (OS.IsWinCE) {
            int n = this.parent.indexOf(this);
            if (n == -1) {
                this.error(31);
            }
            bl = OS.GetMenuItemInfo(l, n, true, mENUITEMINFO);
        } else {
            bl = OS.GetMenuItemInfo(l, this.id, false, mENUITEMINFO);
        }
        if (!bl) {
            this.error(31);
        }
        return (mENUITEMINFO.fState & 3) == 0;
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    @Override
    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    @Override
    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0L) {
            return false;
        }
        long l = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        boolean bl = OS.GetMenuItemInfo(l, this.id, false, mENUITEMINFO);
        if (!bl) {
            this.error(9);
        }
        return (mENUITEMINFO.fState & 8) != 0;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.itemToolTip == null ? null : this.itemToolTip.getMessage();
    }

    void hideToolTip() {
        if (this.itemToolTip == null) {
            return;
        }
        this.itemToolTip.setVisible(false);
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    @Override
    void releaseChildren(boolean bl) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.id = -1;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.hBitmap != 0L) {
            OS.DeleteObject(this.hBitmap);
        }
        this.hBitmap = 0L;
        if (this.accelerator != 0) {
            this.parent.destroyAccelerators();
        }
        this.accelerator = 0;
        this.display.removeMenuItem(this);
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    @Override
    void reskinChildren(int n) {
        if (this.menu != null) {
            this.menu.reskin(n);
        }
        super.reskinChildren(n);
    }

    void selectRadio() {
        MenuItem[] menuItemArray = this.parent.getItems();
        for (int i = 0; i < menuItemArray.length && menuItemArray[i] != this; ++i) {
        }
        for (int i = i - 1; i >= 0 && menuItemArray[i].setRadioSelection(false); --i) {
        }
        for (int i = i + 1; i < menuItemArray.length && menuItemArray[i].setRadioSelection(false); ++i) {
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n) {
        this.checkWidget();
        if (this.accelerator == n) {
            return;
        }
        this.accelerator = n;
        this.parent.destroyAccelerators();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0L) {
            long l = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 4;
            OS.SendMessage(l, OS.TB_GETBUTTONINFO, (long)this.id, tBBUTTONINFO);
            tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState & 0xFFFFFFFB);
            if (bl) {
                tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState | 4);
            }
            OS.SendMessage(l, OS.TB_SETBUTTONINFO, (long)this.id, tBBUTTONINFO);
        } else {
            if ((this.style & 2) != 0) {
                this.state = bl ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
            }
            long l = this.parent.handle;
            if (OS.IsWinCE) {
                int n = this.parent.indexOf(this);
                if (n == -1) {
                    return;
                }
                int n2 = 0x400 | (bl ? 0 : 1);
                OS.EnableMenuItem(l, n, n2);
            } else {
                int n;
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 1;
                boolean bl2 = OS.GetMenuItemInfo(l, this.id, false, mENUITEMINFO);
                if (!bl2) {
                    n = OS.GetLastError();
                    SWT.error(30, null, " [GetLastError=0x" + Integer.toHexString(n) + "]");
                }
                n = 3;
                if (bl) {
                    if ((mENUITEMINFO.fState & n) == 0) {
                        return;
                    }
                    mENUITEMINFO.fState &= ~n;
                } else {
                    if ((mENUITEMINFO.fState & n) == n) {
                        return;
                    }
                    mENUITEMINFO.fState |= n;
                }
                bl2 = OS.SetMenuItemInfo(l, this.id, false, mENUITEMINFO);
                if (!bl2) {
                    if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                        boolean bl3 = bl2 = this.id == OS.GetMenuDefaultItem(l, 0, 1);
                    }
                    if (!bl2) {
                        int n3 = OS.GetLastError();
                        SWT.error(30, null, " [GetLastError=0x" + Integer.toHexString(n3) + "]");
                    }
                }
            }
        }
        this.parent.destroyAccelerators();
        this.parent.redraw();
    }

    public void setID(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        this.userId = n;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (OS.IsWinCE) {
            if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0L) {
                long l = this.parent.hwndCB;
                TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                tBBUTTONINFO.dwMask = 1;
                tBBUTTONINFO.iImage = this.parent.imageIndex(image);
                OS.SendMessage(l, OS.TB_SETBUTTONINFO, (long)this.id, tBBUTTONINFO);
            }
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 128;
        if (this.parent.foreground != -1) {
            mENUITEMINFO.hbmpItem = -1L;
        } else if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && OS.IsAppThemed()) {
            if (this.hBitmap != 0L) {
                OS.DeleteObject(this.hBitmap);
            }
            this.hBitmap = image != null ? Display.create32bitDIB(image) : 0L;
            mENUITEMINFO.hbmpItem = this.hBitmap;
        } else {
            mENUITEMINFO.hbmpItem = image != null ? -1L : 0L;
        }
        long l = this.parent.handle;
        OS.SetMenuItemInfo(l, this.id, false, mENUITEMINFO);
        this.parent.redraw();
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        this.setMenu(menu, false);
    }

    void setMenu(Menu menu, boolean bl) {
        Menu menu2 = this.menu;
        if (menu2 == menu) {
            return;
        }
        if (menu2 != null) {
            menu2.cascade = null;
        }
        this.menu = menu;
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0L) {
            if (OS.IsPPC) {
                long l = this.parent.hwndCB;
                long l2 = menu == null ? 0L : menu.handle;
                OS.SendMessage(l, 1424, (long)this.id, l2);
            }
            if (OS.IsSP) {
                this.error(29);
            }
        } else {
            long l = this.parent.handle;
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 32;
            int n = 0;
            while (OS.GetMenuItemInfo(l, n, true, mENUITEMINFO) && mENUITEMINFO.dwItemData != (long)this.id) {
                ++n;
            }
            if (mENUITEMINFO.dwItemData != (long)this.id) {
                return;
            }
            int n2 = 128;
            long l3 = OS.GetProcessHeap();
            int n3 = n2 * TCHAR.sizeof;
            long l4 = OS.HeapAlloc(l3, 8, n3);
            mENUITEMINFO.fMask = 35;
            mENUITEMINFO.fMask = !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) ? (mENUITEMINFO.fMask |= 0xC0) : (mENUITEMINFO.fMask |= 0x10);
            mENUITEMINFO.dwTypeData = l4;
            mENUITEMINFO.cch = n2;
            boolean bl2 = OS.GetMenuItemInfo(l, n, true, mENUITEMINFO);
            if (menu != null) {
                menu.cascade = this;
                mENUITEMINFO.fMask |= 4;
                mENUITEMINFO.hSubMenu = menu.handle;
            }
            if (OS.IsWinCE) {
                TCHAR tCHAR;
                OS.RemoveMenu(l, n, 1024);
                long l5 = this.id;
                int n4 = 1024;
                if (menu != null) {
                    n4 |= 0x10;
                    l5 = menu.handle;
                }
                if (bl2 = OS.InsertMenu(l, n, n4, l5, tCHAR = new TCHAR(0, " ", true))) {
                    mENUITEMINFO.fMask = 48;
                    bl2 = OS.SetMenuItemInfo(l, n, true, mENUITEMINFO);
                    if ((mENUITEMINFO.fState & 3) != 0) {
                        OS.EnableMenuItem(l, n, 1025);
                    }
                    if ((mENUITEMINFO.fState & 8) != 0) {
                        OS.CheckMenuItem(l, n, 1032);
                    }
                }
            } else if (bl || menu2 == null) {
                bl2 = OS.SetMenuItemInfo(l, n, true, mENUITEMINFO);
            } else {
                OS.RemoveMenu(l, n, 1024);
                bl2 = OS.InsertMenuItem(l, n, true, mENUITEMINFO);
            }
            if (l4 != 0L) {
                OS.HeapFree(l3, 0, l4);
            }
            if (!bl2) {
                int n5 = OS.GetLastError();
                SWT.error(29, null, " [GetLastError=0x" + Integer.toHexString(n5) + "]");
            }
        }
        this.parent.destroyAccelerators();
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    void setOrientation(int n) {
        long l = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 256;
        mENUITEMINFO.fType = this.widgetStyle();
        OS.SetMenuItemInfo(l, this.id, false, mENUITEMINFO);
        if (this.menu != null) {
            this.menu._setOrientation(n);
        }
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0L) {
            return;
        }
        long l = this.parent.handle;
        if (OS.IsWinCE) {
            int n = this.parent.indexOf(this);
            if (n == -1) {
                return;
            }
            int n2 = 0x400 | (bl ? 8 : 0);
            OS.CheckMenuItem(l, n, n2);
        } else {
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 1;
            boolean bl2 = OS.GetMenuItemInfo(l, this.id, false, mENUITEMINFO);
            if (!bl2) {
                this.error(28);
            }
            mENUITEMINFO.fState &= 0xFFFFFFF7;
            if (bl) {
                mENUITEMINFO.fState |= 8;
            }
            if (!(bl2 = OS.SetMenuItemInfo(l, this.id, false, mENUITEMINFO))) {
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    boolean bl3 = bl2 = this.id == OS.GetMenuDefaultItem(l, 0, 1);
                }
                if (!bl2) {
                    int n = OS.GetLastError();
                    SWT.error(28, null, " [GetLastError=0x" + Integer.toHexString(n) + "]");
                }
            }
        }
        this.parent.redraw();
    }

    @Override
    public void setText(String string) {
        Object object;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        long l = OS.GetProcessHeap();
        long l2 = 0L;
        boolean bl = false;
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0L) {
            if (string.indexOf(38) != -1) {
                int n = string.length();
                char[] cArray = new char[n];
                string.getChars(0, n, cArray, 0);
                int n2 = 0;
                int n3 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    if (cArray[n2] == '&') continue;
                    cArray[n3++] = cArray[n2];
                }
                if (n3 < n2) {
                    string = new String(cArray, 0, n3);
                }
            }
            object = new TCHAR(0, string, true);
            int n = ((TCHAR)object).length() * TCHAR.sizeof;
            l2 = OS.HeapAlloc(l, 8, n);
            OS.MoveMemory(l2, (TCHAR)object, n);
            long l3 = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 2;
            tBBUTTONINFO.pszText = l2;
            bl = OS.SendMessage(l3, OS.TB_SETBUTTONINFO, (long)this.id, tBBUTTONINFO) != 0L;
        } else {
            object = new MENUITEMINFO();
            ((MENUITEMINFO)object).cbSize = MENUITEMINFO.sizeof;
            long l4 = this.parent.handle;
            TCHAR tCHAR = new TCHAR(0, string, true);
            int n = tCHAR.length() * TCHAR.sizeof;
            l2 = OS.HeapAlloc(l, 8, n);
            OS.MoveMemory(l2, tCHAR, n);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
                ((MENUITEMINFO)object).fMask = 64;
            } else {
                ((MENUITEMINFO)object).fMask = 16;
                ((MENUITEMINFO)object).fType = this.widgetStyle();
            }
            ((MENUITEMINFO)object).dwTypeData = l2;
            bl = OS.SetMenuItemInfo(l4, this.id, false, (MENUITEMINFO)object);
        }
        if (l2 != 0L) {
            OS.HeapFree(l, 0, l2);
        }
        if (!bl) {
            int n = OS.GetLastError();
            SWT.error(13, null, " [GetLastError=0x" + Integer.toHexString(n) + "]");
        }
        this.parent.redraw();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string == null && this.itemToolTip != null) {
            this.itemToolTip.setVisible(false);
            this.itemToolTip = null;
        }
        if (string == null || string.trim().length() == 0 || this.itemToolTip != null && string.equals(this.itemToolTip.getMessage())) {
            return;
        }
        this.itemToolTip = new MenuItemToolTip(this.getParent().getShell());
        this.itemToolTip.setMessage(string);
        this.itemToolTip.setVisible(false);
    }

    void showTooltip(int n, int n2) {
        if (this.itemToolTip == null) {
            return;
        }
        this.itemToolTip.setLocationInPixels(n, n2);
        this.itemToolTip.setVisible(true);
    }

    int widgetStyle() {
        int n = 0;
        Decorations decorations = this.parent.parent;
        if ((decorations.style & 0x8000000) != 0) {
            if ((this.parent.style & 0x2000000) != 0) {
                n |= 0x6000;
            }
        } else if ((this.parent.style & 0x4000000) != 0) {
            n |= 0x6000;
        }
        if ((this.style & 2) != 0) {
            return n | 0x800;
        }
        if ((this.style & 0x10) != 0) {
            return n | 0x200;
        }
        return n | 0;
    }

    LRESULT wmCommandChild(long l, long l2) {
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        } else if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.getSelection());
            } else {
                this.selectRadio();
            }
        }
        this.sendSelectionEvent(13);
        return null;
    }

    LRESULT wmDrawChild(long l, long l2) {
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, l2, DRAWITEMSTRUCT.sizeof);
        if (this.image != null) {
            GCData gCData = new GCData();
            gCData.device = this.display;
            GC gC = GC.win32_new(dRAWITEMSTRUCT.hDC, gCData);
            int n = (this.parent.style & 2) != 0 ? MARGIN_WIDTH * 2 : dRAWITEMSTRUCT.left;
            Image image = this.getEnabled() ? this.image : new Image((Device)this.display, this.image, 1);
            gC.drawImage(image, DPIUtil.autoScaleDown(n), DPIUtil.autoScaleDown(dRAWITEMSTRUCT.top + MARGIN_HEIGHT));
            if (this.image != image) {
                image.dispose();
            }
            gC.dispose();
        }
        if (this.parent.foreground != -1) {
            OS.SetTextColor(dRAWITEMSTRUCT.hDC, this.parent.foreground);
        }
        return null;
    }

    LRESULT wmMeasureChild(long l, long l2) {
        MEASUREITEMSTRUCT mEASUREITEMSTRUCT = new MEASUREITEMSTRUCT();
        OS.MoveMemory(mEASUREITEMSTRUCT, l2, MEASUREITEMSTRUCT.sizeof);
        int n = 0;
        int n2 = 0;
        if (this.image != null) {
            Rectangle rectangle = this.image.getBoundsInPixels();
            n = rectangle.width;
            n2 = rectangle.height;
        } else {
            MENUINFO mENUINFO = new MENUINFO();
            mENUINFO.cbSize = MENUINFO.sizeof;
            mENUINFO.fMask = 16;
            long l3 = this.parent.handle;
            OS.GetMenuInfo(l3, mENUINFO);
            if ((mENUINFO.dwStyle & 0x4000000) == 0) {
                MenuItem[] menuItemArray = this.parent.getItems();
                for (int i = 0; i < menuItemArray.length; ++i) {
                    MenuItem menuItem = menuItemArray[i];
                    if (menuItem.image == null) continue;
                    Rectangle rectangle = menuItem.image.getBoundsInPixels();
                    n = Math.max(n, rectangle.width);
                }
            }
        }
        if (n != 0 || n2 != 0) {
            mEASUREITEMSTRUCT.itemWidth = n + MARGIN_WIDTH * 2;
            mEASUREITEMSTRUCT.itemHeight = n2 + MARGIN_HEIGHT * 2;
            OS.MoveMemory(l2, mEASUREITEMSTRUCT, MEASUREITEMSTRUCT.sizeof);
        }
        return null;
    }

    private static final class MenuItemToolTip
    extends ToolTip {
        public MenuItemToolTip(Shell shell) {
            super(shell, 0);
        }

        @Override
        long hwndToolTip() {
            return this.parent.menuItemToolTipHandle();
        }
    }
}

