/*
 * Decompiled with CFR 0.152.
 */
package com.jblend.kdwp;

import com.jblend.kdwp.MemoryMapFrameInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MemoryMapFrame
extends JFrame
implements ActionListener {
    public MemoryMapFrameInterface debugProxy = null;
    final String strStart = new String("Start");
    final String strStop = new String("Stop");
    final String strRefresh = new String("Refresh");
    final String strSort = new String("Sort by Address");
    final String strLogName = new String("MemoryLog.txt");
    final String strAddress = new String("Address:");
    final String strSize = new String(" Size:");
    final int cellSize = 4;
    final int repaintInterval = 100;
    final int listBufferSize = 1000;
    final String[] strTypeList = new String[]{"FREE", "NOPOINTERS", "INSTANCE", "ARRAY", "OBJECTARRAY", "METHODTABLE", "POINTERLIST", "EXECSTACK", "THREAD", "MONITOR", "WEAK POINTERLIST", "PERMANENT", "JBALLOC"};
    final Color[] color = new Color[]{Color.blue, Color.red, Color.magenta, Color.magenta, Color.magenta, Color.green, Color.cyan, Color.cyan, Color.cyan, Color.cyan, Color.gray, Color.red, Color.red, Color.black};
    final String[][] strHelp = new String[][]{{"Blue", "Free Area"}, {"Red", "Objects which have no pointers"}, {"Magenta", "Java-level objects"}, {"Green", "For static roots"}, {"Cyan", "Internal VM objects"}, {"Gray", "Weak pointer list"}, {"White", "Out of heap"}};
    final Color[] colorHelp = new Color[]{Color.blue, Color.red, Color.magenta, Color.green, Color.cyan, Color.gray, Color.white};
    JButton startButton;
    JButton stopButton;
    JButton refreshButton;
    JButton sortButton;
    DefaultListModel model;
    JList list;
    JPanel mapPanel;
    JTabbedPane tabbedPane;
    JCheckBox logCheckBox;
    byte[] abHeap;
    String[] listBuffer;
    String[] dateBuffer;
    Map typeToColor = new HashMap();
    int listBufferNum = 0;
    int nHeapAddress = 0;
    int nHeapSize = 0;
    boolean repaintFlag = false;
    boolean flushListFlag = false;
    boolean alreadyStart = false;

    public MemoryMapFrame() {
        for (int i = 0; i < this.strTypeList.length; ++i) {
            this.typeToColor.put(this.strTypeList[i], String.valueOf(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        MemoryMapFrame memoryMapFrame = this;
        synchronized (memoryMapFrame) {
            if (!this.alreadyStart) {
                this.alreadyStart = true;
                this.setTitle("Memory Map");
                this.setSize(500, 400);
                this.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                this.startButton = new JButton(this.strStart);
                this.stopButton = new JButton(this.strStop);
                this.refreshButton = new JButton(this.strRefresh);
                this.sortButton = new JButton(this.strSort);
                this.model = new DefaultListModel();
                this.list = new JList(this.model);
                this.mapPanel = new MapPanel();
                this.tabbedPane = new JTabbedPane();
                this.listBuffer = new String[1000];
                this.dateBuffer = new String[1000];
                this.logCheckBox = new JCheckBox("Output '" + this.strLogName + "' as Log File");
                this.list.setSelectionMode(0);
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.getViewport().setView(this.list);
                this.logCheckBox.setHorizontalAlignment(0);
                this.logCheckBox.setVerticalAlignment(0);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                JLabel jLabel = new JLabel("Map View's Help");
                jLabel.setForeground(Color.black);
                jLabel.setHorizontalAlignment(2);
                jPanel.add(jLabel);
                for (int i = 0; i < this.strHelp.length; ++i) {
                    jLabel = new JLabel(this.strHelp[i][0]);
                    jLabel.setForeground(this.colorHelp[i]);
                    jPanel.add(jLabel);
                    jLabel = new JLabel("          " + this.strHelp[i][1]);
                    jLabel.setForeground(Color.black);
                    jPanel.add(jLabel);
                }
                jLabel = new JLabel("1 pixel = 4 bytes");
                jLabel.setForeground(Color.black);
                jPanel.add(jLabel);
                this.tabbedPane.addTab("List", jScrollPane);
                this.tabbedPane.addTab("Map", this.mapPanel);
                this.tabbedPane.addTab("Log", this.logCheckBox);
                this.tabbedPane.addTab("Help", jPanel);
                JPanel jPanel2 = new JPanel();
                jPanel2.add(this.startButton);
                jPanel2.add(this.stopButton);
                jPanel2.add(this.refreshButton);
                jPanel2.add(this.sortButton);
                this.stopButton.setEnabled(false);
                this.refreshButton.setEnabled(false);
                Container container = this.getContentPane();
                container.add((Component)this.tabbedPane, "Center");
                container.add((Component)jPanel2, "South");
                this.startButton.addActionListener(this);
                this.stopButton.addActionListener(this);
                this.refreshButton.addActionListener(this);
                this.sortButton.addActionListener(this);
                this.tabbedPane.addChangeListener(new TabbedPaneListener());
                new Timer(100, new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (MemoryMapFrame.this.flushListFlag) {
                            MemoryMapFrame.this.flushListFlag = false;
                            DefaultListModel defaultListModel = MemoryMapFrame.this.model;
                            synchronized (defaultListModel) {
                                MemoryMapFrame.this.flushList(true);
                            }
                            if (MemoryMapFrame.this.repaintFlag) {
                                MemoryMapFrame.this.repaintFlag = false;
                                MemoryMapFrame.this.mapPanel.repaint();
                            }
                        } else {
                            if (!MemoryMapFrame.this.tabbedPane.isVisible()) {
                                MemoryMapFrame.this.tabbedPane.setVisible(true);
                            }
                            if (!(MemoryMapFrame.this.refreshButton.isEnabled() || MemoryMapFrame.this.startButton.isEnabled() || MemoryMapFrame.this.stopButton.isEnabled())) {
                                MemoryMapFrame.this.refreshButton.setEnabled(true);
                                MemoryMapFrame.this.stopButton.setEnabled(true);
                            }
                        }
                    }
                }).start();
                this.setVisible(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(this.strStart)) {
            if (this.debugProxy != null) {
                this.debugProxy.startMemoryMap();
                this.startButton.setEnabled(false);
                this.stopButton.setEnabled(true);
                this.refreshButton.setEnabled(true);
            }
        } else if (string.equals(this.strStop)) {
            if (this.debugProxy != null) {
                this.debugProxy.stopMemoryMap();
                this.startButton.setEnabled(true);
                this.stopButton.setEnabled(false);
                this.refreshButton.setEnabled(false);
            }
        } else if (string.equals(this.strRefresh)) {
            if (this.debugProxy != null) {
                this.debugProxy.refreshMemoryMap();
            }
        } else if (string.equals(this.strSort)) {
            DefaultListModel defaultListModel = this.model;
            synchronized (defaultListModel) {
                int n = this.model.getSize();
                if (n >= 2) {
                    int n2;
                    String[] stringArray = new String[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        stringArray[n2] = (String)this.model.getElementAt(n2);
                    }
                    this.sort(0, n - 1, stringArray);
                    this.model.clear();
                    n2 = -1;
                    for (int i = 0; i < n; ++i) {
                        if (n2 >= 0 && stringArray[i].equals(stringArray[n2])) continue;
                        this.model.addElement(stringArray[i]);
                        n2 = i;
                    }
                }
            }
        }
    }

    private void sort(int n, int n2, String[] stringArray) {
        int n3 = this.extractAddress(stringArray[(n + n2) / 2]);
        int n4 = n;
        int n5 = n2;
        block0: while (n4 <= n5) {
            while (n3 > this.extractAddress(stringArray[n4])) {
                if (++n4 <= n5) continue;
                break block0;
            }
            while (n3 < this.extractAddress(stringArray[n5])) {
                if (--n5 >= n4) continue;
                break block0;
            }
            if (n4 < n5) {
                String string = stringArray[n4];
                stringArray[n4++] = stringArray[n5];
                stringArray[n5--] = string;
            }
            if (n4 != n5 || n3 != this.extractAddress(stringArray[n4])) continue;
        }
        if (n < n4 - 1) {
            this.sort(n, n4 - 1, stringArray);
        }
        if (n2 > n5 + 1) {
            this.sort(n5 + 1, n2, stringArray);
        }
    }

    private int extractAddress(String string) {
        int n;
        int n2 = 0;
        if (string.indexOf(this.strAddress) == 0 && (n = string.indexOf(" ", this.strAddress.length())) > 0) {
            n2 = Integer.parseInt(string.substring(this.strAddress.length(), n));
        }
        return n2;
    }

    private int extractSize(String string) {
        int n;
        int n2 = 0;
        int n3 = string.indexOf(this.strSize);
        if (n3 > 0 && (n = string.indexOf(" ", n3 += this.strSize.length())) > 0) {
            n2 = Integer.parseInt(string.substring(n3, n));
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, int n2, String string, String string2, String string3, long l) {
        DefaultListModel defaultListModel = this.model;
        synchronized (defaultListModel) {
            if (this.listBufferNum >= 1000) {
                this.flushList(true);
            }
            this.dateBuffer[this.listBufferNum] = System.currentTimeMillis() + " " + l;
            this.listBuffer[this.listBufferNum++] = this.strAddress + n + this.strSize + n2 + " " + string2 + "/" + string3;
            if (this.nHeapSize > 0 && n >= this.nHeapAddress && n + n2 <= this.nHeapAddress + this.nHeapSize * 4) {
                int n3 = (n - this.nHeapAddress) / 4;
                int n4 = this.convStrIntoType(string);
                for (int i = n2 / 4; i > 0; --i) {
                    if (n4 < 0 || n4 > 11) {
                        n4 = 12;
                    }
                    this.abHeap[n3++] = (byte)n4;
                }
            }
        }
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.repaintFlag = true;
        }
        this.flushListFlag = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        if (this.logCheckBox.isSelected()) {
            this.add(0, 0, null, this.strRefresh, "GC", 0L);
        }
        DefaultListModel defaultListModel = this.model;
        synchronized (defaultListModel) {
            this.flushList(false);
            if (this.refreshButton.isEnabled()) {
                this.stopButton.setEnabled(false);
                this.refreshButton.setEnabled(false);
            }
            this.model.clear();
            for (int i = 0; i < this.nHeapSize; ++i) {
                this.abHeap[i] = 0;
            }
        }
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.mapPanel.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n, int n2) {
        if (this.logCheckBox.isSelected()) {
            this.add(n, n2, null, this.strRefresh, "GC", 0L);
        }
        DefaultListModel defaultListModel = this.model;
        synchronized (defaultListModel) {
            int n3;
            this.flushList(false);
            Vector<String> vector = new Vector<String>();
            int n4 = this.model.size();
            for (n3 = 0; n3 < n4; ++n3) {
                int n5;
                String string = (String)this.model.get(n3);
                int n6 = this.extractAddress(string);
                if (n6 + (n5 = this.extractSize(string)) > n && n + n2 > n6) continue;
                vector.addElement(string);
            }
            n4 = vector.size();
            this.model.clear();
            for (n3 = 0; n3 < n4; ++n3) {
                this.model.addElement(vector.get(n3));
            }
            n3 = (n - this.nHeapAddress) / 4;
            for (int i = n2 / 4; i > 0; --i) {
                this.abHeap[n3++] = 0;
            }
        }
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.mapPanel.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMap(int n, int n2) {
        int n3 = n2 / 4;
        if (n3 > 0) {
            DefaultListModel defaultListModel = this.model;
            synchronized (defaultListModel) {
                this.nHeapAddress = n;
                this.nHeapSize = n3;
                this.abHeap = new byte[n3];
            }
        }
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.mapPanel.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void flushList(boolean var1_1) {
        block14: {
            if (var1_1) {
                var2_2 = this.model.getSize();
                var3_4 = this.list.getSelectedIndex();
                for (var4_6 = 0; var4_6 < this.listBufferNum; ++var4_6) {
                    this.model.addElement(this.listBuffer[var4_6]);
                }
                if (var3_4 >= 0 && var3_4 == var2_2 - 1) {
                    var4_6 = var3_4 + this.listBufferNum;
                    this.list.setSelectedIndex(var4_6);
                    this.list.ensureIndexIsVisible(var4_6);
                }
            }
            if (this.logCheckBox.isSelected()) {
                var2_3 = null;
                try {
                    try {
                        var2_3 = new FileWriter(this.strLogName, true);
                        for (var3_4 = 0; var3_4 < this.listBufferNum; ++var3_4) {
                            var4_7 = this.dateBuffer[var3_4] + " " + this.listBuffer[var3_4] + "\n";
                            var2_3.write(var4_7, 0, var4_7.length());
                        }
                        var6_8 = null;
                        if (var2_3 == null) break block14;
                    }
                    catch (Exception var3_5) {
                        System.err.println("com.jblend.kdwp.MemoryMapFrame.flushList(): Cannot output '" + this.strLogName + "'!");
                        var6_9 = null;
                        if (var2_3 != null) {
                            try {
                                var2_3.close();
                            }
                            catch (Exception var7_12) {}
                        }
                        break block14;
                    }
                }
                catch (Throwable var5_14) {
                    var6_10 = null;
                    if (var2_3 == null) throw var5_14;
                    ** try [egrp 2[TRYBLOCK] [4 : 242->249)] { 
lbl38:
                    // 1 sources

                    var2_3.close();
                    throw var5_14;
lbl40:
                    // 1 sources

                    catch (Exception var7_13) {
                        // empty catch block
                    }
                    throw var5_14;
                }
                try {}
                catch (Exception var7_11) {}
                var2_3.close();
            }
        }
        this.listBufferNum = 0;
    }

    private int convStrIntoType(String string) {
        String string2 = (String)this.typeToColor.get(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return this.color.length - 1;
    }

    class MapPanel
    extends JPanel {
        MapPanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n, n2);
            DefaultListModel defaultListModel = MemoryMapFrame.this.model;
            synchronized (defaultListModel) {
                int n3 = n * n2;
                int n4 = 0;
                int n5 = 0;
                for (int i = 0; i < n3 && i < MemoryMapFrame.this.nHeapSize; ++i) {
                    byte by = MemoryMapFrame.this.abHeap[i];
                    int n6 = n4;
                    while (n4 < n - 1 && i < MemoryMapFrame.this.nHeapSize - 1 && by == MemoryMapFrame.this.abHeap[i + 1]) {
                        ++n4;
                        ++i;
                    }
                    graphics.setColor(MemoryMapFrame.this.color[by]);
                    graphics.drawLine(n6, n5, n4, n5);
                    if (++n4 < n) continue;
                    n4 = 0;
                    ++n5;
                }
            }
        }
    }

    class TabbedPaneListener
    implements ChangeListener {
        TabbedPaneListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MemoryMapFrame.this.sortButton.setEnabled(MemoryMapFrame.this.tabbedPane.getSelectedIndex() == 0);
        }
    }
}

