/*
 * Decompiled with CFR 0.152.
 */
package com.jblend.kdwp;

import com.jblend.kdwp.ClassNameId;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kdp.Flag;

public class UncompressKdwpData
implements Flag {
    private HashMap className;
    private int codeLength;
    private int param;

    public UncompressKdwpData(String string) {
        int n;
        Vector<String> vector = new Vector<String>(100, 100);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(stringTokenizer.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (zipFile == null) continue;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string2 = ((Object)enumeration.nextElement()).toString();
                n = string2.length();
                if (n <= 6 || !string2.substring(n - 6).toLowerCase().equals(".class")) continue;
                vector.add(string2.substring(0, n - 6));
            }
        }
        int n2 = vector.size();
        for (int i = 1; i <= 3; ++i) {
            for (int j = 3; j <= 47; j += 2) {
                ClassNameId classNameId;
                this.className = new HashMap();
                for (n = 0; n < n2 && this.className.get(String.valueOf((classNameId = new ClassNameId((String)vector.get(n), i, j)).getClassId())) == null; ++n) {
                    this.className.put(String.valueOf(classNameId.getClassId()), classNameId);
                }
                if (this.className.size() != n2) continue;
                this.codeLength = i + 1;
                this.param = j;
                return;
            }
        }
        System.out.println("Compressed KDWP: Cannot use the compressed mode!");
    }

    public String get(int n) {
        ClassNameId classNameId = (ClassNameId)this.className.get(String.valueOf(n));
        if (classNameId == null) {
            return null;
        }
        return "L" + classNameId.getClassName() + ";";
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public int getParam() {
        return this.param;
    }
}

