/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import com.jblend.kdwp.Socket;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kdp.Flag;
import kdp.KVMListener;
import kdp.Log;
import kdp.Options;
import kdp.Packet;
import kdp.PacketStream;
import kdp.ProxyListener;
import kdp.SocketConnection;
import kdp.VMConstants;
import kdp.classparser.ClassFile;
import kdp.classparser.ClassManager;
import kdp.classparser.FieldInfo;
import kdp.classparser.MethodInfo;
import kdp.classparser.attributes.CodeAttribute;
import kdp.classparser.attributes.LocalVariable;
import kdp.classparser.attributes.SourceFileAttribute;

class DebuggerListener
extends ProxyListener
implements VMConstants,
Flag {
    SocketConnection connDebugger;
    ProxyListener KVMListener;
    ClassManager manager = null;
    Packet replyPacket;
    Options options;
    boolean Ready = false;
    ServerSocket serverSocket = null;
    Socket acceptSocket = null;
    int maxMethodNum = 0;

    public DebuggerListener(Options options) {
        this.options = options;
    }

    public void set(ProxyListener proxyListener, ClassManager classManager) {
        this.KVMListener = proxyListener;
        this.manager = classManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(Packet packet) throws IOException {
        Object object = this;
        synchronized (object) {
            while (!this.Ready) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = String.valueOf(packet.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            if ((packet.flags & 0x80) == 0 && packet.id < 0) {
                this.waitingQueue.put(object, packet);
            }
        }
        this.connDebugger.send(packet);
    }

    public void quit() {
        boolean bl = this.timeToQuit;
        this.timeToQuit = true;
        if (bl != this.timeToQuit) {
            this.KVMListener.quit();
            try {
                if (this.acceptSocket != null) {
                    this.acceptSocket.close();
                }
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Packet packet = null;
        Object var3_2 = null;
        Object var4_3 = null;
        PacketStream packetStream = null;
        PacketStream packetStream2 = null;
        try {
            System.out.println("Waiting for debugger on port " + this.options.getLocalPort());
            this.serverSocket = new ServerSocket(this.options.getLocalPort());
            this.acceptSocket = new Socket(this.serverSocket.accept());
            this.connDebugger = new SocketConnection(this, this.acceptSocket);
            System.out.println("Connection received.");
        }
        catch (IOException iOException) {
            System.out.println("DebuggerListener: " + iOException.getMessage());
            Runtime.getRuntime().exit(1);
        }
        catch (SecurityException securityException) {
            System.out.println("DebuggerListener: " + securityException.getMessage());
            Runtime.getRuntime().exit(1);
        }
        byte[] byArray = new String("JDWP-Handshake").getBytes();
        try {
            int n;
            for (n = 0; n < byArray.length; ++n) {
                this.connDebugger.receiveByte();
            }
            for (n = 0; n < byArray.length; ++n) {
                this.connDebugger.sendByte(byArray[n]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Flag flag = this;
        synchronized (flag) {
            this.Ready = true;
            this.notify();
        }
        new Thread(this.connDebugger).start();
        try {
            while (!this.timeToQuit) {
                boolean bl = false;
                packet = this.waitForPacket();
                if (packet == null) {
                    System.exit(0);
                }
                if ((packet.flags & 0x80) == 0 && this.options.getUseClassParser()) {
                    packetStream2 = new PacketStream(this, packet);
                    switch (packet.cmdSet) {
                        case 1: {
                            int n;
                            int n2;
                            byte by;
                            Object object;
                            Object object2;
                            switch (packet.cmd) {
                                case 1: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeString("Version 1.0");
                                    packetStream.writeInt(1);
                                    packetStream.writeInt(0);
                                    packetStream.writeString("1.1");
                                    packetStream.writeString("KVM");
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 2: {
                                    object2 = packetStream2.readString();
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    object = ClassManager.classMap.values().iterator();
                                    while (object.hasNext()) {
                                        try {
                                            flag = (ClassFile)object.next();
                                            if (flag == null) {
                                                throw new Exception("Couldn't find classFile object");
                                            }
                                            if (((String)object2).compareTo(((ClassFile)flag).getClassSignature()) != 0) continue;
                                            packetStream.writeInt(1);
                                            packetStream.writeByte(((ClassFile)flag).getJDWPTypeTag());
                                            packetStream.writeInt(((ClassFile)flag).getClassID());
                                            packetStream.writeInt(((ClassFile)flag).getClassStatus());
                                            packetStream.send();
                                            bl = true;
                                            break;
                                        }
                                        catch (Exception exception) {
                                            System.out.println("ClassesBySig command failed with " + exception);
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 41);
                                            packetStream.send();
                                            bl = true;
                                        }
                                    }
                                    if (bl) break;
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(0);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 3: {
                                    packetStream = new PacketStream(this.KVMListener, 1, 3);
                                    PacketStream packetStream3 = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.send();
                                    try {
                                        packetStream.waitForReply();
                                    }
                                    catch (Exception exception) {
                                        packetStream3.writeInt(0);
                                        packetStream3.send();
                                        bl = true;
                                        break;
                                    }
                                    int n3 = packetStream.readInt();
                                    packetStream3.writeInt(n3);
                                    for (int i = 0; i < n3; ++i) {
                                        by = packetStream.readByte();
                                        n2 = packetStream.readInt();
                                        String string = ((KVMListener)this.KVMListener).getUncompressKdwpClassName(packetStream, by, true);
                                        if (this.options.getHideClasses() && string == null) {
                                            string = by != 3 ? "Ldo;" : "[Ldo;";
                                        }
                                        n = packetStream.readInt();
                                        packetStream3.writeByte(by);
                                        packetStream3.writeInt(n2);
                                        packetStream3.writeString(string);
                                        packetStream3.writeInt(n);
                                        if (by != 3) {
                                            string = new String(string.substring(1, string.length() - 1));
                                        }
                                        if ((flag = (ClassFile)ClassManager.classMap.get(new Integer(n2))) == null) {
                                            flag = this.manager.findClass(by, string);
                                            if (flag != null) {
                                                ClassManager.classMap.put(new Integer(n2), flag);
                                                ((ClassFile)flag).setClassID(n2);
                                                ((ClassFile)flag).setClassStatus(n);
                                                continue;
                                            }
                                            if (this.options.getHideClasses()) continue;
                                            System.out.println("ALL_CLASSES_CMD: couldn't find classfile object");
                                            packetStream3 = new PacketStream(this, packetStream2.id, 128, 41);
                                            packetStream3.send();
                                            bl = true;
                                            break;
                                        }
                                        ((ClassFile)flag).setClassStatus(n);
                                    }
                                    packetStream3.send();
                                    bl = true;
                                    break;
                                }
                                case 5: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(1);
                                    packetStream.writeInt(-32);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 6: {
                                    packetStream = new PacketStream(this.KVMListener, 1, 10);
                                    packetStream.writeInt(0);
                                    packetStream.send();
                                    PacketStream packetStream4 = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream4.send();
                                    bl = true;
                                    this.quit();
                                    break;
                                }
                                case 7: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(8);
                                    packetStream.writeInt(4);
                                    packetStream.writeInt(4);
                                    packetStream.writeInt(4);
                                    packetStream.writeInt(4);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 12: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeBoolean(false);
                                    packetStream.writeBoolean(false);
                                    packetStream.writeBoolean(true);
                                    packetStream.writeBoolean(false);
                                    packetStream.writeBoolean(false);
                                    packetStream.writeBoolean(false);
                                    packetStream.writeBoolean(false);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 13: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeString("");
                                    packetStream.writeInt(0);
                                    packetStream.writeInt(0);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 14: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.send();
                                    bl = true;
                                }
                            }
                            break;
                        }
                        case 2: {
                            int n2;
                            Object object;
                            Object object2;
                            switch (packet.cmd) {
                                case 1: {
                                    n2 = packetStream2.readInt();
                                    try {
                                        flag = (ClassFile)ClassManager.classMap.get(new Integer(n2));
                                        if (flag == null) {
                                            throw new Exception("Couldn't get ClassFile object for signature cmd");
                                        }
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        if (n2 == -32) {
                                            packetStream.writeString("Lkvm_threadgroup;");
                                        } else {
                                            packetStream.writeString(((ClassFile)flag).getClassSignature());
                                        }
                                        packetStream.send();
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        if (this.options.getHideClasses()) {
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                            packetStream.writeString("Ldo;");
                                        } else {
                                            System.out.println("Signature cmd: exception " + exception);
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                        }
                                        packetStream.send();
                                        bl = true;
                                    }
                                    break;
                                }
                                case 2: {
                                    packetStream2.readInt();
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(0);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 3: {
                                    n2 = packetStream2.readInt();
                                    try {
                                        flag = (ClassFile)ClassManager.classMap.get(new Integer(n2));
                                        if (flag == null) {
                                            throw new Exception("Couldn't get ClassFile object for Modifiers cmd");
                                        }
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(((ClassFile)flag).getRawAccessFlags());
                                        packetStream.send();
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        if (this.options.getHideClasses()) {
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                            packetStream.writeInt(0);
                                        } else {
                                            System.out.println("Modifiers cmd: exception " + exception);
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                        }
                                        packetStream.send();
                                        bl = true;
                                    }
                                    break;
                                }
                                case 4: {
                                    n2 = packetStream2.readInt();
                                    flag = (ClassFile)ClassManager.classMap.get(new Integer(n2));
                                    if (flag == null) {
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(0);
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    if (this.processFields((ClassFile)flag, packetStream, packetStream2.id)) {
                                        packetStream.send();
                                    }
                                    bl = true;
                                    break;
                                }
                                case 5: {
                                    n2 = packetStream2.readInt();
                                    flag = (ClassFile)ClassManager.classMap.get(new Integer(n2));
                                    if (flag == null || ((ClassFile)flag).getJDWPTypeTag() == 3) {
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        if (this.options.getHideClasses()) {
                                            packetStream.writeInt(this.maxMethodNum);
                                            for (int i = 1; i <= this.maxMethodNum; ++i) {
                                                packetStream.writeInt(i);
                                                packetStream.writeString("_");
                                                packetStream.writeString("()V");
                                                packetStream.writeInt(8);
                                            }
                                        } else {
                                            packetStream.writeInt(0);
                                        }
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    try {
                                        int n = method_index_base;
                                        List list = ((ClassFile)flag).getAllMethodInfo();
                                        Iterator iterator = list.iterator();
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(list.size());
                                        while (iterator.hasNext()) {
                                            object2 = (MethodInfo)iterator.next();
                                            if (object2 == null) {
                                                throw new Exception("methodinfo null");
                                            }
                                            packetStream.writeInt(n++);
                                            packetStream.writeString(((MethodInfo)object2).getName());
                                            packetStream.writeString(((MethodInfo)object2).getSignatureRaw());
                                            packetStream.writeInt(((MethodInfo)object2).getAccessFlags());
                                        }
                                        packetStream.send();
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        System.out.println("Methods cmd: exception " + exception);
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 41);
                                        packetStream.send();
                                        bl = true;
                                    }
                                    break;
                                }
                                case 7: {
                                    n2 = packetStream2.readInt();
                                    try {
                                        flag = (ClassFile)ClassManager.classMap.get(new Integer(n2));
                                        if (flag == null) {
                                            throw new Exception("Couldn't get ClassFile object for Modifiers cmd");
                                        }
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        object2 = ((ClassFile)flag).getSourceAttribute();
                                        if (object2 != null) {
                                            object = ((SourceFileAttribute)object2).getSourceFileName();
                                            packetStream.writeString((String)object);
                                        } else {
                                            packetStream.writeString(((ClassFile)flag).getBaseName() + ".java");
                                        }
                                        packetStream.send();
                                        bl = true;
                                    }
                                    catch (Exception exception) {
                                        if (this.options.getHideClasses()) {
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                            packetStream.writeString(".java");
                                        } else {
                                            System.out.println("Sourcefile cmd: exception " + exception);
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                        }
                                        packetStream.send();
                                        bl = true;
                                    }
                                    break;
                                }
                                case 10: {
                                    n2 = packetStream2.readInt();
                                    try {
                                        flag = (ClassFile)ClassManager.classMap.get(new Integer(n2));
                                        if (flag == null) {
                                            throw new Exception("Couldn't get ClassFile object for Interfaces cmd");
                                        }
                                        object = ((ClassFile)flag).getAllInterfaces();
                                        Iterator iterator = object.iterator();
                                        packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                        packetStream.writeInt(object.size());
                                        while (iterator.hasNext()) {
                                            String string = (String)iterator.next();
                                            if (string == null) {
                                                throw new Exception("interface name null");
                                            }
                                            flag = this.manager.findClass((byte)76, string);
                                            if (flag == null) {
                                                packetStream.writeInt(0);
                                                continue;
                                            }
                                            packetStream.writeInt(((ClassFile)flag).getClassID());
                                        }
                                        packetStream.send();
                                        bl = true;
                                        break;
                                    }
                                    catch (Exception exception) {
                                        if (this.options.getHideClasses()) {
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                            packetStream.writeInt(0);
                                        } else {
                                            System.out.println("Interfaces cmd: exception " + exception);
                                            packetStream = new PacketStream(this, packetStream2.id, 128, 20);
                                        }
                                        packetStream.send();
                                        bl = true;
                                    }
                                }
                            }
                            break;
                        }
                        case 6: {
                            switch (packet.cmd) {
                                case 1: {
                                    this.handleLineTable(packetStream2);
                                    bl = true;
                                    break;
                                }
                                case 2: {
                                    this.handleVariableTable(packetStream2);
                                    bl = true;
                                    break;
                                }
                                case 3: {
                                    this.handleByteCode(packetStream2);
                                    bl = true;
                                }
                            }
                            break;
                        }
                        case 11: {
                            switch (packet.cmd) {
                                case 5: {
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(-32);
                                    packetStream.send();
                                    bl = true;
                                }
                            }
                            break;
                        }
                        case 12: {
                            Object object;
                            switch (packet.cmd) {
                                case 1: {
                                    packetStream2.readInt();
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeString("KVM_System");
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 2: {
                                    int n = packetStream2.readInt();
                                    packetStream = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(0);
                                    packetStream.send();
                                    bl = true;
                                    break;
                                }
                                case 3: {
                                    int n = packetStream2.readInt();
                                    object = new PacketStream(this, packetStream2.id, 128, 0);
                                    if (n == -32) {
                                        packetStream = new PacketStream(this.KVMListener, 1, 4);
                                        packetStream.send();
                                        try {
                                            packetStream.waitForReply();
                                        }
                                        catch (Exception exception) {
                                            ((PacketStream)object).writeInt(0);
                                            ((PacketStream)object).writeInt(0);
                                            ((PacketStream)object).send();
                                            bl = true;
                                            break;
                                        }
                                        int n4 = packetStream.readInt();
                                        ((PacketStream)object).writeInt(n4);
                                        while (n4-- > 0) {
                                            ((PacketStream)object).writeInt(packetStream.readInt());
                                        }
                                    } else {
                                        ((PacketStream)object).writeInt(0);
                                    }
                                    ((PacketStream)object).writeInt(0);
                                    ((PacketStream)object).send();
                                    bl = true;
                                }
                            }
                            break;
                        }
                        case 16: {
                            int n;
                            byte by;
                            switch (packet.cmd) {
                                case 3: {
                                    int n5 = packetStream2.readInt();
                                    int n6 = packetStream2.readInt();
                                    packetStream = new PacketStream(this.KVMListener, 16, 1);
                                    PacketStream packetStream5 = new PacketStream(this, packetStream2.id, 128, 0);
                                    packetStream.writeInt(n5);
                                    packetStream.writeInt(n6);
                                    packetStream.writeInt(1);
                                    packetStream.writeInt(0);
                                    packetStream.writeByte((byte)76);
                                    packetStream.send();
                                    try {
                                        packetStream.waitForReply();
                                    }
                                    catch (Exception exception) {
                                        packetStream5.writeByte((byte)76);
                                        packetStream5.writeInt(0);
                                        packetStream5.send();
                                        bl = true;
                                        break;
                                    }
                                    n = packetStream.readInt();
                                    by = packetStream.readByte();
                                    int n7 = packetStream.readInt();
                                    packetStream5.writeByte(by);
                                    packetStream5.writeInt(n7);
                                    packetStream5.send();
                                    bl = true;
                                }
                            }
                            break;
                        }
                        case 17: {
                            Object object;
                            switch (packet.cmd) {
                                case 1: {
                                    int n = packetStream2.readInt();
                                    object = new PacketStream(this, packetStream2.id, 128, 0);
                                    flag = (ClassFile)ClassManager.classMap.get(new Integer(n));
                                    if (flag == null) {
                                        ((PacketStream)object).writeByte((byte)1);
                                    } else {
                                        ((PacketStream)object).writeByte(((ClassFile)flag).getJDWPTypeTag());
                                    }
                                    ((PacketStream)object).writeInt(n);
                                    ((PacketStream)object).send();
                                    bl = true;
                                }
                            }
                        }
                    }
                }
                if (bl) continue;
                this.disp(packet);
                if (packet.cmdSet != 15 || packet.cmd == 1) {
                    // empty if block
                }
                this.KVMListener.send(packet);
            }
        }
        catch (IOException iOException) {
            PacketStream packetStream6 = new PacketStream(this, packetStream2.id, 128, 41);
            packetStream6.send();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(packet.cmdSet + "/" + packet.cmd + " caused: " + arrayIndexOutOfBoundsException);
            PacketStream packetStream7 = new PacketStream(this, packetStream2.id, 128, 41);
            packetStream7.send();
        }
    }

    public String toString() {
        return new String("DebuggerListener: ");
    }

    protected String getClassName(byte[] byArray) {
        return new String("");
    }

    protected String getMethodName(byte[] byArray) {
        return new String("");
    }

    protected boolean processFields(ClassFile classFile, PacketStream packetStream, int n) {
        try {
            List list = classFile.getAllFieldInfo();
            Iterator iterator = list.iterator();
            long l = (long)classFile.getClassID() << 32;
            packetStream.writeInt(list.size());
            while (iterator.hasNext()) {
                FieldInfo fieldInfo = (FieldInfo)iterator.next();
                if (fieldInfo == null) {
                    throw new Exception("fieldinfo null");
                }
                packetStream.writeLong(l++);
                packetStream.writeString(fieldInfo.getName());
                packetStream.writeString(fieldInfo.getType());
                packetStream.writeInt(fieldInfo.getAccessFlags());
            }
        }
        catch (Exception exception) {
            System.out.println("Fields cmd: exception " + exception);
            packetStream = new PacketStream(this, n, 128, 20);
            packetStream.send();
            return false;
        }
        return true;
    }

    public void handleLineTable(PacketStream packetStream) throws IOException {
        int n;
        long l;
        long l2;
        ClassFile classFile = null;
        int[][] nArray = null;
        int n2 = packetStream.readInt();
        int n3 = packetStream.readInt() - method_index_base;
        classFile = (ClassFile)ClassManager.classMap.get(new Integer(n2));
        if (classFile == null) {
            PacketStream packetStream2;
            if (this.options.getHideClasses()) {
                packetStream2 = new PacketStream(this, packetStream.id, 128, 0);
                packetStream2.writeLong(0L);
                packetStream2.writeLong(32767L);
                packetStream2.writeInt(0);
            } else {
                packetStream2 = new PacketStream(this, packetStream.id, 128, 41);
            }
            packetStream2.send();
            return;
        }
        PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 0);
        MethodInfo methodInfo = classFile.getMethodInfoByIndex(n3);
        if (methodInfo == null) {
            packetStream3 = new PacketStream(this, packetStream.id, 128, 23);
            packetStream3.send();
            return;
        }
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute == null) {
            l2 = -1L;
            l = -1L;
        } else {
            l = 0L;
            l2 = codeAttribute.getCodeLength() - 1;
        }
        nArray = methodInfo.getBreakableLineNumbers();
        if (nArray == null) {
            n = 0;
            l = 0L;
            l2 = 32767L;
        } else {
            n = nArray.length;
        }
        packetStream3.writeLong(l);
        packetStream3.writeLong(l2);
        packetStream3.writeInt(n);
        for (int i = 0; i < n; ++i) {
            packetStream3.writeLong(nArray[i][1]);
            packetStream3.writeInt(nArray[i][0]);
        }
        packetStream3.send();
    }

    public void handleVariableTable(PacketStream packetStream) throws IOException {
        List list = null;
        MethodInfo methodInfo = null;
        int n = packetStream.readInt();
        int n2 = packetStream.readInt() - method_index_base;
        ClassFile classFile = (ClassFile)ClassManager.classMap.get(new Integer(n));
        if (classFile == null) {
            PacketStream packetStream2;
            if (this.options.getHideClasses()) {
                packetStream2 = new PacketStream(this, packetStream.id, 128, 0);
                packetStream2.writeInt(0);
                packetStream2.writeInt(0);
            } else {
                packetStream2 = new PacketStream(this, packetStream.id, 128, 41);
            }
            packetStream2.send();
            return;
        }
        try {
            list = classFile.getVariableTableForMethodIndex(n2);
            methodInfo = classFile.getMethodInfoByIndex(n2);
            if (methodInfo == null) {
                throw new Exception("couldn't find method info for class " + classFile.getClassFileName());
            }
        }
        catch (Exception exception) {
            System.out.println("class " + classFile.getClassName() + " caused " + exception);
            PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 20);
            packetStream3.send();
            return;
        }
        PacketStream packetStream4 = new PacketStream(this, packetStream.id, 128, 0);
        packetStream4.writeInt(methodInfo.getArgCount());
        if (list != null) {
            packetStream4.writeInt(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LocalVariable localVariable = (LocalVariable)iterator.next();
                packetStream4.writeLong(localVariable.getCodeIndex());
                packetStream4.writeString(localVariable.getName());
                packetStream4.writeString(this.getJNISignature(localVariable.getType()));
                packetStream4.writeInt(localVariable.getLength());
                packetStream4.writeInt(localVariable.getSlot());
            }
        } else {
            packetStream4.writeInt(0);
        }
        packetStream4.send();
    }

    private void handleByteCode(PacketStream packetStream) {
        MethodInfo methodInfo = null;
        Object var7_3 = null;
        int n = packetStream.readInt();
        int n2 = packetStream.readInt() - method_index_base;
        ClassFile classFile = (ClassFile)ClassManager.classMap.get(new Integer(n));
        if (classFile == null) {
            Log.LOGN((int)3, (String)"Bytecode cmd: not found");
            PacketStream packetStream2 = new PacketStream(this, packetStream.id, 128, 20);
            packetStream2.send();
            return;
        }
        try {
            methodInfo = classFile.getMethodInfoByIndex(n2);
            if (methodInfo == null) {
                throw new Exception("couldn't find method info for class " + classFile.getClassFileName());
            }
        }
        catch (Exception exception) {
            System.out.println(" class" + classFile.getClassFileName() + " caused " + exception);
            PacketStream packetStream3 = new PacketStream(this, packetStream.id, 128, 23);
            packetStream3.send();
            return;
        }
        byte[] byArray = methodInfo.getCodeAttribute().getByteCodes();
        PacketStream packetStream4 = new PacketStream(this, packetStream.id, 128, 0);
        packetStream4.writeInt(byArray.length);
        packetStream4.writeByteArray(byArray);
        packetStream4.send();
    }

    private String getJNISignature(String string) {
        int n;
        int n2 = n = string.length();
        String string2 = new String();
        while ((n = string.lastIndexOf("[]", n)) != -1) {
            string2 = string2 + "[";
            n2 = n--;
        }
        String string3 = string.substring(0, n2);
        string2 = "int".equalsIgnoreCase(string3) ? string2 + "I" : ("boolean".equalsIgnoreCase(string3) ? string2 + "Z" : ("short".equalsIgnoreCase(string3) ? string2 + "S" : ("byte".equalsIgnoreCase(string3) ? string2 + "B" : ("char".equalsIgnoreCase(string3) ? string2 + "C" : ("long".equalsIgnoreCase(string3) ? string2 + "J" : ("float".equalsIgnoreCase(string3) ? string2 + "F" : ("double".equalsIgnoreCase(string3) ? string2 + "D" : string2 + "L" + string3.replace('.', '/') + ";")))))));
        return string2;
    }
}

