/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import com.jblend.kdwp.MemoryMapFrame;
import com.jblend.kdwp.MemoryMapFrameInterface;
import com.jblend.kdwp.QuitFrame;
import com.jblend.kdwp.UncompressKdwpData;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import kdp.DebuggerListener;
import kdp.Flag;
import kdp.KVMListener;
import kdp.Options;
import kdp.classparser.ClassManager;
import kdp.classparser.SearchPath;

public class KVMDebugProxy
implements MemoryMapFrameInterface,
Flag {
    private static final String DEFAULT_SOCKET_CLASS = "com.jblend.kdwp.JkHSocket";
    Options options = null;
    private KVMListener klisten = null;

    public boolean parseArgs(String[] stringArray) {
        int n = 0;
        this.options = new Options();
        this.options.setLocalPort(0);
        this.options.setRemotePort(2800);
        this.options.setRemoteHost("localhost");
        this.options.setVerbosity(0);
        this.options.setClassPath("./");
        this.options.setUseClassParser(true);
        this.options.setSocketClassName(DEFAULT_SOCKET_CLASS);
        this.options.setHideClasses(true);
        this.options.setCompressedMode(true);
        if (stringArray.length == 0) {
            this.options = null;
        }
        try {
            while (n < stringArray.length) {
                if ("-l".equals(stringArray[n])) {
                    this.options.setLocalPort(Integer.parseInt(stringArray[++n]));
                } else if ("-r".equals(stringArray[n])) {
                    this.options.setRemoteHost(stringArray[++n]);
                    this.options.setRemotePort(Integer.parseInt(stringArray[++n]));
                } else if ("-cp".equals(stringArray[n]) || "-classpath".equals(stringArray[n])) {
                    this.options.setClassPath(stringArray[++n]);
                } else if ("-m".equals(stringArray[n])) {
                    this.options.setMemoryMap(true);
                } else if ("-nc".equals(stringArray[n])) {
                    this.options.setCompressedMode(false);
                } else if ("-q".equals(stringArray[n])) {
                    this.options.setQuitWindow(true);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.options = null;
        }
        if (this.options != null && this.options.getLocalPort() == 0 && !this.options.getQuit()) {
            this.options = null;
        }
        return this.options != null;
    }

    public void help() {
        System.out.println("J2ME Debug Agent Copyright (c) 2000 Sun Microsystems, Inc. All rights reserved.");
        System.out.println("Copyright 2002,2003 Aplix Corporation. All rights reserved.");
        System.out.println();
        System.out.print("Usage: KVMDebugProxy -l <localport> -r <remotehost> <remoteport>");
        System.out.println();
        System.out.print("        ");
        System.out.print("[-cp | - classpath <classpath" + File.pathSeparator + "classpath...>]");
        System.out.print(" [-m]");
        System.out.println();
        System.out.println("Where:");
        System.out.println("  -l <localport> specifies the local port number that the debug agent will");
        System.out.println("     listen on for a connection from a debugger.");
        System.out.println("  -r <remotehost> <remoteport> is the hostname and port number that the debug");
        System.out.println("     agent will use to connect to the Java VM running the application");
        System.out.println("     being debugged.");
        System.out.println("  -cp or -classpath specifies a list of paths separated by '" + File.pathSeparator + "' where the");
        System.out.println("     debug agent can find copies of the class files.");
        System.out.println("  -m displays the memory map window.");
        System.out.println();
    }

    public int go() {
        if (this.options == null) {
            return 1;
        }
        try {
            ClassManager classManager = new ClassManager(new SearchPath(this.options.getClassPath()));
            System.out.println("Connecting to " + this.options.getRemoteHost() + " on port " + this.options.getRemotePort());
            UncompressKdwpData uncompressKdwpData = null;
            if (this.options.getCompressedMode() && (uncompressKdwpData = new UncompressKdwpData(this.options.getClassPath())).getCodeLength() == 0) {
                uncompressKdwpData = null;
            }
            DebuggerListener debuggerListener = new DebuggerListener(this.options);
            this.klisten = new KVMListener(this.options);
            if (this.options.getHideClasses()) {
                debuggerListener.maxMethodNum = this.getMaxMethodNum(this.options.getClassPath());
            }
            if (this.options.getMemoryMap()) {
                this.klisten.memoryMapFrame = new MemoryMapFrame();
                this.klisten.memoryMapFrame.debugProxy = this;
            }
            debuggerListener.set(this.klisten, classManager);
            this.klisten.set(debuggerListener, classManager, uncompressKdwpData);
            debuggerListener.verbose(this.options.getVerbosity());
            this.klisten.verbose(this.options.getVerbosity());
            if (!this.options.getQuit()) {
                new Thread(debuggerListener).start();
            }
            if (this.options.getQuitWindow()) {
                this.klisten.quitFrame = new QuitFrame();
                this.klisten.quitFrame.start();
            }
            new Thread(this.klisten).start();
        }
        catch (SecurityException securityException) {
            System.out.println("KVMDebugProxy: " + securityException.getMessage());
        }
        return 0;
    }

    public static void main(String[] stringArray) {
        KVMDebugProxy kVMDebugProxy = new KVMDebugProxy();
        if (!kVMDebugProxy.parseArgs(stringArray)) {
            kVMDebugProxy.help();
            System.exit(1);
        }
        kVMDebugProxy.go();
    }

    public void startMemoryMap() {
        if (this.klisten != null) {
            this.klisten.startMemoryMap();
        }
    }

    public void stopMemoryMap() {
        if (this.klisten != null) {
            this.klisten.stopMemoryMap();
        }
    }

    public void refreshMemoryMap() {
        if (this.klisten != null) {
            this.klisten.refreshMemoryMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int getMaxMethodNum(String var1_1) {
        var2_2 = new StringTokenizer(var1_1, File.pathSeparator);
        while (var2_2.hasMoreTokens()) {
            block15: {
                var3_3 = null;
                try {
                    var3_3 = new ZipFile(var2_2.nextToken());
                }
                catch (IOException var4_5) {
                    // empty catch block
                }
                if (var3_3 == null || (var4_4 = var3_3.getEntry("dbgclasses.inf")) == null) continue;
                var5_6 = null;
                var6_7 = new byte[16];
                var7_8 = -1;
                var8_9 = 0;
                try {
                    var5_6 = var3_3.getInputStream(var4_4);
                    var7_8 = var5_6.read(var6_7);
                    var12_12 = null;
                    ** if (var5_6 == null) goto lbl-1000
                }
                catch (Throwable var11_14) {
                    var12_12 = null;
                    if (var5_6 != null) {
                        try {
                            var5_6.close();
                        }
                        catch (IOException var13_13) {
                            // empty catch block
                        }
                    }
                    throw var11_14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var5_6.close();
                    }
                    catch (IOException var13_13) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block15;
                    catch (IOException var10_11) {
                        var12_12 = null;
                        if (var5_6 != null) {
                            try {
                                var5_6.close();
                            }
                            catch (IOException var13_13) {}
                        }
                    }
                }
            }
            for (var9_10 = 0; var9_10 < var7_8 && var6_7[var9_10] >= 48 && var6_7[var9_10] <= 57; ++var9_10) {
                var8_9 *= 10;
                var8_9 += var6_7[var9_10] - 48;
            }
            if (var9_10 <= 0) continue;
            return var8_9;
        }
        return 0;
    }
}

