/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Vector;
import kdp.Flag;
import kdp.classparser.AccessFlags;
import kdp.classparser.FieldInfo;
import kdp.classparser.FileReference;
import kdp.classparser.MethodInfo;
import kdp.classparser.StringParser;
import kdp.classparser.attributes.AttributeInfo;
import kdp.classparser.attributes.SourceFileAttribute;
import kdp.classparser.constantpoolclasses.ConstantClassInfo;
import kdp.classparser.constantpoolclasses.ConstantDoubleInfo;
import kdp.classparser.constantpoolclasses.ConstantFieldrefInfo;
import kdp.classparser.constantpoolclasses.ConstantFloatInfo;
import kdp.classparser.constantpoolclasses.ConstantIntegerInfo;
import kdp.classparser.constantpoolclasses.ConstantInterfaceMethodrefInfo;
import kdp.classparser.constantpoolclasses.ConstantLongInfo;
import kdp.classparser.constantpoolclasses.ConstantMethodrefInfo;
import kdp.classparser.constantpoolclasses.ConstantNameAndTypeInfo;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantStringInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class ClassFile
implements Flag {
    private static final int OBJECT_SUPER_CLASS_ID = 0;
    final byte TYPE_TAG_ARRAY = (byte)3;
    private String baseName;
    private String className;
    private String classSignature;
    private FileReference classFile;
    private int magic;
    private int majorVersion;
    private int minorVersion;
    private int constantPoolCount;
    private ConstantPoolInfo[] constantPool;
    private AccessFlags accessFlags;
    private int thisClass;
    private int superClass;
    private int interfacesCount;
    private int[] interfaces;
    private int fieldsCount;
    private FieldInfo[] fieldInfo;
    private int methodsCount;
    private MethodInfo[] methodInfo;
    private int attributesCount;
    private AttributeInfo[] attributes;
    private byte typeTag;
    int classID;
    int classStatus;

    public ClassFile(FileReference fileReference, String string, byte by) {
        this.classFile = fileReference;
        this.className = string;
        int n = string.lastIndexOf(47);
        this.baseName = n != -1 ? string.substring(n + 1) : string;
        this.typeTag = by;
        this.classSignature = by == 3 ? string : "L" + string.replace('.', '/') + ";";
    }

    public boolean equals(String string) {
        return this.className.equals(string);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassSignature() {
        return this.classSignature;
    }

    public String getClassFileName() {
        return this.classFile.toString();
    }

    public byte getJDWPTypeTag() {
        return this.typeTag;
    }

    public void setClassID(int n) {
        this.classID = n;
    }

    public int getClassID() {
        return this.classID;
    }

    public void setClassStatus(int n) {
        this.classStatus = n;
    }

    public int getClassStatus() {
        return this.classStatus;
    }

    public void readClassFile() throws IOException {
        try {
            DataInputStream dataInputStream = new DataInputStream(this.classFile.getInputStream());
            this.magic = dataInputStream.readInt();
            this.minorVersion = dataInputStream.readUnsignedShort();
            this.majorVersion = dataInputStream.readUnsignedShort();
            this.readConstantPool(dataInputStream);
            this.accessFlags = new AccessFlags(dataInputStream);
            this.thisClass = dataInputStream.readUnsignedShort();
            this.superClass = dataInputStream.readUnsignedShort();
            this.readInterfaces(dataInputStream);
            this.readFieldInfo(dataInputStream);
            this.readMethodInfo(dataInputStream);
            this.readAttributes(dataInputStream);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Caught IO Exception - " + iOException.getMessage());
            throw iOException;
        }
    }

    private int readConstantPool(DataInputStream dataInputStream) throws IOException {
        this.constantPoolCount = dataInputStream.readUnsignedShort();
        this.constantPool = new ConstantPoolInfo[this.constantPoolCount];
        block13: for (int i = 1; i < this.constantPoolCount; ++i) {
            byte by = dataInputStream.readByte();
            switch (by) {
                case 7: {
                    this.constantPool[i] = new ConstantClassInfo(dataInputStream);
                    continue block13;
                }
                case 9: {
                    this.constantPool[i] = new ConstantFieldrefInfo(dataInputStream);
                    continue block13;
                }
                case 10: {
                    this.constantPool[i] = new ConstantMethodrefInfo(dataInputStream);
                    continue block13;
                }
                case 11: {
                    this.constantPool[i] = new ConstantInterfaceMethodrefInfo(dataInputStream);
                    continue block13;
                }
                case 8: {
                    this.constantPool[i] = new ConstantStringInfo(dataInputStream);
                    continue block13;
                }
                case 3: {
                    this.constantPool[i] = new ConstantIntegerInfo(dataInputStream);
                    continue block13;
                }
                case 4: {
                    this.constantPool[i] = new ConstantFloatInfo(dataInputStream);
                    continue block13;
                }
                case 5: {
                    this.constantPool[i] = new ConstantLongInfo(dataInputStream);
                    ++i;
                    continue block13;
                }
                case 6: {
                    this.constantPool[i] = new ConstantDoubleInfo(dataInputStream);
                    ++i;
                    continue block13;
                }
                case 12: {
                    this.constantPool[i] = new ConstantNameAndTypeInfo(dataInputStream);
                    continue block13;
                }
                case 1: {
                    this.constantPool[i] = new ConstantUtf8Info(dataInputStream);
                    continue block13;
                }
            }
        }
        return this.constantPoolCount;
    }

    private int readInterfaces(DataInputStream dataInputStream) throws IOException {
        this.interfacesCount = dataInputStream.readUnsignedShort();
        if (this.interfacesCount == 0) {
            return this.interfacesCount;
        }
        this.interfaces = new int[this.interfacesCount];
        for (int i = 0; i < this.interfacesCount; ++i) {
            this.interfaces[i] = dataInputStream.readUnsignedShort();
        }
        return this.interfacesCount;
    }

    private int readFieldInfo(DataInputStream dataInputStream) throws IOException {
        this.fieldsCount = dataInputStream.readUnsignedShort();
        this.fieldInfo = new FieldInfo[this.fieldsCount];
        for (int i = 0; i < this.fieldsCount; ++i) {
            this.fieldInfo[i] = new FieldInfo(dataInputStream, this.constantPool);
        }
        return this.fieldsCount;
    }

    public MethodInfo lookUpMethodByLineNumber(int n) {
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < this.methodsCount) {
            if (this.methodInfo[n2].containsLine(n)) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return bl ? this.methodInfo[n2] : null;
    }

    private int readMethodInfo(DataInputStream dataInputStream) throws IOException {
        this.methodsCount = dataInputStream.readUnsignedShort();
        this.methodInfo = new MethodInfo[this.methodsCount];
        for (int i = 0; i < this.methodsCount; ++i) {
            this.methodInfo[i] = new MethodInfo(dataInputStream, this.constantPool);
        }
        return this.methodsCount;
    }

    private int readAttributes(DataInputStream dataInputStream) throws IOException {
        this.attributesCount = dataInputStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        for (int i = 0; i < this.attributesCount; ++i) {
            this.attributes[i] = new AttributeInfo(dataInputStream, this.constantPool);
        }
        return this.attributesCount;
    }

    public MethodInfo getMethodInfoByName(String string, String string2) {
        for (int i = 0; i < this.methodsCount; ++i) {
            if (!this.methodInfo[i].getName().equals(string) || !this.methodInfo[i].getSignatureRaw().equals(string2)) continue;
            return this.methodInfo[i];
        }
        return null;
    }

    public MethodInfo getMethodInfoByIndex(int n) {
        if (n > this.methodInfo.length) {
            return null;
        }
        return this.methodInfo[n];
    }

    public List getAllMethodInfo() {
        Vector<MethodInfo> vector = new Vector<MethodInfo>();
        for (int i = 0; i < this.methodInfo.length; ++i) {
            vector.add(this.methodInfo[i]);
        }
        return vector;
    }

    public List getAllFieldInfo() {
        Vector<FieldInfo> vector = new Vector<FieldInfo>();
        for (int i = 0; i < this.fieldInfo.length; ++i) {
            vector.add(this.fieldInfo[i]);
        }
        return vector;
    }

    public List getAllInterfaces() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.interfacesCount; ++i) {
            int n = ((ConstantClassInfo)this.constantPool[this.interfaces[i]]).getNameIndex();
            ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[n];
            vector.add(constantUtf8Info.toString());
        }
        return vector;
    }

    public String getSuperClass() {
        if (this.superClass == 0) {
            return "";
        }
        ConstantClassInfo constantClassInfo = (ConstantClassInfo)this.constantPool[this.superClass];
        int n = constantClassInfo.getNameIndex();
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[n];
        return constantUtf8Info.toString();
    }

    public void print(PrintStream printStream) {
        int n;
        printStream.println(this.accessFlags);
        ConstantClassInfo constantClassInfo = (ConstantClassInfo)this.constantPool[this.thisClass];
        int n2 = constantClassInfo.getNameIndex();
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[n2];
        printStream.println("This Class:\t\t" + StringParser.parseClassName(constantUtf8Info.toString()));
        String string = this.getSuperClass();
        printStream.print("Superclass: ");
        if (string.equals("")) {
            printStream.println("None");
        } else {
            printStream.println(string);
        }
        if (this.interfacesCount > 0) {
            for (n = 0; n < this.interfacesCount; ++n) {
                constantClassInfo = (ConstantClassInfo)this.constantPool[this.interfaces[n]];
                n2 = constantClassInfo.getNameIndex();
                constantUtf8Info = (ConstantUtf8Info)this.constantPool[n2];
                printStream.println("Interfaces:\t\t" + StringParser.parseClassName(constantUtf8Info.toString()));
            }
        }
        for (n = 0; n < this.fieldsCount; ++n) {
            printStream.println(this.fieldInfo[n].toString());
        }
        for (n = 0; n < this.methodsCount; ++n) {
            printStream.println(this.methodInfo[n].toString());
        }
        for (n = 0; n < this.attributesCount; ++n) {
            printStream.println(this.attributes[n].toString());
        }
    }

    public List getVariableTableForMethodIndex(int n) {
        MethodInfo methodInfo = null;
        boolean bl = false;
        boolean bl2 = false;
        List list = null;
        methodInfo = this.getMethodInfoByIndex(n);
        if (methodInfo != null) {
            list = methodInfo.getLocalVariables();
        }
        return list;
    }

    public int getRawAccessFlags() {
        return this.accessFlags.getRawAccessFlags();
    }

    public SourceFileAttribute getSourceAttribute() {
        int n = 0;
        boolean bl = false;
        while (!bl && n < this.attributesCount) {
            if (this.attributes[n].getType() == 7) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl) {
            AttributeInfo attributeInfo = this.attributes[n];
            return (SourceFileAttribute)attributeInfo.getInfo();
        }
        return null;
    }
}

