/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.IOException;
import kdp.Flag;
import kdp.classparser.ClassFile;
import kdp.classparser.FileReference;
import kdp.classparser.MethodInfo;

public class ClassParser
implements Flag {
    private String className;
    private String baseName;
    private int lineNumber = -1;
    public ClassFile classFile;
    private int classID;
    private byte typeTag;

    public ClassParser(String string, byte by) {
        this.className = string;
        int n = string.lastIndexOf(47);
        this.baseName = n != -1 ? string.substring(n + 1) : string;
        this.typeTag = by;
    }

    public boolean equals(String string) {
        return this.className.equals(string);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassFileName() {
        return this.className + ".class";
    }

    public String getFullClassFileName() {
        return this.className + ".class";
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public byte getJDWPTypeTag() {
        return this.typeTag;
    }

    public void setClassID(int n) {
        this.classID = n;
    }

    public int getClassID() {
        return this.classID;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        FileReference fileReference = FileReference.create(stringArray[0], stringArray[1]);
        ClassFile classFile = new ClassFile(fileReference, stringArray[1], 76);
        try {
            classFile.readClassFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (stringArray.length < 3) {
            classFile.print(System.out);
        } else {
            int[][] nArray;
            n = Integer.parseInt(stringArray[2]);
            MethodInfo methodInfo = classFile.lookUpMethodByLineNumber(n);
            if (methodInfo != null && (nArray = methodInfo.getBreakableLineNumbers()) == null) {
                for (int i = 0; i < nArray.length; ++i) {
                }
            }
        }
    }
}

