/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.attributes.AttributeInfo;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class FieldInfo {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_VOLATILE = 64;
    private static final int ACC_TRANSIENT = 128;
    private int accessFlags;
    private int nameIndex;
    private int descriptorIndex;
    private int attributesCount;
    private AttributeInfo[] attributes;
    private ConstantPoolInfo[] constantPool;

    public FieldInfo(DataInputStream dataInputStream, ConstantPoolInfo[] constantPoolInfoArray) throws IOException {
        this.accessFlags = dataInputStream.readUnsignedShort();
        this.nameIndex = dataInputStream.readUnsignedShort();
        this.descriptorIndex = dataInputStream.readUnsignedShort();
        this.attributesCount = dataInputStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        for (int i = 0; i < this.attributesCount; ++i) {
            this.attributes[i] = new AttributeInfo(dataInputStream, constantPoolInfoArray);
        }
        this.constantPool = constantPoolInfoArray;
    }

    public String getAccess() {
        String string = new String("");
        if ((this.accessFlags & 1) > 0) {
            string = string + "public ";
        }
        if ((this.accessFlags & 2) > 0) {
            string = string + "private ";
        }
        if ((this.accessFlags & 4) > 0) {
            string = string + "protected ";
        }
        if ((this.accessFlags & 8) > 0) {
            string = string + "static ";
        }
        if ((this.accessFlags & 0x10) > 0) {
            string = string + "final ";
        }
        if ((this.accessFlags & 0x40) > 0) {
            string = string + "volatile ";
        }
        if ((this.accessFlags & 0x80) > 0) {
            string = string + "transient";
        }
        if (string.length() == 0) {
            string = "Not explicitly specified.";
        }
        return string;
    }

    public String getType() {
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[this.descriptorIndex];
        return constantUtf8Info.toString();
    }

    public String getName() {
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[this.nameIndex];
        return constantUtf8Info.toString();
    }

    public String toString() {
        String string = new String("");
        string = string + "Field:\n\tAccess Flags=\t";
        string = string + this.getAccess();
        string = string + "\n\tName=\t\t" + this.getName();
        string = string + "\n\tClass=\t\t" + this.getType();
        for (int i = 0; i < this.attributesCount; ++i) {
            string = string + "\n\t" + this.attributes[i].toString();
        }
        return string;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }
}

