/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kdp.Flag;
import kdp.classparser.StringParser;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.AttributeInfo;
import kdp.classparser.attributes.CodeAttribute;
import kdp.classparser.attributes.LineNumberTableAttribute;
import kdp.classparser.attributes.LocalVariable;
import kdp.classparser.attributes.LocalVariableTable;
import kdp.classparser.attributes.LocalVariableTableAttribute;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class MethodInfo
implements Flag {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SYNCHRONIZED = 32;
    private static final int ACC_NATIVE = 256;
    private static final int ACC_ABSTRACT = 1024;
    private static final int ACC_STRICT = 2048;
    private int accessFlags;
    private int nameIndex;
    private int descriptorIndex;
    private int attributesCount;
    private int argCount;
    private AttributeInfo[] attributes;
    private ConstantPoolInfo[] constantPool;

    public MethodInfo(DataInputStream dataInputStream, ConstantPoolInfo[] constantPoolInfoArray) throws IOException {
        this.accessFlags = dataInputStream.readUnsignedShort();
        this.nameIndex = dataInputStream.readUnsignedShort();
        this.descriptorIndex = dataInputStream.readUnsignedShort();
        this.attributesCount = dataInputStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        for (int i = 0; i < this.attributesCount; ++i) {
            this.attributes[i] = new AttributeInfo(dataInputStream, constantPoolInfoArray);
        }
        this.constantPool = constantPoolInfoArray;
    }

    public int[][] getBreakableLineNumbers() {
        CodeAttribute codeAttribute = this.getCodeAttribute();
        if (codeAttribute == null) {
            return null;
        }
        LineNumberTableAttribute lineNumberTableAttribute = codeAttribute.getLineNumberTable();
        if (lineNumberTableAttribute == null) {
            return null;
        }
        return lineNumberTableAttribute.getLineNumbersAndIndicesAsArray();
    }

    public CodeAttribute getCodeAttribute() {
        int n = 0;
        boolean bl = false;
        while (!bl && n < this.attributesCount) {
            if (this.attributes[n].getType() == 0) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl) {
            AttributeInfo attributeInfo = this.attributes[n];
            CodeAttribute codeAttribute = (CodeAttribute)attributeInfo.getInfo();
            return codeAttribute;
        }
        return null;
    }

    public boolean containsLine(int n) {
        CodeAttribute codeAttribute = this.getCodeAttribute();
        if (codeAttribute != null) {
            return codeAttribute.containsLine(n);
        }
        return false;
    }

    public int getCodeIndex(int n) {
        boolean bl = false;
        boolean bl2 = false;
        CodeAttribute codeAttribute = this.getCodeAttribute();
        if (codeAttribute == null) {
            return -1;
        }
        LineNumberTableAttribute lineNumberTableAttribute = codeAttribute.getLineNumberTable();
        if (lineNumberTableAttribute == null) {
            return -1;
        }
        return lineNumberTableAttribute.getCodeIndexBySourceLineNumber(n);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String getAccess() {
        String string = new String("");
        if ((this.accessFlags & 1) > 0) {
            string = string + "public ";
        }
        if ((this.accessFlags & 2) > 0) {
            string = string + "private ";
        }
        if ((this.accessFlags & 4) > 0) {
            string = string + "protected ";
        }
        if ((this.accessFlags & 8) > 0) {
            string = string + "static ";
        }
        if ((this.accessFlags & 0x10) > 0) {
            string = string + "final ";
        }
        if ((this.accessFlags & 0x20) > 0) {
            string = string + "synchronized ";
        }
        if ((this.accessFlags & 0x100) > 0) {
            string = string + "native ";
        }
        if ((this.accessFlags & 0x400) > 0) {
            string = string + "abstract ";
        }
        if ((this.accessFlags & 0x800) > 0) {
            string = string + "strict";
        }
        if (string.length() == 0) {
            string = "Not explicitly specified.";
        }
        return string;
    }

    public LinkedList getParameterList() {
        String string = new String("");
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[this.descriptorIndex];
        LinkedList linkedList = StringParser.getParametersAsLL(constantUtf8Info.toString());
        return linkedList;
    }

    public String getReturnValue() {
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[this.descriptorIndex];
        return StringParser.getReturnValue(constantUtf8Info.toString());
    }

    public String getName() {
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[this.nameIndex];
        String string = constantUtf8Info.toString();
        return string;
    }

    public String getSignatureRaw() {
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[this.descriptorIndex];
        return constantUtf8Info.toString();
    }

    public String getSignature() {
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[this.descriptorIndex];
        return StringParser.parseSignature(constantUtf8Info.toString());
    }

    public String toString() {
        String string = new String("");
        string = string + "Method:\n\tAccess Flags=\t";
        string = string + this.getAccess();
        string = string + "\n\tName=\t\t";
        string = string + this.getName();
        string = string + "\n\tSignature=\t";
        string = string + this.getSignature();
        string = string + "\n\tRaw signature=\t";
        string = string + this.getSignatureRaw();
        for (int i = 0; i < this.attributesCount; ++i) {
            string = string + "\n\t" + this.attributes[i].toString();
        }
        string = string + "\n\t BreakableLines=\t";
        int[][] nArray = this.getBreakableLineNumbers();
        if (nArray == null) {
            string = string + "No breakable lines\n";
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                string = string + "\tSourceLine: " + nArray[i][0] + " CodeIndex:  " + nArray[i][1] + "\n";
            }
        }
        return string;
    }

    public List getLocalVariables() {
        int n;
        AttributeInfo[] attributeInfoArray = null;
        int n2 = 0;
        Attribute attribute = null;
        for (n = 0; n < this.attributesCount; ++n) {
            if (this.attributes[n].getType() != 0) continue;
            attribute = this.attributes[n].getInfo();
            attributeInfoArray = ((CodeAttribute)attribute).getAttributes();
            n2 = ((CodeAttribute)attribute).getAttributeCount();
            break;
        }
        n = 0;
        for (n = 0; n < n2; ++n) {
            if (attributeInfoArray[n].getType() != 6) continue;
            attribute = attributeInfoArray[n].getInfo();
            LocalVariableTable[] localVariableTableArray = ((LocalVariableTableAttribute)attribute).getLocalVariableTable();
            ArrayList<LocalVariable> arrayList = new ArrayList<LocalVariable>();
            for (n = 0; n < localVariableTableArray.length; ++n) {
                ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)this.constantPool[localVariableTableArray[n].nameIndex];
                String string = constantUtf8Info.toString();
                constantUtf8Info = (ConstantUtf8Info)this.constantPool[localVariableTableArray[n].descriptorIndex];
                String string2 = StringParser.parseDataType(constantUtf8Info.toString());
                arrayList.add(new LocalVariable(string, string2, localVariableTableArray[n].startPC, localVariableTableArray[n].length, localVariableTableArray[n].index));
            }
            return arrayList;
        }
        return null;
    }

    public int getArgCount() {
        return this.argCount;
    }
}

