/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AppIconException;
import java.io.ByteArrayInputStream;

class AppIconCheck {
    private final int TRAILER = 59;
    private final int IMAGE_BLOCK = 44;
    private final int EXTENSION_INTRODUCER = 33;
    private final int PLAIN_TEXT_EXTENTION = 1;
    private final int GRAPHIC_CONTROL_EXTENTION = 249;
    private final int COMMENT_EXTENTION = 254;
    private final int APPLICATION_EXTENTION = 255;
    private final int[] REGULATION_SIZE = new int[]{24, 48, 96};
    public static final int REGULATION_FORMAT = 0;
    public static final int INVALID_FORMAT = -1;
    public static final int INVALID_SIGVER = -2;
    public static final int INVALID_SIZE = -3;
    public static final int INVALID_INTERLACE = -4;
    public static final int INVALID_ANIMATION = -5;
    public static final int UNDEFINED_ERROR = -99;
    private int nTh;

    public AppIconCheck(int n) {
        this.nTh = n;
    }

    private void checkHeader(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n = 0;
        byte[] byArray = new byte[6];
        byteArrayInputStream.read(byArray);
        String string = new String(byArray);
        if (!string.equals("GIF87a") && !string.equals("GIF89a")) {
            throw new AppIconException(2, "Invalid signature or version");
        }
        byte[] byArray2 = new byte[4];
        byteArrayInputStream.read(byArray2);
        int n2 = byArray2[1] | byArray2[0];
        int n3 = byArray2[3] | byArray2[2];
        if (this.REGULATION_SIZE[this.nTh] != n2 || this.REGULATION_SIZE[this.nTh] != n3) {
            throw new AppIconException(3, "Invalid logical screen size");
        }
        byte by = (byte)byteArrayInputStream.read();
        if ((by & 0x80) != 0) {
            int n4 = (by & 7) + 1;
            n = (int)Math.pow(2.0, n4) * 3;
        }
        byteArrayInputStream.skip(2 + n);
    }

    private void checkImageBlock(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        int n2 = 0;
        byteArrayInputStream.skip(8L);
        byte by = (byte)((byte)byteArrayInputStream.read() & 0xFF);
        if ((by & 0x40) != 0) {
            throw new AppIconException(4, "Interlace image");
        }
        if ((by & 0x80) != 0) {
            n = (by & 7) + 1;
            n2 = (int)Math.pow(2.0, n) * 3;
        }
        byteArrayInputStream.skip(n2 + 1);
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private void checkPlaneText(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        byteArrayInputStream.skip(byteArrayInputStream.read() & 0xFF);
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private void checkGraphicControl(ByteArrayInputStream byteArrayInputStream) throws Exception {
        byteArrayInputStream.skip(byteArrayInputStream.read() & 0xFF);
        if ((byteArrayInputStream.read() & 0xFF) != 0) {
            throw new AppIconException(1, "Invalid Block Terminator");
        }
    }

    private void checkComment(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private void checkApplication(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        byteArrayInputStream.skip(1L);
        byte[] byArray = new byte[11];
        byteArrayInputStream.read(byArray);
        String string = new String(byArray);
        if (string.equals("NETSCAPE2.0") || string.equals("ANIMEXTS1.0")) {
            bl = true;
        }
        while ((n = byteArrayInputStream.read()) != 0) {
            if (n == 3) {
                byte[] byArray2 = new byte[n];
                byteArrayInputStream.read(byArray2);
                if (byArray2[0] != 1) continue;
                bl2 = true;
                continue;
            }
            byteArrayInputStream.skip(n);
        }
        if (bl && bl2) {
            throw new AppIconException(5, "Animation GIF");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int checkFormat(byte[] byArray) {
        int n;
        int n2 = 0;
        ByteArrayInputStream byteArrayInputStream = null;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.checkHeader(byteArrayInputStream);
        while ((n = byteArrayInputStream.read()) != 59) {
            if (n == 44) {
                this.checkImageBlock(byteArrayInputStream);
                continue;
            }
            if (n != 33) break;
            int n3 = byteArrayInputStream.read();
            if (n3 == 1) {
                this.checkPlaneText(byteArrayInputStream);
                continue;
            }
            if (n3 == 249) {
                this.checkGraphicControl(byteArrayInputStream);
                continue;
            }
            if (n3 == 254) {
                this.checkComment(byteArrayInputStream);
                continue;
            }
            if (n3 != 255) break;
            this.checkApplication(byteArrayInputStream);
        }
        Object var7_8 = null;
        if (byteArrayInputStream == null) return n2;
        try {
            byteArrayInputStream.close();
            return n2;
        }
        catch (Exception exception) {}
        return n2;
        {
            catch (AppIconException appIconException) {
                n2 = appIconException.getType() * -1;
                Object var7_9 = null;
                if (byteArrayInputStream == null) return n2;
                try {
                    byteArrayInputStream.close();
                    return n2;
                }
                catch (Exception exception) {}
                return n2;
            }
            catch (Exception exception) {
                n2 = -99;
                Object var7_10 = null;
                if (byteArrayInputStream == null) return n2;
                try {
                    byteArrayInputStream.close();
                    return n2;
                }
                catch (Exception exception2) {}
                return n2;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (byteArrayInputStream == null) throw throwable;
            try {
                byteArrayInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

