/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractFrame;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.BMLPropUtil;
import com.nttdocomo.dojaemu.ktoolbar.BMLSettingWindow;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.io.File;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class BMLWindow
extends AbstractFrame {
    private JPanel jContentPane = null;
    private JPanel bmlPanel = null;
    private JPanel cooperationInfoPanel = null;
    private JLabel affiliationIdLabel = null;
    private JLabel jamNameLabel = null;
    private JPanel buttonPanel = null;
    private JButton launchButton = null;
    private JButton settingButton = null;
    private JButton endButton = null;
    private MainWindow parent;
    private Hashtable properties = null;
    private static final String JAM_FILE_EXTENSION = ".jam";

    BMLWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("BML_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.initialize();
        this.launchButton.setActionCommand("launch");
        this.settingButton.setActionCommand("set");
        this.endButton.setActionCommand("end");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.launchButton.addActionListener(actionDispatcher);
        this.settingButton.addActionListener(actionDispatcher);
        this.endButton.addActionListener(actionDispatcher);
        this.setResizable(false);
        this.pack();
    }

    void launch() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = (String)this.properties.get("JAM_NAME");
        if (!JAMManager.check(7, string2, string = (String)this.properties.get("AFFILIATION_ID"), stringBuffer)) {
            if (!stringBuffer.toString().equals(Resource.getString("NOT_APPLICATION_WNG"))) {
                stringBuffer.append(Resource.getString("NOT_LAUNCH_APPLICATION_WNG2"));
            }
            this.parent.showDialog(stringBuffer.toString(), this, 2);
            return;
        }
        String string3 = (String)this.properties.get("PARAMETER");
        if (string2.length() != 0 && string2.endsWith(JAM_FILE_EXTENSION)) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            string2 = string2.substring(0, string2.length() - 4);
        }
        JOptionPane jOptionPane = new JOptionPane(Resource.format("BML_LAUNCH_APPLICATION", new String[]{string2, this.convStrToForMessage(string3, 30)}), 3, 0);
        JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object instanceof Integer && (Integer)object == 0) {
            try {
                this.parent.setVisibleInvoker(7, false);
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put(Resource.getString("BML_PARAMETER_KEY"), string3);
                JAMManager.invokeApplication(JAMManager.getAdfPath(), JAMManager.getJarPath(), 21, JAMManager.getParams(hashtable), this.parent.getDeviceName(), this.parent.getAdfUrl(), JAMManager.getProjectName(), DebugTraceWindow.getDebugParam());
            }
            catch (Exception exception) {
                this.parent.setVisibleInvoker(7, true);
                this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
                return;
            }
            this.parent.setEnabledDeviceMenu(false);
        }
    }

    void set() {
        BMLSettingWindow bMLSettingWindow = new BMLSettingWindow(this.parent, this);
        bMLSettingWindow.setLocation(this.parent.getShowLocation(bMLSettingWindow.getWidth(), bMLSettingWindow.getHeight(), this));
        bMLSettingWindow.setVisible(true);
    }

    void end() {
        this.parent.closeWindow(this);
    }

    Hashtable getProperties() {
        return this.properties;
    }

    void setProperties(Hashtable hashtable) {
        this.affiliationIdLabel.setText(Resource.getString("BML_AFFILIATION_ID") + (String)hashtable.get("AFFILIATION_ID"));
        String string = (String)hashtable.get("JAM_NAME");
        if (string == null) {
            string = "";
        } else if (string.endsWith(JAM_FILE_EXTENSION)) {
            string = string.substring(0, string.length() - 4);
        }
        this.jamNameLabel.setText(Resource.getString("BML_COOPERATION_INFO") + string);
        this.properties = hashtable;
        this.pack();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getBmlPanel(), "North");
            this.jContentPane.add((Component)this.getCooperationInfoPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getBmlPanel() {
        if (this.bmlPanel == null) {
            this.bmlPanel = new BMLMonitor();
        }
        return this.bmlPanel;
    }

    private JPanel getCooperationInfoPanel() {
        if (this.cooperationInfoPanel == null) {
            String string;
            this.properties = new Hashtable();
            BMLPropUtil.load(this.properties);
            String string2 = (String)this.properties.get("AFFILIATION_ID");
            if (string2 == null) {
                string2 = "";
            }
            if ((string = (String)this.properties.get("JAM_NAME")) == null) {
                string = "";
            } else if (string.endsWith(JAM_FILE_EXTENSION)) {
                string = string.substring(0, string.length() - 4);
            }
            this.affiliationIdLabel = new JLabel(Resource.getString("BML_AFFILIATION_ID") + string2, 0);
            this.jamNameLabel = new JLabel(Resource.getString("BML_COOPERATION_INFO") + string, 0);
            this.cooperationInfoPanel = new JPanel();
            this.cooperationInfoPanel.setLayout(new GridLayout(2, 1, 0, 3));
            this.cooperationInfoPanel.add(this.affiliationIdLabel);
            this.cooperationInfoPanel.add(this.jamNameLabel);
            this.cooperationInfoPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("BML_COOPERATION_INFORMATION")));
        }
        return this.cooperationInfoPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getLaunchButton(), null);
            this.buttonPanel.add((Component)this.getSettingButton(), null);
            this.buttonPanel.add((Component)this.getEndButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getLaunchButton() {
        if (this.launchButton == null) {
            this.launchButton = new JButton();
            this.launchButton.setText(Resource.getString("RUN_BML_IAPPLI"));
        }
        return this.launchButton;
    }

    private JButton getSettingButton() {
        if (this.settingButton == null) {
            this.settingButton = new JButton();
            this.settingButton.setText(Resource.getString("SET_BML_COOPERATION_INFO"));
        }
        return this.settingButton;
    }

    private JButton getEndButton() {
        if (this.endButton == null) {
            this.endButton = new JButton();
            this.endButton.setText(Resource.getString("BML_EXIT"));
        }
        return this.endButton;
    }

    private String convStrToForMessage(String string, int n) {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n3 = 0;
        for (n3 = 0; n3 < string.length(); n3 += n) {
            if (n2 >= string.length()) {
                n2 = string.length();
            }
            stringBuffer.append(string.substring(n3, n2));
            if (n2 < string.length()) {
                stringBuffer.append("\n");
            }
            n2 += n;
        }
        return stringBuffer.toString();
    }

    private class BMLMonitor
    extends JPanel {
        private final int WIDTH = 240;
        private final int HEIGHT = 258;
        private final String IMG_BASE;
        private final String[] ICON_FILE = new String[]{"antenna.gif", "battery.gif"};
        private final int[][] ICON_POS = new int[][]{{4, 0}, {163, 2}};
        private Image[] iconImage;
        private Image bmlImage;

        BMLMonitor() {
            this.IMG_BASE = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "skin" + File.separator + "device1" + File.separator;
            this.setPreferredSize(new Dimension(240, 258));
            this.setBackground(Color.WHITE);
            this.iconImage = new Image[this.ICON_FILE.length];
            for (int i = 0; i < this.iconImage.length; ++i) {
                ImageIcon imageIcon = new ImageIcon(this.IMG_BASE + this.ICON_FILE[i]);
                this.iconImage[i] = imageIcon.getImage();
            }
            ImageIcon imageIcon = new ImageIcon(this.IMG_BASE + "bml.gif");
            this.bmlImage = imageIcon.getImage();
        }

        protected synchronized void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(new Color(186, 231, 217));
            graphics2D.fillRect(0, 0, this.getWidth(), 17);
            graphics2D.fillRect(0, 240, this.getWidth(), 18);
            graphics2D.setPaint(new Color(128, 255, 255));
            graphics2D.fillRect(2, 242, 48, 14);
            graphics2D.fillRect(this.getWidth() - 50, 242, 48, 14);
            graphics2D.drawImage(this.iconImage[0], this.ICON_POS[0][0], this.ICON_POS[0][1], null);
            graphics2D.drawImage(this.iconImage[1], this.getWidth() - (240 - this.ICON_POS[1][0]), this.ICON_POS[1][1], null);
            graphics2D.drawImage(this.bmlImage, (this.getWidth() - this.bmlImage.getWidth(null)) / 2, 111, null);
        }
    }
}

