/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractFrame;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.InlineView;

class BrowserWindow
extends AbstractFrame {
    private static final int FRAME_WIDTH = 400;
    private static final int FRAME_HEIGHT = 400;
    private static final int MAX_PARAM_NUM = 16;
    private static final int MAX_PARAM_LEN = 255;
    private static final String TITLE = Resource.getString("BROWSER_WINDOW_TITLE");
    private static final String HTTP_HEAD = "http://";
    private static final String HTTPS_HEAD = "https://";
    private static final String FILE_HEAD = "file:/";
    private JComboBox urlList;
    private static final int URL_LIST_MAX_COUNT = 10;
    private int[] order = new int[10];
    private static boolean addList = true;
    private int keyCode = 0;
    private static boolean setRegistry = true;
    private JEditorPane editorPane;
    private String urlString;
    private boolean appResumeFlag = false;

    BrowserWindow(MainWindow mainWindow, boolean bl) {
        this(mainWindow);
        this.appResumeFlag = bl;
    }

    BrowserWindow(MainWindow mainWindow) {
        super(mainWindow, TITLE);
        this.addWindowListener();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("URL"));
        this.urlList = new JComboBox();
        int n = 0;
        for (int i = 1; i <= 10; ++i) {
            byte[] byArray = JAMManager.getUrlHistory(i);
            int n2 = byArray.length;
            if (n2 <= 0) continue;
            this.urlList.insertItemAt(new String(byArray, 0, n2), n);
            this.order[n] = JAMManager.getOrder(i);
            ++n;
        }
        this.listSort();
        if (0 < this.urlList.getItemCount()) {
            this.urlList.setSelectedIndex(-1);
        }
        this.urlList.setMaximumRowCount(this.urlList.getItemCount());
        this.urlList.setEditable(true);
        JTextField jTextField = (JTextField)this.urlList.getEditor().getEditorComponent();
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                    BrowserWindow.this.keyCode = keyEvent.getKeyCode();
                } else {
                    BrowserWindow.this.keyCode = 0;
                }
            }
        });
        JSeparator jSeparator = new JSeparator(0);
        this.editorPane = new JEditorPane();
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        BrowserWindowHyperlinkListener browserWindowHyperlinkListener = new BrowserWindowHyperlinkListener(this);
        this.editorPane.addHyperlinkListener(browserWindowHyperlinkListener);
        this.editorPane.setEditorKit(new NewHTMLEditorKit());
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        UrlActionListener urlActionListener = new UrlActionListener();
        this.urlList.addActionListener(urlActionListener);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jLabel);
        jPanel2.add(this.urlList);
        jPanel.add("North", jSeparator);
        jPanel.add("Center", jScrollPane);
        container.add("North", jPanel2);
        container.add("Center", jPanel);
        this.setSize(400, 400);
    }

    private void setUrlHistory(String string, int n) {
        if (JAMManager.setUrlHistory((string + '\u0000').getBytes(), n) == -1) {
            setRegistry = false;
            this.parent.showDialog(Resource.getString("URL_HISTORY_WNG"), this, 2);
        }
    }

    private void setOrder(int n, int n2) {
        if (JAMManager.setOrder(n, n2) == -1) {
            setRegistry = false;
            this.parent.showDialog(Resource.getString("URL_HISTORY_WNG"), this, 2);
        }
    }

    private void listSort() {
        int n = this.urlList.getSelectedIndex();
        if (n == -1) {
            n = this.urlList.getItemCount();
        }
        for (int i = 0; i < this.urlList.getItemCount() - 1 && i < n; ++i) {
            for (int j = i + 1; j < this.urlList.getItemCount() && j <= n; ++j) {
                if (this.order[i] >= this.order[j] && (this.order[i] != this.order[j] || n != j)) continue;
                this.urlList.insertItemAt(this.urlList.getItemAt(j), i);
                this.urlList.removeItemAt(j + 1);
                int n2 = this.order[j];
                for (int k = j; i < k; --k) {
                    this.order[k] = this.order[k - 1];
                }
                this.order[i] = n2;
                if (n != j) continue;
                n = i;
            }
        }
        if (n != this.urlList.getSelectedIndex() && this.urlList.getSelectedIndex() >= 0) {
            this.urlList.setSelectedIndex(n);
        }
    }

    private void setList() {
        if (addList) {
            int n;
            int n2 = this.urlList.getSelectedIndex();
            if (0 <= n2) {
                int n3 = n2;
                this.order[n3] = this.order[n3] + 1;
                this.listSort();
            } else {
                this.urlList.insertItemAt(this.urlString, 0);
                this.urlList.setSelectedIndex(0);
                if (10 < this.urlList.getItemCount()) {
                    this.urlList.removeItemAt(10);
                } else {
                    this.urlList.setMaximumRowCount(this.urlList.getItemCount());
                }
                for (n = this.urlList.getItemCount() - 1; 0 < n; --n) {
                    this.order[n] = this.order[n - 1];
                }
                this.order[0] = this.order[0] + 1;
            }
            for (int i = 0; i < 10 && setRegistry; ++i) {
                String string;
                if (i < this.urlList.getItemCount()) {
                    string = (String)this.urlList.getItemAt(i);
                    n = this.order[i];
                } else {
                    string = "";
                    n = 0;
                }
                this.setUrlHistory(string, i + 1);
                if (!setRegistry) continue;
                this.setOrder(n, i + 1);
            }
            setRegistry = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void browse() {
        this.urlString = this.urlList.getSelectedItem().toString().trim();
        if (this.urlString.length() == 0) {
            return;
        }
        this.setTitle(TITLE + Resource.getString("READING"));
        String string = Resource.getString("COMPLETE_READING");
        String string2 = this.urlString;
        try {
            try {
                URL uRL = new URL(this.urlString);
                if (this.urlString.startsWith("file") && !this.urlString.endsWith("/")) {
                    String string3 = uRL.getPath();
                    while (string3.startsWith("/")) {
                        string3 = string3.substring(1);
                    }
                    File file = new File(string3);
                    if (file.isDirectory()) {
                        this.urlString = this.urlString + "/";
                    }
                }
                this.editorPane.setPage(this.urlString);
                this.setList();
            }
            catch (MalformedURLException malformedURLException) {
                string = Resource.getString("PROTOCOL_ERR");
                System.err.println(string);
                Object var7_10 = null;
                addList = true;
                this.setTitle(TITLE + " - " + string);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                string = Resource.format("NOT_FOUND_ERR2", string2);
                System.err.println(string);
                Object var7_11 = null;
                addList = true;
                this.setTitle(TITLE + " - " + string);
                return;
            }
            catch (IOException iOException) {
                string = Resource.getString("COM_ERR");
                System.err.println(string);
                System.err.println(iOException);
                Object var7_12 = null;
                addList = true;
                this.setTitle(TITLE + " - " + string);
                return;
            }
            Object var7_9 = null;
            addList = true;
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            addList = true;
            this.setTitle(TITLE + " - " + string);
            throw throwable;
        }
        this.setTitle(TITLE + " - " + string);
    }

    void setURL(String string) {
        addList = false;
        this.urlList.setSelectedItem(string);
    }

    boolean getAppResumeFlag() {
        return this.appResumeFlag;
    }

    private String getAdfUrl(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        try {
            string2 = this.editorPane.getText();
            int n = string2.indexOf(string);
            string2 = string2.substring(0, n);
            n = string2.toLowerCase().lastIndexOf("<object");
            string2 = string2.substring(n);
            n = string2.toLowerCase().indexOf("data");
            string2 = string2.substring(n);
            n = string2.toLowerCase().indexOf("\"") + 1;
            string2 = string2.substring(n);
            n = string2.toLowerCase().indexOf(".jam") + 4;
            string2 = string2.substring(0, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string2 = null;
        }
        return string2;
    }

    private String getAdfUrl(HyperlinkEvent hyperlinkEvent, String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = -1;
        int n2 = 0;
        if (string == null) {
            return string2;
        }
        string3 = this.editorPane.getText();
        while (n2 < string3.length()) {
            try {
                string4 = string3.substring(n2);
                n = string4.toLowerCase().indexOf("<object");
                n2 += n;
                string4 = string4.substring(n);
                n = string4.toLowerCase().indexOf(">");
                n2 += n + 1;
                string4 = string4.substring(0, n);
                n = string4.toLowerCase().indexOf("id");
                string5 = string4.substring(n);
                n = string5.toLowerCase().indexOf("\"") + 1;
                string6 = (string5 = string5.substring(n)).substring(0, n = string5.toLowerCase().indexOf("\""));
                if (!string6.equals(string.toLowerCase())) continue;
                n = string4.toLowerCase().indexOf("data");
                string5 = string4.substring(n);
                n = string5.toLowerCase().indexOf("\"") + 1;
                string5 = string5.substring(n);
                n = string5.toLowerCase().indexOf("\"");
                string2 = string5.substring(0, n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                string2 = null;
            }
            break;
        }
        return string2;
    }

    private Hashtable getParameter(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String string2 = this.editorPane.getText();
            int n = string2.indexOf(string);
            string2 = string2.substring(0, n);
            n = string2.toLowerCase().lastIndexOf("<object") + 8;
            string2 = string2.substring(n);
            n = string2.toLowerCase().indexOf(">");
            string2 = string2.substring(0, n);
            int n2 = 0;
            String string3 = string2;
            while (string3.trim().length() != 0) {
                n = string3.indexOf("=\"");
                int n3 = string3.indexOf("\"") + 1;
                int n4 = string3.indexOf("\"", n3);
                String string4 = string3.substring(0, n).trim();
                if (!(string4.toLowerCase().equals("declare") || string4.toLowerCase().equals("data") || string4.toLowerCase().equals("id") || string4.toLowerCase().equals("type"))) {
                    String string5 = string3.substring(0, n).trim();
                    String string6 = string3.substring(n3, n4).trim();
                    if (string5.length() != 0 && string6.length() != 0) {
                        hashtable.put(string5, string6);
                        n2 = n2 + string5.getBytes().length + string6.getBytes().length;
                    }
                }
                string3 = string3.substring(n4 + 1);
            }
            if (hashtable.size() > 16 || n2 > 255) {
                hashtable = null;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            hashtable = null;
        }
        return hashtable;
    }

    private Hashtable getParameter(HyperlinkEvent hyperlinkEvent, String string) {
        Hashtable hashtable = new Hashtable();
        Document document = this.editorPane.getDocument();
        if (string == null) {
            return null;
        }
        if (document instanceof HTMLDocument) {
            Element element;
            int n;
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            this.findHtmlElement(hTMLDocument.getDefaultRootElement(), "body", vector, 0);
            for (n = 0; n < vector.size(); ++n) {
                element = (Element)vector.get(n);
                this.findHtmlElement(element, "object", vector2, 0);
            }
            for (n = 0; n < vector2.size(); ++n) {
                element = (Element)vector2.get(n);
                AttributeSet attributeSet = element.getAttributes();
                String string2 = (String)attributeSet.getAttribute(HTML.Attribute.ID);
                String string3 = (String)attributeSet.getAttribute(HTML.Attribute.DATA);
                if (string2 == null || string3 == null || !string2.equals(string.toLowerCase())) continue;
                int n2 = 0;
                Enumeration<?> enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    if (!(obj instanceof String)) continue;
                    String string4 = (String)attributeSet.getAttribute(obj);
                    if (((String)obj).length() == 0 || string4.length() == 0) continue;
                    hashtable.put(obj, string4);
                    n2 = n2 + ((String)obj).getBytes().length + string4.getBytes().length;
                }
                if (hashtable.size() <= 16 && n2 <= 255) break;
                hashtable = null;
                break;
            }
        }
        return hashtable;
    }

    private void findHtmlElement(Element element, String string, Vector vector, int n) {
        int n2 = n + 1;
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element element2 = element.getElement(i);
            if (element2.getName().toLowerCase().equals(string)) {
                vector.addElement(element2);
            }
            this.findHtmlElement(element2, string, vector, n2);
        }
    }

    private Hashtable getParameter2(HyperlinkEvent hyperlinkEvent, String string) {
        String string2 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = -1;
        int n2 = 0;
        if (string == null) {
            return hashtable;
        }
        string3 = this.editorPane.getText();
        while (n2 < string3.length()) {
            try {
                string4 = string3.substring(n2);
                n2 = n = string4.toLowerCase().indexOf("<object");
                string4 = string4.substring(n);
                n = string4.toLowerCase().indexOf(">");
                n2 += n + 1;
                string4 = string4.substring(7, n + 1);
                n = string4.toLowerCase().indexOf("id");
                string5 = string4.substring(n);
                n = string5.toLowerCase().indexOf("\"") + 1;
                string6 = (string5 = string5.substring(n)).substring(0, n = string5.toLowerCase().indexOf("\""));
                if (!string6.equals(string.toLowerCase())) continue;
                string2 = new String(string4);
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                string2 = null;
                break;
            }
        }
        if (string2 != null) {
            try {
                int n3 = 0;
                String string7 = string2;
                while (string7.trim().length() != 0) {
                    int n4 = string7.indexOf("=\"");
                    int n5 = string7.indexOf("\"") + 1;
                    int n6 = string7.indexOf("\"", n5);
                    if (n4 == -1 || n5 == 0 || n6 == -1) break;
                    String string8 = string7.substring(0, n4).trim();
                    if (!(string8.toLowerCase().equals("declare") || string8.toLowerCase().equals("data") || string8.toLowerCase().equals("id") || string8.toLowerCase().equals("type"))) {
                        String string9 = string7.substring(0, n4).trim();
                        String string10 = string7.substring(n5, n6).trim();
                        if (string9.length() != 0 && string10.length() != 0) {
                            hashtable.put(string9, string10);
                            n3 = n3 + string9.getBytes().length + string10.getBytes().length;
                        }
                    }
                    if (n6 == string7.length() - 1) break;
                    string7 = string7.substring(n6 + 1);
                }
                if (hashtable.size() > 16 || n3 > 255) {
                    hashtable = null;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                hashtable = null;
            }
        }
        return hashtable;
    }

    private String getUrl(String string) {
        String string2;
        if (string.toLowerCase().startsWith(HTTP_HEAD) || string.toLowerCase().startsWith(HTTPS_HEAD)) {
            string2 = string;
        } else {
            int n = 0;
            string2 = this.urlString;
            if (string.startsWith("/")) {
                String string3;
                if (string2.toLowerCase().startsWith(HTTP_HEAD)) {
                    n = HTTP_HEAD.length();
                    string3 = string2.substring(n);
                } else if (string2.toLowerCase().startsWith(FILE_HEAD)) {
                    n = FILE_HEAD.length();
                    string3 = string2.substring(n);
                } else {
                    string3 = string2;
                }
                int n2 = string3.indexOf("/");
                if (n2 == -1) {
                    string2 = string2 + "/";
                    n2 = string3.length();
                }
                string2 = string2.substring(0, n += n2) + string;
            } else if (string2.endsWith("/")) {
                string2 = string2 + string;
            } else {
                String string4;
                if (string2.toLowerCase().startsWith(HTTP_HEAD)) {
                    n = HTTP_HEAD.length();
                    string4 = string2.substring(n);
                } else if (string2.toLowerCase().startsWith(FILE_HEAD)) {
                    n = FILE_HEAD.length();
                    string4 = string2.substring(n);
                } else {
                    string4 = string2;
                }
                int n3 = string4.lastIndexOf("/");
                if (n3 == -1) {
                    string2 = string2 + "/" + string;
                    return string2;
                }
                String string5 = string4.substring(n3 + 1);
                string4 = string2.substring(n += n3 + 1);
                string2 = string5.toLowerCase().indexOf(".htm") != -1 || string5.toLowerCase().indexOf(".html") != -1 ? string2.substring(0, n) + string : string2 + "/" + string;
            }
        }
        return string2;
    }

    private int getType() {
        int n;
        try {
            String string = this.editorPane.getText();
            int n2 = string.toLowerCase().lastIndexOf("<a");
            string = string.substring(n2);
            n2 = string.toLowerCase().indexOf(">") + 1;
            string = string.substring(0, n2);
            n = string.toLowerCase().indexOf("ijam=") != -1 || string.toLowerCase().indexOf("ista=") != -1 ? 5 : (string.toLowerCase().indexOf("ilet=") != -1 ? 9 : -1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            n = -1;
        }
        return n;
    }

    private int getType(HyperlinkEvent hyperlinkEvent) {
        Object object = null;
        int n = -1;
        AttributeSet attributeSet = hyperlinkEvent.getSourceElement().getAttributes();
        Object object2 = attributeSet.getAttribute(HTML.Tag.A);
        if (object2 != null && object2 instanceof AttributeSet) {
            AttributeSet attributeSet2 = (AttributeSet)object2;
            object = attributeSet2.getAttribute("ista");
            if (object != null && object instanceof String) {
                n = 5;
            } else {
                object = attributeSet2.getAttribute("ijam");
                if (object != null && object instanceof String) {
                    n = 5;
                } else {
                    object = attributeSet2.getAttribute("ilet");
                    if (object != null && object instanceof String) {
                        n = 9;
                    }
                }
            }
        }
        return n;
    }

    private String getTargetId(HyperlinkEvent hyperlinkEvent) {
        String string = null;
        Object object = null;
        AttributeSet attributeSet = hyperlinkEvent.getSourceElement().getAttributes();
        Object object2 = attributeSet.getAttribute(HTML.Tag.A);
        if (object2 != null && object2 instanceof AttributeSet) {
            AttributeSet attributeSet2 = (AttributeSet)object2;
            object = attributeSet2.getAttribute("ista");
            if (object != null && object instanceof String) {
                string = (String)object;
            } else {
                object = attributeSet2.getAttribute("ijam");
                if (object != null && object instanceof String) {
                    string = (String)object;
                } else {
                    object = attributeSet2.getAttribute("ilet");
                    if (object != null && object instanceof String) {
                        string = (String)object;
                    }
                }
            }
        }
        if (string != null) {
            string = string.substring(1);
        }
        return string;
    }

    private boolean isAdvancedVersion(HyperlinkEvent hyperlinkEvent) {
        boolean bl = true;
        Method method = null;
        Class<?> clazz = hyperlinkEvent.getClass();
        try {
            method = clazz.getMethod("getSourceElement", null);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    class NewHTMLFactory
    extends HTMLEditorKit.HTMLFactory {
        NewHTMLFactory() {
        }

        public View create(Element element) {
            if (element.getName().toLowerCase().equals("object")) {
                return new InlineView(element);
            }
            return super.create(element);
        }
    }

    class NewHTMLEditorKit
    extends HTMLEditorKit {
        NewHTMLEditorKit() {
        }

        public ViewFactory getViewFactory() {
            return new NewHTMLFactory();
        }
    }

    class BrowserWindowHyperlinkListener
    implements HyperlinkListener {
        private BrowserWindow window;

        BrowserWindowHyperlinkListener(BrowserWindow browserWindow2) {
            this.window = browserWindow2;
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Object object;
                if (JAMManager.getState() != 4) {
                    String string = Resource.getString("EXIT_CONNECT_WNG");
                    BrowserWindow.this.parent.showDialog(string, this.window, 2);
                    return;
                }
                String string = null;
                if (BrowserWindow.this.isAdvancedVersion(hyperlinkEvent)) {
                    object = BrowserWindow.this.getTargetId(hyperlinkEvent);
                    string = BrowserWindow.this.getAdfUrl(hyperlinkEvent, (String)object);
                } else {
                    string = BrowserWindow.this.getAdfUrl(hyperlinkEvent.getDescription());
                }
                if (string == null) {
                    if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                        object = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                        HTMLDocument hTMLDocument = (HTMLDocument)BrowserWindow.this.editorPane.getDocument();
                        hTMLDocument.processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)object);
                    } else if (hyperlinkEvent.getURL() != null) {
                        addList = false;
                        BrowserWindow.this.urlList.setSelectedItem(hyperlinkEvent.getURL().toString());
                        BrowserWindow.this.browse();
                    }
                } else {
                    String string2;
                    object = null;
                    int n = -1;
                    StringBuffer stringBuffer = new StringBuffer("");
                    if (BrowserWindow.this.isAdvancedVersion(hyperlinkEvent)) {
                        n = BrowserWindow.this.getType(hyperlinkEvent);
                        string2 = BrowserWindow.this.getTargetId(hyperlinkEvent);
                        object = BrowserWindow.this.getParameter(hyperlinkEvent, string2);
                    } else {
                        n = BrowserWindow.this.getType();
                        object = BrowserWindow.this.getParameter(hyperlinkEvent.getDescription());
                    }
                    if (JAMManager.check(1, string, BrowserWindow.this.urlString, stringBuffer) && object != null && n != -1) {
                        string2 = null;
                        string2 = JAMManager.getGpsState() && JAMManager.isGPSAppli(string) ? Resource.getString("LOCATION_SECURITY_WNG") : Resource.getString("LAUNCH_APPLICATION");
                        JOptionPane jOptionPane = new JOptionPane(string2, 3, 0);
                        JDialog jDialog = jOptionPane.createDialog(this.window, Resource.getString("CONFIRM"));
                        jDialog.setResizable(false);
                        jDialog.setVisible(true);
                        Object object2 = jOptionPane.getValue();
                        if (object2 instanceof Integer) {
                            if ((Integer)object2 != 0) {
                                return;
                            }
                        } else {
                            return;
                        }
                        try {
                            BrowserWindow.this.parent.setVisibleInvoker(1, false);
                            JAMManager.invokeApplication(JAMManager.getAdfPath(), JAMManager.getJarPath(), n, JAMManager.getParams((Hashtable)object), BrowserWindow.this.parent.getDeviceName(), BrowserWindow.this.parent.getAdfUrl(), JAMManager.getProjectName(), DebugTraceWindow.getDebugParam());
                        }
                        catch (Exception exception) {
                            BrowserWindow.this.parent.setVisibleInvoker(1, true);
                            BrowserWindow.this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this.window, 0);
                            return;
                        }
                        BrowserWindow.this.parent.setEnabledDeviceMenu(false);
                    } else if (stringBuffer.toString().equals(Resource.getString("NOT_APPLICATION_WNG"))) {
                        String string3 = BrowserWindow.this.getUrl(hyperlinkEvent.getDescription().trim());
                        string2 = stringBuffer.toString();
                        BrowserWindow.this.parent.showDialog(string2, this.window, 2);
                        addList = false;
                        BrowserWindow.this.urlList.setSelectedItem(string3);
                        BrowserWindow.this.browse();
                    } else {
                        string2 = Resource.getString("NOT_LAUNCH_APPLICATION_WNG2");
                        BrowserWindow.this.parent.showDialog(string2, this.window, 2);
                    }
                }
            }
        }
    }

    class UrlActionListener
    implements ActionListener {
        UrlActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BrowserWindow.this.keyCode == 10 || "comboBoxChanged".equals(actionEvent.getActionCommand()) && BrowserWindow.this.keyCode == 0 && BrowserWindow.this.urlList.getSelectedIndex() > -1 && addList) {
                BrowserWindow.this.browse();
            }
            BrowserWindow.this.keyCode = 0;
        }
    }
}

