/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.ADFNeedChecker;
import com.nttdocomo.dojaemu.ktoolbar.BuildException;
import com.nttdocomo.dojaemu.ktoolbar.DeployWindow;
import com.nttdocomo.dojaemu.ktoolbar.Environment;
import com.nttdocomo.dojaemu.ktoolbar.ExecuteProcess;
import com.nttdocomo.dojaemu.ktoolbar.IAppliChecker;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.JarAccess;
import com.nttdocomo.dojaemu.ktoolbar.JavaFileSelector;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.ReadWindowClassTag;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import com.nttdocomo.dojaemu.ktoolbar.SourceChecker;
import com.nttdocomo.dojaemu.ktoolbar.StringChecker;
import com.nttdocomo.dojaemu.ktoolbar.iapplibrary.IAppLibInclude;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

class BuildProject
implements Runnable {
    private ADF adf;
    private String classpath;
    private File srcDir;
    private File resDir;
    private File binDir;
    private File jamFile;
    private File jarFile;
    private File jarCompFile;
    private File verifiedClassDir = null;
    private File unverifiedClassDir = null;
    private File stubDir = null;
    private MainWindow parent;
    private File downloadFile;
    private String projectName;
    private int launchType;
    private boolean isOnlyReqClass = true;
    private Vector includeLibList = new Vector();
    private Vector unUsedLibList = new Vector();
    private File iAppLibInDir = null;
    private Vector overWriteInfo = new Vector();
    private static final int MAX_COLUMN = 4;
    private static final String DOWNLOADHTML = "Download.html";
    private static final String DOWNLOADHTML_TEMP = "Download.txt";
    private static final String PROJECTNAME = "PROJECTNAME";
    private static final String ATTRIBUTE = "ATTRIBUTE";
    private static final String PACKAGEURL = "PACKAGEURL";
    private int buildSwitch = 0;
    private Setting projectSetting;

    BuildProject(File file, String string, int n, MainWindow mainWindow) throws BuildException {
        this.jamFile = file;
        this.classpath = string;
        this.launchType = n;
        this.parent = mainWindow;
        this.buildSwitch = mainWindow.getBuildSwitch();
        this.projectSetting = mainWindow.getProjectSetting();
        if (this.projectSetting == null) {
            this.buildSwitch = 0;
        }
        try {
            this.adf = new ADF(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException(Resource.format("NOT_FOUND_ERR", file.getPath()));
        }
        catch (IOException iOException) {
            throw new BuildException(Resource.format("READ_ERR", file.getPath()));
        }
        File file2 = file.getParentFile().getParentFile();
        this.srcDir = new File(file2, "src");
        this.resDir = new File(file2, "res");
        this.binDir = new File(file2, "bin");
        try {
            this.verifiedClassDir = File.createTempFile("class", "verified");
            this.unverifiedClassDir = File.createTempFile("class", "unverified");
            this.verifiedClassDir.delete();
            this.verifiedClassDir.mkdir();
            this.unverifiedClassDir.delete();
            this.unverifiedClassDir.mkdir();
            if (this.buildSwitch != 1) {
                this.unpackJarDir(this.verifiedClassDir);
                this.iAppLibInDir = this.verifiedClassDir;
            } else {
                String string2 = this.projectSetting.getProperty("componentName");
                if (string2 != null) {
                    if (string2.length() == 0) {
                        this.deleteAllTmpDir();
                        throw new BuildException(Resource.getString("NOT_FOUND_COMPJAR_ERR"));
                    }
                    if (!new StringChecker(string2).isFileName()) {
                        this.deleteAllTmpDir();
                        throw new BuildException(Resource.getString("PROP_ERR"));
                    }
                } else {
                    this.deleteAllTmpDir();
                    throw new BuildException(Resource.getString("NOT_FOUND_COMPJAR_ERR"));
                }
                this.stubDir = File.createTempFile("class", "stub");
                this.stubDir.delete();
                this.stubDir.mkdir();
                this.unpackJarDir(this.stubDir);
                this.iAppLibInDir = this.stubDir;
                String string3 = this.projectSetting.getProperty("componentName");
                this.jarCompFile = new File(this.binDir, string3 + ".jar");
            }
        }
        catch (IOException iOException) {
            this.deleteAllTmpDir();
            throw new BuildException(Resource.getString("MAKE_TMP_FILE_ERR"));
        }
        String string4 = file.getPath();
        String string5 = string4.substring(0, string4.lastIndexOf(".")) + ".jar";
        this.jarFile = new File(string5);
        this.projectName = file2.getName();
        String string6 = file.getParentFile().getPath() + File.separator + DOWNLOADHTML;
        this.downloadFile = new File(string6);
    }

    private boolean deleteTmpDir(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.deleteTmpDir(fileArray[i]);
                continue;
            }
            fileArray[i].delete();
        }
        return file.delete();
    }

    private boolean deleteAllTmpDir() {
        boolean bl = true;
        try {
            if (this.verifiedClassDir != null && !this.deleteTmpDir(this.verifiedClassDir)) {
                this.verifiedClassDir.deleteOnExit();
                bl = false;
            }
            if (this.unverifiedClassDir != null && !this.deleteTmpDir(this.unverifiedClassDir)) {
                this.unverifiedClassDir.deleteOnExit();
                bl = false;
            }
            if (this.stubDir != null && !this.deleteTmpDir(this.stubDir)) {
                this.stubDir.deleteOnExit();
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void unpackJarDir(File file) {
        if (!file.exists()) {
            return;
        }
        String[] stringArray = this.loadListFile();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            JarAccess jarAccess = new JarAccess(stringArray[i]);
            jarAccess.unpack(file.getPath(), false);
            this.MakeOverWriteMessage(stringArray[i], jarAccess.getOverWriteFiles());
        }
    }

    private void MakeOverWriteMessage(String string, Collection collection) {
        int n;
        if (collection.size() == 0) {
            return;
        }
        String string2 = "";
        if ((string != null || string.length() != 0) && (n = string.lastIndexOf(File.separator)) != -1) {
            string2 = string.substring(n + 1, string.length());
            string2 = string2 + " : ";
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.overWriteInfo.add(string2 + (String)iterator.next());
        }
    }

    private String[] makeJarCommand(String string, String string2) throws BuildException {
        String string3 = Resource.JAR;
        if (!new File(string3).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        Vector<String> vector = new Vector<String>();
        vector.add(string3);
        vector.add(string);
        vector.add(this.jarFile.getPath());
        vector.add("-C");
        vector.add(string2);
        vector.add(".");
        return vector.toArray(new String[0]);
    }

    private String[] makeJarCommand(String string, String string2, String string3, boolean bl) throws BuildException {
        String string4 = Resource.JAR;
        if (!new File(string4).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        Vector<String> vector = new Vector<String>();
        vector.add(string4);
        vector.add(string);
        vector.add(string3);
        if (bl) {
            vector.add("-C");
            vector.add(string2);
            vector.add(".");
        } else {
            vector.add(string2);
        }
        return vector.toArray(new String[0]);
    }

    private String getDate() {
        int n = 60000;
        int n2 = 60 * n;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Environment.getLocale());
        String string = simpleDateFormat.format(new Date());
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.isPreScript()) {
                System.out.println(Resource.getString("EXECUTION_PRE_SCRIPT"));
                this.doScript("optimize_script1.bat");
            }
            this.doJavac();
            this.choiceLibClass();
            this.doPreverify();
            long l = this.jarFile.lastModified();
            this.printLibInfo();
            this.doJar();
            if (this.isPostScript()) {
                System.out.println(Resource.getString("EXECUTION_POST_SCRIPT"));
                this.doScript("optimize_script2.bat");
            }
            this.updateJam();
            this.makeDownloadHtml(l);
            this.setProjectInfo();
            System.out.println(Resource.getString("FINISH_BUILD"));
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            System.out.println(Resource.format("LAST_JARFILE", this.jarFile.getName()) + Resource.format("LAST_JARSIZE", numberFormat.format(this.jarFile.length())));
            this.doDeploy();
            this.doIAppliCheck();
            this.doADFNeedCheck();
        }
        catch (BuildException buildException) {
            System.err.println(buildException.getMessage());
        }
        finally {
            this.deleteAllTmpDir();
            this.parent.setOperatable(true);
        }
    }

    void doJavac() throws BuildException {
        String string = Resource.JAVA;
        String string2 = Resource.DOJA_CONV;
        String string3 = Resource.TOOLS_JAR;
        if (!new File(string).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        if (!new File(string3).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        if (!new File(string2).exists()) {
            throw new BuildException(Resource.format("NOT_FOUND_ERR", string2));
        }
        Vector vector = JavaFileSelector.get(this.srcDir);
        if (vector == null || vector.size() == 0) {
            throw new BuildException(Resource.getString("SRC_NOT_FOUND_ERR"));
        }
        Vector<String> vector2 = new Vector<String>();
        vector2.add(string);
        vector2.add("-Xbootclasspath/a:" + string2);
        vector2.add("-classpath");
        vector2.add(string3);
        vector2.add(Environment.getJavaCompilerClassName(this.parent.getJavacType()));
        if (Package.getPackage("java.lang").isCompatibleWith("1.5.0") && this.parent.getJavacType() == 0) {
            System.out.println("JDK1.5 compile...");
            vector2.add("-target");
            vector2.add("1.2");
            vector2.add("-source");
            vector2.add("1.3");
        }
        vector2.add("-bootclasspath");
        vector2.add(this.classpath);
        vector2.add("-d");
        vector2.add(this.unverifiedClassDir.getPath());
        vector2.add("-classpath");
        vector2.add(this.unverifiedClassDir.getPath());
        vector2.add("-g:none");
        vector2.addAll(vector);
        String[] stringArray = vector2.toArray(new String[0]);
        try {
            ExecuteProcess executeProcess = new ExecuteProcess(stringArray, this.parent, 1);
            if (executeProcess.execute() != 0) {
                throw new BuildException(Resource.getString("JAVAC_ERR"));
            }
        }
        catch (Exception exception) {
            throw new BuildException(Resource.getString("JAVAC_ERR"));
        }
    }

    void doPreverify() throws BuildException {
        String string = Resource.PREVERIFY;
        if (!new File(string).exists()) {
            throw new BuildException(Resource.format("NOT_FOUND_ERR", string));
        }
        String[] stringArray = new String[6];
        String[] stringArray2 = this.getFileInDir(this.verifiedClassDir);
        stringArray[0] = string;
        stringArray[1] = "-classpath";
        stringArray[2] = this.classpath;
        stringArray[3] = "-d";
        stringArray[4] = this.verifiedClassDir.getPath();
        stringArray[5] = this.unverifiedClassDir.getPath();
        try {
            ExecuteProcess executeProcess = new ExecuteProcess(stringArray);
            if (executeProcess.execute() != 0) {
                throw new BuildException(Resource.getString("PREVERIFY_ERR"));
            }
        }
        catch (Exception exception) {
            throw new BuildException(Resource.getString("PREVERIFY_ERR"));
        }
        this.overWriteMessage(stringArray2, this.getFileInDir(this.unverifiedClassDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeManifest() throws BuildException {
        String string;
        String string2;
        String string3;
        BufferedWriter bufferedWriter = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Object var3_3 = null;
        String string4 = this.projectSetting.getProperty("componentTitle");
        if (string4 != null && string4.length() != 0) {
            hashtable.put("Specification-Title", string4);
        } else {
            string4 = this.projectSetting.getProperty("componentName");
            if (string4 != null) {
                hashtable.put("Specification-Title", string4);
            }
        }
        String string5 = this.projectSetting.getProperty("componentVersion");
        if (string5 != null) {
            hashtable.put("Specification-Version", string5);
        }
        if ((string3 = this.projectSetting.getProperty("componentVendor")) != null) {
            hashtable.put("Specification-Vendor", string3);
        }
        if ((string2 = this.projectSetting.getProperty("componentAuthor")) != null) {
            hashtable.put("Created-By", string2);
        }
        if ((string = new String(JAMManager.getBuildTargetProfile())) != null) {
            hashtable.put("Build-By", string);
        }
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.stubDir, "manifest.mf")), "UTF-8"));
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string6 = (String)enumeration.nextElement();
                String string7 = (String)hashtable.get(string6);
                String string8 = string6.trim() + ": " + string7.trim() + "\r\n";
                bufferedWriter.write(string8);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    String[] loadListFile() {
        var1_1 = new File(this.parent.getProjectPath(this.parent.getProjectName()) + File.separator + "component.list");
        if (!var1_1.exists()) {
            return new String[0];
        }
        var2_2 = 0;
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = new Vector<String>();
        try {
            var6_6 = new BufferedReader(new InputStreamReader(new FileInputStream(var1_1)));
            var8_8 = 0;
            while ((var3_3 = var6_6.readLine()) != null) {
                var3_3 = var3_3.trim();
                if (var8_8 != 0) ** GOTO lbl23
                if (var3_3.equals("true")) {
                    this.isOnlyReqClass = true;
                } else if (var3_3.equals("false")) {
                    this.isOnlyReqClass = false;
                } else {
                    this.isOnlyReqClass = true;
lbl23:
                    // 2 sources

                    if ((var2_2 = var3_3.lastIndexOf(32)) >= 0) {
                        var4_4 = var3_3.substring(0, var2_2).trim();
                        var5_5 = var3_3.substring(var2_2 + 1);
                        if (var5_5.length() == 1 && !var5_5.equals("0")) {
                            var7_7.addElement(var4_4);
                        }
                    }
                }
                ++var8_8;
            }
        }
        catch (FileNotFoundException var8_10) {
            var9_13 = null;
            return var9_13;
        }
        catch (IOException var8_11) {
            var9_14 = null;
            return var9_14;
        }
        catch (Exception var8_12) {
            var9_15 = null;
            return var9_15;
            {
                catch (Throwable var11_19) {
                    throw var11_19;
                }
            }
        }
        finally {
            try {
                var6_6.close();
            }
            catch (Exception var10_16) {}
        }
        if (var7_7.size() > 0) {
            return var7_7.toArray(new String[0]);
        }
        return new String[0];
    }

    void doJar() throws BuildException {
        block17: {
            this.jarFile.delete();
            if (this.buildSwitch == 1) {
                this.jarCompFile.delete();
                String string = this.projectSetting.getProperty("stubSourceName");
                int n = string.indexOf(".java");
                String string2 = string.substring(0, n) + ".class";
                String[] stringArray = this.getFileInDir(this.stubDir);
                File file = new File(this.verifiedClassDir, string2);
                File file2 = new File(this.stubDir, string2);
                if (file2.exists()) {
                    file2.delete();
                }
                if (!file.renameTo(file2)) {
                    throw new BuildException(Resource.getString("JAR_ERR"));
                }
                String[] stringArray2 = new String[]{string2};
                this.overWriteMessage(stringArray, stringArray2);
                try {
                    if (this.verifiedClassDir.list().length == 0) {
                        throw new BuildException(Resource.getString("JAR_ERR"));
                    }
                    String[] stringArray3 = this.makeJarCommand("cfM", this.verifiedClassDir.getPath(), this.jarCompFile.getPath(), true);
                    ExecuteProcess executeProcess = new ExecuteProcess(stringArray3);
                    if (executeProcess.execute() != 0) {
                        throw new BuildException(Resource.getString("JAR_ERR"));
                    }
                    stringArray3 = this.makeJarCommand("ufM", this.resDir.getPath(), this.jarCompFile.getPath(), true);
                    executeProcess = new ExecuteProcess(stringArray3);
                    if (executeProcess.execute() != 0) {
                        throw new BuildException(Resource.getString("JAR_ERR"));
                    }
                    JarAccess jarAccess = new JarAccess(this.jarCompFile.getPath());
                    jarAccess.unpack(this.stubDir.getPath());
                    stringArray3 = this.makeJarCommand("cfM", this.stubDir.getPath(), this.jarFile.getPath(), true);
                    executeProcess = new ExecuteProcess(stringArray3);
                    if (executeProcess.execute() != 0) {
                        throw new BuildException(Resource.getString("JAR_ERR"));
                    }
                    this.makeManifest();
                    stringArray3 = this.makeJarCommand("ufm", new File(this.stubDir, "manifest.mf").getPath(), this.jarCompFile.getPath(), false);
                    executeProcess = new ExecuteProcess(stringArray3);
                    if (executeProcess.execute() != 0) {
                        throw new BuildException(Resource.getString("JAR_ERR"));
                    }
                    break block17;
                }
                catch (BuildException buildException) {
                    throw buildException;
                }
                catch (Exception exception) {
                    throw new BuildException(Resource.format("MAKE_JAR_ERR", this.jarFile.getPath()));
                }
            }
            try {
                String[] stringArray = this.makeJarCommand("cfM", this.verifiedClassDir.getPath());
                ExecuteProcess executeProcess = new ExecuteProcess(stringArray);
                if (executeProcess.execute() != 0) {
                    throw new BuildException(Resource.getString("JAR_ERR"));
                }
                stringArray = this.makeJarCommand("ufM", this.resDir.getPath());
                executeProcess = new ExecuteProcess(stringArray);
                if (executeProcess.execute() != 0) {
                    throw new BuildException(Resource.getString("JAR_ERR"));
                }
            }
            catch (BuildException buildException) {
                throw buildException;
            }
            catch (Exception exception) {
                throw new BuildException(Resource.format("MAKE_JAR_ERR", this.jarFile.getPath()));
            }
        }
        System.out.println(Resource.format("MAKE_FILE", this.jarFile.getPath()));
        if (this.buildSwitch == 1) {
            System.out.println(Resource.format("MAKE_FILE", this.jarCompFile.getPath()));
        }
    }

    void updateJam() throws BuildException {
        String string = this.adf.getProperty("AppName");
        String string2 = this.adf.getProperty("AppClass");
        this.adf.setProperty("AppSize", String.valueOf(this.jarFile.length()));
        this.adf.setProperty("LastModified", this.getDate());
        try {
            if (string == null || string.equals("") || string2 == null || string2.equals("")) {
                SourceChecker sourceChecker = new SourceChecker();
                ArrayList arrayList = sourceChecker.getSourceList(this.srcDir.getPath());
                for (int i = 0; i < arrayList.size(); ++i) {
                    System.out.println(arrayList.get(i));
                }
                if (sourceChecker.checkMainClass(arrayList)) {
                    if (string == null) {
                        this.adf.setProperty("AppName", sourceChecker.getClassName());
                        System.out.println(Resource.format("UPDATE_ADFKEY", "AppName"));
                    }
                    if (string2 == null) {
                        if (sourceChecker.getPackageName().length() == 0) {
                            this.adf.setProperty("AppClass", sourceChecker.getClassName());
                        } else {
                            this.adf.setProperty("AppClass", sourceChecker.getPackageName() + "." + sourceChecker.getClassName());
                        }
                        System.out.println(Resource.format("UPDATE_ADFKEY", "AppClass"));
                    }
                    if (sourceChecker.getAppliType() == 1) {
                        this.adf.setProperty("MyConcierge", "yes");
                        this.parent.setLaunchConcierge();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.parent.saveProject(this.adf) == 0) {
            System.out.println(Resource.format("UPDATE_FILE", this.jamFile.getPath()));
        }
    }

    void makeDownloadHtml(long l) throws BuildException {
        try {
            String string;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            String string2 = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "template" + File.separator + DOWNLOADHTML_TEMP;
            if (this.downloadFile.exists() && l > 0L) {
                long l2 = this.downloadFile.lastModified() / 1000L;
                long l3 = Math.abs((l /= 1000L) - l2);
                if (l3 > 5L) {
                    return;
                }
                if (!this.checkDownloadHtml(this.downloadFile.toString(), string2)) {
                    return;
                }
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.downloadFile.toString())));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string2)));
            while ((string = bufferedReader.readLine()) != null) {
                string = this.replaceKeyword(string);
                bufferedWriter.write(string + "\r\n");
            }
            bufferedWriter.close();
            bufferedReader.close();
            System.out.println(Resource.format("MAKE_FILE", this.downloadFile.getPath()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean checkDownloadHtml(String string, String string2) {
        boolean bl;
        block22: {
            Exception exception2222;
            BufferedReader bufferedReader;
            BufferedReader bufferedReader2;
            block20: {
                block19: {
                    String string3;
                    String string4;
                    bl = true;
                    bufferedReader2 = null;
                    bufferedReader = null;
                    bufferedReader2 = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string2)));
                    while (bl && (string4 = bufferedReader2.readLine()) != null) {
                        string3 = bufferedReader.readLine();
                        if (string3 != null) {
                            if (!bl || this.compare(string3, string4)) continue;
                            bl = false;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    if (!bl || (string3 = bufferedReader.readLine()) == null) break block19;
                    bl = false;
                }
                Object var10_8 = null;
                if (bufferedReader2 == null) break block20;
                try {
                    bufferedReader2.close();
                }
                catch (Exception exception2222) {
                    bl = false;
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2222) {
                    bl = false;
                }
            }
            bufferedReader2 = null;
            bufferedReader = null;
            {
                break block22;
                catch (Exception exception3) {
                    Exception exception42222;
                    bl = false;
                    Object var10_9 = null;
                    if (bufferedReader2 != null) {
                        try {
                            bufferedReader2.close();
                        }
                        catch (Exception exception42222) {
                            bl = false;
                        }
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception42222) {
                            bl = false;
                        }
                    }
                    bufferedReader2 = null;
                    bufferedReader = null;
                }
            }
            catch (Throwable throwable) {
                Exception exception52222;
                Object var10_10 = null;
                if (bufferedReader2 != null) {
                    try {
                        bufferedReader2.close();
                    }
                    catch (Exception exception52222) {
                        bl = false;
                    }
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception52222) {
                        bl = false;
                    }
                }
                bufferedReader2 = null;
                bufferedReader = null;
                throw throwable;
            }
        }
        return bl;
    }

    String replaceKeyword(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf("{", n3)) != -1 && (n2 = string.indexOf("}", n3)) != -1) {
            String string2;
            String string3 = string.substring(n + 1, n2);
            if (string3.equals(PROJECTNAME)) {
                string = string.substring(0, n) + this.projectName + string.substring(n2 + 1);
                n3 = n + this.projectName.length();
                continue;
            }
            if (string3.equals(PACKAGEURL)) {
                string2 = this.adf.getProperty("PackageURL");
                string = string.substring(0, n) + string2.substring(0, string2.lastIndexOf(".")) + ".jam" + string.substring(n2 + 1);
                n3 = n + string2.substring(0, string2.lastIndexOf(".")).length() + 4;
                continue;
            }
            if (string3.equals(ATTRIBUTE)) {
                string2 = "ijam";
                if (this.launchType == 9) {
                    string2 = "ilet";
                } else if (this.launchType == 5) {
                    string2 = "ista";
                }
                string = string.substring(0, n) + string2 + string.substring(n2 + 1);
                n3 = n + string2.length();
                continue;
            }
            n3 = n2;
        }
        return string;
    }

    boolean compare(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string3 = null;
        try {
            while ((n = string.indexOf("{", n3)) != -1 && (n2 = string.indexOf("}", n3)) != -1) {
                String string4 = string.substring(n + 1, n2);
                n5 = string4.equals(PROJECTNAME) || string4.equals(PACKAGEURL) || string4.equals(ATTRIBUTE) ? n - n3 : n2 - n3;
                if (!string.regionMatches(n3, string2, n4, n5)) {
                    return false;
                }
                n3 = n2 + 1;
                n = string.indexOf("{", n3);
                string3 = n == -1 ? string.substring(n3) : string.substring(n3, n);
                n4 = string2.indexOf(string3, n4 + n5);
                if (n4 != -1) continue;
                return false;
            }
            if (!string.regionMatches(n3, string2, n4, string.length() - n3)) {
                return false;
            }
            if (string.length() - n3 != string2.length() - n4) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void setProjectInfo() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 128;
        String string5 = "@info";
        try {
            string4 = this.projectSetting.getProperty("projectInfo");
            ADF aDF = new ADF(this.jamFile);
            string2 = aDF.getProperty("AppClass");
            string3 = this.getAppClassSrcPath(string2);
            if (new File(string3).exists()) {
                ReadWindowClassTag readWindowClassTag = new ReadWindowClassTag(string3);
                readWindowClassTag.set(string5);
                string = readWindowClassTag.getTagText(n);
            } else {
                SourceChecker sourceChecker = new SourceChecker();
                ArrayList arrayList = sourceChecker.getSourceList(this.srcDir.getPath());
                if (sourceChecker.checkMainClass(arrayList)) {
                    string2 = sourceChecker.getPackageName().length() == 0 ? sourceChecker.getClassName() : sourceChecker.getPackageName() + "." + sourceChecker.getClassName();
                    string3 = this.getAppClassSrcPath(string2);
                    if (string3.length() != 0) {
                        ReadWindowClassTag readWindowClassTag = new ReadWindowClassTag(string3);
                        readWindowClassTag.set(string5);
                        string = readWindowClassTag.getTagText(n);
                    } else {
                        string = "";
                    }
                } else {
                    if (string4 == null) {
                        return;
                    }
                    string = "";
                }
            }
            if (string == null && string4 == null) {
                return;
            }
            if (string == null) {
                string = "";
            }
            this.projectSetting.setProperty("projectInfo", string);
            this.parent.saveProjectSetting(this.projectSetting);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getAppClassSrcPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "";
        }
        try {
            String string3;
            String string4;
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).equals(".")) {
                    stringBuffer.append(File.separator);
                    continue;
                }
                stringBuffer.append((String)object);
            }
            stringBuffer.append(".java");
            string2 = this.srcDir.getPath() + File.separator + stringBuffer.toString();
            object = new File(string2);
            if (!(((File)object).exists() || ((File)(object = new File(string2 = (string4 = this.srcDir.getParent()) + File.separator + stringBuffer.toString()))).exists() || ((File)(object = new File(string2 = (string3 = this.srcDir.getParentFile().getParent()) + File.separator + stringBuffer.toString()))).exists())) {
                string2 = "";
            }
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    private boolean isPreScript() {
        int n = this.parent.getBuildSetting();
        return n == 1 || n == 3;
    }

    private boolean isPostScript() {
        int n = this.parent.getBuildSetting();
        return n == 2 || n == 3;
    }

    private void doScript(String string) throws BuildException {
        String string2 = System.getProperty("emu.home") + File.separator + "lib" + File.separator + string;
        File file = this.jamFile.getParentFile().getParentFile();
        if (!new File(string2).exists()) {
            throw new BuildException(Resource.format("NOT_FOUND_ERR", string2));
        }
        String[] stringArray = new String[]{string2};
        String[] stringArray2 = new String[]{"PROJECT_NAME=" + this.parent.getProjectName(), "JAR_PATH=" + Resource.JAR, "APP_CLASS=" + this.getAppClass()};
        try {
            ExecuteProcess executeProcess = new ExecuteProcess(stringArray, stringArray2, this.binDir);
            if (executeProcess.execute() != 0) {
                throw new BuildException(Resource.getString("SCRIPT_ERR"));
            }
        }
        catch (Exception exception) {
            throw new BuildException(Resource.getString("SCRIPT_ERR"));
        }
    }

    private String getAppClass() {
        String string = this.adf.getProperty("AppClass");
        try {
            SourceChecker sourceChecker = new SourceChecker();
            ArrayList arrayList = sourceChecker.getSourceList(this.srcDir.getPath());
            if (sourceChecker.checkMainClass(arrayList) && string == null) {
                string = sourceChecker.getPackageName().length() == 0 ? sourceChecker.getClassName() : sourceChecker.getPackageName() + "." + sourceChecker.getClassName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    void doIAppliCheck() {
        try {
            IAppliChecker iAppliChecker = new IAppliChecker();
            iAppliChecker.iAppliChecker(this.jarFile.getPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void choiceLibClass() {
        String[] stringArray = this.iAppLibInDir.list();
        if (stringArray == null || stringArray.length == 0) {
            this.isOnlyReqClass = false;
            return;
        }
        if (this.isOnlyReqClass) {
            IAppLibInclude iAppLibInclude = new IAppLibInclude();
            Vector vector = new Vector();
            try {
                iAppLibInclude.setClassesList(this.unverifiedClassDir.getPath(), this.iAppLibInDir.getPath());
                vector.addAll(iAppLibInclude.getNoUseClass());
                this.includeLibList.addAll(iAppLibInclude.getNeedClassName());
                this.unUsedLibList.addAll(iAppLibInclude.getNoUseClassName());
            }
            catch (Exception exception) {
                System.out.println(Resource.getString("BLD_COMP_INCLUDE_ERR"));
                this.isOnlyReqClass = false;
            }
            if (this.isOnlyReqClass) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    File file = new File((String)enumeration.nextElement());
                    if (!file.exists()) continue;
                    file.delete();
                }
                this.deleteEmptyDir(this.iAppLibInDir);
            }
        }
    }

    private boolean deleteEmptyDir(File file) {
        boolean bl = true;
        try {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                this.deleteEmptyDir(fileArray[i]);
                File[] fileArray2 = fileArray[i].listFiles();
                if (fileArray2.length != 0 || fileArray[i].delete()) continue;
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    void doADFNeedCheck() {
        try {
            ADFNeedChecker aDFNeedChecker = new ADFNeedChecker(this.parent);
            aDFNeedChecker.ADFNeedCheck(this.jamFile.getPath(), this.jarFile.getPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void doDeploy() {
        if (!this.parent.getSimultaneousWithBuild()) {
            return;
        }
        DeployWindow deployWindow = new DeployWindow(this.parent, this.projectSetting, false);
        if (deployWindow.saveSetting()) {
            deployWindow.deployFiles();
        }
        deployWindow.dispose();
        deployWindow = null;
    }

    private void overWriteMessage(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return;
        }
        Arrays.sort(stringArray);
        Arrays.sort(stringArray2);
        try {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (Arrays.binarySearch(stringArray, stringArray2[i]) < 0) continue;
                System.out.println(Resource.format("OVERWRITE_FILE", stringArray2[i]));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private String[] getFileInDir(File file) {
        int n;
        File[] fileArray;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String string = "";
        String string2 = "";
        int n2 = 0;
        if (this.buildSwitch == 1) {
            string2 = this.stubDir.toString();
        }
        String[] stringArray = new String[]{this.verifiedClassDir.toString(), this.unverifiedClassDir.toString(), string2};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(file.toString())) continue;
            n2 = file.toString().length() + File.separator.length();
            break;
        }
        if ((fileArray = file.listFiles()) == null) {
            return null;
        }
        if (fileArray.length == 0) {
            return null;
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (fileArray[n].isDirectory()) {
                String[] stringArray2 = this.getFileInDir(fileArray[n]);
                if (stringArray2 == null) continue;
                for (int i = 0; i < stringArray2.length; ++i) {
                    vector.addElement(stringArray2[i]);
                }
                continue;
            }
            vector.addElement(fileArray[n].getPath());
        }
        vector.trimToSize();
        if (vector.size() == 0) {
            return null;
        }
        for (n = 0; n < vector.size(); ++n) {
            string = ((String)vector.get(n)).substring(n2);
            vector2.addElement(string);
        }
        vector2.trimToSize();
        return vector2.toArray(new String[0]);
    }

    void printLibInfo() {
        if (this.isOnlyReqClass) {
            StringBuffer stringBuffer = new StringBuffer(Resource.getString("BLD_COMP_START_SEPARATE"));
            if (this.overWriteInfo.size() != 0) {
                Enumeration enumeration = this.overWriteInfo.elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(Resource.format("BLD_COMP_OVERWRITE_CLS", (String)enumeration.nextElement()));
                }
            }
            int n = 1;
            int n2 = this.includeLibList.size();
            stringBuffer.append(Resource.getString("BLD_COMP_USE_CLASS"));
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append((String)this.includeLibList.get(n3));
                if (n < 4) {
                    if (n3 < n2 - 1) {
                        stringBuffer.append(", ");
                    } else {
                        stringBuffer.append("\n");
                    }
                } else if (n == 4) {
                    stringBuffer.append("\n");
                    n = 0;
                }
                ++n3;
                ++n;
            }
            n = 1;
            n2 = this.unUsedLibList.size();
            stringBuffer.append(Resource.getString("BLD_COMP_UNUSED_CLASS"));
            n3 = 0;
            while (n3 < n2) {
                stringBuffer.append((String)this.unUsedLibList.get(n3));
                if (n < 4) {
                    if (n3 < n2 - 1) {
                        stringBuffer.append(", ");
                    } else {
                        stringBuffer.append("\n");
                    }
                } else if (n == 4) {
                    stringBuffer.append("\n");
                    n = 0;
                }
                ++n3;
                ++n;
            }
            stringBuffer.append(Resource.getString("BLD_COMP_END_SEPARATE"));
            System.out.println(stringBuffer.toString());
        } else if (this.overWriteInfo.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer(Resource.getString("BLD_COMP_START_SEPARATE"));
            Enumeration enumeration = this.overWriteInfo.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(Resource.format("BLD_COMP_OVERWRITE_CLS", (String)enumeration.nextElement()));
            }
            stringBuffer.append(Resource.getString("BLD_COMP_END_SEPARATE"));
            System.out.println(stringBuffer.toString());
        }
    }
}

