/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.AbstractFrame;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class CodeReaderWindow
extends AbstractFrame {
    static final int FRAME_WIDTH = 200;
    static final int FRAME_HEIGHT = 150;
    private static final int MAX_PARAM_NUM = 16;
    private static final int MAX_PARAM_LEN = 255;
    private static final String laplStr = "lapl:";
    private static final String adfurlStr = "adfurl:";
    private static final String cmdStr = "cmd:";
    private static final String paramStr = "param:";
    private static String paramName = "";
    private static String paramValue = "";
    private static Vector infoStore;
    private JEditorPane editorPane;
    private Hashtable parameters = new Hashtable();

    CodeReaderWindow(MainWindow mainWindow, String string) {
        super(mainWindow, Resource.getString("CODE_READER_WINDOW_TITLE"));
        this.addWindowListener();
        if (!this.getAllAppliInfo(string)) {
            mainWindow.closeWindow(this);
            return;
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.editorPane);
        WindowHyperlinkListener windowHyperlinkListener = new WindowHyperlinkListener(this);
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(windowHyperlinkListener);
        container.add("Center", jScrollPane);
        this.setSize(200, 150);
    }

    private boolean getAllAppliInfo(String string) {
        Object object;
        CharSequence charSequence;
        String string2 = "";
        boolean bl = false;
        BufferedReader bufferedReader = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "";
        int n = 0;
        infoStore = new Vector();
        AppliInfo appliInfo = new AppliInfo();
        this.parameters.clear();
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            bufferedReader.close();
            string3 = stringBuffer.substring(0, stringBuffer.length() - 1);
            if (string3.toLowerCase().indexOf(laplStr) == 0) {
                appliInfo.init();
                string3 = string3.substring(laplStr.length());
                bl = true;
            }
            while (bl) {
                int n2;
                if (string3.toLowerCase().indexOf(adfurlStr) == 0 && bl) {
                    n2 = 0;
                    while (true) {
                        if ((n2 = string3.indexOf(";", n2)) == -1) {
                            System.err.println(Resource.format("READ_ERR", string));
                            return false;
                        }
                        if (string3.indexOf("\\", n2 - 1) != n2 - 1) break;
                        ++n2;
                    }
                    charSequence = string3.substring(adfurlStr.length(), n2 + 1);
                    string3 = string3.substring(n2 + 1);
                    charSequence = this.endSequ((String)charSequence);
                    if (!this.checkPropertyStr(adfurlStr, (String)charSequence)) {
                        System.err.println(Resource.format("INPUT_FORMAT_ERR", string));
                        return false;
                    }
                    appliInfo.adfUrl = this.escapeSequ((String)charSequence);
                    if ((appliInfo.appli = this.getAppliName(appliInfo.adfUrl)) != null) continue;
                    System.err.println(Resource.format("READ_ERR", string));
                    return false;
                }
                if (string3.toLowerCase().indexOf(cmdStr) == 0 && bl) {
                    n2 = 0;
                    while (true) {
                        if ((n2 = string3.indexOf(";", n2)) == -1) {
                            System.err.println(Resource.format("READ_ERR", string));
                            return false;
                        }
                        if (string3.indexOf("\\", n2 - 1) != n2 - 1) break;
                        ++n2;
                    }
                    charSequence = string3.substring(cmdStr.length(), n2 + 1);
                    string3 = string3.substring(n2 + 1);
                    charSequence = this.endSequ((String)charSequence);
                    if (!this.checkPropertyStr(cmdStr, (String)charSequence)) {
                        System.err.println(Resource.format("INPUT_FORMAT_ERR", string));
                        return false;
                    }
                    appliInfo.command = this.escapeSequ((String)charSequence);
                    continue;
                }
                if (string3.toLowerCase().indexOf(paramStr) == 0 && bl) {
                    if (++n > 16) {
                        System.err.println(Resource.format("INPUT_FORMAT_ERR", string));
                        return false;
                    }
                    n2 = 0;
                    while (true) {
                        if ((n2 = string3.indexOf(";", n2)) == -1) {
                            System.err.println(Resource.format("INPUT_FORMAT_ERR", string));
                            return false;
                        }
                        if (string3.indexOf("\\", n2 - 1) != n2 - 1) break;
                        ++n2;
                    }
                    charSequence = string3.substring(paramStr.length(), n2 + 1);
                    string3 = string3.substring(n2 + 1);
                    charSequence = this.endSequ((String)charSequence);
                    this.paramSequ((String)charSequence);
                    if (!this.checkPropertyStr(paramStr, (String)charSequence)) {
                        System.err.println(Resource.format("INPUT_FORMAT_ERR", string));
                        return false;
                    }
                    String string4 = this.escapeSequ(paramName);
                    object = this.escapeSequ(paramValue);
                    appliInfo.parameters.put(string4, object);
                    this.parameters.put(string4, object);
                    appliInfo.paramLen = appliInfo.paramLen + string4.getBytes().length + ((String)object).getBytes().length;
                    paramName = "";
                    paramValue = "";
                    continue;
                }
                if (string3.toLowerCase().indexOf(";") == 0 && bl) {
                    bl = false;
                    infoStore.addElement(appliInfo);
                    continue;
                }
                System.err.println(Resource.format("INPUT_FORMAT_ERR", string));
                return false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(Resource.format("NOT_FOUND_ERR", string));
            return false;
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("READ_ERR", string));
            return false;
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append("<html>");
        ((StringBuffer)charSequence).append("<body>");
        for (int i = 0; i < infoStore.size(); ++i) {
            object = (AppliInfo)infoStore.elementAt(i);
            ((StringBuffer)charSequence).append("<p>");
            ((StringBuffer)charSequence).append("<br>");
            ((StringBuffer)charSequence).append("<a href=" + ((AppliInfo)object).adfUrl + ">" + Resource.getString("APPLI_EXEC") + "</a>");
            ((StringBuffer)charSequence).append("<br>");
            ((StringBuffer)charSequence).append(Resource.getString("APPLI_NAME") + " " + ((AppliInfo)object).appli);
            ((StringBuffer)charSequence).append("</p>");
        }
        ((StringBuffer)charSequence).append("</body>");
        ((StringBuffer)charSequence).append("</html>");
        this.editorPane = new JEditorPane("text/html", ((StringBuffer)charSequence).toString());
        return true;
    }

    private boolean checkPropertyStr(String string, String string2) {
        block16: {
            byte[] byArray;
            block15: {
                int n = -1;
                if (string == null) {
                    return false;
                }
                if (string2 == null) {
                    return false;
                }
                if (string2.equals("")) {
                    return true;
                }
                if (string.equals(cmdStr) && string2.length() > 250) {
                    return false;
                }
                if (string.equals(paramStr) && string2.length() > 255) {
                    return false;
                }
                byArray = string2.getBytes();
                if (!string.equals(adfurlStr) && !string.equals(cmdStr)) break block15;
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] == 92) {
                        if (i == byArray.length - 1) {
                            return false;
                        }
                        if (byArray[i + 1] != 44 && byArray[i + 1] != 58 && byArray[i + 1] != 59 && byArray[i + 1] != 92) {
                            return false;
                        }
                        ++i;
                        continue;
                    }
                    if (byArray[i] == 44 || byArray[i] == 58 || byArray[i] == 59 || byArray[i] == 92) {
                        return false;
                    }
                    if (byArray[i] >= 33 && byArray[i] <= 126) continue;
                    return false;
                }
                break block16;
            }
            if (!string.equals(paramStr)) break block16;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 92) {
                    if (i == byArray.length - 1) {
                        return false;
                    }
                    if (byArray[i + 1] != 58 && byArray[i + 1] != 59 && byArray[i + 1] != 92) {
                        return false;
                    }
                    ++i;
                    continue;
                }
                if (byArray[i] == 58 || byArray[i] == 59 || byArray[i] == 92) {
                    return false;
                }
                if (byArray[i] >= 0 && byArray[i] <= 127) continue;
                return false;
            }
        }
        return true;
    }

    private void paramSequ(String string) {
        int n = -1;
        if (string == null) {
            return;
        }
        while ((n = string.indexOf(",", n)) != -1) {
            if (n == 0) {
                paramName = "";
                paramValue = string.substring(1);
                return;
            }
            if (paramName.length() == 0 && string.charAt(n - 1) != '\\') {
                paramName = string.substring(0, n);
                paramValue = string.substring(n + 1);
                return;
            }
            ++n;
        }
        if (paramName.length() == 0) {
            paramName = string;
            paramValue = "";
            return;
        }
    }

    private String endSequ(String string) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        String string2 = "";
        while ((n3 = string.indexOf("\\")) != -1) {
            if (String.valueOf(string.charAt(n3 + 1)).equals("\\")) {
                ++n3;
            } else if (String.valueOf(string.charAt(n3 + 1)).equals(";")) {
                ++n3;
            }
            String string3 = string.substring(0, n3);
            n = string3.indexOf(";");
            if (n != -1) break;
            string2 = string2.concat(string.substring(0, n3 + 1));
            string = string.substring(n3 + 1);
        }
        string2 = n != -1 ? string2.concat(string.substring(0, n)) : ((n2 = string.indexOf(";")) != -1 ? string2.concat(string.substring(0, n2)) : "");
        return string2;
    }

    private String escapeSequ(String string) {
        int n = -1;
        String string2 = "";
        while ((n = string.indexOf("\\")) != -1) {
            if (String.valueOf(string.charAt(n + 1)).equals("\\")) {
                ++n;
            }
            string2 = string2.concat(string.substring(0, n));
            string = string.substring(n + 1);
        }
        string2 = string2.concat(string);
        return string2;
    }

    private String getAppliName(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ADF aDF = null;
        int n = string.lastIndexOf(47);
        string2 = n != -1 ? string.substring(n + 1) : string;
        if (string2 == null) {
            return null;
        }
        string3 = this.parent.getJamPath(string2.substring(0, string2.length() - 4));
        File file = new File(string3);
        if (file.exists()) {
            try {
                aDF = new ADF(file);
                string4 = aDF.getProperty("AppName");
                if (string4 != null && !string4.equals("")) {
                    return string4;
                }
                System.err.println(Resource.getString("ADF_FORMAT_WNG"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("NOT_FOUND_ERR", string3));
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("READ_ERR", string3));
            }
        } else {
            System.err.println(Resource.format("NOT_FOUND_ERR", string3));
        }
        return null;
    }

    class WindowHyperlinkListener
    implements HyperlinkListener {
        private CodeReaderWindow window;

        WindowHyperlinkListener(CodeReaderWindow codeReaderWindow2) {
            this.window = codeReaderWindow2;
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            AppliInfo appliInfo = new AppliInfo();
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String string = "";
                if (hyperlinkEvent.getURL() != null) {
                    Object object;
                    CharSequence charSequence;
                    string = hyperlinkEvent.getURL().toString();
                    for (int i = 0; i < infoStore.size(); ++i) {
                        appliInfo.init();
                        appliInfo = (AppliInfo)infoStore.elementAt(i);
                        if (appliInfo.adfUrl.compareTo(string) == 0) break;
                    }
                    appliInfo.parameters.clear();
                    Enumeration enumeration = CodeReaderWindow.this.parameters.keys();
                    while (enumeration.hasMoreElements()) {
                        charSequence = new String((String)enumeration.nextElement());
                        object = new String((String)CodeReaderWindow.this.parameters.get(charSequence));
                        appliInfo.parameters.put(charSequence, object);
                    }
                    charSequence = new StringBuffer("");
                    if (JAMManager.check(5, string, appliInfo.command, charSequence) && appliInfo.parameters.size() <= 16 && appliInfo.paramLen <= 255) {
                        object = new JOptionPane(Resource.getString("LAUNCH_APPLICATION"), 3, 0);
                        JDialog jDialog = ((JOptionPane)object).createDialog(this.window, Resource.getString("CONFIRM"));
                        jDialog.setResizable(false);
                        jDialog.setVisible(true);
                        Object object2 = ((JOptionPane)object).getValue();
                        if (object2 instanceof Integer) {
                            if ((Integer)object2 != 0) {
                                return;
                            }
                        } else {
                            return;
                        }
                        try {
                            CodeReaderWindow.this.parent.setVisibleInvoker(5, true);
                            JAMManager.invokeApplication(JAMManager.getAdfPath(), JAMManager.getJarPath(), 4, JAMManager.getParams(appliInfo.parameters), CodeReaderWindow.this.parent.getDeviceName(), CodeReaderWindow.this.parent.getAdfUrl(), JAMManager.getProjectName(), DebugTraceWindow.getDebugParam());
                            CodeReaderWindow.this.parent.setEnabledDeviceMenu(false);
                        }
                        catch (Exception exception) {
                            CodeReaderWindow.this.parent.setVisibleInvoker(5, true);
                            CodeReaderWindow.this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this.window, 0);
                            return;
                        }
                    } else {
                        object = Resource.getString("NOT_LAUNCH_APPLICATION_WNG2");
                        CodeReaderWindow.this.parent.showDialog((String)object, this.window, 2);
                    }
                }
            }
        }
    }

    class AppliInfo {
        private String adfUrl = "";
        private String command = "";
        private Hashtable parameters = new Hashtable();
        private int paramLen = 0;
        private String appli = "";

        AppliInfo() {
        }

        public void init() {
            this.adfUrl = "";
            this.command = "";
            this.appli = "";
            this.parameters.clear();
            this.paramLen = 0;
        }
    }
}

