/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.ComPortEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class ComPortWindow
extends TabPanel {
    private static final int FRAME_WIDTH = 450;
    private static final int FRAME_HEIGHT = 200;
    private static final int BUTTON_WIDTH = 10;
    private static final int BUTTON_HEIGHT = 10;
    private static final int BUTTON_INTERVAL = 5;
    private JTable comPortTable;
    public static final int MAX_PORT_COUNT = 1;
    private Hashtable comPortHash;
    private static final String REMOVED_PORT_NAME = "removed";
    private Vector initPortTable;
    private JScrollPane scrollpane;
    static /* synthetic */ Class class$java$lang$Object;

    ComPortWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        JButton jButton = new JButton(Resource.getString("ADD"));
        JButton jButton2 = new JButton(Resource.getString("EDIT"));
        JButton jButton3 = new JButton(Resource.getString("REMOVE"));
        jButton.setActionCommand("add");
        jButton2.setActionCommand("edit");
        jButton3.setActionCommand("remove");
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        jButton.setSize(10, 10);
        jButton2.setSize(10, 10);
        jButton3.setSize(10, 10);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(jButton);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(jButton2);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(jButton3);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createHorizontalStrut(5));
        this.refreshComPortHash();
        this.comPortTable = this.createComPortTable();
        this.scrollpane = new JScrollPane(this.comPortTable);
        this.add("East", jPanel2);
        this.add("Center", this.scrollpane);
    }

    public Dimension getPreferredSize() {
        return new Dimension(450, 200);
    }

    private JTable createComPortTable() {
        String[] stringArray = new String[]{Resource.getString("COM_PORT_NO"), Resource.getString("COM_PORT_NAME")};
        ComPortTableModel comPortTableModel = new ComPortTableModel(stringArray, 0);
        Integer n = null;
        String string = null;
        this.initPortTable = new Vector();
        Enumeration enumeration = this.comPortHash.keys();
        while (enumeration.hasMoreElements()) {
            Vector<String> vector = new Vector<String>();
            Object object = enumeration.nextElement();
            n = null;
            if (object == null || !(object instanceof Integer)) continue;
            n = (Integer)object;
            string = null;
            object = this.comPortHash.get(n);
            if (object == null || !(object instanceof String) || 0 >= (string = (String)object).length() || REMOVED_PORT_NAME.equals(string)) continue;
            vector.addElement(n.toString());
            vector.addElement(string);
            comPortTableModel.addRow(vector);
            this.initPortTable.add(n);
        }
        JTable jTable = new JTable(comPortTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ComPortWindow.class$("java.lang.Object")) : class$java$lang$Object, new ComPortTableCellRenderer());
        jTable.setSelectionMode(0);
        jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    ComPortWindow.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ComPortWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    private void refreshComPortHash() {
        Vector vector = JAMManager.getComPortSettingList(1);
        this.comPortHash = new Hashtable();
        for (int i = 0; i < vector.size(); ++i) {
            this.comPortHash.put(new Integer(i), vector.get(i));
        }
    }

    void add() {
        ComPortEditWindow comPortEditWindow = new ComPortEditWindow(this.parent, null, null, this.comPortHash);
        comPortEditWindow.setLocation(this.parent.getShowLocation(comPortEditWindow.getWidth(), comPortEditWindow.getHeight(), this.tabwin));
        comPortEditWindow.setVisible(true);
        if (comPortEditWindow.isEdited() && this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
        comPortEditWindow.dispose();
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.comPortTable = null;
        this.comPortTable = this.createComPortTable();
        this.scrollpane = new JScrollPane(this.comPortTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void edit() {
        int n = this.comPortTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        Integer n2 = (Integer)this.initPortTable.get(n);
        String string = null;
        Object v = this.comPortHash.get(n2);
        if (v == null || !(v instanceof String)) {
            return;
        }
        string = (String)v;
        ComPortEditWindow comPortEditWindow = new ComPortEditWindow(this.parent, n2, string, this.comPortHash);
        comPortEditWindow.setLocation(this.parent.getShowLocation(comPortEditWindow.getWidth(), comPortEditWindow.getHeight(), this.tabwin));
        comPortEditWindow.setVisible(true);
        if (comPortEditWindow.isEdited() && this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
        comPortEditWindow.dispose();
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.comPortTable = null;
        this.comPortTable = this.createComPortTable();
        this.scrollpane = new JScrollPane(this.comPortTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void remove() {
        int n = this.comPortTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        Integer n2 = (Integer)this.initPortTable.get(n);
        this.comPortHash.put(n2, REMOVED_PORT_NAME);
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.comPortTable = null;
        this.comPortTable = this.createComPortTable();
        this.scrollpane = new JScrollPane(this.comPortTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    void cancel() {
    }

    boolean set() {
        this.saveSetting();
        return true;
    }

    void saveSetting() {
        Integer n = null;
        String string = null;
        Enumeration enumeration = this.comPortHash.keys();
        while (enumeration.hasMoreElements()) {
            Vector vector = new Vector();
            Object object = enumeration.nextElement();
            n = null;
            if (object == null || !(object instanceof Integer)) continue;
            n = (Integer)object;
            string = null;
            object = this.comPortHash.get(n);
            if (object == null || !(object instanceof String) || 0 >= (string = (String)object).length()) continue;
            if (REMOVED_PORT_NAME.equals(string)) {
                JAMManager.delComPortSetting((n.toString() + '\u0000').getBytes());
                continue;
            }
            JAMManager.setComPortSetting((n.toString() + '\u0000').getBytes(), (string + '\u0000').getBytes());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ComPortTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ComPortTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class ComPortTableModel
    extends DefaultTableModel {
        ComPortTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

