/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class ConsoleInput
extends InputStream {
    private static final int BUFFER_SIZE = 8192;
    private byte[] buffer = new byte[8192];
    private int start = 0;
    private int size = 0;

    public synchronized int read() throws IOException {
        try {
            while (this.size < 1) {
                this.wait();
            }
            byte by = this.buffer[this.start];
            this.start = (this.start + 1) % 8192;
            --this.size;
            this.notifyAll();
            return by;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            int n3;
            while (this.size < 1) {
                this.wait();
            }
            int n4 = this.size;
            if (n4 < n2) {
                n2 = n4;
            }
            if ((n3 = 8192 - this.start) < n2) {
                System.arraycopy(this.buffer, this.start, byArray, n, n3);
                System.arraycopy(this.buffer, 0, byArray, n + n3, n2 - n3);
            } else {
                System.arraycopy(this.buffer, this.start, byArray, n, n2);
            }
            this.start = (this.start + n2) % 8192;
            this.size -= n2;
            this.notifyAll();
            return n2;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException();
        }
    }

    public synchronized void add(byte[] byArray, int n, int n2) {
        try {
            while (8192 - this.size < n2) {
                this.wait();
            }
            int n3 = (this.start + this.size) % 8192;
            int n4 = 8192 - n3;
            if (n4 < n2) {
                System.arraycopy(byArray, n, this.buffer, n3, n4);
                System.arraycopy(byArray, n + n4, this.buffer, 0, n2 - n4);
            } else {
                System.arraycopy(byArray, n, this.buffer, n3, n2);
            }
            this.size += n2;
            this.notifyAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int available() throws IOException {
        return this.size;
    }
}

