/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.DTVParameter;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

class DTVMonitor
extends JPanel {
    private final int WIDTH = 240;
    private final int HEIGHT = 258;
    private final Color BCOLOR = Color.black;
    private final String IMG_BASE;
    private final String[] ICON_FILE = new String[]{"antenna.gif", "dtvicon.gif", "battery.gif", "task1.gif", "task2.gif"};
    private final int[][] ICON_POS = new int[][]{{4, 0}, {29, 0}, {163, 2}, {245, 2}, {245, 2}};
    private Image[] iconImage;
    private Image dtvImage;
    private DTVParameter parameter;
    private int dtvTaskStatus;
    private MainWindow parent;

    DTVMonitor(DTVParameter dTVParameter, MainWindow mainWindow, int n) {
        this.parameter = dTVParameter;
        this.parent = mainWindow;
        this.dtvTaskStatus = n;
        this.IMG_BASE = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "skin" + File.separator + "device1" + File.separator;
        this.setPreferredSize(new Dimension(240, 258));
        this.setBackground(this.BCOLOR);
        this.iconImage = new Image[this.ICON_FILE.length];
        for (int i = 0; i < this.iconImage.length; ++i) {
            ImageIcon imageIcon = new ImageIcon(this.IMG_BASE + this.ICON_FILE[i]);
            this.iconImage[i] = imageIcon.getImage();
        }
        ImageIcon imageIcon = new ImageIcon(this.IMG_BASE + "dtv.gif");
        this.dtvImage = imageIcon.getImage();
    }

    protected synchronized void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(new Color(186, 231, 217));
        graphics2D.fillRect(0, 0, this.getWidth(), 17);
        graphics2D.fillRect(0, 240, this.getWidth(), 18);
        graphics2D.setPaint(new Color(128, 255, 255));
        graphics2D.fillRect(2, 242, 48, 14);
        graphics2D.fillRect(this.getWidth() - 50, 242, 48, 14);
        for (n = 0; n < this.iconImage.length - 1; ++n) {
            if (n == this.iconImage.length - 2 && this.dtvTaskStatus == 2) {
                graphics2D.drawImage(this.iconImage[n + 1], this.ICON_POS[n][0], this.ICON_POS[n][1], null);
                continue;
            }
            graphics2D.drawImage(this.iconImage[n], this.ICON_POS[n][0], this.ICON_POS[n][1], null);
        }
        graphics2D.drawImage(this.dtvImage, (this.getWidth() - this.dtvImage.getWidth(null)) / 2, 111, null);
        n = this.parameter.getFrequency();
        String string = "CH: ";
        string = n == -1 ? string + "--" : string + n;
        graphics2D.drawString(string, this.getWidth() - graphics2D.getFontMetrics().stringWidth(string) - 10, 17 + graphics2D.getFontMetrics().getHeight() + 5);
    }
}

