/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DTVScheduleComparator;
import com.nttdocomo.dojaemu.ktoolbar.DTVScheduleEntry;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

class DTVScheduleWindow
extends TabPanel {
    private static final int FRAME_WIDTH = 540;
    private static final int FRAME_HEIGHT = 150;
    private static String[] scheduleFiles;
    private JTable scheduleTable;
    private Hashtable scheduleHash;
    private List scheduleList;
    private JScrollPane scrollpane;
    private JTextField typeText = null;
    private JTextField serviceNameText = null;
    private JTextField serviceIdText = null;
    private JTextField frequencyText = null;
    private JTextField affiliationIdText = null;
    private JTextField startTimeText = null;
    private JTextField endTimeText = null;
    private JTextField eventNameText = null;
    private JTextField repeatTypeText = null;
    private JButton deleteButton;
    private static final File scheduleDir;
    private static final String DTV_EXTENSION_SCHEDULE = ".dtv";
    static final int COL_SCHEDULE_TYPE = 0;
    static final int COL_STARTTIME = 1;
    static final int COL_ENDTIME = 2;
    static final int COL_SERVICE_NAME = 3;
    static final int COL_EVENT_NAME = 4;
    static final int SORT_TYPE_ASC = 1;
    static final int SORT_TYPE_DESC = -1;
    private int sortColNum = 1;
    private int sortType = 1;
    private String[] COLUMN_NAMES = new String[]{Resource.getString("DTV_BOOKING_TABLE_HEADER_TYPE"), Resource.getString("DTV_BOOKING_TABLE_HEADER_STARTTIME"), Resource.getString("DTV_BOOKING_TABLE_HEADER_ENDTIME"), Resource.getString("DTV_BOOKING_TABLE_SERVICE_NAME"), Resource.getString("DTV_BOOKING_TABLE_EVENT_NAME")};
    static /* synthetic */ Class class$java$lang$Object;

    DTVScheduleWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createDetailPanel();
        JPanel jPanel2 = new JPanel();
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.deleteButton.setActionCommand("delete");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.deleteButton.addActionListener(actionDispatcher);
        jPanel2.add(this.deleteButton);
        this.createScheduleData();
        this.scheduleTable = this.createScheduleTable();
        this.scrollpane = new JScrollPane(this.scheduleTable);
        this.add("North", this.scrollpane);
        this.add("Center", jPanel);
        this.add("South", jPanel2);
        this.changeButtonEnabled();
    }

    private void createScheduleData() {
        scheduleFiles = scheduleDir.list(new ScheduleFilter());
        this.scheduleHash = new Hashtable();
        this.scheduleList = new ArrayList();
        int n = 0;
        while (true) {
            block8: {
                if (n >= scheduleFiles.length) break;
                String string = scheduleDir.getPath() + File.separator + scheduleFiles[n];
                int n2 = scheduleFiles[n].indexOf(DTV_EXTENSION_SCHEDULE);
                if (DTV_EXTENSION_SCHEDULE.equals(scheduleFiles[n].substring(n2))) {
                    int n3;
                    try {
                        n3 = Integer.parseInt(scheduleFiles[n].substring(0, n2));
                        if (n3 < 0) break block8;
                        if ("0".equals(scheduleFiles[n].substring(0, n2).substring(0, 1))) {
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break block8;
                    try {
                        DTVScheduleEntry dTVScheduleEntry = new DTVScheduleEntry();
                        dTVScheduleEntry.setId(n3);
                        if (dTVScheduleEntry.load(string) == 0) {
                            this.scheduleList.add(dTVScheduleEntry);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(Resource.format("NOT_FOUND_ERR", string));
                    }
                }
            }
            ++n;
        }
    }

    private JTable createScheduleTable() {
        ScheduleListTable scheduleListTable = new ScheduleListTable();
        scheduleListTable.setModel(new DTVScheduleModel());
        scheduleListTable.getTableHeader().setReorderingAllowed(false);
        scheduleListTable.getTableHeader().setResizingAllowed(false);
        scheduleListTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = DTVScheduleWindow.class$("java.lang.Object")) : class$java$lang$Object, new ScheduleTableCellRenderer());
        JTableHeader jTableHeader = scheduleListTable.getTableHeader();
        jTableHeader.addMouseListener(new SelectionHeader());
        this.setColumnWidth(scheduleListTable);
        return scheduleListTable;
    }

    private JPanel createDetailPanel() {
        JPanel jPanel = new JPanel();
        int n = 0;
        int n2 = 0;
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.anchor = 13;
        JLabel jLabel = new JLabel(Resource.getString("DTV_BOOKING_DETAIL_LABEL_TYPE"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = n + 1;
        gridBagConstraints.anchor = 17;
        this.typeText = new JTextField("");
        this.typeText.setColumns(22);
        this.typeText.setEditable(false);
        jPanel.add((Component)this.typeText, gridBagConstraints);
        gridBagConstraints.gridx = n + 2;
        gridBagConstraints.anchor = 13;
        JLabel jLabel2 = new JLabel(Resource.getString("DTV_BOOKING_DETAIL_LABEL_SERVICE_ID"));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = n + 3;
        gridBagConstraints.anchor = 17;
        this.serviceIdText = new JTextField("");
        this.serviceIdText.setColumns(22);
        this.serviceIdText.setEditable(false);
        jPanel.add((Component)this.serviceIdText, gridBagConstraints);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2 + 1;
        gridBagConstraints.anchor = 13;
        JLabel jLabel3 = new JLabel(Resource.getString("DTV_BOOKING_DETAIL_LABEL_STARTTIME"));
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = n + 1;
        gridBagConstraints.anchor = 17;
        this.startTimeText = new JTextField("");
        this.startTimeText.setColumns(22);
        this.startTimeText.setEditable(false);
        jPanel.add((Component)this.startTimeText, gridBagConstraints);
        gridBagConstraints.gridx = n + 2;
        gridBagConstraints.anchor = 13;
        JLabel jLabel4 = new JLabel(Resource.getString("DTV_BOOKING_DETAIL_LABEL_FREQUENCY"));
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = n + 3;
        gridBagConstraints.anchor = 17;
        this.frequencyText = new JTextField("");
        this.frequencyText.setColumns(22);
        this.frequencyText.setEditable(false);
        jPanel.add((Component)this.frequencyText, gridBagConstraints);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2 + 2;
        gridBagConstraints.anchor = 13;
        JLabel jLabel5 = new JLabel(Resource.getString("DTV_BOOKING_DETAIL_LABEL_ENDTIME"));
        jPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = n + 1;
        gridBagConstraints.anchor = 17;
        this.endTimeText = new JTextField("");
        this.endTimeText.setColumns(22);
        this.endTimeText.setEditable(false);
        jPanel.add((Component)this.endTimeText, gridBagConstraints);
        gridBagConstraints.gridx = n + 2;
        gridBagConstraints.anchor = 13;
        JLabel jLabel6 = new JLabel(Resource.getString("DTV_BOOKING_DETAIL_LABEL_AFFILIATION_ID"));
        jPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridx = n + 3;
        gridBagConstraints.anchor = 17;
        this.affiliationIdText = new JTextField("");
        this.affiliationIdText.setColumns(22);
        this.affiliationIdText.setEditable(false);
        jPanel.add((Component)this.affiliationIdText, gridBagConstraints);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2 + 3;
        gridBagConstraints.anchor = 13;
        JLabel jLabel7 = new JLabel(Resource.getString("DTV_BOOKING_DETAIL_LABEL_SERVICE_NAME"));
        jPanel.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints.gridx = n + 1;
        gridBagConstraints.anchor = 17;
        this.serviceNameText = new JTextField("");
        this.serviceNameText.setColumns(22);
        this.serviceNameText.setEditable(false);
        jPanel.add((Component)this.serviceNameText, gridBagConstraints);
        gridBagConstraints.gridx = n + 2;
        gridBagConstraints.anchor = 13;
        JLabel jLabel8 = new JLabel(Resource.getString("DTV_BOOKING_DETAIL_LABEL_REPEAT_TYPE"));
        jPanel.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints.gridx = n + 3;
        gridBagConstraints.anchor = 17;
        this.repeatTypeText = new JTextField("");
        this.repeatTypeText.setColumns(22);
        this.repeatTypeText.setEditable(false);
        jPanel.add((Component)this.repeatTypeText, gridBagConstraints);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2 + 4;
        gridBagConstraints.anchor = 13;
        JLabel jLabel9 = new JLabel(Resource.getString("DTV_BOOKING_DETAIL_LABEL_EVENT_NAME"));
        jPanel.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints.gridx = n + 1;
        gridBagConstraints.anchor = 17;
        this.eventNameText = new JTextField("");
        this.eventNameText.setColumns(22);
        this.eventNameText.setEditable(false);
        jPanel.add((Component)this.eventNameText, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("DTV_BOOKING_DETAIL_NAME"), 0, 0));
        return jPanel;
    }

    private void initDetailInfo() {
        this.typeText.setText("");
        this.serviceNameText.setText("");
        this.serviceIdText.setText("");
        this.frequencyText.setText("");
        this.affiliationIdText.setText("");
        this.startTimeText.setText("");
        this.endTimeText.setText("");
        this.eventNameText.setText("");
        this.repeatTypeText.setText("");
    }

    void delete() {
        int[] nArray = this.scheduleTable.getSelectedRows();
        if (nArray.length > 0) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("DTV_DELETE_WNG", new String[]{String.valueOf(nArray.length)}), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    DTVScheduleEntry dTVScheduleEntry = (DTVScheduleEntry)this.scheduleHash.get(new Integer(nArray[i]));
                    File file = new File(scheduleDir, String.valueOf(dTVScheduleEntry.getId()) + DTV_EXTENSION_SCHEDULE);
                    file.delete();
                }
                this.createScheduleData();
                this.scheduleTable.setModel(new DTVScheduleModel());
                this.setColumnWidth(this.scheduleTable);
                this.changeButtonEnabled();
                this.initDetailInfo();
            }
        }
    }

    void cancel() {
    }

    boolean set() {
        return true;
    }

    private void setColumnWidth(JTable jTable) {
        jTable.getColumnModel().getColumn(0).setMinWidth(55);
        jTable.getColumnModel().getColumn(0).setMaxWidth(55);
        jTable.getColumnModel().getColumn(1).setMinWidth(125);
        jTable.getColumnModel().getColumn(1).setMaxWidth(125);
        jTable.getColumnModel().getColumn(2).setMinWidth(125);
        jTable.getColumnModel().getColumn(2).setMaxWidth(125);
        jTable.getColumnModel().getColumn(3).setMinWidth(110);
        jTable.getColumnModel().getColumn(3).setMaxWidth(110);
    }

    private void saveRowSelectedSatus(JTable jTable) {
        int[] nArray = this.scheduleTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            DTVScheduleEntry dTVScheduleEntry = (DTVScheduleEntry)this.scheduleHash.get(new Integer(nArray[i]));
            dTVScheduleEntry.setSelected(true);
        }
    }

    private void loadRowSelectedSatus(JTable jTable) {
        for (int i = 0; i < this.scheduleHash.size(); ++i) {
            DTVScheduleEntry dTVScheduleEntry = (DTVScheduleEntry)this.scheduleHash.get(new Integer(i));
            if (dTVScheduleEntry.isSelected()) {
                jTable.addRowSelectionInterval(i, i);
            }
            dTVScheduleEntry.setSelected(false);
        }
    }

    private void changeButtonEnabled() {
        if (this.scheduleList != null && this.scheduleList.size() > 0) {
            this.deleteButton.setEnabled(true);
        } else {
            this.deleteButton.setEnabled(false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        scheduleDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "schedule");
    }

    class SelectionHeader
    extends MouseAdapter {
        SelectionHeader() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            if (n >= 0 && n <= 4) {
                if (DTVScheduleWindow.this.sortColNum == n) {
                    if (DTVScheduleWindow.this.sortType == 1) {
                        DTVScheduleWindow.this.sortType = -1;
                    } else {
                        DTVScheduleWindow.this.sortType = 1;
                    }
                } else {
                    DTVScheduleWindow.this.sortColNum = n;
                    DTVScheduleWindow.this.sortType = 1;
                }
                DTVScheduleWindow.this.saveRowSelectedSatus(DTVScheduleWindow.this.scheduleTable);
                DTVScheduleWindow.this.scheduleTable.setModel(new DTVScheduleModel());
                DTVScheduleWindow.this.setColumnWidth(DTVScheduleWindow.this.scheduleTable);
                DTVScheduleWindow.this.loadRowSelectedSatus(DTVScheduleWindow.this.scheduleTable);
            }
        }
    }

    class DTVScheduleModel
    extends AbstractTableModel {
        private Object[] sortArray = null;

        public DTVScheduleModel() {
            this.sortArray = DTVScheduleWindow.this.scheduleList.toArray();
            DTVScheduleComparator dTVScheduleComparator = new DTVScheduleComparator();
            dTVScheduleComparator.setColNum(DTVScheduleWindow.this.sortColNum);
            dTVScheduleComparator.setSortType(DTVScheduleWindow.this.sortType);
            Arrays.sort(this.sortArray, dTVScheduleComparator);
            DTVScheduleWindow.this.scheduleHash.clear();
            for (int i = 0; i < this.sortArray.length; ++i) {
                DTVScheduleWindow.this.scheduleHash.put(new Integer(i), (DTVScheduleEntry)this.sortArray[i]);
            }
        }

        public int getRowCount() {
            return DTVScheduleWindow.this.scheduleList != null ? DTVScheduleWindow.this.scheduleList.size() : 0;
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            String string = null;
            String string2 = null;
            if (n == DTVScheduleWindow.this.sortColNum) {
                if (DTVScheduleWindow.this.sortType == 1) {
                    string2 = Resource.getString("DTV_BOOKING_TABLE_SORT_MARK_ASC");
                } else if (DTVScheduleWindow.this.sortType == -1) {
                    string2 = Resource.getString("DTV_BOOKING_TABLE_SORT_MARK_DESC");
                }
                string = DTVScheduleWindow.this.COLUMN_NAMES[n] + string2;
            } else {
                string = DTVScheduleWindow.this.COLUMN_NAMES[n];
            }
            return string;
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            if (this.sortArray == null || this.sortArray.length == 0) {
                return null;
            }
            DTVScheduleEntry dTVScheduleEntry = (DTVScheduleEntry)this.sortArray[n];
            switch (n2) {
                case 0: {
                    string = dTVScheduleEntry.getScheduleTypeStringForDisplay();
                    break;
                }
                case 1: {
                    string = dTVScheduleEntry.getDateStringForDisplay(dTVScheduleEntry.getStartTime());
                    break;
                }
                case 2: {
                    string = dTVScheduleEntry.getDateStringForDisplay(dTVScheduleEntry.getEndTime());
                    break;
                }
                case 3: {
                    string = dTVScheduleEntry.getServiceName();
                    break;
                }
                case 4: {
                    string = dTVScheduleEntry.getEventName();
                }
            }
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class ScheduleTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ScheduleTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (n2 == 0) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class ScheduleFilter
    implements FilenameFilter {
        ScheduleFilter() {
        }

        public boolean accept(File file, String string) {
            if (file.equals(scheduleDir)) {
                return string.endsWith(DTVScheduleWindow.DTV_EXTENSION_SCHEDULE);
            }
            return false;
        }
    }

    class ScheduleListTable
    extends JTable {
        ScheduleListTable() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DTVScheduleEntry dTVScheduleEntry;
            super.valueChanged(listSelectionEvent);
            int n = this.getSelectedRow();
            if (n >= 0 && (dTVScheduleEntry = (DTVScheduleEntry)DTVScheduleWindow.this.scheduleHash.get(new Integer(n))) != null) {
                DTVScheduleWindow.this.typeText.setText(dTVScheduleEntry.getScheduleTypeStringForDisplay());
                DTVScheduleWindow.this.serviceNameText.setText(dTVScheduleEntry.getServiceName());
                DTVScheduleWindow.this.serviceIdText.setText(dTVScheduleEntry.getServiceId());
                DTVScheduleWindow.this.frequencyText.setText(dTVScheduleEntry.getFrequency());
                DTVScheduleWindow.this.affiliationIdText.setText(dTVScheduleEntry.getAffiliationId());
                DTVScheduleWindow.this.startTimeText.setText(dTVScheduleEntry.getDateStringForDisplay(dTVScheduleEntry.getStartTime()));
                DTVScheduleWindow.this.endTimeText.setText(dTVScheduleEntry.getDateStringForDisplay(dTVScheduleEntry.getEndTime()));
                DTVScheduleWindow.this.eventNameText.setText(dTVScheduleEntry.getEventName());
                DTVScheduleWindow.this.repeatTypeText.setText(dTVScheduleEntry.getRepeatTypeStringForDisplay(dTVScheduleEntry.getRepeatType()));
            }
        }
    }
}

