/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DeviceDisplayInfo;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class DeviceDisplayEditWindow
extends AbstractWindow {
    private static int MIN_MAINW_SIZE = 240;
    private static int MIN_MAINH_SIZE = 240;
    private static int MAX_MAINW_SIZE = 480;
    private static int MAX_MAINH_SIZE = 640;
    private static int MIN_SUBW_SIZE = 120;
    private static int MIN_SUBH_SIZE = 120;
    private static int MAX_SUBW_SIZE = 240;
    private static int MAX_SUBH_SIZE = 320;
    private MainWindow parent;
    private DeviceDisplayInfo editedEntry;
    private Vector entryList;
    private boolean edited;
    private JTextField dispNameField;
    private JTextField mainHeightField;
    private JTextField mainWidthField;
    private JTextField subHeightField;
    private JTextField subWidthField;
    private boolean funcAdd = true;

    DeviceDisplayEditWindow(MainWindow mainWindow, DeviceDisplayInfo deviceDisplayInfo, Vector vector) {
        super(mainWindow, Resource.getString("SET_DISPLAY_TITLE"), true);
        this.parent = mainWindow;
        this.editedEntry = deviceDisplayInfo;
        this.entryList = vector;
        this.edited = false;
        this.addWindowListener();
        JLabel jLabel = new JLabel(Resource.getString("DISPLAY_DEVICE_NAME"));
        JLabel jLabel2 = new JLabel(Resource.getString("DISPLAY_DEVICE_HIGHT"));
        JLabel jLabel3 = new JLabel(Resource.getString("DISPLAY_DEVICE_WIDTH"));
        JLabel jLabel4 = new JLabel(Resource.getString("DISPLAY_DEVICE_HIGHT"));
        JLabel jLabel5 = new JLabel(Resource.getString("DISPLAY_DEVICE_WIDTH"));
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        this.dispNameField = new JTextField(15);
        this.mainHeightField = new JTextField(10);
        this.mainHeightField.setDocument(new HalfNumberDocument(3));
        this.mainWidthField = new JTextField(10);
        this.mainWidthField.setDocument(new HalfNumberDocument(3));
        this.subHeightField = new JTextField(10);
        this.subHeightField.setDocument(new HalfNumberDocument(3));
        this.subWidthField = new JTextField(10);
        this.subWidthField.setDocument(new HalfNumberDocument(3));
        this.dispNameField.setText(this.editedEntry.getDeviceName());
        if (this.editedEntry.getDeviceName().length() > 0) {
            this.dispNameField.setEnabled(false);
            this.funcAdd = false;
        }
        this.mainHeightField.setText(this.editedEntry.getMainHeight());
        this.mainWidthField.setText(this.editedEntry.getMainWidth());
        this.subHeightField.setText(this.editedEntry.getSubHeight());
        this.subWidthField.setText(this.editedEntry.getSubWidth());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jLabel);
        jPanel.add(this.dispNameField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("DISPLAY_MAIN")));
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        jPanel3.add(jLabel3);
        jPanel3.add(this.mainWidthField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        jPanel4.add(jLabel2);
        jPanel4.add(this.mainHeightField);
        jPanel2.add("North", jPanel3);
        jPanel2.add("South", jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("DISPLAY_SUB")));
        jPanel5.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(1));
        jPanel6.add(jLabel5);
        jPanel6.add(this.subWidthField);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(1));
        jPanel7.add(jLabel4);
        jPanel7.add(this.subHeightField);
        jPanel5.add("North", jPanel6);
        jPanel5.add("South", jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add("North", jPanel2);
        jPanel8.add("South", jPanel5);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(1));
        jPanel9.add(jButton);
        jPanel9.add(jButton2);
        container.add("North", jPanel);
        container.add("Center", jPanel8);
        container.add("South", jPanel9);
        jButton2.setActionCommand("cancel");
        jButton.setActionCommand("save");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton2.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        this.setResizable(false);
        this.pack();
    }

    void save() {
        Object[] objectArray = new String[3];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = this.dispNameField.getText();
        try {
            n = Integer.parseInt(this.mainWidthField.getText());
            n2 = Integer.parseInt(this.mainHeightField.getText());
            n3 = Integer.parseInt(this.subWidthField.getText());
            n4 = Integer.parseInt(this.subHeightField.getText());
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.getString("DISPLAY_NOINPUT_WNG"), this, 2);
            return;
        }
        if (string.length() == 0) {
            this.parent.showDialog(Resource.format("SPECIFIED_VAL_WNG", Resource.getString("DISPLAY_DEVICE_NAME")), this, 2);
            return;
        }
        if (this.funcAdd) {
            for (int i = 0; i < this.entryList.size(); ++i) {
                DeviceDisplayInfo deviceDisplayInfo = (DeviceDisplayInfo)this.entryList.get(i);
                if (!string.equals(deviceDisplayInfo.getDeviceName())) continue;
                this.parent.showDialog(Resource.getString("DISPLAY_NAME_WNG"), this, 2);
                return;
            }
        }
        objectArray[0] = Resource.getString("DISPLAY_CLM_MAIN_W");
        objectArray[1] = String.valueOf(MIN_MAINW_SIZE);
        objectArray[2] = String.valueOf(MAX_MAINW_SIZE);
        if (n < MIN_MAINW_SIZE || n > MAX_MAINW_SIZE) {
            this.parent.showDialog(Resource.format("DISPLAY_LIMIT_WNG", objectArray), this, 2);
            return;
        }
        objectArray[0] = Resource.getString("DISPLAY_CLM_MAIN_H");
        objectArray[1] = String.valueOf(MIN_MAINH_SIZE);
        objectArray[2] = String.valueOf(MAX_MAINH_SIZE);
        if (n2 < MIN_MAINH_SIZE || n2 > MAX_MAINH_SIZE) {
            this.parent.showDialog(Resource.format("DISPLAY_LIMIT_WNG", objectArray), this, 2);
            return;
        }
        objectArray[0] = Resource.getString("DISPLAY_CLM_SUB_W");
        objectArray[1] = String.valueOf(MIN_SUBW_SIZE);
        objectArray[2] = String.valueOf(MAX_SUBW_SIZE);
        if (n3 < MIN_SUBW_SIZE || n3 > MAX_SUBW_SIZE) {
            this.parent.showDialog(Resource.format("DISPLAY_LIMIT_WNG", objectArray), this, 2);
            return;
        }
        objectArray[0] = Resource.getString("DISPLAY_CLM_SUB_H");
        objectArray[1] = String.valueOf(MIN_SUBH_SIZE);
        objectArray[2] = String.valueOf(MAX_SUBH_SIZE);
        if (n4 < MIN_SUBH_SIZE || n4 > MAX_SUBH_SIZE) {
            this.parent.showDialog(Resource.format("DISPLAY_LIMIT_WNG", objectArray), this, 2);
            return;
        }
        this.editedEntry.setDeviceName(this.dispNameField.getText());
        this.editedEntry.setMainWidth(this.mainWidthField.getText());
        this.editedEntry.setMainHeight(this.mainHeightField.getText());
        this.editedEntry.setSubWidth(this.subWidthField.getText());
        this.editedEntry.setSubHeight(this.subHeightField.getText());
        this.edited = true;
        this.setVisible(false);
    }

    boolean isEdited() {
        return this.edited;
    }

    void cancel() {
        this.setVisible(false);
    }
}

