/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.ExportListener;
import com.nttdocomo.dojaemu.ktoolbar.GestureTekEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.GestureTekRollEntry;
import com.nttdocomo.dojaemu.ktoolbar.GestureTekShakeEntry;
import com.nttdocomo.dojaemu.ktoolbar.ImExportDialog;
import com.nttdocomo.dojaemu.ktoolbar.ImportException;
import com.nttdocomo.dojaemu.ktoolbar.ImportListener;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import com.nttdocomo.dojaemu.ktoolbar.VerifyGestureTekData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class GestureTekEntryWindow
extends TabPanel
implements ImportListener,
ExportListener {
    private JTable rollTable;
    private JTable shakeTable;
    private JPanel rollPanel;
    private JPanel shakePanel;
    private int[] rollIdList = null;
    private int[] shakeIdList = null;
    private int rollNext = 0;
    private int shakeNext = 0;
    private JScrollPane rollScrollpane;
    private JScrollPane shakeScrollpane;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;
    private JButton exportButton;
    private JRadioButton rollMove;
    private JRadioButton shakeMove;
    private ButtonGroup move;
    static int ROLL_SELECT = 0;
    static int SHAKE_SELECT = 1;
    static /* synthetic */ Class class$java$lang$Object;

    GestureTekEntryWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = new JPanel();
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.upButton = new JButton(Resource.getString("GESTURETEK_UP"));
        this.downButton = new JButton(Resource.getString("GESTURETEK_DOWN"));
        JButton jButton = new JButton(Resource.getString("COMMON_IMPORT"));
        this.exportButton = new JButton(Resource.getString("COMMON_EXPORT"));
        this.rollMove = new JRadioButton(Resource.getString("ROLL_MOVE"), true);
        this.shakeMove = new JRadioButton(Resource.getString("SHAKE_MOVE"), false);
        this.move = new ButtonGroup();
        this.move.add(this.rollMove);
        this.move.add(this.shakeMove);
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        this.upButton.setActionCommand("up");
        this.downButton.setActionCommand("down");
        this.rollMove.setActionCommand("roll");
        this.shakeMove.setActionCommand("shake");
        jButton.setActionCommand("importData");
        this.exportButton.setActionCommand("exportData");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        this.upButton.addActionListener(actionDispatcher);
        this.downButton.addActionListener(actionDispatcher);
        this.rollMove.addActionListener(actionDispatcher);
        this.shakeMove.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        this.exportButton.addActionListener(actionDispatcher);
        jPanel.add(this.rollMove);
        jPanel.add(this.shakeMove);
        jPanel3.add(this.addButton);
        jPanel3.add(this.editButton);
        jPanel3.add(this.deleteButton);
        jPanel3.add(this.upButton);
        jPanel3.add(this.downButton);
        jPanel3.add(new JLabel("  "));
        jPanel3.add(jButton);
        jPanel3.add(this.exportButton);
        this.rollPanel = new JPanel();
        this.rollPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("ROLL_MOVE")));
        this.rollTable = this.createRollTable();
        this.rollScrollpane = new JScrollPane(this.rollTable);
        this.rollScrollpane.getVerticalScrollBar().setEnabled(true);
        this.rollScrollpane.setWheelScrollingEnabled(true);
        this.rollScrollpane.setPreferredSize(new Dimension(430, 450));
        this.rollPanel.add("Center", this.rollScrollpane);
        this.shakePanel = new JPanel();
        this.shakePanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SHAKE_MOVE")));
        this.shakeTable = this.createShakeTable();
        this.shakeScrollpane = new JScrollPane(this.shakeTable);
        this.shakeScrollpane.getVerticalScrollBar().setEnabled(false);
        this.shakeScrollpane.setWheelScrollingEnabled(false);
        this.shakeScrollpane.setPreferredSize(new Dimension(130, 450));
        this.shakePanel.add("Center", this.shakeScrollpane);
        jPanel2.add(this.rollPanel);
        jPanel2.add(this.shakePanel);
        this.add("North", jPanel);
        this.add("Center", jPanel2);
        this.add("South", jPanel3);
    }

    private JTable createRollTable() {
        int n;
        JTable jTable = null;
        BufferedReader bufferedReader = null;
        Vector<Integer> vector = new Vector<Integer>();
        String[] stringArray = new String[]{Resource.getString("GES_X_AXIS"), Resource.getString("GES_Y_AXIS"), Resource.getString("GES_QUALITY")};
        RollTableModel rollTableModel = new RollTableModel(stringArray, 0);
        if (GestureTekRollEntry.ROLL_ORDER.exists()) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(GestureTekRollEntry.ROLL_ORDER)));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    n = 0;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    String string2 = GestureTekRollEntry.ROLL_DIR.getPath() + File.separator + string + ".ges";
                    GestureTekRollEntry gestureTekRollEntry = new GestureTekRollEntry();
                    gestureTekRollEntry.setEntryId(n);
                    boolean bl = gestureTekRollEntry.rollLoad(string2);
                    if (!bl) continue;
                    vector.addElement(new Integer(n));
                    Vector<String> vector2 = new Vector<String>();
                    vector2.addElement(gestureTekRollEntry.getGestureTekX());
                    vector2.addElement(gestureTekRollEntry.getGestureTekY());
                    for (int i = 0; i < GestureTekEditWindow.qualityValues.length; ++i) {
                        if (!GestureTekEditWindow.qualityValues[i].equals(gestureTekRollEntry.getQuality())) continue;
                        vector2.addElement(GestureTekEditWindow.qualityItems[i]);
                        break;
                    }
                    rollTableModel.addRow(vector2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        jTable = new JTable(rollTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = GestureTekEntryWindow.class$("java.lang.Object")) : class$java$lang$Object, new GestureRollTableCellRenderer());
        jTable.setSelectionMode(2);
        this.rollIdList = new int[vector.size()];
        for (int i = 0; i < this.rollIdList.length; ++i) {
            this.rollIdList[i] = (Integer)vector.get(i);
        }
        int[] nArray = new int[vector.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = this.rollIdList[n];
        }
        Arrays.sort(nArray);
        this.rollNext = nArray.length > 0 ? nArray[nArray.length - 1] + 1 : 1;
        this.changeButtonEnabled();
        jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && GestureTekEntryWindow.this.rollMove.isSelected() && mouseEvent.getClickCount() == 2) {
                    GestureTekEntryWindow.this.rollEdit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    GestureTekEntryWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    private JTable createShakeTable() {
        int n;
        JTable jTable = null;
        BufferedReader bufferedReader = null;
        Vector<Integer> vector = new Vector<Integer>();
        String[] stringArray = new String[]{Resource.getString("GES_SHAKE")};
        ShakeTableModel shakeTableModel = new ShakeTableModel(stringArray, 0);
        if (GestureTekShakeEntry.SHAKE_ORDER.exists()) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(GestureTekShakeEntry.SHAKE_ORDER)));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    n = 0;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    String string2 = GestureTekShakeEntry.SHAKE_DIR.getPath() + File.separator + string + ".ges";
                    GestureTekShakeEntry gestureTekShakeEntry = new GestureTekShakeEntry();
                    gestureTekShakeEntry.setEntryId(n);
                    boolean bl = gestureTekShakeEntry.shakeLoad(string2);
                    if (!bl) continue;
                    vector.addElement(new Integer(n));
                    Vector<String> vector2 = new Vector<String>();
                    vector2.addElement(gestureTekShakeEntry.getShake());
                    shakeTableModel.addRow(vector2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        jTable = new JTable(shakeTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = GestureTekEntryWindow.class$("java.lang.Object")) : class$java$lang$Object, new GestureShakeTableCellRenderer());
        jTable.setSelectionMode(2);
        this.shakeIdList = new int[vector.size()];
        for (int i = 0; i < this.shakeIdList.length; ++i) {
            this.shakeIdList[i] = (Integer)vector.get(i);
        }
        int[] nArray = new int[vector.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = this.shakeIdList[n];
        }
        Arrays.sort(nArray);
        this.shakeNext = nArray.length > 0 ? nArray[nArray.length - 1] + 1 : 1;
        this.changeButtonEnabled();
        jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && GestureTekEntryWindow.this.shakeMove.isSelected() && mouseEvent.getClickCount() == 2) {
                    GestureTekEntryWindow.this.shakeEdit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    GestureTekEntryWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    void changeButtonEnabled() {
        if (this.rollMove.isSelected()) {
            this.changeRollButtonEnabled();
        } else if (this.shakeMove.isSelected()) {
            this.changeShakeButtonEnabled();
        }
    }

    void add() {
        if (this.rollMove.isSelected()) {
            this.rollAdd();
        } else if (this.shakeMove.isSelected()) {
            this.shakeAdd();
        }
    }

    void edit() {
        if (this.rollMove.isSelected()) {
            this.rollEdit();
        } else if (this.shakeMove.isSelected()) {
            this.shakeEdit();
        }
    }

    void delete() {
        if (this.rollMove.isSelected()) {
            this.rollDelete();
        } else if (this.shakeMove.isSelected()) {
            this.shakeDelete();
        }
    }

    void up() {
        if (this.rollMove.isSelected()) {
            this.rollUp();
        } else if (this.shakeMove.isSelected()) {
            this.shakeUp();
        }
    }

    void down() {
        if (this.rollMove.isSelected()) {
            this.rollDown();
        } else if (this.shakeMove.isSelected()) {
            this.shakeDown();
        }
    }

    void rollAdd() {
        GestureTekRollEntry gestureTekRollEntry = new GestureTekRollEntry();
        gestureTekRollEntry.setEntryId(this.rollNext);
        gestureTekRollEntry.init();
        GestureTekEditWindow gestureTekEditWindow = new GestureTekEditWindow(this.parent, gestureTekRollEntry, null, true, ROLL_SELECT);
        gestureTekEditWindow.setLocation(this.parent.getShowLocation(gestureTekEditWindow.getWidth(), gestureTekEditWindow.getHeight(), this.tabwin));
        gestureTekEditWindow.setVisible(true);
        this.setVisible(false);
        this.rollPanel.remove(this.rollScrollpane);
        this.rollScrollpane = null;
        this.rollTable = null;
        this.rollTable = this.createRollTable();
        this.rollScrollpane = new JScrollPane(this.rollTable);
        this.rollScrollpane.setPreferredSize(new Dimension(430, 450));
        this.rollPanel.add("Center", this.rollScrollpane);
        this.setVisible(true);
    }

    void shakeAdd() {
        GestureTekShakeEntry gestureTekShakeEntry = new GestureTekShakeEntry();
        gestureTekShakeEntry.setEntryId(this.shakeNext);
        gestureTekShakeEntry.init();
        GestureTekEditWindow gestureTekEditWindow = new GestureTekEditWindow(this.parent, null, gestureTekShakeEntry, true, SHAKE_SELECT);
        gestureTekEditWindow.setLocation(this.parent.getShowLocation(gestureTekEditWindow.getWidth(), gestureTekEditWindow.getHeight(), this.tabwin));
        gestureTekEditWindow.setVisible(true);
        this.setVisible(false);
        this.shakePanel.remove(this.shakeScrollpane);
        this.shakeScrollpane = null;
        this.shakeTable = null;
        this.shakeTable = this.createShakeTable();
        this.shakeScrollpane = new JScrollPane(this.shakeTable);
        this.shakeScrollpane.setPreferredSize(new Dimension(130, 450));
        this.shakePanel.add("Center", this.shakeScrollpane);
        this.setVisible(true);
    }

    void rollEdit() {
        int[] nArray = this.rollTable.getSelectedRows();
        if (this.rollTable.getSelectedRowCount() == 1) {
            int n = this.rollIdList[nArray[0]];
            String string = GestureTekRollEntry.ROLL_DIR.getPath() + File.separator + Integer.toString(n) + ".ges";
            GestureTekRollEntry gestureTekRollEntry = new GestureTekRollEntry();
            gestureTekRollEntry.setEntryId(n);
            try {
                boolean bl = gestureTekRollEntry.rollLoad(string);
                if (bl) {
                    GestureTekEditWindow gestureTekEditWindow = new GestureTekEditWindow(this.parent, gestureTekRollEntry, null, false, ROLL_SELECT);
                    gestureTekEditWindow.setLocation(this.parent.getShowLocation(gestureTekEditWindow.getWidth(), gestureTekEditWindow.getHeight(), this.tabwin));
                    gestureTekEditWindow.setVisible(true);
                    this.setVisible(false);
                    this.rollPanel.remove(this.rollScrollpane);
                    this.rollScrollpane = null;
                    this.rollTable = null;
                    this.rollTable = this.createRollTable();
                    this.rollScrollpane = new JScrollPane(this.rollTable);
                    this.rollScrollpane.setPreferredSize(new Dimension(430, 450));
                    this.rollPanel.add("Center", this.rollScrollpane);
                    this.setVisible(true);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    void shakeEdit() {
        int[] nArray = this.shakeTable.getSelectedRows();
        if (this.shakeTable.getSelectedRowCount() == 1) {
            int n = this.shakeIdList[nArray[0]];
            String string = GestureTekShakeEntry.SHAKE_DIR.getPath() + File.separator + Integer.toString(n) + ".ges";
            GestureTekShakeEntry gestureTekShakeEntry = new GestureTekShakeEntry();
            gestureTekShakeEntry.setEntryId(n);
            try {
                boolean bl = gestureTekShakeEntry.shakeLoad(string);
                if (bl) {
                    GestureTekEditWindow gestureTekEditWindow = new GestureTekEditWindow(this.parent, null, gestureTekShakeEntry, false, SHAKE_SELECT);
                    gestureTekEditWindow.setLocation(this.parent.getShowLocation(gestureTekEditWindow.getWidth(), gestureTekEditWindow.getHeight(), this.tabwin));
                    gestureTekEditWindow.setVisible(true);
                    this.setVisible(false);
                    this.shakePanel.remove(this.shakeScrollpane);
                    this.shakeScrollpane = null;
                    this.shakeTable = null;
                    this.shakeTable = this.createShakeTable();
                    this.shakeScrollpane = new JScrollPane(this.shakeTable);
                    this.shakeScrollpane.setPreferredSize(new Dimension(130, 450));
                    this.shakePanel.add("Center", this.shakeScrollpane);
                    this.setVisible(true);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    void rollDelete() {
        int[] nArray = this.rollTable.getSelectedRows();
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        if (this.rollTable.getSelectedRowCount() != 0) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("ROLL_DELETE_WNG", String.valueOf(this.rollTable.getSelectedRowCount())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                String string = null;
                try {
                    for (int i = 0; i < this.rollTable.getSelectedRowCount(); ++i) {
                        int n = nArray[i];
                        string = Integer.toString(this.rollIdList[n]) + ".ges";
                        File file = new File(GestureTekRollEntry.ROLL_DIR, string);
                        bufferedReader = new BufferedReader(new FileReader(GestureTekRollEntry.ROLL_ORDER));
                        String string2 = null;
                        String string3 = "";
                        while ((string2 = bufferedReader.readLine()) != null) {
                            string2 = string2.equals(Integer.toString(this.rollIdList[n])) ? "" : string2 + "\n";
                            string3 = string3 + string2;
                        }
                        bufferedWriter = new BufferedWriter(new FileWriter(GestureTekRollEntry.ROLL_ORDER, false));
                        bufferedWriter.write(string3);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    System.err.println(Resource.format("ROLL_DELETE_ERR", string));
                    return;
                }
                this.setVisible(false);
                this.rollPanel.remove(this.rollScrollpane);
                this.rollScrollpane = null;
                this.rollTable = null;
                this.rollTable = this.createRollTable();
                this.rollScrollpane = new JScrollPane(this.rollTable);
                this.rollScrollpane.setPreferredSize(new Dimension(430, 450));
                this.rollPanel.add("Center", this.rollScrollpane);
                this.setVisible(true);
            }
        }
    }

    void shakeDelete() {
        int[] nArray = this.shakeTable.getSelectedRows();
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        if (this.shakeTable.getSelectedRowCount() != 0) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("SHAKE_DELETE_WNG", String.valueOf(this.shakeTable.getSelectedRowCount())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                String string = null;
                try {
                    for (int i = 0; i < this.shakeTable.getSelectedRowCount(); ++i) {
                        int n = nArray[i];
                        string = Integer.toString(this.shakeIdList[n]) + ".ges";
                        File file = new File(GestureTekShakeEntry.SHAKE_DIR, string);
                        bufferedReader = new BufferedReader(new FileReader(GestureTekShakeEntry.SHAKE_ORDER));
                        String string2 = null;
                        String string3 = "";
                        while ((string2 = bufferedReader.readLine()) != null) {
                            string2 = string2.equals(Integer.toString(this.shakeIdList[n])) ? "" : string2 + "\n";
                            string3 = string3 + string2;
                        }
                        bufferedWriter = new BufferedWriter(new FileWriter(GestureTekShakeEntry.SHAKE_ORDER, false));
                        bufferedWriter.write(string3);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    System.err.println(Resource.format("SHAKE_DELETE_ERR", string));
                    return;
                }
                this.setVisible(false);
                this.shakePanel.remove(this.shakeScrollpane);
                this.shakeScrollpane = null;
                this.shakeTable = null;
                this.shakeTable = this.createShakeTable();
                this.shakeScrollpane = new JScrollPane(this.shakeTable);
                this.shakeScrollpane.setPreferredSize(new Dimension(130, 450));
                this.shakePanel.add("Center", this.shakeScrollpane);
                this.setVisible(true);
            }
        }
    }

    void rollUp() {
        int[] nArray = this.rollTable.getSelectedRows();
        BufferedWriter bufferedWriter = null;
        if (this.rollTable.getSelectedRowCount() == 1) {
            int n = nArray[0];
            if (n == 0) {
                return;
            }
            try {
                String string = "";
                for (int i = 0; i < this.rollIdList.length; ++i) {
                    string = i == n - 1 ? string + Integer.toString(this.rollIdList[i + 1]) + '\n' : (i == n ? string + Integer.toString(this.rollIdList[i - 1]) + '\n' : string + Integer.toString(this.rollIdList[i]) + '\n');
                }
                bufferedWriter = new BufferedWriter(new FileWriter(GestureTekRollEntry.ROLL_ORDER, false));
                bufferedWriter.write(string);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                return;
            }
            this.setVisible(false);
            this.rollPanel.remove(this.rollScrollpane);
            this.rollScrollpane = null;
            this.rollTable = null;
            this.rollTable = this.createRollTable();
            this.rollScrollpane = new JScrollPane(this.rollTable);
            this.rollScrollpane.setPreferredSize(new Dimension(430, 450));
            this.rollPanel.add("Center", this.rollScrollpane);
            this.rollTable.setRowSelectionInterval(n - 1, n - 1);
            this.setVisible(true);
        }
    }

    void shakeUp() {
        int[] nArray = this.shakeTable.getSelectedRows();
        BufferedWriter bufferedWriter = null;
        if (this.shakeTable.getSelectedRowCount() == 1) {
            int n = nArray[0];
            if (n == 0) {
                return;
            }
            try {
                String string = "";
                for (int i = 0; i < this.shakeIdList.length; ++i) {
                    string = i == n - 1 ? string + Integer.toString(this.shakeIdList[i + 1]) + '\n' : (i == n ? string + Integer.toString(this.shakeIdList[i - 1]) + '\n' : string + Integer.toString(this.shakeIdList[i]) + '\n');
                }
                bufferedWriter = new BufferedWriter(new FileWriter(GestureTekShakeEntry.SHAKE_ORDER, false));
                bufferedWriter.write(string);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                return;
            }
            this.setVisible(false);
            this.shakePanel.remove(this.shakeScrollpane);
            this.shakeScrollpane = null;
            this.shakeTable = null;
            this.shakeTable = this.createShakeTable();
            this.shakeScrollpane = new JScrollPane(this.shakeTable);
            this.shakeScrollpane.setPreferredSize(new Dimension(130, 450));
            this.shakePanel.add("Center", this.shakeScrollpane);
            this.shakeTable.setRowSelectionInterval(n - 1, n - 1);
            this.setVisible(true);
        }
    }

    void rollDown() {
        int[] nArray = this.rollTable.getSelectedRows();
        BufferedWriter bufferedWriter = null;
        if (this.rollTable.getSelectedRowCount() == 1) {
            int n = nArray[0];
            if (n == this.rollIdList.length - 1) {
                return;
            }
            try {
                String string = "";
                for (int i = 0; i < this.rollIdList.length; ++i) {
                    string = i == n + 1 ? string + Integer.toString(this.rollIdList[i - 1]) + '\n' : (i == n ? string + Integer.toString(this.rollIdList[i + 1]) + '\n' : string + Integer.toString(this.rollIdList[i]) + '\n');
                }
                bufferedWriter = new BufferedWriter(new FileWriter(GestureTekRollEntry.ROLL_ORDER, false));
                bufferedWriter.write(string);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                return;
            }
            this.setVisible(false);
            this.rollPanel.remove(this.rollScrollpane);
            this.rollScrollpane = null;
            this.rollTable = null;
            this.rollTable = this.createRollTable();
            this.rollScrollpane = new JScrollPane(this.rollTable);
            this.rollScrollpane.setPreferredSize(new Dimension(430, 450));
            this.rollPanel.add("Center", this.rollScrollpane);
            this.rollTable.setRowSelectionInterval(n + 1, n + 1);
            this.setVisible(true);
        }
    }

    void shakeDown() {
        int[] nArray = this.shakeTable.getSelectedRows();
        BufferedWriter bufferedWriter = null;
        if (this.shakeTable.getSelectedRowCount() == 1) {
            int n = nArray[0];
            if (n == this.shakeIdList.length - 1) {
                return;
            }
            try {
                String string = "";
                for (int i = 0; i < this.shakeIdList.length; ++i) {
                    string = i == n + 1 ? string + Integer.toString(this.shakeIdList[i - 1]) + '\n' : (i == n ? string + Integer.toString(this.shakeIdList[i + 1]) + '\n' : string + Integer.toString(this.shakeIdList[i]) + '\n');
                }
                bufferedWriter = new BufferedWriter(new FileWriter(GestureTekShakeEntry.SHAKE_ORDER, false));
                bufferedWriter.write(string);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                return;
            }
            this.setVisible(false);
            this.shakePanel.remove(this.shakeScrollpane);
            this.shakeScrollpane = null;
            this.shakeTable = null;
            this.shakeTable = this.createShakeTable();
            this.shakeScrollpane = new JScrollPane(this.shakeTable);
            this.shakeScrollpane.setPreferredSize(new Dimension(130, 450));
            this.shakePanel.add("Center", this.shakeScrollpane);
            this.shakeTable.setRowSelectionInterval(n + 1, n + 1);
            this.setVisible(true);
        }
    }

    void cancel() {
    }

    boolean set() {
        return true;
    }

    void roll() {
        if (this.rollMove.isSelected()) {
            this.rollTable.setEnabled(true);
            this.rollScrollpane.getVerticalScrollBar().setEnabled(true);
            this.rollScrollpane.setWheelScrollingEnabled(true);
            this.shakeTable.setEnabled(false);
            this.shakeScrollpane.getVerticalScrollBar().setEnabled(false);
            this.shakeScrollpane.setWheelScrollingEnabled(false);
            this.changeRollButtonEnabled();
        }
        this.rollTable.repaint();
        this.shakeTable.repaint();
    }

    void shake() {
        if (this.shakeMove.isSelected()) {
            this.shakeTable.setEnabled(true);
            this.shakeScrollpane.getVerticalScrollBar().setEnabled(true);
            this.shakeScrollpane.setWheelScrollingEnabled(true);
            this.rollTable.setEnabled(false);
            this.rollScrollpane.getVerticalScrollBar().setEnabled(false);
            this.rollScrollpane.setWheelScrollingEnabled(false);
            this.changeShakeButtonEnabled();
        }
        this.rollTable.repaint();
        this.shakeTable.repaint();
    }

    private void changeRollButtonEnabled() {
        if (this.rollIdList != null && this.rollIdList.length > 0) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.exportButton.setEnabled(true);
            if (this.rollIdList.length > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.exportButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    private void changeShakeButtonEnabled() {
        if (this.shakeIdList != null && this.shakeIdList.length > 0) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.exportButton.setEnabled(true);
            if (this.shakeIdList.length > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.exportButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public void check(String[] stringArray, int n) throws ImportException {
        if (this.rollMove.isSelected()) {
            VerifyGestureTekData.verify(stringArray, 0);
        } else {
            VerifyGestureTekData.verify(stringArray, 1);
        }
    }

    public int add(String[] stringArray, int n) throws ImportException {
        if (this.rollMove.isSelected()) {
            Object[] objectArray = VerifyGestureTekData.adjust(stringArray, 0);
            GestureTekRollEntry gestureTekRollEntry = new GestureTekRollEntry();
            gestureTekRollEntry.setEntryId(this.rollNext);
            gestureTekRollEntry.init();
            String string = objectArray[0] + "," + objectArray[1] + "," + objectArray[2];
            String string2 = gestureTekRollEntry.getEntryId() + ".ges";
            try {
                gestureTekRollEntry.rollSave(string, string2, true);
            }
            catch (IOException iOException) {
                throw new ImportException(-1, -1, Resource.format("WRITE_ERR", string2));
            }
            ++this.rollNext;
            objectArray[2] = GestureTekEditWindow.qualityItems[Integer.parseInt(objectArray[2])];
            this.addRow(this.rollTable, objectArray);
            return gestureTekRollEntry.getEntryId();
        }
        Object[] objectArray = VerifyGestureTekData.adjust(stringArray, 1);
        GestureTekShakeEntry gestureTekShakeEntry = new GestureTekShakeEntry();
        gestureTekShakeEntry.setEntryId(this.shakeNext);
        gestureTekShakeEntry.init();
        String string = objectArray[0];
        String string3 = gestureTekShakeEntry.getEntryId() + ".ges";
        try {
            gestureTekShakeEntry.shakeSave(string, string3, true);
        }
        catch (IOException iOException) {
            throw new ImportException(-1, -1, Resource.format("WRITE_ERR", string3));
        }
        ++this.shakeNext;
        this.addRow(this.shakeTable, objectArray);
        return gestureTekShakeEntry.getEntryId();
    }

    public void addRow(final JTable jTable, final Object[] objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (GestureTekEntryWindow.this.rollMove.isSelected() && jTable != null && GestureTekEntryWindow.this.rollTable != null && jTable.equals(GestureTekEntryWindow.this.rollTable) || !GestureTekEntryWindow.this.rollMove.isSelected() && jTable != null && GestureTekEntryWindow.this.shakeTable != null && jTable.equals(GestureTekEntryWindow.this.shakeTable)) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
                    defaultTableModel.addRow(objectArray);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int delete(int n) throws ImportException {
        File file = null;
        File file2 = null;
        int n2 = n;
        if (this.rollMove.isSelected()) {
            file = GestureTekRollEntry.ROLL_DIR;
            file2 = GestureTekRollEntry.ROLL_ORDER;
        } else {
            file = GestureTekShakeEntry.SHAKE_DIR;
            file2 = GestureTekShakeEntry.SHAKE_ORDER;
        }
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = "";
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(file2));
                while ((string = bufferedReader.readLine()) != null && !string.equals(Integer.toString(n))) {
                    string2 = string2 + string + "\n";
                }
                bufferedReader.close();
                bufferedReader = null;
                bufferedWriter = new BufferedWriter(new FileWriter(file2, false));
                bufferedWriter.write(string2);
                bufferedWriter.flush();
            }
            catch (Exception exception) {
                throw new ImportException(-1, -1, Resource.format("WRITE_ERR", file2.getName()));
            }
            Object var11_9 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter == null) throw throwable;
                bufferedWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        if (bufferedWriter != null) {
            bufferedWriter.close();
        }
        while (true) {
            string = Integer.toString(n2++) + ".ges";
            try {
                File file3 = new File(file, string);
                if (!file3.exists()) {
                    return n2 - n;
                }
                file3.delete();
            }
            catch (Exception exception) {
                throw new ImportException(-1, -1, Resource.format("ROLL_DELETE_ERR", string));
            }
        }
    }

    public ArrayList get() {
        DefaultTableModel defaultTableModel = null;
        defaultTableModel = this.rollMove.isSelected() ? (DefaultTableModel)this.rollTable.getModel() : (DefaultTableModel)this.shakeTable.getModel();
        Vector<Vector> vector = defaultTableModel.getDataVector();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = "";
            Vector vector2 = vector.elementAt(i);
            String[] stringArray = vector2.toArray(new String[0]);
            if (this.rollMove.isSelected()) {
                for (int j = 0; j < stringArray.length - 1; ++j) {
                    string = string + stringArray[j] + ",";
                }
                String[] stringArray2 = GestureTekEditWindow.qualityItems;
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray[stringArray.length - 1].equals(stringArray2[j])) continue;
                    string = string + j;
                    break;
                }
            } else {
                for (int j = 0; j < stringArray.length; ++j) {
                    string = string + stringArray[j] + (j < stringArray.length - 1 ? "," : "");
                }
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    void importData() {
        ImExportDialog imExportDialog = new ImExportDialog(this.tabwin, this, 0);
        imExportDialog.open();
        this.setVisible(false);
        if (this.rollMove.isSelected()) {
            this.rollPanel.remove(this.rollScrollpane);
            this.rollScrollpane = null;
            this.rollTable = null;
            this.rollTable = this.createRollTable();
            this.rollScrollpane = new JScrollPane(this.rollTable);
            this.rollScrollpane.setPreferredSize(new Dimension(430, 450));
            this.rollPanel.add("Center", this.rollScrollpane);
        } else {
            this.shakePanel.remove(this.shakeScrollpane);
            this.shakeScrollpane = null;
            this.shakeTable = null;
            this.shakeTable = this.createShakeTable();
            this.shakeScrollpane = new JScrollPane(this.shakeTable);
            this.shakeScrollpane.setPreferredSize(new Dimension(130, 450));
            this.shakePanel.add("Center", this.shakeScrollpane);
        }
        this.setVisible(true);
    }

    void exportData() {
        ImExportDialog imExportDialog = new ImExportDialog(this.tabwin, this, 1);
        imExportDialog.open();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class GestureShakeTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        GestureShakeTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl && GestureTekEntryWindow.this.shakeMove.isSelected()) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else if (GestureTekEntryWindow.this.shakeMove.isSelected()) {
                this.setForeground(Color.black);
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
            } else {
                this.setForeground(Color.black);
                this.setBackground(GestureTekEntryWindow.this.shakePanel.getBackground());
            }
            this.setText((String)object);
            return this;
        }
    }

    class GestureRollTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        GestureRollTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl && GestureTekEntryWindow.this.rollMove.isSelected()) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else if (GestureTekEntryWindow.this.rollMove.isSelected()) {
                this.setForeground(Color.black);
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
            } else {
                this.setForeground(Color.black);
                this.setBackground(GestureTekEntryWindow.this.rollPanel.getBackground());
            }
            this.setText((String)object);
            return this;
        }
    }

    class ShakeTableModel
    extends DefaultTableModel {
        ShakeTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    class RollTableModel
    extends DefaultTableModel {
        RollTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

