/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class HeapSizeWindow
extends TabPanel
implements DocumentListener {
    private static int MIN_HEAP_SIZE = 1000;
    private static int MAX_HEAP_SIZE = Short.MAX_VALUE;
    private JTextField heapSizeField;

    HeapSizeWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        JLabel jLabel = new JLabel(Resource.getString("HEAP_SIZE"));
        JLabel jLabel2 = new JLabel(Resource.getString("HEAP_UNIT"));
        this.heapSizeField = new JTextField(6);
        this.heapSizeField.setDocument(new HalfNumberDocument(6));
        this.heapSizeField.setText(String.valueOf(this.parent.getHeapMemorySize()));
        this.heapSizeField.getDocument().addDocumentListener(this);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1));
        jPanel2.add(this.heapSizeField);
        jPanel2.add(jLabel2);
        this.add("North", jPanel);
        this.add("Center", jPanel2);
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
    }

    boolean set() {
        String string = this.heapSizeField.getText().trim();
        int n = 0;
        Object[] objectArray = new String[]{String.valueOf(MIN_HEAP_SIZE), String.valueOf(MAX_HEAP_SIZE)};
        if (string.length() == 0) {
            try {
                this.parent.showDialog(Resource.format("SPECIFIED_VAL_WNG", Resource.getString("HEAP_SIZE")), this.tabwin, 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            this.parent.showDialog(Resource.format("HEAP_LIMIT_WNG", objectArray), this.tabwin, 2);
            return false;
        }
        n = Integer.parseInt(string);
        if (n < MIN_HEAP_SIZE || n > MAX_HEAP_SIZE) {
            this.parent.showDialog(Resource.format("HEAP_LIMIT_WNG", objectArray), this.tabwin, 2);
            return false;
        }
        this.parent.setHeapMemorySize(n);
        return true;
    }

    void cancel() {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }
}

