/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.ExportListener;
import com.nttdocomo.dojaemu.ktoolbar.ExportNativeData;
import com.nttdocomo.dojaemu.ktoolbar.ImExportListener;
import com.nttdocomo.dojaemu.ktoolbar.ImportListener;
import com.nttdocomo.dojaemu.ktoolbar.ImportNativeData;
import com.nttdocomo.dojaemu.ktoolbar.ProgressDialog;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

class ImExportDialog
extends JDialog {
    static final int TYPE_IMPORT = 0;
    static final int TYPE_EXPORT = 1;
    private JDialog parent;
    private ImExportListener listener;
    private int type;
    private JTextField tfdFilePath;
    private JRadioButton btnTypeEntry;
    private JRadioButton btnTypeAdd;

    ImExportDialog(JDialog jDialog, ImExportListener imExportListener, int n) {
        super((Dialog)jDialog, true);
        this.parent = jDialog;
        this.listener = imExportListener;
        this.type = n;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        if (n == 0) {
            this.setTitle(Resource.getString("COMMON_IMPORT"));
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this.getInputFilePanel());
        } else {
            this.setTitle(Resource.getString("COMMON_EXPORT"));
            jPanel = this.getInputFilePanel();
        }
        container.add("North", new JPanel());
        container.add("West", new JPanel());
        container.add("East", new JPanel());
        container.add("Center", jPanel);
        container.add("South", this.getButtonPanel());
        this.pack();
        this.setResizable(false);
    }

    private JPanel getButtonPanel() {
        JButton jButton = new JButton(Resource.getString("COMMON_EXECUTE"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton.setActionCommand("execute");
        jButton2.setActionCommand("cancel");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private JPanel getInputFilePanel() {
        String string = Resource.format("COMMON_FILE_OF", this.type == 0 ? Resource.getString("COMMON_IMPORT") : Resource.getString("COMMON_EXPORT"));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), string + " :"));
        jPanel.setLayout(new FlowLayout(1));
        this.tfdFilePath = new JTextField(36);
        JButton jButton = new JButton(Resource.getString("SELECT_DIR"));
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton.setActionCommand("ref");
        jPanel.add(this.tfdFilePath);
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel getInportTypePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("IMPORT_REG_METHOD")));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnTypeEntry = new JRadioButton(Resource.getString("IMPORT_REG_ENTRY_ID"));
        this.btnTypeAdd = new JRadioButton(Resource.getString("IMPORT_REG_ADDITION"));
        buttonGroup.add(this.btnTypeEntry);
        buttonGroup.add(this.btnTypeAdd);
        this.btnTypeEntry.setSelected(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.btnTypeEntry);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.btnTypeAdd);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    void ref() {
        JFileChooser jFileChooser = new JFileChooser(new File(this.tfdFilePath.getText()).getAbsolutePath());
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new CSVFileFilter());
        jFileChooser.setMultiSelectionEnabled(false);
        if (this.type == 0) {
            jFileChooser.setDialogTitle(Resource.format("COMMON_STRING_PLACE_OF", Resource.getString("COMMON_CSV_FILE")));
            if (jFileChooser.showOpenDialog(this) == 0) {
                this.tfdFilePath.setText(jFileChooser.getSelectedFile().toString());
            }
        } else {
            jFileChooser.setDialogTitle(Resource.format("COMMON_SAVE_DIRECTORY_OF", Resource.getString("COMMON_CSV_FILE")));
            int n = jFileChooser.showDialog(this, Resource.getString("COMMON_DECISION"));
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                String string2 = string.trim().toLowerCase();
                if (!string2.endsWith(".csv")) {
                    string = string + ".csv";
                }
                this.tfdFilePath.setText(string);
            }
        }
    }

    void open() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = this.parent.getSize();
        Point point = this.parent.getLocationOnScreen();
        Point point2 = new Point(0, 0);
        point2.x = point.x + (dimension3.width - dimension2.width) / 2;
        point2.y = point.y + (dimension3.height - dimension2.height) / 2;
        if (point2.x < 0) {
            point2.x = 0;
        } else if (point2.x + dimension2.width > dimension.width) {
            point2.x = dimension.width - dimension2.width;
        }
        if (point2.y < 0) {
            point2.y = 0;
        } else if (point2.y + dimension2.height > dimension.height) {
            point2.y = dimension.height - dimension2.height;
        }
        this.setLocation(point2);
        this.setVisible(true);
    }

    void execute() {
        Thread thread = null;
        String string = this.tfdFilePath.getText().trim();
        String string2 = Resource.format("COMMON_PROCESSING_OF", this.type == 0 ? Resource.getString("COMMON_IMPORT") : Resource.getString("COMMON_EXPORT"));
        ProgressDialog progressDialog = new ProgressDialog(this.parent, string2);
        if (string == null || string.length() <= 0) {
            this.showMessage(2, Resource.format("COMMON_EMES_NOT_SELECT", Resource.getString("COMMON_CSV_FILE")), null);
            return;
        }
        File file = new File(string);
        if (this.type == 0) {
            if (!file.exists()) {
                this.showMessage(2, Resource.format("COMMON_EMES_NOT_EXIST", Resource.getString("COMMON_CSV_FILE")), null);
                return;
            }
            int n = 0;
            ImportNativeData importNativeData = new ImportNativeData(progressDialog, (ImportListener)this.listener, file.getAbsolutePath(), n);
            thread = new Thread(importNativeData);
        } else {
            Object[] objectArray;
            int n = 0;
            if (file.isDirectory()) {
                this.showMessage(2, Resource.format("COMMON_EMES_INVALID", Resource.getString("COMMON_INPUT_PATH")), null);
                return;
            }
            if (file.exists()) {
                objectArray = new Object[]{Resource.getString("COMMON_OVERWRITE"), Resource.getString("COMMON_ADDITION"), Resource.getString("CANCEL")};
                int n2 = this.showMessage(3, Resource.format("COMMON_EMES_EXIST", Resource.getString("COMMON_CSV_FILE")), objectArray);
                if (n2 == 1) {
                    n = 1;
                } else if (n2 == 2 || n2 == -1) {
                    return;
                }
            } else {
                objectArray = file.getParentFile();
                if (objectArray == null || !objectArray.isDirectory()) {
                    this.showMessage(2, Resource.format("COMMON_EMES_INVALID", Resource.getString("COMMON_INPUT_PATH")), null);
                    return;
                }
            }
            objectArray = new ExportNativeData(progressDialog, (ExportListener)this.listener, file.getAbsolutePath(), n);
            thread = new Thread((Runnable)objectArray);
        }
        this.setVisible(false);
        this.dispose();
        thread.start();
        progressDialog.open();
    }

    void cancel() {
        this.dispose();
    }

    private int showMessage(int n, String string, Object[] objectArray) {
        String string2 = "";
        int n2 = -1;
        Object object = null;
        if (objectArray != null) {
            object = objectArray[0];
        }
        if (n == 2) {
            string2 = Resource.getString("WNG");
        } else if (n == 3) {
            string2 = Resource.getString("COMMON_SELECTION");
            n2 = 1;
        } else {
            string2 = Resource.getString("CONFIRM");
        }
        return JOptionPane.showOptionDialog(this, string, string2, n2, n, null, objectArray, object);
    }

    class CSVFileFilter
    extends FileFilter {
        CSVFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getPath().toLowerCase();
            return string.endsWith(".csv");
        }

        public String getDescription() {
            String string = Resource.getString("COMMON_CSV_FILE") + "(*.csv)";
            return string;
        }
    }
}

