/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.ImportException;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class ImportErrorDialog
extends JDialog {
    static final int BUTTON_DEFAULT = 0;
    static final int BUTTON_OK = 1;
    static final int BUTTON_CANCEL = 2;
    static final int BUTTON_INTERRUPT = 3;
    static final int BUTTON_KEEP_ON = 4;
    private final Icon errorIcon;
    private final Icon warnIcon;
    private JDialog parent;
    private final ImportException error;
    private int lineNo;
    private String target;
    private int select;

    ImportErrorDialog(JDialog jDialog, ImportException importException, int n, String string) {
        super(jDialog, Resource.getString("WNG"), true);
        this.parent = jDialog;
        this.error = importException;
        this.lineNo = n;
        this.target = string;
        this.select = 0;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (ImportErrorDialog.this.error.getType() == -1) {
                    ImportErrorDialog.this.select = 1;
                } else {
                    ImportErrorDialog.this.select = 3;
                }
                ImportErrorDialog.this.dispose();
            }
        });
        this.errorIcon = UIManager.getIcon("OptionPane.errorIcon");
        this.warnIcon = UIManager.getIcon("OptionPane.warningIcon");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("North", this.getHeadingPanel());
        container.add("West", new JPanel());
        container.add("East", new JPanel());
        container.add("Center", this.getMessagePanel());
        container.add("South", this.getButtonPanel());
        this.pack();
        this.setResizable(false);
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        if (this.error.getType() == -1) {
            JButton jButton = new JButton(Resource.getString("OK"));
            jButton.addActionListener(actionDispatcher);
            jButton.setActionCommand("ok");
            jPanel.add(jButton);
        } else {
            JButton jButton = new JButton(Resource.getString("COMMON_INTERRUPT"));
            JButton jButton2 = new JButton(Resource.getString("COMMON_CONTINUE"));
            JButton jButton3 = new JButton(Resource.getString("CANCEL"));
            jButton.addActionListener(actionDispatcher);
            jButton2.addActionListener(actionDispatcher);
            jButton3.addActionListener(actionDispatcher);
            jButton.setActionCommand("interrupt");
            jButton2.setActionCommand("keepon");
            jButton3.setActionCommand("cancel");
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
        }
        return jPanel;
    }

    private JPanel getHeadingPanel() {
        JLabel jLabel = null;
        jLabel = this.error.getType() == -1 ? new JLabel(this.error.getMessage(), this.errorIcon, 0) : new JLabel(Resource.getString("IMPORT_EMES_INVALID_LINE"), this.warnIcon, 0);
        jLabel.setVerticalTextPosition(3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel getMessagePanel() {
        JLabel jLabel;
        int n;
        JPanel jPanel = new JPanel();
        if (this.error.getType() == -1) {
            return jPanel;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("IMPORT_LBL_CONTENT_OF_ERROR")));
        jPanel.setLayout(gridBagLayout);
        String[] stringArray = new String[]{Resource.getString("COMMON_LINE_NO"), Resource.getString("COMMON_COLUMN"), Resource.getString("COMMON_STRING"), Resource.getString("COMMON_CAUSE")};
        String[] stringArray2 = new String[]{Integer.toString(this.lineNo), 0 <= this.error.getColumn() ? Integer.toString(this.error.getColumn() + 1) : "-", this.target.length() > 25 ? this.target.substring(0, 23) + "..." : this.target, this.error.getMessage()};
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 13;
        for (n = 0; n < stringArray.length; ++n) {
            gridBagConstraints.gridy = n;
            jLabel = new JLabel(stringArray[n] + " : ");
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        for (n = 0; n < stringArray2.length; ++n) {
            gridBagConstraints.gridy = n;
            jLabel = new JLabel(stringArray2[n]);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
        }
        return jPanel;
    }

    int open() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = this.parent.getSize();
        Point point = this.parent.getLocationOnScreen();
        Point point2 = new Point(0, 0);
        point2.x = point.x + (dimension3.width - dimension2.width) / 2;
        point2.y = point.y + (dimension3.height - dimension2.height) / 2;
        if (point2.x < 0) {
            point2.x = 0;
        } else if (point2.x + dimension2.width > dimension.width) {
            point2.x = dimension.width - dimension2.width;
        }
        if (point2.y < 0) {
            point2.y = 0;
        } else if (point2.y + dimension2.height > dimension.height) {
            point2.y = dimension.height - dimension2.height;
        }
        this.setLocation(point2);
        this.setVisible(true);
        return this.select;
    }

    void interrupt() {
        this.select = 3;
        this.dispose();
    }

    void keepon() {
        this.select = 4;
        this.dispose();
    }

    void cancel() {
        this.select = 2;
        this.dispose();
    }

    void ok() {
        this.select = 1;
        this.dispose();
    }
}

