/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

class JarAccess {
    static final String COMP_TITLE = "Specification-Title";
    static final int TITLE = 0;
    static final String COMP_VERSION = "Specification-Version";
    static final int VERSION = 1;
    static final String COMP_VENDOR = "Specification-Vendor";
    static final int VENDOR = 2;
    static final String COMP_AUTHOR = "Created-By";
    static final int AUTHOR = 3;
    static final String COMP_PROFILE = "Build-By";
    static final int PROFILE = 4;
    static final int BUFFER_SIZE = 1024000;
    private boolean changeCode = false;
    private String fileName = null;
    private JarFile jarFile;
    private Manifest mf;
    private boolean manifest;
    private TreeSet overWriteFiles = new TreeSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarAccess(String string) {
        this.fileName = string;
        this.manifest = false;
        this.changeCode = this.isCodeChange();
        try {
            this.jarFile = new JarFile(this.fileName);
            this.mf = this.jarFile.getManifest();
            if (this.mf != null) {
                this.manifest = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.jarFile.close();
            }
            catch (Exception exception) {}
        }
    }

    String[] getRowItems() throws IOException {
        int n = 0;
        Attributes attributes = this.mf.getMainAttributes();
        String[] stringArray = new String[]{"", "", "", "", ""};
        Iterator<Object> iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            Attributes.Name name = (Attributes.Name)iterator.next();
            if (name.toString().equals(COMP_TITLE)) {
                n = 0;
            } else if (name.toString().equals(COMP_VERSION)) {
                n = 1;
            } else if (name.toString().equals(COMP_VENDOR)) {
                n = 2;
            } else if (name.toString().equals(COMP_AUTHOR)) {
                n = 3;
            } else {
                if (!name.toString().equals(COMP_PROFILE)) continue;
                n = 4;
            }
            if (this.changeCode) {
                stringArray[n] = new String(attributes.getValue(name.toString()).getBytes("iso-8859-1"), "UTF-8");
                continue;
            }
            stringArray[n] = new String(attributes.getValue(name.toString()));
        }
        return stringArray;
    }

    String lastModified() {
        long l = 0L;
        if (this.fileName != null) {
            l = new File(this.fileName).lastModified();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        return simpleDateFormat.format(new Date(l));
    }

    void unpack(String string) {
        this.unpack(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unpack(String string, boolean bl) {
        int n = 1024000;
        ZipInputStream zipInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            zipInputStream = new JarInputStream(new FileInputStream(this.fileName));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipInputStream);
            JarEntry jarEntry = null;
            String string2 = null;
            byte[] byArray = null;
            int n2 = 0;
            while ((jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry()) != null) {
                string2 = jarEntry.getName();
                if (string2.toUpperCase().startsWith("META-INF/")) continue;
                if (jarEntry.isDirectory()) {
                    new File(string + File.separator + string2).mkdir();
                    continue;
                }
                File file = new File(string + File.separator + string2);
                if (file.exists()) {
                    if (bl) {
                        System.out.println(Resource.format("OVERWRITE_FILE", string2));
                    }
                    this.overWriteFiles.add(string2);
                }
                byArray = new byte[n];
                while ((n2 = bufferedInputStream.read(byArray, 0, n)) >= n) {
                    byArray = new byte[n += 1024000];
                }
                zipInputStream.closeEntry();
                fileOutputStream = new FileOutputStream(file);
                if (n2 == -1) {
                    n2 = 0;
                }
                fileOutputStream.write(byArray, 0, n2);
                fileOutputStream.flush();
                fileOutputStream.close();
                n = 1024000;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                zipInputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    boolean isManifest() {
        return this.manifest;
    }

    private boolean isCodeChange() {
        int[] nArray = new int[]{1, 4, 2};
        char c = '.';
        try {
            char c2;
            int n;
            String string = System.getProperty("java.version");
            if (string == null || string.length() == 0) {
                return false;
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = string.indexOf(c, string.indexOf(c) + 1);
            if (n5 == -1) {
                return false;
            }
            for (n = 1; n <= n5; ++n) {
                c2 = string.charAt(n);
                if (c2 != c) continue;
                try {
                    n4 = Integer.parseInt(string.substring(n2, n));
                    n2 = n + 1;
                    if (n4 < nArray[n3]) {
                        return true;
                    }
                    if (n4 > nArray[n3]) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
                ++n3;
            }
            n2 = n;
            try {
                while (n < string.length() && Character.isDigit(c2 = string.charAt(n))) {
                    ++n;
                }
                n4 = Integer.parseInt(string.substring(n2, n));
                if (n4 < nArray[n3]) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    String getPath() {
        return this.fileName;
    }

    Collection getOverWriteFiles() {
        return this.overWriteFiles;
    }
}

