/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.ScheduleDate;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class LimitWindow
extends AbstractWindow {
    private int maxPhoneBook = 10;
    private int maxGroup = 10;
    private Setting projectSetting;
    private final int MAX_ENTRY = 6;
    private final int MAX_PARAM = 36;
    private final int MAX_INT_LEN = 10;
    private final int MAX_X_DCM = 4;
    private int LAUNCH_TIME_MAX = 4;
    private final int DEFAULT_3D_RESOURCE = 4;
    private final int MAX_3D_RESOURCE = 8;
    private final int DEFAULT_DTV_SCHEDULE_MAX = 50;
    private final int DEFAULT_ACCELERATION_MAX = 20;
    private final int DEFAULT_CAMERA_FRAME_RATE = 15;
    private String[] dateTypeStr = new String[]{"ONETIME", "DAILY", "WEEKLY", "MONTHLY", "YEARLY"};
    private String[] monthStr = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private String[] weekStr = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
    private JTextField maxSentMail;
    private JTextField maxReceivedMail;
    private JTextField maxPhoneBookEntry;
    private JTextField maxGroupEntry;
    private JTextField maxDTVScheduleEntry;
    private JTextField maxAccelerationSensorEntry;
    private JComboBox dateType;
    private JTextField launchTimeY;
    private JComboBox launchTimeM;
    private JComboBox launchTimeW;
    private JTextField launchTimeD;
    private JTextField launchTimeH;
    private JTextField launchTimeMin;
    private JList launchTimes;
    private String[] launchTimesStr;
    private String[] dispLaunchTimesStr;
    private int previousIndex;
    private JCheckBox linkHttpHeader;
    private JTextField xDcmMoveVal;
    private JCheckBox isMovedCheck;
    private JCheckBox otherTermCheck;
    private JTextField fontBaseline;
    private JTextField cameraDeviceNum;
    private JTextField cameraDeviceRate;
    private JTextField sound3dResourceNum;

    LimitWindow(MainWindow mainWindow, Setting setting) {
        super(mainWindow, Resource.getString("LIMIT_WINDOW_TITLE"));
        this.addWindowListener();
        this.setProjectSetting(setting);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("MAX_MAIL_SENT"));
        JLabel jLabel2 = new JLabel(Resource.getString("MAX_MAIL_RECEIVED"));
        JLabel jLabel3 = new JLabel(Resource.getString("MAX_PHONEBOOK"));
        JLabel jLabel4 = new JLabel(Resource.getString("MAX_GROUP"));
        JLabel jLabel5 = new JLabel(Resource.getString("MAX_DTV_SCHEDULE"));
        JLabel jLabel6 = new JLabel(Resource.getString("MAX_ACCELERATION_DATA"));
        this.maxSentMail = new JTextField(this.MAX_ENTRY);
        this.maxReceivedMail = new JTextField(this.MAX_ENTRY);
        this.maxPhoneBookEntry = new JTextField(this.MAX_ENTRY);
        this.maxGroupEntry = new JTextField(this.MAX_ENTRY);
        this.maxDTVScheduleEntry = new JTextField(this.MAX_ENTRY);
        this.maxAccelerationSensorEntry = new JTextField(this.MAX_ENTRY);
        this.maxSentMail.setDocument(new HalfNumberDocument(this.MAX_ENTRY));
        this.maxReceivedMail.setDocument(new HalfNumberDocument(this.MAX_ENTRY));
        this.maxPhoneBookEntry.setDocument(new HalfNumberDocument(this.MAX_ENTRY));
        this.maxGroupEntry.setDocument(new HalfNumberDocument(this.MAX_ENTRY));
        this.maxDTVScheduleEntry.setDocument(new HalfNumberDocument(this.MAX_ENTRY));
        this.maxAccelerationSensorEntry.setDocument(new HalfNumberDocument(3));
        this.linkHttpHeader = new JCheckBox(Resource.getString("LINK_HTTP_HEADER"));
        JLabel jLabel7 = new JLabel(Resource.getString("X_DCM_MOVE"));
        this.getClass();
        this.xDcmMoveVal = new JTextField(4);
        this.getClass();
        this.xDcmMoveVal.setDocument(new HalfNumberDocument(4));
        this.isMovedCheck = new JCheckBox(Resource.getString("APP_MOVE_INFO_FLAG"));
        this.otherTermCheck = new JCheckBox(Resource.getString("MOVED_OTHER_TERM"));
        JLabel jLabel8 = new JLabel(Resource.getString("FONT_BASELINE"));
        this.fontBaseline = new JTextField(this.MAX_INT_LEN);
        this.fontBaseline.setDocument(new HalfNumberDocument(this.MAX_INT_LEN));
        JLabel jLabel9 = new JLabel(Resource.getString("CAMERA_DEVICE_NUM"));
        this.cameraDeviceNum = new JTextField(this.MAX_ENTRY);
        this.cameraDeviceNum.setDocument(new HalfNumberDocument(this.MAX_ENTRY));
        JLabel jLabel10 = new JLabel(Resource.getString("CAMERA_FRAME_RATE"));
        this.cameraDeviceRate = new JTextField(this.MAX_ENTRY);
        this.cameraDeviceRate.setDocument(new HalfNumberDocument(2));
        JLabel jLabel11 = new JLabel(Resource.getString("SOUND3D_RESOURCE_NUM"));
        this.sound3dResourceNum = new JTextField(this.MAX_ENTRY);
        this.launchTimes = new JList();
        this.launchTimes.setSelectionMode(0);
        this.launchTimes.setVisibleRowCount(4);
        JScrollPane jScrollPane = new JScrollPane(this.launchTimes);
        jScrollPane.getViewport().setView(this.launchTimes);
        this.dateType = new JComboBox<String>(this.dateTypeStr);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                switch (LimitWindow.this.dateType.getSelectedIndex()) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 8;
                        break;
                    }
                    case 4: {
                        n = 16;
                    }
                }
                LimitWindow.this.setEnabled(n);
            }
        };
        JLabel jLabel12 = new JLabel("YYYY:");
        JLabel jLabel13 = new JLabel("DD:");
        JLabel jLabel14 = new JLabel("HH:");
        JLabel jLabel15 = new JLabel("MM:");
        this.launchTimeY = new JTextField(5);
        this.launchTimeM = new JComboBox<String>(this.monthStr);
        this.launchTimeW = new JComboBox<String>(this.weekStr);
        this.launchTimeD = new JTextField(3);
        this.launchTimeH = new JTextField(3);
        this.launchTimeMin = new JTextField(3);
        this.launchTimeY.setDocument(new HalfNumberDocument(4));
        this.launchTimeD.setDocument(new HalfNumberDocument(2));
        this.launchTimeH.setDocument(new HalfNumberDocument(2));
        this.launchTimeMin.setDocument(new HalfNumberDocument(2));
        String string = "";
        string = this.projectSetting.getProperty("sentMailMax");
        if (string != null) {
            this.maxSentMail.setText(string);
        } else {
            this.maxSentMail.setText("0");
        }
        string = this.projectSetting.getProperty("receivedMailMax");
        if (string != null) {
            this.maxReceivedMail.setText(string);
        } else {
            this.maxReceivedMail.setText("0");
        }
        string = this.projectSetting.getProperty("phoneBookEntry");
        if (string != null) {
            this.maxPhoneBookEntry.setText(string);
        } else {
            this.maxPhoneBookEntry.setText("0");
        }
        string = this.projectSetting.getProperty("groupEntry");
        if (string != null) {
            this.maxGroupEntry.setText(string);
        } else {
            this.maxGroupEntry.setText("0");
        }
        string = this.projectSetting.getProperty("dtvScheduleMax");
        if (string != null) {
            this.maxDTVScheduleEntry.setText(string);
        } else {
            this.maxDTVScheduleEntry.setText(String.valueOf(50));
        }
        string = this.projectSetting.getProperty("accelerationDataMax");
        if (string != null) {
            this.maxAccelerationSensorEntry.setText(string);
        } else {
            this.maxAccelerationSensorEntry.setText(String.valueOf(20));
        }
        string = this.projectSetting.getProperty("fontBaselinePos");
        if (string != null) {
            this.fontBaseline.setText(string);
        } else {
            this.fontBaseline.setText("");
        }
        try {
            string = this.projectSetting.getProperty("linkHttpHeader");
            if (string.equals("true")) {
                this.linkHttpHeader.setSelected(true);
            } else {
                this.linkHttpHeader.setSelected(false);
            }
        }
        catch (Exception exception) {
            this.linkHttpHeader.setSelected(false);
        }
        string = this.projectSetting.getProperty("xDcmMove");
        if (string != null) {
            this.xDcmMoveVal.setText(string);
        } else {
            this.xDcmMoveVal.setText("0000");
            this.linkHttpHeader.setSelected(false);
        }
        if (!this.linkHttpHeader.isSelected()) {
            this.setCompEnabled(this.xDcmMoveVal, false);
        } else {
            this.setCompEnabled(this.xDcmMoveVal, true);
        }
        try {
            string = this.projectSetting.getProperty("appMoveInfo");
            if (string.equals("true")) {
                this.isMovedCheck.setSelected(true);
            } else {
                this.isMovedCheck.setSelected(false);
            }
        }
        catch (Exception exception) {
            this.isMovedCheck.setSelected(false);
        }
        try {
            string = this.projectSetting.getProperty("moveFromOtherTerm");
            if (string.equals("true")) {
                this.otherTermCheck.setSelected(true);
            } else {
                this.otherTermCheck.setSelected(false);
            }
        }
        catch (Exception exception) {
            this.otherTermCheck.setSelected(false);
        }
        string = this.projectSetting.getProperty("cameraDevice");
        if (string != null) {
            this.cameraDeviceNum.setText(string);
        } else {
            this.cameraDeviceNum.setText("1");
        }
        string = this.projectSetting.getProperty("cameraFrameRate");
        if (string != null) {
            this.cameraDeviceRate.setText(string);
        } else {
            this.cameraDeviceRate.setText(String.valueOf(15));
        }
        string = this.projectSetting.getProperty("sound3dResource");
        this.sound3dResourceNum.setDocument(new HalfNumberDocument(this.MAX_ENTRY));
        this.sound3dResourceNum.setText(this.fitting3DResource(string));
        string = this.projectSetting.getProperty("launchTimeMax");
        if (string == null) {
            string = "4";
        }
        try {
            this.LAUNCH_TIME_MAX = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.LAUNCH_TIME_MAX >= 1000) {
            this.LAUNCH_TIME_MAX = 999;
        }
        if (this.LAUNCH_TIME_MAX < 4) {
            this.LAUNCH_TIME_MAX = 4;
        }
        this.launchTimesStr = this.getStringsFromProperty(this.projectSetting.getProperty("launchTime"));
        this.dispLaunchTimesStr = this.getDispStringsFromProperties(this.launchTimesStr);
        this.launchTimes.setListData(this.dispLaunchTimesStr);
        this.launchTimes.setSelectedIndex(0);
        if (this.launchTimesStr != null && this.launchTimesStr[0] != null) {
            this.insertLaunchTime(0);
        } else {
            this.launchTimeY.setText("");
            this.launchTimeM.setSelectedIndex(0);
            this.launchTimeW.setSelectedIndex(0);
            this.launchTimeD.setText("");
            this.launchTimeH.setText("");
            this.launchTimeMin.setText("");
            this.setEnabled(1);
        }
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jButton.setActionCommand("set");
        jButton2.setActionCommand("cancel");
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("MAX_NUM_SET")));
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("RESOURCE_PROPERTY_SET")));
        jPanel4.setLayout(new GridBagLayout());
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("APP_MOVE_INFO_SET")));
        jPanel5.setLayout(new GridBagLayout());
        jPanel5.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("CAMERA_INFO_SET")));
        jPanel6.setLayout(new GridBagLayout());
        jPanel7.setLayout(new GridBagLayout());
        jPanel7.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("LAUNCH_TIME_SET")));
        jPanel9.setLayout(new GridLayout());
        jPanel10.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        int n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.maxSentMail, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel2.add((Component)this.maxReceivedMail, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.maxPhoneBookEntry, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel2.add((Component)this.maxGroupEntry, gridBagConstraints);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.maxDTVScheduleEntry, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel2.add((Component)this.maxAccelerationSensorEntry, gridBagConstraints);
        n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        jPanel3.add((Component)this.linkHttpHeader, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel3.add((Component)this.xDcmMoveVal, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel3.add(Box.createHorizontalStrut(36), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel3.add(Box.createHorizontalStrut(36), gridBagConstraints);
        gridBagConstraints.gridy = n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel4.add((Component)this.isMovedCheck, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel4.add((Component)this.otherTermCheck, gridBagConstraints);
        gridBagConstraints.gridy = n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel5.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel5.add((Component)this.cameraDeviceNum, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel5.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel5.add((Component)this.cameraDeviceRate, gridBagConstraints);
        n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel6.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel6.add((Component)this.fontBaseline, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel6.add(Box.createHorizontalStrut(36), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel6.add(Box.createHorizontalStrut(36), gridBagConstraints);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel6.add((Component)jLabel11, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        jPanel6.add((Component)this.sound3dResourceNum, gridBagConstraints);
        n = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel10.add((Component)this.dateType, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel10.add((Component)jLabel12, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel10.add((Component)this.launchTimeY, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel10.add((Component)this.launchTimeM, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jPanel10.add((Component)this.launchTimeW, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        jPanel10.add((Component)jLabel13, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        jPanel10.add((Component)this.launchTimeD, gridBagConstraints);
        gridBagConstraints.gridx = 7;
        jPanel10.add((Component)jLabel14, gridBagConstraints);
        gridBagConstraints.gridx = 8;
        jPanel10.add((Component)this.launchTimeH, gridBagConstraints);
        gridBagConstraints.gridx = 9;
        jPanel10.add((Component)jLabel15, gridBagConstraints);
        gridBagConstraints.gridx = 10;
        jPanel10.add((Component)this.launchTimeMin, gridBagConstraints);
        ++n;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel10, gridBagConstraints);
        jPanel9.add(jScrollPane);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        jPanel7.add((Component)jPanel9, gridBagConstraints);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        container.add(jPanel2);
        container.add(jPanel3);
        container.add(jPanel4);
        container.add(jPanel5);
        container.add(jPanel6);
        container.add(jPanel7);
        container.add(jPanel);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = LimitWindow.this.linkHttpHeader.isSelected();
                LimitWindow.this.setCompEnabled(LimitWindow.this.xDcmMoveVal, bl);
            }
        };
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = LimitWindow.this.launchTimes.getSelectedIndex();
                LimitWindow.this.setLaunchTime(n);
                if (LimitWindow.this.previousIndex >= LimitWindow.this.launchTimesStr.length) {
                    LimitWindow.this.previousIndex = -1;
                } else {
                    LimitWindow.this.previousIndex = n;
                }
            }
        };
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.dateType.addActionListener(actionListener);
        this.launchTimes.addListSelectionListener(listSelectionListener);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        this.linkHttpHeader.addChangeListener(changeListener);
        this.setResizable(false);
        this.pack();
    }

    private void setProjectSetting(Setting setting) {
        if (setting != null) {
            this.projectSetting = setting;
        } else {
            this.projectSetting = new Setting();
            this.projectSetting.setProperty("sentMailMax", "0");
            this.projectSetting.setProperty("receivedMailMax", "0");
            this.projectSetting.setProperty("phoneBookEntry", "0");
            this.projectSetting.setProperty("groupEntry", "0");
            this.projectSetting.setProperty("launchTime", "4");
            this.projectSetting.setProperty("cameraDevice", "1");
            this.projectSetting.setProperty("sound3dResource", "4");
            this.projectSetting.setProperty("fontBaselinePos", "0");
            this.projectSetting.setProperty("linkHttpHeader", "false");
            this.projectSetting.setProperty("xDcmMove", "0000");
            this.projectSetting.setProperty("appMoveInfo", "false");
            this.projectSetting.setProperty("moveFromOtherTerm", "false");
        }
    }

    private void setCompEnabled(JComponent jComponent, boolean bl) {
        if (bl) {
            jComponent.setEnabled(true);
        } else {
            jComponent.setEnabled(false);
        }
    }

    void set() {
        int n = 0;
        String string = this.maxSentMail.getText();
        String string2 = this.maxReceivedMail.getText();
        String string3 = this.maxPhoneBookEntry.getText();
        String string4 = this.maxGroupEntry.getText();
        String string5 = this.fontBaseline.getText();
        String string6 = this.maxDTVScheduleEntry.getText();
        String string7 = this.maxAccelerationSensorEntry.getText();
        String string8 = null;
        string8 = this.linkHttpHeader.isSelected() ? "true" : "false";
        String string9 = this.xDcmMoveVal.getText();
        String string10 = this.cameraDeviceNum.getText();
        String string11 = this.cameraDeviceRate.getText();
        String string12 = this.sound3dResourceNum.getText();
        if ((string = this.checkNumStr(string)) == null) {
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("MAX_MAIL_SENT")));
            return;
        }
        if ((string2 = this.checkNumStr(string2)) == null) {
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("MAX_MAIL_RECEIVED")));
            return;
        }
        if ((string3 = this.checkNumStr(string3)) == null) {
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("MAX_PHONEBOOK")));
            return;
        }
        if ((string4 = this.checkNumStr(string4)) == null) {
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("MAX_GROUP")));
            return;
        }
        if ((string6 = this.checkNumStr(string6)) == null) {
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("MAX_DTV_SCHEDULE")));
            return;
        }
        if ((string7 = this.checkNumStr(string7)) == null) {
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("MAX_ACCELERATION_DATA")));
            return;
        }
        if ((string5 = this.checkNumStr(string5)) == null) {
            string5 = "";
        }
        String string13 = null;
        string13 = this.isMovedCheck.isSelected() ? "true" : "false";
        String string14 = null;
        string14 = this.otherTermCheck.isSelected() ? "true" : "false";
        if ((string10 = this.checkNumStr(string10)) == null) {
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("CAMERA_DEVICE_NUM")));
            return;
        }
        if ((string11 = this.checkNumStr(string11)) == null) {
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("CAMERA_FRAME_RATE")));
            return;
        }
        string11 = this.fittingCameraRate(string11);
        if ((string12 = this.checkNumStr(string12)) == null) {
            this.showDialog(Resource.format("SET_LIMIT_WNG", Resource.getString("SOUND3D_RESOURCE_NUM")));
            return;
        }
        string12 = this.fitting3DResource(string12);
        this.projectSetting.setProperty("sentMailMax", string);
        this.projectSetting.setProperty("receivedMailMax", string2);
        this.projectSetting.setProperty("phoneBookEntry", string3);
        this.projectSetting.setProperty("groupEntry", string4);
        this.projectSetting.setProperty("fontBaselinePos", string5);
        this.projectSetting.setProperty("dtvScheduleMax", string6);
        this.projectSetting.setProperty("accelerationDataMax", string7);
        this.projectSetting.setProperty("launchTimeMax", String.valueOf(this.LAUNCH_TIME_MAX));
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.launchTimes.getSelectedIndex();
        if (n2 >= 0) {
            this.setLaunchTime(n2);
        }
        for (int i = 0; i < this.launchTimesStr.length; ++i) {
            if (!this.launchTimesStr[i].equals("null")) {
                stringBuffer.append(this.launchTimesStr[i] + ";");
                continue;
            }
            stringBuffer.append(";");
        }
        this.projectSetting.setProperty("launchTime", stringBuffer.toString());
        this.projectSetting.setProperty("linkHttpHeader", string8);
        this.projectSetting.setProperty("xDcmMove", string9);
        this.projectSetting.setProperty("appMoveInfo", string13);
        this.projectSetting.setProperty("moveFromOtherTerm", string14);
        this.projectSetting.setProperty("cameraDevice", string10);
        this.projectSetting.setProperty("cameraFrameRate", string11);
        this.projectSetting.setProperty("sound3dResource", string12);
        File file = new File(this.parent.getProjectSettingPath(this.parent.getProjectName()));
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        n = this.parent.saveProjectSetting(this.projectSetting);
        if (n == 0) {
            System.out.println(Resource.getString("UPDATE_SETTING"));
        } else {
            System.out.println(Resource.format("WRITE_ERR", file.getPath()));
        }
        this.parent.closeWindow(this);
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private String checkNumStr(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
            if (n < 0) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return String.valueOf(n);
    }

    private void showDialog(String string) {
        Object[] objectArray = new Object[]{Resource.getString("OK")};
        JOptionPane jOptionPane = new JOptionPane(string, 2, 0, null, objectArray);
        JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("WNG"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
    }

    private String getDispLaunchTimeStr(ScheduleDate scheduleDate) {
        StringBuffer stringBuffer = new StringBuffer();
        if (scheduleDate != null) {
            switch (scheduleDate.getType()) {
                case 1: {
                    stringBuffer.append("Onetime ");
                    stringBuffer.append(scheduleDate.get(1) + " ");
                    stringBuffer.append(this.getMonthStr(scheduleDate.get(2)) + " ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(5), 2) + " ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(11), 2) + ":");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(12), 2));
                    break;
                }
                case 2: {
                    stringBuffer.append("Everyday ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(11), 2) + ":");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(12), 2));
                    break;
                }
                case 4: {
                    stringBuffer.append("Every ");
                    stringBuffer.append(this.getWeekStr(scheduleDate.get(7)) + " ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(11), 2) + ":");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(12), 2));
                    break;
                }
                case 8: {
                    stringBuffer.append("Every ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(5), 2) + " ");
                    stringBuffer.append("of month ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(11), 2) + ":");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(12), 2));
                    break;
                }
                case 16: {
                    stringBuffer.append("Every ");
                    stringBuffer.append(this.getMonthStr(scheduleDate.get(2)) + " ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(5), 2) + " ");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(11), 2) + ":");
                    stringBuffer.append(LimitWindow.paddingZero(scheduleDate.get(12), 2));
                    break;
                }
                default: {
                    stringBuffer.append("null");
                    break;
                }
            }
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    private String getWeekStr(int n) {
        switch (n) {
            case 1: {
                return "Sunday";
            }
            case 2: {
                return "Monday";
            }
            case 3: {
                return "Tuesday";
            }
            case 4: {
                return "Wednesday";
            }
            case 5: {
                return "Thursday";
            }
            case 6: {
                return "Friday";
            }
            case 7: {
                return "Saturday";
            }
        }
        return null;
    }

    private String getMonthStr(int n) {
        switch (n) {
            case 0: {
                return "January";
            }
            case 1: {
                return "February";
            }
            case 2: {
                return "March";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "June";
            }
            case 6: {
                return "July";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "October";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "December";
            }
        }
        return null;
    }

    private String[] getStringsFromProperty(String string) {
        String[] stringArray = new String[this.LAUNCH_TIME_MAX];
        for (int i = 0; i < this.LAUNCH_TIME_MAX; ++i) {
            int n;
            if (string != null && (n = string.indexOf(59)) != -1) {
                stringArray[i] = n == 0 ? "null" : string.substring(0, n);
                string = string.substring(n + 1);
                continue;
            }
            stringArray[i] = "null";
        }
        return stringArray;
    }

    private String[] getDispStringsFromProperties(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.getDispLaunchTimeStr(this.getScheduleDateFromProperty(stringArray[i]));
        }
        return stringArray2;
    }

    private void insertLaunchTime(int n) {
        try {
            ScheduleDate scheduleDate = this.getScheduleDateFromProperty(this.launchTimesStr[n]);
            switch (scheduleDate.getType()) {
                case 1: {
                    this.dateType.setSelectedIndex(0);
                    break;
                }
                case 2: {
                    this.dateType.setSelectedIndex(1);
                    break;
                }
                case 4: {
                    this.dateType.setSelectedIndex(2);
                    break;
                }
                case 8: {
                    this.dateType.setSelectedIndex(3);
                    break;
                }
                case 16: {
                    this.dateType.setSelectedIndex(4);
                    break;
                }
                default: {
                    return;
                }
            }
            if (scheduleDate.getType() == 4) {
                switch (scheduleDate.get(7)) {
                    case 1: {
                        this.launchTimeW.setSelectedIndex(0);
                        break;
                    }
                    case 2: {
                        this.launchTimeW.setSelectedIndex(1);
                        break;
                    }
                    case 3: {
                        this.launchTimeW.setSelectedIndex(2);
                        break;
                    }
                    case 4: {
                        this.launchTimeW.setSelectedIndex(3);
                        break;
                    }
                    case 5: {
                        this.launchTimeW.setSelectedIndex(4);
                        break;
                    }
                    case 6: {
                        this.launchTimeW.setSelectedIndex(5);
                        break;
                    }
                    case 7: {
                        this.launchTimeW.setSelectedIndex(6);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (scheduleDate.getType() == 1) {
                this.launchTimeY.setText(String.valueOf(scheduleDate.get(1)));
            }
            if (scheduleDate.getType() == 1 || scheduleDate.getType() == 16) {
                this.launchTimeM.setSelectedIndex(scheduleDate.get(2));
            }
            if (scheduleDate.getType() == 1 || scheduleDate.getType() == 16 || scheduleDate.getType() == 8) {
                this.launchTimeD.setText(String.valueOf(scheduleDate.get(5)));
            }
            this.launchTimeH.setText(String.valueOf(scheduleDate.get(11)));
            this.launchTimeMin.setText(String.valueOf(scheduleDate.get(12)));
            this.setEnabled(scheduleDate.getType());
        }
        catch (Exception exception) {
            this.dateType.setSelectedIndex(0);
            this.launchTimeY.setText("");
            this.launchTimeM.setSelectedIndex(0);
            this.launchTimeW.setSelectedIndex(0);
            this.launchTimeD.setText("");
            this.launchTimeH.setText("");
            this.launchTimeMin.setText("");
            this.setEnabled(1);
            return;
        }
    }

    private void setEnabled(int n) {
        switch (n) {
            case 2: {
                this.launchTimeY.setEnabled(false);
                this.launchTimeM.setEnabled(false);
                this.launchTimeW.setEnabled(false);
                this.launchTimeD.setEnabled(false);
                this.launchTimeH.setEnabled(true);
                this.launchTimeMin.setEnabled(true);
                break;
            }
            case 4: {
                this.launchTimeY.setEnabled(false);
                this.launchTimeM.setEnabled(false);
                this.launchTimeW.setEnabled(true);
                this.launchTimeD.setEnabled(false);
                this.launchTimeH.setEnabled(true);
                this.launchTimeMin.setEnabled(true);
                break;
            }
            case 8: {
                this.launchTimeY.setEnabled(false);
                this.launchTimeM.setEnabled(false);
                this.launchTimeW.setEnabled(false);
                this.launchTimeD.setEnabled(true);
                this.launchTimeH.setEnabled(true);
                this.launchTimeMin.setEnabled(true);
                break;
            }
            case 16: {
                this.launchTimeY.setEnabled(false);
                this.launchTimeM.setEnabled(true);
                this.launchTimeW.setEnabled(false);
                this.launchTimeD.setEnabled(true);
                this.launchTimeH.setEnabled(true);
                this.launchTimeMin.setEnabled(true);
                break;
            }
            case 1: {
                this.launchTimeY.setEnabled(true);
                this.launchTimeM.setEnabled(true);
                this.launchTimeW.setEnabled(false);
                this.launchTimeD.setEnabled(true);
                this.launchTimeH.setEnabled(true);
                this.launchTimeMin.setEnabled(true);
                break;
            }
        }
    }

    private void setLaunchTime(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            return;
        }
        switch (this.dateType.getSelectedIndex()) {
            case 0: {
                if (this.launchTimeY.getText().length() == 0 || this.launchTimeD.getText().length() == 0 || Integer.parseInt(this.launchTimeD.getText()) == 0 || this.launchTimeH.getText().length() == 0 || this.launchTimeMin.getText().length() == 0) {
                    stringBuffer.append("null");
                    if (this.previousIndex >= 0) {
                        this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
                        this.dispLaunchTimesStr[this.previousIndex] = stringBuffer.toString();
                    }
                    this.launchTimes.repaint();
                    this.insertLaunchTime(n);
                    return;
                }
                stringBuffer.append(String.valueOf(1) + "@");
                stringBuffer.append(this.launchTimeY.getText() + "/");
                stringBuffer.append(this.launchTimeM.getSelectedIndex() + "/");
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeD.getText() + "/");
                stringBuffer.append(this.launchTimeH.getText() + "/");
                stringBuffer.append(this.launchTimeMin.getText());
                break;
            }
            case 1: {
                if (this.launchTimeH.getText().length() == 0 || this.launchTimeMin.getText().length() == 0) {
                    stringBuffer.append("null");
                    if (this.previousIndex >= 0) {
                        this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
                        this.dispLaunchTimesStr[this.previousIndex] = stringBuffer.toString();
                    }
                    this.launchTimes.repaint();
                    this.insertLaunchTime(n);
                    return;
                }
                stringBuffer.append(String.valueOf(2) + "@");
                stringBuffer.append("/");
                stringBuffer.append("/");
                stringBuffer.append("/");
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeH.getText() + "/");
                stringBuffer.append(this.launchTimeMin.getText());
                break;
            }
            case 2: {
                if (this.launchTimeH.getText().length() == 0 || this.launchTimeMin.getText().length() == 0) {
                    stringBuffer.append("null");
                    if (this.previousIndex >= 0) {
                        this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
                        this.dispLaunchTimesStr[this.previousIndex] = stringBuffer.toString();
                    }
                    this.launchTimes.repaint();
                    this.insertLaunchTime(n);
                    return;
                }
                stringBuffer.append(String.valueOf(4) + "@");
                stringBuffer.append("/");
                stringBuffer.append("/");
                switch (this.launchTimeW.getSelectedIndex()) {
                    case 0: {
                        stringBuffer.append(String.valueOf(1) + "/");
                        break;
                    }
                    case 1: {
                        stringBuffer.append(String.valueOf(2) + "/");
                        break;
                    }
                    case 2: {
                        stringBuffer.append(String.valueOf(3) + "/");
                        break;
                    }
                    case 3: {
                        stringBuffer.append(String.valueOf(4) + "/");
                        break;
                    }
                    case 4: {
                        stringBuffer.append(String.valueOf(5) + "/");
                        break;
                    }
                    case 5: {
                        stringBuffer.append(String.valueOf(6) + "/");
                        break;
                    }
                    case 6: {
                        stringBuffer.append(String.valueOf(7) + "/");
                    }
                }
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeH.getText() + "/");
                stringBuffer.append(this.launchTimeMin.getText());
                break;
            }
            case 3: {
                if (this.launchTimeD.getText().length() == 0 || Integer.parseInt(this.launchTimeD.getText()) == 0 || this.launchTimeH.getText().length() == 0 || this.launchTimeMin.getText().length() == 0) {
                    stringBuffer.append("null");
                    if (this.previousIndex >= 0) {
                        this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
                        this.dispLaunchTimesStr[this.previousIndex] = stringBuffer.toString();
                    }
                    this.launchTimes.repaint();
                    this.insertLaunchTime(n);
                    return;
                }
                stringBuffer.append(String.valueOf(8) + "@");
                stringBuffer.append("/");
                stringBuffer.append("/");
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeD.getText() + "/");
                stringBuffer.append(this.launchTimeH.getText() + "/");
                stringBuffer.append(this.launchTimeMin.getText());
                break;
            }
            case 4: {
                if (this.launchTimeD.getText().length() == 0 || Integer.parseInt(this.launchTimeD.getText()) == 0 || this.launchTimeH.getText().length() == 0 || this.launchTimeMin.getText().length() == 0) {
                    stringBuffer.append("null");
                    if (this.previousIndex >= 0) {
                        this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
                        this.dispLaunchTimesStr[this.previousIndex] = stringBuffer.toString();
                    }
                    this.launchTimes.repaint();
                    this.insertLaunchTime(n);
                    return;
                }
                stringBuffer.append(String.valueOf(16) + "@");
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeM.getSelectedIndex() + "/");
                stringBuffer.append("/");
                stringBuffer.append(this.launchTimeD.getText() + "/");
                stringBuffer.append(this.launchTimeH.getText() + "/");
                stringBuffer.append(this.launchTimeMin.getText());
                break;
            }
            default: {
                stringBuffer.append("null");
            }
        }
        if (this.previousIndex >= 0) {
            this.launchTimesStr[this.previousIndex] = stringBuffer.toString();
            this.dispLaunchTimesStr[this.previousIndex] = this.getDispLaunchTimeStr(this.getScheduleDateFromProperty(stringBuffer.toString()));
        }
        this.launchTimes.repaint();
        this.insertLaunchTime(n);
    }

    private ScheduleDate getScheduleDateFromProperty(String string) {
        ScheduleDate scheduleDate;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            int n7 = string.indexOf(64);
            int n8 = Integer.parseInt(string.substring(0, n7));
            scheduleDate = new ScheduleDate(n8);
            int n9 = n7 + 1;
            n7 = string.indexOf(47, n9);
            if (n8 == 1) {
                n = Integer.parseInt(string.substring(n9, n7));
            }
            n9 = n7 + 1;
            n7 = string.indexOf(47, n9);
            if (n8 == 1 || n8 == 16) {
                n2 = Integer.parseInt(string.substring(n9, n7));
            }
            n9 = n7 + 1;
            n7 = string.indexOf(47, n9);
            if (n8 == 4) {
                n3 = Integer.parseInt(string.substring(n9, n7));
            }
            n9 = n7 + 1;
            n7 = string.indexOf(47, n9);
            if (n8 == 1 || n8 == 16 || n8 == 8) {
                n4 = Integer.parseInt(string.substring(n9, n7));
            }
            n9 = n7 + 1;
            n7 = string.indexOf(47, n9);
            if (n8 == 1 || n8 == 16 || n8 == 8 || n8 == 4 || n8 == 2) {
                n5 = Integer.parseInt(string.substring(n9, n7));
            }
            n9 = n7 + 1;
            if (n8 == 1 || n8 == 16 || n8 == 8 || n8 == 4 || n8 == 2) {
                n6 = Integer.parseInt(string.substring(n9));
            }
            if (n8 == 1 || n8 == 16 || n8 == 8 || n8 == 4 || n8 == 2) {
                scheduleDate.set(12, n6);
                scheduleDate.set(11, n5);
            }
            if (n8 == 1 || n8 == 16 || n8 == 8) {
                scheduleDate.set(5, n4);
            }
            if (n8 == 4) {
                scheduleDate.set(7, n3);
            }
            if (n8 == 1 || n8 == 16) {
                scheduleDate.set(2, n2);
            }
            if (n8 == 1) {
                scheduleDate.set(1, n);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return scheduleDate;
    }

    private static String paddingZero(int n, int n2) {
        String string = "" + n;
        String string2 = "";
        if (string.length() >= n2) {
            return string;
        }
        for (int i = 0; i < n2 - string.length(); ++i) {
            string2 = string2.concat("0");
        }
        return string2.concat(string);
    }

    private String fitting3DResource(String string) {
        int n = 4;
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                n = n2 > 8 ? 8 : (n2 < 0 ? 0 : n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return String.valueOf(n);
    }

    private String fittingCameraRate(String string) {
        int n = 15;
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                n = n2 > 15 ? 15 : (n2 < 1 ? 15 : n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return String.valueOf(n);
    }
}

