/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.LocationEntry;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class LocationConfirmWindow
extends AbstractWindow {
    private final String ENTRY_ID_KEY = "entry-id";
    private final String TIMESTAMP_KEY = "timestamp";
    private final String ACCURACY_LEVEL_KEY = "level";
    private final String LATITUDE_KEY = "latitude";
    private final String LONGITUDE_KEY = "longitude";
    private final String DATUM_KEY = "datum";
    private final String ACCURACY_LEVEL_1 = "2147483647";
    private final String ACCURACY_LEVEL_2 = "299";
    private final String ACCURACY_LEVEL_3 = "49";
    private final String ACCURACY_UNKNOWN = "-1";
    private MainWindow parent = null;
    private LocationEntry entry = null;
    private int launchType = -1;
    private JButton startButton;
    private JButton cancelButton;
    private int locationEntryID = 0;
    private long locationInfoTimestamp = 0L;
    private int locationInfoLevel = 0;
    private String locationInfoLatitude = null;
    private String locationInfoLongitude = null;
    private int locationInfoDatum = 0;
    private int id = 0;

    LocationConfirmWindow(MainWindow mainWindow, LocationEntry locationEntry, int n, int n2) {
        super(mainWindow, "");
        this.id = n2;
        if (n == 13) {
            this.setTitle(Resource.getString("LOCATION_SELECT_WINDOW_TITLE"));
        } else if (n == 14) {
            this.setTitle(Resource.getString("LOCATION_IMAGE_SELECT_WINDOW_TITLE"));
        } else {
            this.setTitle(Resource.getString("LOCATION_PHONEBOOK_WINDOW_TITLE"));
        }
        this.parent = mainWindow;
        this.entry = locationEntry;
        this.launchType = n;
        this.addWindowListener();
        JLabel jLabel = new JLabel(Resource.getString("LOCATION_INFO_TIMESTAMP") + " : ");
        JLabel jLabel2 = new JLabel(Resource.getString("GPS_ACCURACY_LEVEL") + " : ");
        JLabel jLabel3 = new JLabel(Resource.getString("GPS_LATITUDE") + " : ");
        JLabel jLabel4 = new JLabel(Resource.getString("GPS_LONGITUDE") + " : ");
        JLabel jLabel5 = new JLabel(Resource.getString("GPS_DATUM_TYPE") + " : ");
        String string = locationEntry.getTimeStampYearPart() + "/" + locationEntry.getTimeStampMonthPart() + "/" + locationEntry.getTimeStampDayPart() + " " + locationEntry.getTimeStampHourPart() + ":" + locationEntry.getTimeStampMinutePart() + ":" + locationEntry.getTimeStampSecondPart() + "." + locationEntry.getTimeStampMilliSecondPart();
        JLabel jLabel6 = new JLabel(string);
        JLabel jLabel7 = new JLabel(locationEntry.getInfoLevel());
        String string2 = locationEntry.getLatitudeHeadPart();
        String string3 = locationEntry.getLatitudeDegreePart();
        String string4 = locationEntry.getLatitudeMinutePart();
        String string5 = locationEntry.getLatitudeSecondPart();
        String string6 = locationEntry.getLatitudeCentiSecondPart();
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        }
        string3 = string3 == null || string3.length() == 0 ? "" : string3 + ".";
        string4 = string4 == null || string4.length() == 0 ? "" : string4 + ".";
        string5 = string5 == null || string5.length() == 0 ? "" : string5 + ".";
        if (string6 == null || string6.length() == 0) {
            string6 = "";
        }
        String string7 = string2 + string3 + string4 + string5 + string6;
        string2 = locationEntry.getLongitudeHeadPart();
        string3 = locationEntry.getLongitudeDegreePart();
        string4 = locationEntry.getLongitudeMinutePart();
        string5 = locationEntry.getLongitudeSecondPart();
        string6 = locationEntry.getLongitudeCentiSecondPart();
        if (string2 == null || string2.length() == 0) {
            string2 = "";
        }
        string3 = string3 == null || string3.length() == 0 ? "" : string3 + ".";
        string4 = string4 == null || string4.length() == 0 ? "" : string4 + ".";
        string5 = string5 == null || string5.length() == 0 ? "" : string5 + ".";
        if (string6 == null || string6.length() == 0) {
            string6 = "";
        }
        String string8 = string2 + string3 + string4 + string5 + string6;
        JLabel jLabel8 = new JLabel(" " + string7);
        JLabel jLabel9 = new JLabel(" " + string8);
        String string9 = "";
        if (Integer.parseInt(locationEntry.getDatum()) == 0) {
            string9 = Resource.getString("GPS_DATUM_WGS84");
        } else if (Integer.parseInt(locationEntry.getDatum()) == 1) {
            string9 = Resource.getString("GPS_DATUM_TOKYO");
        }
        JLabel jLabel10 = new JLabel(" " + string9);
        this.startButton = new JButton(Resource.getString("LAUNCH_FROM_MINIWINDOW"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new GridLayout(6, 1));
        jPanel4.setLayout(new GridLayout(6, 1));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("LOCATION_INFO_CURRENT")));
        jPanel3.add(this.getFlowPanel(jLabel, 2));
        jPanel3.add(this.getFlowPanel(jLabel2, 2));
        jPanel3.add(this.getFlowPanel(jLabel3, 2));
        jPanel3.add(this.getFlowPanel(jLabel4, 2));
        jPanel3.add(this.getFlowPanel(jLabel5, 2));
        jPanel4.add(this.getFlowPanel(jLabel6, 0));
        jPanel4.add(this.getFlowPanel(jLabel7, 0));
        jPanel4.add(this.getFlowPanel(jLabel8, 0));
        jPanel4.add(this.getFlowPanel(jLabel9, 0));
        jPanel4.add(this.getFlowPanel(jLabel10, 0));
        jPanel5.add(this.startButton);
        jPanel5.add(this.cancelButton);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add("North", jPanel2);
        jPanel.add("South", jPanel5);
        container.add(jPanel);
        this.startButton.setActionCommand("start");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.startButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.setResizable(false);
        this.pack();
    }

    void start() {
        String string;
        int n;
        String string2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.launchType != 13) {
            hashtable.put("entry-id", Integer.toString(this.id));
        }
        hashtable.put("timestamp", this.entry.parseStringTimestamp());
        String string3 = null;
        int n2 = 0;
        if (!this.entry.getInfoLevel().equals("UNKNOWN")) {
            n2 = Integer.parseInt(this.entry.getInfoLevel());
        }
        switch (n2) {
            case 1: {
                string3 = "2147483647";
                break;
            }
            case 2: {
                string3 = "299";
                break;
            }
            case 3: {
                string3 = "49";
                break;
            }
            default: {
                string3 = "-1";
            }
        }
        hashtable.put("level", string3);
        String string4 = this.parseStringDms(0);
        if (string4 != null) {
            hashtable.put("latitude", string4);
        }
        if ((string2 = this.parseStringDms(1)) != null) {
            hashtable.put("longitude", string2);
        }
        if ((n = Integer.parseInt(string = this.entry.getDatum())) != -1) {
            hashtable.put("datum", string);
        }
        JOptionPane jOptionPane = new JOptionPane(Resource.getString("LOCATION_FIRST_WNG"), 3, 0);
        JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object instanceof Integer && (Integer)object == 0) {
            try {
                JAMManager.invokeApplication(this.parent.getAdfPath(), this.parent.getJarPath(), this.launchType, JAMManager.getParams(hashtable), this.parent.getDeviceName(), this.parent.getAdfUrl(), this.parent.getProjectNameForBytes(), DebugTraceWindow.getDebugParam());
                this.parent.setEnabledDeviceMenu(false);
                this.parent.closeWindow(this);
            }
            catch (Exception exception) {
                this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
            }
        }
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private String parseStringDms(int n) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n2 = 0;
        if (n == 0) {
            string2 = this.entry.getLatitudeHeadPart();
            string3 = this.entry.getLatitudeDegreePart();
            string4 = this.entry.getLatitudeMinutePart();
            string5 = this.entry.getLatitudeSecondPart();
            string6 = this.entry.getLatitudeCentiSecondPart();
            if (string3 == null || string4 == null || string5 == null || string5 == null) {
                return null;
            }
            if (string2 == null) {
                string2 = "N";
            }
            if ((n2 = Integer.parseInt(string3)) < 10) {
                string3 = string3.substring(1);
            }
            if (string4.length() == 1) {
                string4 = "0" + string4;
            }
            if (string5.length() == 1) {
                string5 = "0" + string5;
            }
            if (string6.length() == 1) {
                string6 = "0" + string6;
            } else if (string6.length() == 3) {
                string6 = string6.substring(0, 2);
            }
        } else {
            string2 = this.entry.getLongitudeHeadPart();
            string3 = this.entry.getLongitudeDegreePart();
            string4 = this.entry.getLongitudeMinutePart();
            string5 = this.entry.getLongitudeSecondPart();
            string6 = this.entry.getLongitudeCentiSecondPart();
            if (string3 == null || string4 == null || string5 == null || string5 == null) {
                return null;
            }
            if (string2 == null) {
                string2 = "E";
            }
            if ((n2 = Integer.parseInt(string3)) < 10) {
                string3 = string3.substring(2);
            } else if (n2 < 100) {
                string3 = string3.substring(1);
            }
            if (string4.length() == 1) {
                string4 = "0" + string4;
            }
            if (string5.length() == 1) {
                string5 = "0" + string5;
            }
            if (string6.length() == 1) {
                string6 = "0" + string6;
            } else if (string6.length() == 3) {
                string6 = string6.substring(0, 2);
            }
        }
        string = string2 + string3 + "." + string4 + "." + string5 + "." + string6;
        return string;
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }
}

