/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.LocationEntry;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PhoneBookEntry;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class LocationSelectWindow
extends AbstractWindow {
    private MainWindow parent = null;
    private LocationEntry entry = null;
    private int launchType = -1;
    private JTextField entryIdField;
    private JButton setButton;
    private JButton cancelButton;
    private static final int ACCURACY_COARSE = Integer.MAX_VALUE;
    private static final int ACCURACY_NORMAL = 299;
    private static final int ACCURACY_FINE = 49;
    private static final File phoneBookDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "phonebook");
    private String phoneBookPath = null;

    LocationSelectWindow(MainWindow mainWindow, LocationEntry locationEntry, int n) {
        super(mainWindow, null);
        Object object;
        Object object2;
        this.parent = mainWindow;
        this.entry = locationEntry;
        this.addWindowListener();
        this.launchType = n;
        if (n == 14) {
            this.setTitle(Resource.getString("SET_LOCATION_IMAGE"));
        } else {
            this.setTitle(Resource.getString("SET_LOCATION_PHONEBOOK"));
        }
        JLabel jLabel = new JLabel(Resource.getString("LOCATION_IMAGE_ID") + " : ");
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.entryIdField = new JTextField(4);
        this.entryIdField.setDocument(new HalfNumberDocument(3));
        this.entryIdField.setHorizontalAlignment(4);
        if (n == 14) {
            object2 = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "location" + File.separator + "location_information" + File.separator + "lmg_entry";
            object = null;
            try {
                object = new BufferedReader(new InputStreamReader(new FileInputStream((String)object2)));
                this.entryIdField.setText(((BufferedReader)object).readLine());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object2 = this.getContentPane();
        ((Container)object2).setLayout(new FlowLayout());
        object = new JPanel();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setLayout(new GridLayout(1, 1));
        jPanel3.setLayout(new GridLayout(1, 1));
        jPanel5.add(this.entryIdField);
        jPanel2.add(this.getFlowPanel(jLabel, 2));
        jPanel3.add(this.getFlowPanel(this.entryIdField, 0));
        jPanel4.add(this.setButton);
        jPanel4.add(this.cancelButton);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        ((Container)object).add("North", jPanel);
        ((Container)object).add("South", jPanel4);
        ((Container)object2).add((Component)object);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    void set() {
        block16: {
            String string = null;
            String string2 = null;
            PhoneBookEntry phoneBookEntry = new PhoneBookEntry();
            String string3 = this.entryIdField.getText();
            if (string3 == null || string3.trim().length() == 0) {
                this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("LOCATION_IMAGE_ID")), this, 2);
                return;
            }
            try {
                Integer.parseInt(string3);
            }
            catch (Exception exception) {
                this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("LOCATION_IMAGE_ID")), this, 2);
                return;
            }
            if (this.launchType == 15 && (phoneBookEntry = this.getPhonebookEntry(string3)) == null) {
                this.parent.showDialog(Resource.getString("SET_PHONEENTRY_ERR"), this, 2);
                return;
            }
            string = string3 + "," + this.entry.parseStringTimestamp() + "," + this.entry.getInfoLevel() + "," + this.entry.parseStringDms(0) + "," + this.entry.parseStringDms(1) + "," + this.entry.getAltitude() + "," + this.entry.getDatum();
            if (this.launchType == 14) {
                try {
                    string2 = string3 + ".lmg";
                    this.entry.save(string, string2);
                    String string4 = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "location" + File.separator + "location_information" + File.separator + "lmg_entry";
                    BufferedWriter bufferedWriter = null;
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string4)));
                    bufferedWriter.write(string3 + "\n");
                    bufferedWriter.close();
                    break block16;
                }
                catch (IOException iOException) {
                    System.err.println(Resource.format("WRITE_ERR", string2));
                    return;
                }
            }
            try {
                phoneBookEntry.setTimeStamp(this.entry.parseStringTimestamp());
                String string5 = null;
                switch (Integer.parseInt(this.entry.getInfoLevel())) {
                    case 1: {
                        string5 = Integer.toString(Integer.MAX_VALUE);
                        break;
                    }
                    case 2: {
                        string5 = Integer.toString(299);
                        break;
                    }
                    case 3: {
                        string5 = Integer.toString(49);
                    }
                }
                phoneBookEntry.setAccuracy(string5);
                phoneBookEntry.setLatitude(this.entry.parseStringDms(0));
                phoneBookEntry.setLongitude(this.entry.parseStringDms(1));
                phoneBookEntry.setAltitude(this.entry.getAltitude());
                phoneBookEntry.setDatum(this.entry.getDatum());
                phoneBookEntry.save(this.phoneBookPath);
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("WRITE_ERR", this.phoneBookPath));
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private PhoneBookEntry getPhonebookEntry(String string) {
        String[] stringArray = phoneBookDir.list(new PhoneBookFilter());
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.phoneBookPath = phoneBookDir.getPath() + File.separator + stringArray[i];
            int n = stringArray[i].indexOf(95);
            try {
                int n2 = Integer.parseInt(stringArray[i].substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            try {
                PhoneBookEntry phoneBookEntry = new PhoneBookEntry();
                phoneBookEntry.load(this.phoneBookPath);
                if (!phoneBookEntry.getMemoryNo().equals(string)) continue;
                return phoneBookEntry;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("NOT_FOUND_ERR", this.phoneBookPath));
                continue;
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("READ_ERR", this.phoneBookPath));
            }
        }
        return null;
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }

    class PhoneBookFilter
    implements FilenameFilter {
        PhoneBookFilter() {
        }

        public boolean accept(File file, String string) {
            if (file.equals(phoneBookDir)) {
                return string.endsWith(".tel");
            }
            return false;
        }
    }
}

