/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MailFileManager;
import com.nttdocomo.dojaemu.ktoolbar.MailInfo;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class MailEditWindow
extends AbstractWindow
implements ItemListener {
    static final int ADDRESS_BYTE_NUM = 50;
    static final int SUBJECT_BYTE_NUM = 30;
    static final int MESSAGE_BYTE_NUM = 10000;
    private static final int YEAR_CHAR_NUM = 4;
    private static final int MONTH_CHAR_NUM = 2;
    private static final int DAY_CHAR_NUM = 2;
    private static final int HOUR_CHAR_NUM = 2;
    private static final int MINUTE_CHAR_NUM = 2;
    private static final int TEXT_FIELD_WIDTH = 30;
    private static final String MESSAGE_CODE = "MessageCode=";
    private static final String DATA = "data=";
    private static final String BOUNDARY_STRING = "--B:P";
    private static final String BOUNDARY_END_STRING = "--B:P--";
    private static final int MAX_ADDRES_NUM = 5;
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private JTextField fromField;
    private JTextField toField;
    private JLabel myAddressLabel;
    private JTextField subjectField;
    private JTextField yearField;
    private JTextField monthField;
    private JTextField dayField;
    private JTextField hourField;
    private JTextField minuteField;
    private JTextArea messageArea;
    private JRadioButton yetNormalButton;
    private JRadioButton alreadyXStringButton;
    private JCheckBox nativeMailCheckBox;
    private JScrollPane messageScroll;
    private JLabel dateLabel;
    private JLabel mailStateLabel;
    private JLabel messageCodeContentLabel;
    private boolean isNewMail = true;
    private int mailBoxState = 0;
    private String mailBoxName = null;
    private String messageCode = null;
    private MailInfo mail = new MailInfo();
    private MainWindow parent = null;
    private int receivedNum = 0;
    private int sentNum = 0;
    private String myAddress = null;

    MailEditWindow(MainWindow mainWindow, String string, int n, String string2, int n2, int n3, String string3) {
        super(mainWindow, string3, true);
        this.mailBoxState = n;
        this.mailBoxName = string;
        this.parent = mainWindow;
        this.messageCode = string2;
        this.receivedNum = n2;
        this.sentNum = n3;
        this.addWindowListener();
        JLabel jLabel = new JLabel(Resource.getString("FROM") + " : ");
        JLabel jLabel2 = new JLabel(Resource.getString("TO") + " : ");
        JLabel jLabel3 = new JLabel(Resource.getString("SUBJECT") + " : ");
        this.dateLabel = new JLabel();
        this.messageCodeContentLabel = new JLabel(this.messageCode);
        JLabel jLabel4 = new JLabel(Resource.getString("YEAR"));
        JLabel jLabel5 = new JLabel(Resource.getString("MONTH"));
        JLabel jLabel6 = new JLabel(Resource.getString("DAY"));
        JLabel jLabel7 = new JLabel(Resource.getString("HOUR"));
        JLabel jLabel8 = new JLabel(Resource.getString("MINUTE"));
        JLabel jLabel9 = new JLabel(Resource.getString("MESSAGE"));
        JLabel jLabel10 = new JLabel(Resource.getString("NATIVE_MAIL") + " : ");
        this.mailStateLabel = new JLabel();
        JLabel jLabel11 = new JLabel(Resource.getString("MESSAGE_CODE") + " : ");
        this.myAddressLabel = new JLabel();
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        this.nativeMailCheckBox = new JCheckBox();
        this.fromField = new JTextField(33);
        this.toField = new JTextField(33);
        this.subjectField = new JTextField(33);
        this.yearField = new JTextField(4);
        this.monthField = new JTextField(3);
        this.dayField = new JTextField(3);
        this.hourField = new JTextField(3);
        this.minuteField = new JTextField(3);
        this.messageArea = new JTextArea(5, 30);
        this.yetNormalButton = new JRadioButton();
        this.alreadyXStringButton = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.alreadyXStringButton);
        buttonGroup.add(this.yetNormalButton);
        this.messageScroll = new JScrollPane();
        this.messageScroll.getViewport().add(this.messageArea);
        this.messageScroll.setSize(5, 30);
        this.initializeWindowState();
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        if (this.mailBoxState == 0) {
            jPanel2.setLayout(new GridLayout(8, 1));
            jPanel3.setLayout(new GridLayout(8, 1));
            jPanel2.add(this.getFlowPanel(jLabel2, 2));
            jPanel2.add(this.getFlowPanel(new JLabel(), 2));
            jPanel3.add(this.getFlowPanel(this.myAddressLabel, 0));
            jPanel3.add(this.getFlowPanel(this.toField, 0));
            jPanel2.add(this.getFlowPanel(jLabel, 2));
            jPanel3.add(this.getFlowPanel(this.fromField, 0));
        } else {
            jPanel2.setLayout(new GridLayout(7, 1));
            jPanel3.setLayout(new GridLayout(7, 1));
            jPanel2.add(this.getFlowPanel(jLabel2, 2));
            jPanel3.add(this.getFlowPanel(this.toField, 0));
            jPanel2.add(this.getFlowPanel(jLabel, 2));
            jPanel3.add(this.getFlowPanel(this.myAddressLabel, 0));
        }
        jPanel2.add(this.getFlowPanel(jLabel3, 2));
        jPanel3.add(this.getFlowPanel(this.subjectField, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0, 0, 0));
        jPanel4.add(this.yearField);
        jPanel4.add(jLabel4);
        jPanel4.add(this.monthField);
        jPanel4.add(jLabel5);
        jPanel4.add(this.dayField);
        jPanel4.add(jLabel6);
        jPanel4.add(this.hourField);
        jPanel4.add(jLabel7);
        jPanel4.add(this.minuteField);
        jPanel4.add(jLabel8);
        jPanel2.add(this.getFlowPanel(this.dateLabel, 2));
        jPanel3.add(this.getFlowPanel(jPanel4, 0));
        jPanel2.add(this.getFlowPanel(jLabel11, 2));
        jPanel3.add(this.getFlowPanel(this.messageCodeContentLabel, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(this.alreadyXStringButton);
        jPanel5.add(this.yetNormalButton);
        jPanel2.add(this.getFlowPanel(jLabel10, 0));
        jPanel3.add(this.getFlowPanel(this.nativeMailCheckBox, 0));
        jPanel3.add(jPanel5);
        jPanel2.add(this.getFlowPanel(this.mailStateLabel, 2));
        jPanel.setLayout(new BorderLayout());
        jPanel.add("West", jPanel2);
        jPanel.add("Center", jPanel3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add("North", this.getFlowPanel(jLabel9, 0));
        jPanel6.add("Center", this.messageScroll);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(1));
        jPanel7.add(jButton);
        jPanel7.add(jButton2);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(1));
        jPanel8.add(jPanel7);
        container.setLayout(new BorderLayout());
        container.add("North", jPanel);
        container.add("Center", jPanel6);
        container.add("South", jPanel8);
        this.pack();
        this.setResizable(false);
        jButton2.setActionCommand("cancel");
        jButton.setActionCommand("save");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton2.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        this.nativeMailCheckBox.addItemListener(this);
    }

    MailEditWindow(MainWindow mainWindow, MailInfo mailInfo, String string, int n, String string2, int n2, int n3, String string3) {
        this(mainWindow, string, n, string2, n2, n3, string3);
        this.mail = mailInfo;
        this.setMailInfo(this.mail);
        this.messageArea.setCaretPosition(0);
        this.isNewMail = false;
    }

    private void setMailInfo(MailInfo mailInfo) {
        if (mailInfo == null) {
            return;
        }
        if (this.mailBoxState == 0) {
            this.toField.setText(this.getOtherAddress(mailInfo.getToHeader()));
            this.fromField.setText(mailInfo.getFromHeader());
        } else {
            this.toField.setText(MailEditWindow.getAddressString(mailInfo.getToHeader()));
        }
        this.subjectField.setText(mailInfo.getSubjectHeader());
        this.messageArea.setText(mailInfo.getMessage());
        Calendar calendar = mailInfo.getCalendar();
        this.yearField.setText(MailEditWindow.intToString(calendar.get(1), 4));
        this.monthField.setText(MailEditWindow.intToString(calendar.get(2) + 1, 2));
        this.dayField.setText(MailEditWindow.intToString(calendar.get(5), 2));
        this.hourField.setText(MailEditWindow.intToString(calendar.get(11), 2));
        this.minuteField.setText(MailEditWindow.intToString(calendar.get(12), 2));
        if (this.mailBoxState == 0) {
            if (mailInfo.getState() == 0) {
                this.yetNormalButton.setSelected(true);
            }
            if (mailInfo.getBoundary() == null) {
                this.nativeMailCheckBox.setSelected(true);
            } else if (mailInfo.getBoundary().trim().length() == 0) {
                this.nativeMailCheckBox.setSelected(true);
            }
        } else if (mailInfo.getRecipientState() == 2) {
            if (mailInfo.getBoundary() == null) {
                this.nativeMailCheckBox.setSelected(true);
            } else {
                this.alreadyXStringButton.setSelected(true);
            }
        } else if (mailInfo.getRecipientState() == 1) {
            this.alreadyXStringButton.setSelected(true);
        } else {
            this.yetNormalButton.setSelected(true);
        }
    }

    private void initializeWindowState() {
        MailFileManager mailFileManager = new MailFileManager(this.mailBoxName, this.messageCode);
        this.myAddress = mailFileManager.getMyAddress();
        if (this.myAddress == null) {
            this.myAddress = "message_app_usr0@docomo.ne.jp";
        }
        if (this.mailBoxState == 0) {
            this.myAddressLabel.setText(this.myAddress + ",");
            this.dateLabel.setText(Resource.getString("RECEIVE_DATE") + " : ");
            this.mailStateLabel.setText(Resource.getString("MAIL_STATE") + " : ");
            this.yetNormalButton.setText(Resource.getString("NOT_READ_YET"));
            this.alreadyXStringButton.setText(Resource.getString("ALREADY_READ"));
        } else {
            this.myAddressLabel.setText(this.myAddress);
            this.dateLabel.setText(Resource.getString("SEND_DATE") + " : ");
            this.mailStateLabel.setText(Resource.getString("STRING_STATE") + " : ");
            this.yetNormalButton.setText(Resource.getString("NORMAL_STRING"));
            this.alreadyXStringButton.setText(Resource.getString("XSTRING"));
        }
        this.alreadyXStringButton.setSelected(true);
    }

    void save() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        string6 = this.subjectField.getText();
        if (string6 != null) {
            if (string6.getBytes().length > 30) {
                Object[] objectArray = new String[]{Resource.getString("SUBJECT"), "30"};
                this.parent.showDialog(Resource.format("OVER_VAL_WNG", objectArray), this, 2);
                return;
            }
            if (this.mailBoxState != 0 && this.toField.getText() != null && this.nativeMailCheckBox.isSelected() && this.toField.getText().trim().equals("SMS") && !MailEditWindow.checkNumber(string6)) {
                Object[] objectArray = new String[]{Resource.getString("SUBJECT")};
                this.parent.showDialog(Resource.format("WRNG_VAL_WNG", objectArray), this, 2);
                return;
            }
            if (this.mailBoxState == 0 && this.fromField.getText() != null && this.nativeMailCheckBox.isSelected() && this.fromField.getText().trim().equals("SMS") && !MailEditWindow.checkNumber(string6)) {
                Object[] objectArray = new String[]{Resource.getString("SUBJECT")};
                this.parent.showDialog(Resource.format("WRNG_VAL_WNG", objectArray), this, 2);
                return;
            }
        }
        if (this.mailBoxState == 0) {
            string = this.fromField.getText();
            if (string == null) {
                string = "";
            }
            string2 = this.toField.getText() != null ? (this.toField.getText().length() != 0 ? this.toField.getText() + "," + this.myAddress : this.myAddress) : this.myAddress;
        } else {
            string2 = this.toField.getText();
            if (string2 == null) {
                string2 = "";
            }
            string = this.myAddress;
        }
        string5 = this.messageArea.getText();
        if (string5 == null) {
            string5 = "";
        }
        StringBuffer stringBuffer = new StringBuffer(string5);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '\n' || i != 0 && stringBuffer.charAt(i - 1) == '\r') continue;
            stringBuffer.insert(i, '\r');
            ++i;
        }
        string5 = stringBuffer.toString();
        if (string.length() == 0) {
            this.parent.showDialog(Resource.format("EMP_VAL_WNG", Resource.getString("FROM")), this, 2);
            return;
        }
        if (this.mailBoxState == 0 ? !this.checkAddresses(string, 1, Resource.getString("FROM")) : !this.checkAddresses(string, 5, Resource.getString("FROM"))) {
            return;
        }
        if (string2.trim().length() == 0) {
            this.parent.showDialog(Resource.format("EMP_VAL_WNG", Resource.getString("TO")), this, 2);
            return;
        }
        if (this.mailBoxState == 0 ? !this.checkAddresses(string2, 5, Resource.getString("TO")) : !this.checkAddresses(string2, 5, Resource.getString("TO"))) {
            return;
        }
        MailFileManager mailFileManager = new MailFileManager(this.mailBoxName, this.messageCode);
        String string7 = MailEditWindow.encodeBase64(this.messageCode);
        if (this.nativeMailCheckBox.isSelected()) {
            string3 = "";
        } else if (this.isNewMail || this.mail.getBoundary() == null) {
            string3 = "--B:P\r\nMessageCode=\"" + string7 + "\"\r\n" + DATA + "\"" + mailFileManager.getBinaryData() + "\"\r\n" + BOUNDARY_END_STRING;
        } else {
            string3 = this.mail.getBoundary();
            if (string3 == null) {
                string3 = "";
            }
        }
        if (string5.length() + string3.length() > 10000) {
            Object[] objectArray = new String[]{Resource.getString("MESSAGE"), "10000"};
            this.parent.showDialog(Resource.format("OVER_VAL_WNG", objectArray), this, 2);
            return;
        }
        string4 = this.getDateString();
        if (string4 == null) {
            String string8 = null;
            string8 = this.mailBoxState == 0 ? Resource.getString("RECEIVE_DATE") : Resource.getString("SEND_DATE");
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", string8), this, 2);
            return;
        }
        this.mail.setFromHeader(string);
        this.mail.setToHeader(string2);
        this.mail.setSubjectHeader(this.subjectField.getText());
        this.mail.setDate(string4);
        this.mail.setMessage(string5);
        this.mail.setMailType(this.mailBoxState);
        if (string3 != null && string3.trim().length() == 0) {
            string3 = null;
        }
        this.mail.setBoundary(string3);
        if (this.mailBoxState == 0) {
            if (this.alreadyXStringButton.isSelected()) {
                this.mail.setState(1);
            } else {
                this.mail.setState(0);
            }
        } else if (this.nativeMailCheckBox.isSelected()) {
            this.mail.setRecipientState(2);
        } else if (this.alreadyXStringButton.isSelected()) {
            if (MailEditWindow.getAddressVector(string2).size() > 1) {
                this.mail.setRecipientState(2);
            } else {
                this.mail.setRecipientState(1);
            }
        } else {
            this.mail.setRecipientState(0);
        }
        MailFileManager mailFileManager2 = new MailFileManager(this.mailBoxName, this.messageCode);
        if (!mailFileManager2.saveMail(this.mail, this.messageCode, this.receivedNum, this.sentNum)) {
            this.parent.showDialog(Resource.format("WRITE_ERR", Resource.getString("MAIL_FILE")), this, 2);
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    static String intToString(int n, int n2) {
        String string = "" + n;
        String string2 = "";
        for (int i = 0; i < n2 - string.length(); ++i) {
            string2 = string2.concat("0");
        }
        return string2.concat(string);
    }

    private String getDateString() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            n = Integer.parseInt(this.yearField.getText());
            n2 = Integer.parseInt(this.monthField.getText());
            n3 = Integer.parseInt(this.dayField.getText());
            n4 = Integer.parseInt(this.hourField.getText());
            n5 = Integer.parseInt(this.minuteField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (n4 < 0 || n4 > 23) {
            return null;
        }
        if (n5 < 0 || n5 > 59) {
            return null;
        }
        if (n2 < 1 || n2 > 12) {
            return null;
        }
        if (n < 1 || n > 9999) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(2, n2 - 1);
        if (n3 < 1 || n3 > gregorianCalendar.getActualMaximum(5)) {
            return null;
        }
        String string = MailEditWindow.intToString(n, 4) + "/" + MailEditWindow.intToString(n2, 2) + "/" + MailEditWindow.intToString(n3, 2) + " " + MailEditWindow.intToString(n4, 2) + ":" + MailEditWindow.intToString(n5, 2);
        return string;
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }

    private String getOtherAddress(String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = null;
        String string2 = "";
        if (string == null) {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.trim().equals(this.myAddress)) continue;
            vector.addElement(string3);
        }
        if (vector.size() == 0) {
            return string2;
        }
        enumeration = vector.elements();
        string2 = string2 + (String)enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            string2 = string2 + "," + (String)enumeration.nextElement();
        }
        return string2;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() != this.nativeMailCheckBox) {
            return;
        }
        if (this.mailBoxState == 0) {
            return;
        }
        if (itemEvent.getStateChange() == 1) {
            this.yetNormalButton.setEnabled(false);
            this.alreadyXStringButton.setEnabled(false);
        } else if (itemEvent.getStateChange() == 2) {
            this.yetNormalButton.setEnabled(true);
            this.alreadyXStringButton.setEnabled(true);
        }
    }

    static boolean checkASCIICharacters(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= ' ' && cArray[i] <= '~') continue;
            return false;
        }
        return true;
    }

    static boolean checkNumber(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= '0' && cArray[i] <= '9') continue;
            return false;
        }
        return true;
    }

    private boolean checkAddresses(String string, int n, String string2) {
        Vector vector = null;
        if (string == null) {
            return true;
        }
        if (string.trim().length() == 0) {
            return true;
        }
        vector = MailEditWindow.getAddressVector(string);
        if (vector.size() > n) {
            Object[] objectArray = new String[]{string2, "" + n};
            this.parent.showDialog(Resource.format("OVER_ELEMENT_WNG", objectArray), this, 2);
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            boolean bl = true;
            String string3 = (String)vector.elementAt(i);
            if (string3.getBytes().length > 50) {
                bl = false;
            }
            if (!MailEditWindow.checkASCIICharacters(string3)) {
                bl = false;
            }
            if (bl) continue;
            if (vector.size() == 1) {
                this.parent.showDialog(Resource.format("WRNG_VAL_WNG", string2), this, 2);
            } else {
                Object[] objectArray = new String[]{string2, "" + (i + 1)};
                this.parent.showDialog(Resource.format("WRNG_VAL_AT_WNG", objectArray), this, 2);
            }
            return false;
        }
        return true;
    }

    static Vector getAddressVector(String string) {
        int n = 0;
        int n2 = 0;
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return vector;
        }
        while (n < string.length() + 1) {
            String string2;
            n2 = string.indexOf(",", n);
            if (n2 < 0) {
                n2 = string.length();
            }
            if ((string2 = string.substring(n, n2)).length() != 0) {
                vector.addElement(string2);
            }
            n = n2 + 1;
        }
        return vector;
    }

    static String getAddressString(String string) {
        Vector vector = null;
        String string2 = "";
        Enumeration enumeration = null;
        if (string == null) {
            return "";
        }
        vector = MailEditWindow.getAddressVector(string);
        if (vector.size() == 0) {
            return "";
        }
        enumeration = vector.elements();
        string2 = (String)enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            string2 = string2 + "," + enumeration.nextElement();
        }
        return string2;
    }

    private static String encodeBase64(String string) {
        if (string != null) {
            byte[] byArray = string.getBytes();
            return MailEditWindow.byteArrayToBase64(byArray);
        }
        return null;
    }

    private static String byteArrayToBase64(byte[] byArray) {
        int n;
        int n2;
        int n3 = byArray.length;
        int n4 = n3 / 3;
        int n5 = n3 - 3 * n4;
        int n6 = 4 * ((n3 + 2) / 3);
        StringBuffer stringBuffer = new StringBuffer(n6);
        char[] cArray = intToBase64;
        int n7 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n = byArray[n7++] & 0xFF;
            int n8 = byArray[n7++] & 0xFF;
            int n9 = byArray[n7++] & 0xFF;
            stringBuffer.append(cArray[n >> 2]);
            stringBuffer.append(cArray[n << 4 & 0x3F | n8 >> 4]);
            stringBuffer.append(cArray[n8 << 2 & 0x3F | n9 >> 6]);
            stringBuffer.append(cArray[n9 & 0x3F]);
        }
        if (n5 != 0) {
            n2 = byArray[n7++] & 0xFF;
            stringBuffer.append(cArray[n2 >> 2]);
            if (n5 == 1) {
                stringBuffer.append(cArray[n2 << 4 & 0x3F]);
                stringBuffer.append("==");
            } else {
                n = byArray[n7++] & 0xFF;
                stringBuffer.append(cArray[n2 << 4 & 0x3F | n >> 4]);
                stringBuffer.append(cArray[n << 2 & 0x3F]);
                stringBuffer.append('=');
            }
        }
        return stringBuffer.toString();
    }
}

