/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PhoneGroupEntry;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class PhoneGroupEntryWindow
extends AbstractWindow {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private JTextField groupNameField;
    private PhoneGroupEntry entry;
    private static final File phoneGroupDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "group");

    PhoneGroupEntryWindow(MainWindow mainWindow, PhoneGroupEntry phoneGroupEntry) {
        super(mainWindow, Resource.getString("PHONEGROUP_ENTRY_WINDOW_TITLE"));
        this.entry = phoneGroupEntry;
        this.addWindowListener();
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("PHONEGROUP_GROUP_NAME"));
        this.groupNameField = new JTextField(16);
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jButton.setActionCommand("set");
        jButton2.setActionCommand("cancel");
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel.add(jLabel);
        jPanel.add(this.groupNameField);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel2);
        container.add("Center", jPanel3);
        container.add("South", jPanel4);
        this.setResizable(true);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set() {
        if (this.groupNameField.getText().length() > 0) {
            this.entry.setGroupName(this.groupNameField.getText());
            String string = phoneGroupDir + File.separator + this.entry.getNo() + "_" + this.entry.getGroupName() + ".grp";
            try {
                this.entry.save(string);
            }
            catch (IOException iOException) {
                this.parent.showDialog(Resource.format("WRITE_ERR", string), this, 2);
            }
            finally {
                this.setVisible(false);
                this.dispose();
            }
        } else {
            this.parent.showDialog(Resource.format("INPUT_EMPTY_ERR", Resource.getString("PHONEGROUP_GROUP_NAME")), this, 2);
        }
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }
}

