/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerList;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class ProjectExplorerListAction
implements ActionListener {
    private ProjectExplorerList list = null;
    static final int TYPE_OPEN = 0;
    static final String STR_OPEN = Resource.getString("EXPLORER_FILE_OPEN");
    static String ACTCMD_OPEN = "Open";
    static final int TYPE_EDIT = 1;
    static final String STR_EDIT = Resource.getString("EXPLORER_FILE_EDIT_OPEN");
    static String ACTCMD_EDIT = "Edit";
    static final int TYPE_RENAME = 2;
    static final String STR_RENAME = Resource.getString("EXPLORER_FILE_RENAME");
    static final String ACTCMD_RENAME = "Rename";
    static final int TYPE_DELETE = 3;
    static final String STR_DELETE = Resource.getString("EXPLORER_FILE_DELETE");
    static final String ACTCMD_DELETE = "Delete";
    static final int TYPE_ADFSET = 4;
    static final String STR_ADFSET = Resource.getString("ATTR_WINDOW_TITLE");
    static final String ACTCMD_ADF = "ADFSet";
    static final int TYPE_SPSET = 5;
    static final String STR_SPSET = Resource.getString("SP_WINDOW_TITLE");
    static final String ACTCMD_SPSET = "SPSet";
    static final int TYPE_PROPSET = 6;
    static final String STR_PROPSET = Resource.getString("EXPLORER_PROJECT_SETTING");
    static final String ACTCMD_PROPSET = "PROPSet";
    static final int TYPE_FCSET = 7;
    static final String STR_FCSET = Resource.getString("FC_WINDOW_TITLE");
    static final String ACTCMD_FCSET = "FCSet";
    static final int TYPE_SDFSET = 8;
    static final String STR_SDFSET = Resource.getString("SDF_WINDOW_TITLE");
    static final String ACTCMD_SDFSET = "SDFSet";
    static final int TYPE_IAPPLIB = 9;
    static final String STR_IAPPLIB = Resource.getString("EXPLORER_IAPPLI_LIBRARY");
    static final String ACTCMD_IAPPLIB = "IAPPLibSet";
    private static final byte[] JNICMD_OPEN = new byte[]{111, 112, 101, 110, 0};
    private static final byte[] JNICMD_EDIT = new byte[]{101, 100, 105, 116, 0};
    private static final int OPE_TYPE_COPY = 2;
    private static final int OPE_TYPE_DELETE = 3;
    private static final int OPE_TYPE_RENAME = 4;
    private static final int OPE_NO_DIALOG = 16;

    ProjectExplorerListAction(ProjectExplorerList projectExplorerList) {
        this.list = projectExplorerList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTCMD_OPEN)) {
            this.list.openSelectedFile();
        } else if (string.equals(ACTCMD_EDIT)) {
            this.list.openEditorSelectedFile();
        } else if (string.equals(ACTCMD_RENAME)) {
            this.list.renameSelectedFile();
        } else if (string.equals(ACTCMD_DELETE)) {
            this.list.deleteSelectedFile();
        } else if (string.equals(ACTCMD_ADF)) {
            this.list.getMainWindow().attr();
        } else if (string.equals(ACTCMD_SPSET)) {
            this.list.getMainWindow().sp();
        } else if (string.equals(ACTCMD_PROPSET)) {
            this.list.getMainWindow().limit();
        } else if (string.equals(ACTCMD_FCSET)) {
            this.list.getMainWindow().faver();
        } else if (string.equals(ACTCMD_SDFSET)) {
            this.list.getMainWindow().sdf();
        } else if (string.equals(ACTCMD_IAPPLIB)) {
            this.list.getMainWindow().selectComponent();
        }
    }

    int actOpenFile(String string) {
        string = string + '\u0000';
        byte[] byArray = string.getBytes();
        return JAMManager.openFile(byArray, JNICMD_OPEN);
    }

    int actEditFile(String string) {
        string = string + '\u0000';
        byte[] byArray = string.getBytes();
        return JAMManager.openFile(byArray, JNICMD_EDIT);
    }

    public int actDeleteFiles(String[] stringArray) {
        byte[] byArray = this.createArgsLine(stringArray);
        return JAMManager.fileOperation(19, byArray, null);
    }

    public int actCopyFiles(String[] stringArray, String string) {
        byte[] byArray = this.createArgsLine(stringArray);
        string = string + '\u0000';
        byte[] byArray2 = string.getBytes();
        return JAMManager.fileOperation(2, byArray, byArray2);
    }

    public int actRenameFile(String string, String string2) {
        string = string + '\u0000';
        byte[] byArray = string.getBytes();
        string2 = string2 + "\u0000\u0000";
        byte[] byArray2 = string2.getBytes();
        return JAMManager.fileOperation(4, byArray, byArray2);
    }

    private byte[] createArgsLine(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append('\u0000');
        }
        stringBuffer.append("\u0000");
        return stringBuffer.toString().getBytes();
    }
}

