/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerList;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerTree;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Component;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

class ProjectExplorerMain
extends JSplitPane {
    private MainWindow parent;
    private ProjectExplorerTree dirTree;
    private ProjectExplorerList fileList;
    private File root;

    ProjectExplorerMain(MainWindow mainWindow) {
        super(1);
        this.parent = mainWindow;
        this.dirTree = new ProjectExplorerTree(this);
        this.fileList = new ProjectExplorerList(this);
        this.createPane();
    }

    private void createPane() {
        JScrollPane jScrollPane = new JScrollPane(this.dirTree);
        JScrollPane jScrollPane2 = new JScrollPane(this.fileList);
        this.setTopComponent(jScrollPane);
        this.setBottomComponent(jScrollPane2);
    }

    void updateTree(String string) {
        File file;
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.dirTree.getModel();
        if (MainWindow.IS_OVER_JRE14) {
            defaultTreeModel.setRoot(null);
        }
        this.updateList("");
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        this.root = file = new File(this.parent.getProjectHome() + File.separator + string);
        if (file.exists()) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            this.dirTree.createNodes(defaultMutableTreeNode, file);
            defaultTreeModel.setRoot(defaultMutableTreeNode);
        }
        this.dirTree.setSelectionRow(0);
    }

    String getProjectHome() {
        return this.parent.getProjectHome();
    }

    File getProjectRoot() {
        return this.root;
    }

    void updateList(String string) {
        this.fileList.update(string);
    }

    MainWindow getMainWindow() {
        return this.parent;
    }

    void showDialog(Component component, String string) {
        JOptionPane jOptionPane = new JOptionPane(string, 2);
        if (component == null) {
            component = this;
        }
        JDialog jDialog = jOptionPane.createDialog(component, Resource.getString("WNG"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
    }

    int showQuestionDialog(Component component, String string) {
        Object[] objectArray = new Object[]{Resource.getString("OK"), Resource.getString("CANCEL")};
        JOptionPane jOptionPane = new JOptionPane(string, 3, 2, null, objectArray);
        if (component == null) {
            component = this;
        }
        JDialog jDialog = jOptionPane.createDialog(component, Resource.getString("CONFIRM"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null) {
            if (object.toString().equals(objectArray[0].toString())) {
                return 0;
            }
            return 2;
        }
        return 2;
    }
}

