/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ExtPopup;
import com.nttdocomo.dojaemu.ktoolbar.PopupManager;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerMain;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerTreeAction;
import com.nttdocomo.dojaemu.ktoolbar.ProjectTreeMouseAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

class ProjectExplorerTree
extends JTree
implements TreeSelectionListener {
    private PopupManager popupManager = null;
    private ProjectExplorerMain parent;
    private String currentDir = "";
    private static final String HASHKEY_OPEN = "OPEN";
    private static final String HASHKEY_RELOAD = "RELOAD";
    ProjectExplorerTreeAction treeAction = null;
    private boolean isThroughValueChange = false;

    ProjectExplorerTree(ProjectExplorerMain projectExplorerMain) {
        this.parent = projectExplorerMain;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode, true);
        this.setModel(defaultTreeModel);
        this.addTreeSelectionListener(this);
        this.getSelectionModel().setSelectionMode(1);
        ProjectTreeMouseAdapter projectTreeMouseAdapter = new ProjectTreeMouseAdapter(this);
        this.addMouseListener(projectTreeMouseAdapter);
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        this.treeAction = new ProjectExplorerTreeAction(this);
        this.popupManager = new PopupManager();
        ExtPopup extPopup = new ExtPopup();
        extPopup.add(ProjectExplorerTreeAction.STR_OPEN, "Open", this.treeAction);
        this.popupManager.setMenu(HASHKEY_OPEN, extPopup);
        ExtPopup extPopup2 = new ExtPopup();
        extPopup2.add(ProjectExplorerTreeAction.STR_OPEN, "Open", this.treeAction);
        extPopup2.addSeparator();
        extPopup2.add(ProjectExplorerTreeAction.STR_RELOAD, "Reload", this.treeAction);
        this.popupManager.setMenu(HASHKEY_RELOAD, extPopup2);
    }

    void createNodes(DefaultMutableTreeNode defaultMutableTreeNode, File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileArray[i].getName());
                this.createNodes(defaultMutableTreeNode2, fileArray[i]);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = treeSelectionEvent.getPath().getPath();
        if (objectArray != null && objectArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i].toString());
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(File.separator);
            }
            String string = this.parent.getProjectHome() + File.separator + stringBuffer.toString();
            this.parent.updateList(string);
            this.currentDir = string;
            this.isThroughValueChange = true;
            int n = this.getSelectionRow();
            if (n != -1) {
                this.scrollRowToVisible(n);
            }
        }
    }

    private String getSelectedPath() {
        return this.currentDir;
    }

    void updateCurrentList() {
        if (!this.isThroughValueChange) {
            this.parent.updateList(this.getSelectedPath());
        }
        this.isThroughValueChange = false;
    }

    void reloadProjectTree() {
        String string = this.getModel().getRoot().toString();
        this.parent.updateTree(string);
    }

    void openSelectedDir() {
        String string = this.getSelectedPath();
        if (string.length() == 0) {
            return;
        }
        if (!new File(string).exists()) {
            return;
        }
        this.treeAction.actOpenFolder(string);
    }

    public void showPopupMenu(MouseEvent mouseEvent, boolean bl) {
        if (bl) {
            String string;
            JPopupMenu jPopupMenu = null;
            String string2 = new File(this.getSelectedPath()).getName();
            jPopupMenu = string2.equals(string = this.parent.getProjectRoot().getName()) ? this.popupManager.getMenu(HASHKEY_RELOAD) : this.popupManager.getMenu(HASHKEY_OPEN);
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c != '\uffff') {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
    }

    private int getSelectionRow() {
        int[] nArray = this.getSelectionRows();
        if (nArray == null || nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }
}

