/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerList;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.List;

class ProjectListDropTarget
extends DropTarget {
    ProjectExplorerList list;

    ProjectListDropTarget(ProjectExplorerList projectExplorerList) {
        this.list = projectExplorerList;
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        int n = 0;
        if (!this.list.isEnabled()) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        if (this.list.isShowingRenameBox()) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dropTargetDropEvent.acceptDrop(1);
            List list = null;
            try {
                list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
            n = this.list.appendFile(list);
            if (n == 0) {
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }
}

