/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerList;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.SwingUtilities;

class ProjectListMouseAdapter
extends MouseAdapter
implements MouseMotionListener {
    private ProjectExplorerList list;
    private boolean withinMouseCursor = false;

    ProjectListMouseAdapter(ProjectExplorerList projectExplorerList) {
        this.list = projectExplorerList;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.list.requestFocus();
        this.withinMouseCursor = true;
        int n = this.getPointerIndex(mouseEvent.getPoint());
        if (n == -1) {
            this.list.clearSelection();
            return;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            Object[] objectArray = this.list.getSelectedValues();
            if (objectArray.length >= 1) {
                if (!this.list.isSelectedIndex(n)) {
                    this.list.setSelectedIndex(n);
                }
            } else if (objectArray.length == 0) {
                this.list.setSelectedIndex(n);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.getPointerIndex(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
            Object[] objectArray = this.list.getSelectedValues();
            if (objectArray.length != 1) {
                return;
            }
            File file = (File)objectArray[0];
            this.list.defaultAction(file.getAbsolutePath());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Object[] objectArray = this.list.getSelectedValues();
            if (objectArray.length == 0) {
                return;
            }
            Component component = mouseEvent.getComponent();
            if (!component.isShowing()) {
                return;
            }
            if (!this.withinMouseCursor) {
                return;
            }
            if (objectArray.length == 1) {
                File file = (File)objectArray[0];
                this.list.showPopupMenu(mouseEvent, file.getAbsolutePath());
            } else {
                int n = this.getPointerIndex(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                if (this.list.isSelectedIndex(n)) {
                    this.list.showPluralPopupMenu(mouseEvent);
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this.getPointerIndex(mouseEvent.getPoint());
        if (n == -1) {
            this.list.clearSelection();
            return;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.withinMouseCursor = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.withinMouseCursor = true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private int getPointerIndex(Point point) {
        int n = this.list.locationToIndex(point);
        if (n == -1) {
            return -1;
        }
        int n2 = this.list.getLastVisibleIndex();
        if (n2 == -1) {
            if (this.list.getFirstVisibleIndex() == -1) {
                return -1;
            }
            n2 = this.list.getModel().getSize() - 1;
        }
        if (n == n2 && !this.list.getCellBounds(n2, n2).contains(point)) {
            return -1;
        }
        return n;
    }
}

