/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerTree;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

class ProjectTreeMouseAdapter
extends MouseAdapter
implements MouseMotionListener {
    private ProjectExplorerTree tree;
    private boolean withinMouseCursor = false;

    ProjectTreeMouseAdapter(ProjectExplorerTree projectExplorerTree) {
        this.tree = projectExplorerTree;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.tree.getRowForLocation(point.x, point.y);
        if (n == -1) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.tree.setSelectionRow(n);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.tree.getRowForLocation(point.x, point.y);
        if (n == -1) {
            return;
        }
        this.tree.updateCurrentList();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Component component = mouseEvent.getComponent();
            if (!component.isShowing()) {
                return;
            }
            if (!this.withinMouseCursor) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = this.tree.getRowForLocation(point.x, point.y);
            if (n != -1) {
                this.tree.showPopupMenu(mouseEvent, true);
            } else {
                this.tree.showPopupMenu(mouseEvent, false);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.withinMouseCursor = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.withinMouseCursor = true;
    }
}

