/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

class ReadWindowClassTag {
    private String sourceFile = "";
    private String targetClass = "";
    private String extendClass = "";
    private String tagName = "";
    private DefineClassInfo defClassInfo;
    private ClassTag classTag;
    private FileReader fr = null;
    private StreamTokenizer tokenizer = null;
    private boolean isIMAppli = false;
    private static final String JAVA_EXTENSION = ".java";
    private static final String STR_CLASS = "class";
    private static final String STR_EXTENDS = "extends";
    private static final String IAPPLICATION = "IApplication";
    private static final String MAPPLICATION = "MApplication";
    private static final String STR_COMMA = ", ";
    private static final char SLASH = '/';
    private static final char STAR = '*';
    private static final char AT = '@';
    private static final char SEMICOLON = ';';
    private static final char BRACE = '{';
    private static final char SPACE = ' ';
    private static final char TABSPACE = '\t';
    private static final String ENCODING = "Shift_JIS";
    private static final int EOF = -1;
    private static final int EOL = 10;
    private static final int WORD = -3;
    private static final int TAG_OK = 0;
    private static final int TAG_ERR = -1;
    private static final int TAG_NONE = -2;
    private static final int TAG_NO_DEFINE = -3;
    private static final int NO_RELATION = 0;
    private static final int DOC_START = 1;
    private static final int DOC_END = 2;

    public ReadWindowClassTag(String string) {
        this.sourceFile = string;
        this.extendClass = IAPPLICATION;
        this.isIMAppli = true;
    }

    public ReadWindowClassTag(String string, String string2) {
        this.sourceFile = string;
        this.extendClass = string2;
        this.isIMAppli = false;
    }

    void set(String string) throws FileNotFoundException, ClassNotFoundException, IOException {
        File file = new File(this.sourceFile);
        if (!file.exists()) {
            throw new FileNotFoundException("Source file not found");
        }
        this.tagName = string;
        String string2 = file.getName();
        int n = string2.toLowerCase().lastIndexOf(JAVA_EXTENSION);
        this.targetClass = string2.substring(0, n);
        this.defClassInfo = new DefineClassInfo();
        this.defClassInfo.setup();
        this.classTag = new ClassTag(this.tagName);
    }

    String getTagText() {
        if (this.classTag.exist()) {
            return this.classTag.text();
        }
        return null;
    }

    String getTagText(int n) {
        String string = "";
        if (!this.classTag.exist()) {
            return null;
        }
        string = this.classTag.text();
        if (n >= string.length()) {
            return string;
        }
        if (n == 0) {
            return "";
        }
        String string2 = string.substring(0, n);
        String string3 = "";
        try {
            byte[] byArray = string2.getBytes(ENCODING);
            char[] cArray = string2.toCharArray();
            int n2 = byArray.length - cArray.length;
            if (n2 <= 0) {
                return string2;
            }
            int n3 = 0;
            for (int i = string2.length() - 1; i > 0; --i) {
                String string4 = String.valueOf(string2.charAt(i));
                byte[] byArray2 = string4.getBytes(ENCODING);
                if ((n3 += byArray2.length) < n2) continue;
                string3 = string2.substring(0, i);
                break;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = string2;
        }
        return string3;
    }

    private String concatArray(Object[] objectArray, String string) {
        if (objectArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = objectArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(objectArray[i]);
            if (string.length() <= 0 || i >= n) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String trimSpace(String string) {
        String string2 = "";
        if (string.length() != 0) {
            string2 = string.trim();
        }
        return string2;
    }

    private void open() throws FileNotFoundException {
        this.fr = new FileReader(this.sourceFile);
        this.tokenizer = new StreamTokenizer(new BufferedReader(this.fr));
    }

    private void close() {
        try {
            this.fr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fr = null;
        this.tokenizer = null;
    }

    private void initTokenizer() {
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(33, 47);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(58, 64);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(91, 96);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(123, 126);
        this.whiteSpace();
        this.setComment(true);
        this.tokenizer.eolIsSignificant(true);
    }

    private void whiteSpace() {
        this.setWhiteSpace();
        this.tokenizer.whitespaceChars(10, 10);
        this.tokenizer.whitespaceChars(13, 13);
    }

    private void setWhiteSpace() {
        this.tokenizer.whitespaceChars(32, 32);
        this.tokenizer.whitespaceChars(9, 9);
    }

    private void unSetWhiteSpace() {
        this.tokenizer.ordinaryChar(32);
        this.tokenizer.ordinaryChar(9);
    }

    private void setComment(boolean bl) {
        if (bl) {
            this.tokenizer.ordinaryChar(47);
            this.tokenizer.ordinaryChar(42);
        } else {
            this.tokenizer.wordChars(47, 47);
            this.tokenizer.wordChars(42, 42);
        }
        this.tokenizer.slashStarComments(bl);
        this.tokenizer.slashSlashComments(bl);
    }

    private class ClassTag {
        private String tag = "";
        private String tagText = "";
        private int tagline = 0;
        private String[] classDefArrays = null;
        private boolean inDocComment = false;
        private boolean inTagText = false;
        private boolean tagExist = false;

        ClassTag(String string) {
            this.tag = string;
            int n = this.readTag();
            this.tagExist = n >= 0;
        }

        String text() {
            return this.tagText;
        }

        int position() {
            return this.tagline;
        }

        boolean exist() {
            return this.tagExist;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int readTag() {
            this.classDefArrays = ReadWindowClassTag.this.defClassInfo.getClassDefine();
            if (this.classDefArrays == null) {
                return -3;
            }
            try {
                ReadWindowClassTag.this.open();
                ReadWindowClassTag.this.initTokenizer();
                ReadWindowClassTag.this.setComment(false);
                ReadWindowClassTag.this.tokenizer.ordinaryChar(47);
                ReadWindowClassTag.this.tokenizer.slashSlashComments(true);
                ReadWindowClassTag.this.tokenizer.ordinaryChar(42);
                String string = "";
                Vector<String> vector = new Vector<String>();
                boolean bl = false;
                int n = 0;
                int n2 = ((ReadWindowClassTag)ReadWindowClassTag.this).defClassInfo.classDefLine;
                while ((n = ReadWindowClassTag.this.tokenizer.nextToken()) != -1 && ReadWindowClassTag.this.tokenizer.lineno() <= n2) {
                    if (n == 10) {
                        bl = true;
                        if (!this.inDocComment) continue;
                        ReadWindowClassTag.this.setWhiteSpace();
                        continue;
                    }
                    if (n == -3) {
                        string = ((ReadWindowClassTag)ReadWindowClassTag.this).tokenizer.sval;
                        if (bl) {
                            if (this.inTagText) {
                                vector.add(string);
                            }
                        } else if (this.inDocComment) {
                            if (!this.inTagText) {
                                if (string.equals(this.tag)) {
                                    this.inTagText = true;
                                    this.tagline = ReadWindowClassTag.this.tokenizer.lineno();
                                    ReadWindowClassTag.this.unSetWhiteSpace();
                                    if (!vector.isEmpty()) {
                                        vector.add(ReadWindowClassTag.STR_COMMA);
                                    } else {
                                        vector.add(string);
                                    }
                                    this.exceptSpaceNextToken();
                                }
                            } else {
                                vector.add(string);
                            }
                        }
                        bl = false;
                        continue;
                    }
                    if (!this.inDocComment) {
                        if (bl && this.isDocCommentStart((char)n)) {
                            this.inDocComment = true;
                            ReadWindowClassTag.this.tokenizer.slashSlashComments(false);
                        }
                    } else {
                        if (this.isDocCommentEnd((char)n)) {
                            this.inDocComment = false;
                            this.inTagText = false;
                            if (this.isCommentRelation()) break;
                            vector.clear();
                            ReadWindowClassTag.this.tokenizer.slashSlashComments(true);
                        }
                        if (this.inDocComment && this.inTagText) {
                            if (bl) {
                                if (this.isTagEnd((char)n)) {
                                    this.inTagText = false;
                                }
                                ReadWindowClassTag.this.unSetWhiteSpace();
                            } else {
                                vector.add(String.valueOf((char)n));
                            }
                        }
                    }
                    bl = false;
                }
                if (!vector.isEmpty()) {
                    vector.remove(0);
                    this.tagText = ReadWindowClassTag.this.trimSpace(ReadWindowClassTag.this.concatArray(vector.toArray(), ""));
                    int n3 = 0;
                    return n3;
                }
                int n4 = -2;
                return n4;
            }
            catch (Exception exception) {
                int n = -1;
                return n;
            }
            finally {
                ReadWindowClassTag.this.close();
            }
        }

        private boolean isDocCommentStart(char c) throws IOException {
            if (c == '/') {
                c = (char)ReadWindowClassTag.this.tokenizer.nextToken();
                if (c == '*') {
                    c = (char)ReadWindowClassTag.this.tokenizer.nextToken();
                    if (c == '*') {
                        return true;
                    }
                    ReadWindowClassTag.this.tokenizer.pushBack();
                } else {
                    ReadWindowClassTag.this.tokenizer.pushBack();
                }
            }
            return false;
        }

        private boolean isDocCommentEnd(char c) throws IOException {
            if (c == '*') {
                c = (char)ReadWindowClassTag.this.tokenizer.nextToken();
                if (c == '/') {
                    return true;
                }
                ReadWindowClassTag.this.tokenizer.pushBack();
            }
            return false;
        }

        private boolean isTagEnd(char c) throws IOException {
            if (c == '*') {
                String string;
                ReadWindowClassTag.this.setWhiteSpace();
                int n = ReadWindowClassTag.this.tokenizer.nextToken();
                if (n == -3 && (string = ((ReadWindowClassTag)ReadWindowClassTag.this).tokenizer.sval).charAt(0) == '@') {
                    if (!string.equals(ReadWindowClassTag.this.tagName)) {
                        return true;
                    }
                    ReadWindowClassTag.this.tokenizer.pushBack();
                    return true;
                }
                ReadWindowClassTag.this.tokenizer.pushBack();
            }
            return false;
        }

        private boolean isCommentRelation() throws IOException {
            boolean bl = true;
            String string = "";
            ReadWindowClassTag.this.whiteSpace();
            ReadWindowClassTag.this.tokenizer.ordinaryChar(123);
            ReadWindowClassTag.this.tokenizer.slashSlashComments(false);
            for (int i = 0; i < this.classDefArrays.length; ++i) {
                int n = ReadWindowClassTag.this.tokenizer.nextToken();
                if (n == -3) {
                    if (((ReadWindowClassTag)ReadWindowClassTag.this).tokenizer.sval.equals(this.classDefArrays[i])) continue;
                    bl = false;
                    break;
                }
                if (n == 10) {
                    --i;
                    continue;
                }
                bl = false;
                break;
            }
            ReadWindowClassTag.this.tokenizer.slashSlashComments(true);
            ReadWindowClassTag.this.tokenizer.wordChars(123, 123);
            if (bl) {
                return true;
            }
            ReadWindowClassTag.this.tokenizer.pushBack();
            return false;
        }

        private int exceptSpaceNextToken() throws IOException {
            int n;
            ReadWindowClassTag.this.unSetWhiteSpace();
            while ((n = ReadWindowClassTag.this.tokenizer.nextToken()) != -1) {
                if (n == 32 || n == 9) continue;
                ReadWindowClassTag.this.tokenizer.pushBack();
                return 0;
            }
            ReadWindowClassTag.this.tokenizer.pushBack();
            return 0;
        }
    }

    class DefineClassInfo {
        int classDefLine = 0;
        private boolean isRead = false;
        private String[] classDefineArrays = null;

        DefineClassInfo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void setup() throws ClassNotFoundException, IOException {
            int n = 0;
            int n2 = 0;
            try {
                try {
                    String string;
                    ReadWindowClassTag.this.open();
                    ReadWindowClassTag.this.initTokenizer();
                    do {
                        if ((n = ReadWindowClassTag.this.tokenizer.nextToken()) == -1) throw new ClassNotFoundException();
                    } while (n != -3 || !this.isDefWord(string = ((ReadWindowClassTag)ReadWindowClassTag.this).tokenizer.sval) || (n2 = this.moreNextReadDefClass(string)) != 0);
                    Object var5_7 = null;
                    this.classDefLine = ReadWindowClassTag.this.tokenizer.lineno();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.isRead = false;
                    throw classNotFoundException;
                }
                catch (IOException iOException) {
                    this.isRead = false;
                    throw iOException;
                }
                catch (Exception exception) {
                    this.isRead = false;
                    Object var5_8 = null;
                    this.classDefLine = ReadWindowClassTag.this.tokenizer.lineno();
                    ReadWindowClassTag.this.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.classDefLine = ReadWindowClassTag.this.tokenizer.lineno();
                ReadWindowClassTag.this.close();
                throw throwable;
            }
            ReadWindowClassTag.this.close();
        }

        private int moreNextReadDefClass(String string) throws IOException {
            block8: {
                int n = 0;
                Vector<String> vector = new Vector<String>();
                vector.add(string);
                ReadWindowClassTag.this.tokenizer.ordinaryChar(59);
                ReadWindowClassTag.this.tokenizer.ordinaryChar(123);
                while ((n = ReadWindowClassTag.this.tokenizer.nextToken()) != -1) {
                    if (n == -3) {
                        String string2 = ((ReadWindowClassTag)ReadWindowClassTag.this).tokenizer.sval;
                        vector.add(string2);
                        continue;
                    }
                    char c = (char)n;
                    if (c == ';') {
                        this.isRead = false;
                        break;
                    }
                    if (c != '{') continue;
                    this.isRead = true;
                    break;
                }
                this.setClassDefine(vector);
                if (!this.isRead) break block8;
                int n2 = 0;
                Object var6_9 = null;
                ReadWindowClassTag.this.tokenizer.wordChars(59, 59);
                ReadWindowClassTag.this.tokenizer.wordChars(123, 123);
                return n2;
            }
            try {
                int n = 1;
                Object var6_10 = null;
                ReadWindowClassTag.this.tokenizer.wordChars(59, 59);
                ReadWindowClassTag.this.tokenizer.wordChars(123, 123);
                return n;
            }
            catch (IOException iOException) {
                try {
                    this.isRead = false;
                    throw iOException;
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    ReadWindowClassTag.this.tokenizer.wordChars(59, 59);
                    ReadWindowClassTag.this.tokenizer.wordChars(123, 123);
                    throw throwable;
                }
            }
        }

        private boolean isDefWord(String string) {
            String[] stringArray = new String[]{"public", ReadWindowClassTag.STR_CLASS, "private", "protected", "static", "final", "abstract"};
            if (string == null) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return true;
            }
            return false;
        }

        private void setClassDefine(Vector vector) {
            if (!this.isRead) {
                this.resetDefine();
                return;
            }
            int n = vector.size();
            if (n < 2) {
                this.resetDefine();
                return;
            }
            int n2 = vector.indexOf(ReadWindowClassTag.this.targetClass);
            if (n2 == -1) {
                this.resetDefine();
                return;
            }
            this.classDefineArrays = vector.toArray(new String[0]);
            int n3 = vector.indexOf(ReadWindowClassTag.STR_CLASS);
            if (n3 == -1) {
                this.resetDefine();
                return;
            }
            int n4 = n3;
            if (ReadWindowClassTag.this.extendClass.length() != 0) {
                String[] stringArray = new String[]{ReadWindowClassTag.STR_CLASS, ReadWindowClassTag.this.targetClass, ReadWindowClassTag.STR_EXTENDS, ReadWindowClassTag.this.extendClass};
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.classDefineArrays[n4 + i].equals(stringArray[i])) continue;
                    if (i == stringArray.length - 1 && ReadWindowClassTag.this.isIMAppli) {
                        if (this.classDefineArrays[n4 + i].equals(ReadWindowClassTag.MAPPLICATION)) continue;
                        this.resetDefine();
                        return;
                    }
                    this.resetDefine();
                    return;
                }
            } else {
                String[] stringArray = new String[]{ReadWindowClassTag.STR_CLASS, ReadWindowClassTag.this.targetClass};
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.classDefineArrays[n4 + i].equals(stringArray[i])) continue;
                    this.resetDefine();
                    return;
                }
            }
            this.isRead = true;
        }

        private void resetDefine() {
            this.classDefineArrays = null;
            this.isRead = false;
        }

        String[] getClassDefine() {
            return this.classDefineArrays;
        }
    }
}

