/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class SDF {
    private Properties properties = new Properties();
    private Properties disp_properties = new Properties();

    public SDF() {
        SDF.initSDF();
    }

    public SDF(File file) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new FileNotFoundException();
        }
        Properties properties = new Properties();
        SDF.readSDF(file.getPath().getBytes());
        properties.setProperty("AllowedHost", new String(SDF.getURL(0)));
        properties.setProperty("AppDownLoadURL", new String(SDF.getURL(1)));
        properties.setProperty("GetPrivateInfo", new String(SDF.getDispItem(0)));
        properties.setProperty("UseMailer", new String(SDF.getDispItem(1)));
        properties.setProperty("MessageApp", new String(SDF.getDispItem(2)));
        properties.setProperty("SetPhoneTheme", new String(SDF.getDispItem(3)));
        properties.setProperty("SetLaunchTime", new String(SDF.getDispItem(4)));
        properties.setProperty("GetLocationInfo", new String(SDF.getDispItem(5)));
        properties.setProperty("UseBluetooth", new String(SDF.getDispItem(6)));
        properties.setProperty("LaunchByDTV", new String(SDF.getDispItem(7)));
        properties.setProperty("UseFeliCaOnline", new String(SDF.getDispItem(8)));
        properties.setProperty("UseFeliCaOffline", new String(SDF.getDispItem(9)));
        properties.setProperty("UseFeliCaRW", new String(SDF.getDispItem(10)));
        properties.setProperty("UseOpenGL", new String(SDF.getDispItem(11)));
        if (properties != null) {
            this.disp_properties = properties;
        }
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public String getProperty(String string) {
        return (String)this.properties.get(string);
    }

    public void setDispProperty(String string, String string2) {
        this.disp_properties.put(string, string2);
    }

    public String getDispProperty(String string) {
        return (String)this.disp_properties.get(string);
    }

    public void save(String string) {
        SDF.writeSDF(string.getBytes());
    }

    public void parseSDF(ADF aDF) {
        this.parseSDF(this.disp_properties, aDF);
    }

    public void parseSDF(Properties properties, ADF aDF) {
        String[] stringArray = new String[]{"GetPrivateInfo", "UseMailer", "MessageApp", "SetPhoneTheme", "SetLaunchTime", "GetLocationInfo", "UseBluetooth", "LaunchByDTV", "UseFeliCaOnline", "UseFeliCaOffline", "UseFeliCaRW", "UseOpenGL", "AllowedHost", "AppDownLoadURL"};
        boolean bl = false;
        for (int i = 0; i < 14; ++i) {
            String string = properties.getProperty(stringArray[i]);
            if (string != null) {
                this.properties.setProperty(stringArray[i], string);
                bl = true;
                continue;
            }
            this.properties.remove(stringArray[i]);
        }
        if (properties.getProperty("Lmd") != null) {
            this.properties.setProperty("Lmd", properties.getProperty("Lmd"));
        }
        if (bl) {
            try {
                this.properties.setProperty("PackageURL", aDF.getProperty("PackageURL"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static native void initSDF();

    private static native void readSDF(byte[] var0);

    private static native void writeSDF(byte[] var0);

    public static native byte[] getLmd();

    public static native byte[] getURL(int var0);

    public static native byte[] getDispItem(int var0);

    public static native void setLmd(byte[] var0);

    public static native void setURL(int var0, byte[] var1);

    public static native void setDispItem(int var0, boolean var1);
}

