/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import java.util.Calendar;

class ScheduleDate {
    public static final int ONETIME = 1;
    public static final int DAILY = 2;
    public static final int WEEKLY = 4;
    public static final int MONTHLY = 8;
    public static final int YEARLY = 16;
    private int type;
    private Calendar cal = Calendar.getInstance();
    private int year = 0;
    private int month = 0;
    private int week = 0;
    private int day = 0;
    private int hour = 0;
    private int minute = 0;

    public ScheduleDate(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 16: {
                this.type = n;
                break;
            }
            case 8: {
                this.type = n;
                this.cal.set(2, 7);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid date type");
            }
        }
        this.year = this.cal.get(1);
        this.month = this.cal.get(2);
        this.week = this.cal.get(7);
        this.day = this.cal.get(5);
        this.hour = this.cal.get(11);
        this.minute = this.cal.get(12);
    }

    public int getType() {
        return this.type;
    }

    public int get(int n) {
        int n2 = 0;
        switch (this.type) {
            case 1: {
                if (n == 1 || n == 2 || n == 5 || n == 11 || n == 12) {
                    n2 = this.cal.get(n);
                    break;
                }
                throw new IllegalArgumentException("Invalid datetime field");
            }
            case 2: {
                if (n == 11 || n == 12) {
                    n2 = this.cal.get(n);
                    break;
                }
                throw new IllegalArgumentException();
            }
            case 4: {
                if (n == 7 || n == 11 || n == 12) {
                    n2 = this.cal.get(n);
                    break;
                }
                throw new IllegalArgumentException("Invalid datetime field");
            }
            case 8: {
                if (n == 5 || n == 11 || n == 12) {
                    n2 = this.cal.get(n);
                    break;
                }
                throw new IllegalArgumentException("Invalid datetime field");
            }
            case 16: {
                if (n == 2 || n == 5 || n == 11 || n == 12) {
                    n2 = this.cal.get(n);
                    break;
                }
                throw new IllegalArgumentException("Invalid datetime field");
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n2;
    }

    public void set(int n, int n2) {
        switch (this.type) {
            case 1: {
                if (n == 1 || n == 2 || n == 5 || n == 11 || n == 12) {
                    this.setField(n, n2);
                    break;
                }
                throw new IllegalArgumentException("Invalid datetime field");
            }
            case 2: {
                if (n == 11 || n == 12) {
                    this.setField(n, n2);
                    break;
                }
                throw new IllegalArgumentException("Invalid datetime field");
            }
            case 4: {
                if (n == 7 || n == 11 || n == 12) {
                    this.setField(n, n2);
                    break;
                }
                throw new IllegalArgumentException("Invalid datetime field");
            }
            case 8: {
                if (n == 5 || n == 11 || n == 12) {
                    if (n == 5) {
                        int n3 = n2 % 31;
                        if (n3 == 0) {
                            n3 = 31;
                        }
                        this.setField(n, n3);
                    } else {
                        this.setField(n, n2);
                    }
                    this.setField(2, 7);
                    break;
                }
                throw new IllegalArgumentException("Invalid datetime field");
            }
            case 16: {
                if (n == 2 || n == 5 || n == 11 || n == 12) {
                    this.setField(n, n2);
                    break;
                }
                throw new IllegalArgumentException("Invalid datetime field");
            }
            default: {
                throw new IllegalArgumentException("Invalid datetime field");
            }
        }
    }

    private void setField(int n, int n2) {
        if (n == 7 && n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5 && n2 != 6 && n2 != 7) {
            throw new IllegalArgumentException("Invalid datetime value");
        }
        try {
            this.cal.set(n, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid datetime value");
        }
        switch (n) {
            case 12: {
                this.minute = this.cal.get(12);
            }
            case 11: {
                this.hour = this.cal.get(11);
            }
            case 5: {
                this.day = this.cal.get(5);
            }
            case 7: {
                this.week = this.cal.get(7);
            }
            case 2: {
                this.month = this.cal.get(2);
            }
            case 1: {
                this.year = this.cal.get(1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid datetime value");
            }
        }
    }
}

