/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SoundDefinition;
import com.nttdocomo.dojaemu.ktoolbar.SoundSetting;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class SoundSettingWindow
extends TabPanel {
    private final int FRAME_WIDTH = 460;
    private final int FRAME_HEIGHT = 550;
    private JScrollPane scrollpane;
    private final int[] CEL_WIDTH = new int[]{1, 4, 5};
    private JTable scwTable;
    private SelectCompTblModel tableModel;
    private ActionDispatcher actionListener;
    private SelectionListener selectionListener;
    ListSelectionModel lsmodel;
    private static final String soundSettingFilePath = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "SoundConf.properties";
    private final String[] columnNames = new String[]{Resource.getString("SOUND_SETTING_ROW_CHANNEL"), Resource.getString("SOUND_SETTING_ROW_SOUND_GROUP"), Resource.getString("SOUND_SETTING_ROW_INSTRUMENT")};
    private final String[] modeNames = new String[]{Resource.getString("SOUND_SETTING_MODE_SOUND"), Resource.getString("SOUND_SETTING_MODE_VISUAL")};
    private Vector compItemVector;
    private JComboBox modeChangeComboBox;
    private JComboBox soundLibComboBox;
    private JComboBox deviceComboBox;
    private JComboBox channelComboBox;
    private JComboBox soundGroupComboBox;
    private JComboBox instrumentComboBox;
    private static SoundDefinition def;
    private static SoundSetting setting;
    private int[][] oldSetting;
    private int oldMode;
    private int curMode;
    private int curSoundLib;
    private int oldSoundLib;
    private Color bc;
    private boolean devEnableFlag = true;
    private int oldDevice;
    private String[][] oldData = new String[16][3];
    static /* synthetic */ Class class$java$lang$Object;

    SoundSettingWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        int n;
        String[] stringArray;
        this.setLayout(new BorderLayout());
        this.actionListener = new ActionDispatcher(this);
        this.selectionListener = new SelectionListener();
        this.bc = this.getBackground();
        if (def == null) {
            JLabel jLabel = new JLabel(Resource.getString("SOUND_SETTING_ERR_OPEN_DEF"));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1));
            jPanel.add(jLabel);
            this.setLayout(new GridLayout(3, 1));
            this.add(new JPanel());
            this.add(jPanel);
            this.add(new JPanel());
            return;
        }
        JLabel jLabel = new JLabel(Resource.getString("SOUND_SETTING_LBL_MODE"));
        JLabel jLabel2 = new JLabel(Resource.getString("SOUND_SETTING_LBL_SOUNDLIB"));
        JLabel jLabel3 = new JLabel(Resource.getString("SOUND_SETTING_LBL_SEL_DEVICE"));
        JLabel jLabel4 = new JLabel(Resource.getString("SOUND_SETTING_LBL_CHANNEL"));
        JLabel jLabel5 = new JLabel(Resource.getString("SOUND_SETTING_LBL_SOUND_GROUP"));
        JLabel jLabel6 = new JLabel(Resource.getString("SOUND_SETTING_LBL_INSTRUMENT"));
        JLabel jLabel7 = new JLabel(Resource.getString("SOUND_SETTING_LBL_CUR_SETTING"));
        this.compItemVector = this.getSubSoundSetting();
        this.modeChangeComboBox = new JComboBox<String>(this.modeNames);
        String[] stringArray2 = def.getSoundDeviceName();
        if (stringArray2 != null) {
            this.oldMode = setting.getPlayMode();
            this.deviceComboBox = new JComboBox();
            for (int i = 0; i < stringArray2.length; ++i) {
                this.deviceComboBox.addItem(this.makeItemObj(stringArray2[i]));
            }
        } else {
            this.oldMode = 1;
            this.modeChangeComboBox.setEnabled(false);
            stringArray2 = new String[]{Resource.getString("SOUND_SETTING_NO_DEVICE")};
            this.deviceComboBox = new JComboBox<String>(stringArray2);
            this.devEnableFlag = false;
            this.deviceComboBox.setEnabled(false);
        }
        this.curMode = this.oldMode;
        this.modeChangeComboBox.setSelectedIndex(this.oldMode);
        String[] stringArray3 = def.getSoundLibName();
        this.oldSoundLib = 0;
        if (stringArray3 != null) {
            stringArray = setting.getLibraryIndex();
            if (stringArray != null && !stringArray.equals("")) {
                this.oldSoundLib = def.getSoundLibIndex((String)stringArray);
                if (this.oldSoundLib < 0) {
                    this.oldSoundLib = 0;
                }
            }
            this.soundLibComboBox = new JComboBox();
            for (n = 0; n < stringArray3.length; ++n) {
                this.soundLibComboBox.addItem(this.makeItemObj(stringArray3[n]));
            }
            this.soundLibComboBox.setSelectedIndex(this.oldSoundLib);
        } else {
            if (this.oldMode == 0) {
                this.curMode = this.oldMode = 1;
            }
            this.modeChangeComboBox.setEnabled(false);
            stringArray3 = new String[]{Resource.getString("SOUND_SETTING_NO_SOUNDLIB")};
            this.soundLibComboBox = new JComboBox<String>(stringArray3);
            this.soundLibComboBox.setEnabled(false);
        }
        this.curSoundLib = this.oldSoundLib;
        stringArray = def.getSoundDeviceGUID();
        this.oldDevice = 0;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equals(setting.getDevice())) continue;
                this.oldDevice = n;
                break;
            }
        }
        this.deviceComboBox.setSelectedIndex(this.oldDevice);
        this.channelComboBox = new JComboBox<String>(this.getComboBoxList(0));
        this.channelComboBox.setSelectedIndex(0);
        this.soundGroupComboBox = new JComboBox<String>(this.getComboBoxList(1));
        int[] nArray = setting.getCurrentSetting(0);
        this.soundGroupComboBox.setSelectedIndex(nArray[0] + 1);
        this.instrumentComboBox = new JComboBox<String>(this.getComboBoxList(2));
        if (nArray[0] == -1) {
            this.instrumentComboBox.setSelectedIndex(0);
        } else if (nArray[0] == 16) {
            this.instrumentComboBox.setSelectedIndex(nArray[1]);
        } else {
            this.instrumentComboBox.setSelectedIndex(nArray[1] % 8);
        }
        this.modeChangeComboBox.setActionCommand("selectMode");
        this.soundLibComboBox.setActionCommand("selectSoundLib");
        this.deviceComboBox.setActionCommand("selectDevice");
        this.channelComboBox.setActionCommand("selectChannel");
        this.soundGroupComboBox.setActionCommand("selectSoundGroup");
        this.instrumentComboBox.setActionCommand("selectInstrument");
        this.enableEvent(true);
        int n2 = this.getPreferredSize().width - 30;
        this.setFitSizeComboBox(n2 -= jLabel2.getPreferredSize().width);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(jLabel);
        jPanel.add(this.modeChangeComboBox);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(jLabel2);
        jPanel2.add(this.soundLibComboBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SOUND_SETTING_BD_MODE")));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SOUND_SETTING_BD_SET_DEVICE")));
        jPanel4.setLayout(new FlowLayout(2));
        jPanel4.add(jLabel3);
        jPanel4.add(this.deviceComboBox);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(2));
        jPanel6.add(jLabel4);
        jPanel6.add(this.channelComboBox);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(2));
        jPanel7.add(jLabel5);
        jPanel7.add(this.soundGroupComboBox);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(2));
        jPanel8.add(jLabel6);
        jPanel8.add(this.instrumentComboBox);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout(0));
        jPanel9.add(jLabel7);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SOUND_SETTING_BD_SET_SUB_SOUND")));
        jPanel10.setLayout(new BoxLayout(jPanel10, 1));
        jPanel10.add(jPanel6);
        jPanel10.add(jPanel7);
        jPanel10.add(jPanel8);
        jPanel10.add(jPanel9);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new FlowLayout(1));
        this.scwTable = this.createComponetTable();
        this.scrollpane = new JScrollPane(this.scwTable);
        jPanel11.add(this.scrollpane);
        jPanel10.add(this.scrollpane);
        this.add("North", jPanel5);
        this.add("Center", jPanel10);
        this.enableComponent();
    }

    private Object makeItemObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    public Dimension getPreferredSize() {
        return new Dimension(460, 550);
    }

    private void enableEvent(boolean bl) {
        if (bl) {
            this.modeChangeComboBox.addActionListener(this.actionListener);
            this.soundLibComboBox.addActionListener(this.actionListener);
            this.deviceComboBox.addActionListener(this.actionListener);
            this.channelComboBox.addActionListener(this.actionListener);
            this.soundGroupComboBox.addActionListener(this.actionListener);
            this.instrumentComboBox.addActionListener(this.actionListener);
        } else {
            this.modeChangeComboBox.removeActionListener(this.actionListener);
            this.soundLibComboBox.removeActionListener(this.actionListener);
            this.deviceComboBox.removeActionListener(this.actionListener);
            this.channelComboBox.removeActionListener(this.actionListener);
            this.soundGroupComboBox.removeActionListener(this.actionListener);
            this.instrumentComboBox.removeActionListener(this.actionListener);
        }
    }

    private void enableSelectionListener(boolean bl) {
        if (bl) {
            this.lsmodel.addListSelectionListener(this.selectionListener);
        } else {
            this.lsmodel.removeListSelectionListener(this.selectionListener);
        }
    }

    private String[] getComboBoxList(int n) {
        String[] stringArray = null;
        switch (n) {
            case 0: {
                stringArray = new String[16];
                for (int i = 0; i < 16; ++i) {
                    stringArray[i] = Resource.getString("SOUND_SETTING_CB_CHANNEL") + " " + (i + 1);
                }
                break;
            }
            case 1: {
                stringArray = def.getSoundGroupAll();
                break;
            }
            case 2: {
                int n2 = this.soundGroupComboBox.getSelectedIndex();
                if (n2 < 0) {
                    n2 = 0;
                }
                stringArray = def.getInstrumentGropuInfo(--n2);
                break;
            }
        }
        return stringArray;
    }

    private void setFitSizeComboBox(int n) {
        int n2 = this.modeChangeComboBox.getPreferredSize().width;
        int n3 = this.modeChangeComboBox.getPreferredSize().height;
        if (n2 < this.soundLibComboBox.getPreferredSize().width) {
            n2 = this.soundLibComboBox.getPreferredSize().width;
        }
        if (n2 < this.deviceComboBox.getPreferredSize().width) {
            n2 = this.deviceComboBox.getPreferredSize().width;
        }
        if (n2 < this.soundGroupComboBox.getPreferredSize().width) {
            n2 = this.soundGroupComboBox.getPreferredSize().width;
        }
        if (n2 < this.instrumentComboBox.getPreferredSize().width) {
            n2 = this.instrumentComboBox.getPreferredSize().width;
        }
        if (n2 > n) {
            n2 = n;
        }
        Dimension dimension = new Dimension(n2, n3);
        this.modeChangeComboBox.setPreferredSize(dimension);
        this.soundLibComboBox.setPreferredSize(dimension);
        this.deviceComboBox.setPreferredSize(dimension);
        this.channelComboBox.setPreferredSize(dimension);
        this.soundGroupComboBox.setPreferredSize(dimension);
        this.instrumentComboBox.setPreferredSize(dimension);
    }

    public void selectDevice() {
        String[] stringArray;
        int n = this.deviceComboBox.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        if ((stringArray = def.getSoundDeviceGUID()) != null) {
            setting.setDevice(stringArray[n]);
        }
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }

    private void enableComponent() {
        if (this.curMode == 0) {
            if (this.devEnableFlag) {
                this.deviceComboBox.setEnabled(true);
            }
            this.soundLibComboBox.setEnabled(true);
            if (def.isUcsEnabled(this.curSoundLib)) {
                this.channelComboBox.setEnabled(false);
                this.soundGroupComboBox.setEnabled(false);
                this.instrumentComboBox.setEnabled(false);
                this.scrollpane.getVerticalScrollBar().setEnabled(false);
                this.scrollpane.setWheelScrollingEnabled(false);
                this.scwTable.setEnabled(false);
            } else {
                this.channelComboBox.setEnabled(true);
                this.soundGroupComboBox.setEnabled(true);
                this.instrumentComboBox.setEnabled(true);
                this.scrollpane.getVerticalScrollBar().setEnabled(true);
                this.scrollpane.setWheelScrollingEnabled(true);
                this.scwTable.setEnabled(true);
            }
        } else {
            if (this.devEnableFlag) {
                this.deviceComboBox.setEnabled(false);
            }
            this.soundLibComboBox.setEnabled(false);
            this.channelComboBox.setEnabled(false);
            this.soundGroupComboBox.setEnabled(false);
            this.instrumentComboBox.setEnabled(false);
            this.scrollpane.getVerticalScrollBar().setEnabled(false);
            this.scrollpane.setWheelScrollingEnabled(false);
            this.scwTable.setEnabled(false);
        }
        this.scwTable.repaint();
    }

    public void selectMode() {
        int n = this.modeChangeComboBox.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        this.curMode = n;
        this.enableComponent();
        setting.setPlayMode(n);
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }

    public void selectSoundLib() {
        int n = this.soundLibComboBox.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        this.curSoundLib = n;
        this.enableComponent();
        String[] stringArray = def.getSoundLibIndexString();
        if (stringArray != null && n < stringArray.length && stringArray[n] != null) {
            setting.setLibraryIndex(stringArray[n]);
            if (this.listener != null) {
                this.listener.tabPanelEvent(this, 2, 0);
            }
        }
    }

    public void selectChannel() {
        this.enableSelectionListener(false);
        int n = this.channelComboBox.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        if (n != this.scwTable.getSelectedRow()) {
            this.scwTable.addRowSelectionInterval(n, n);
            this.enableEvent(false);
            int[] nArray = setting.getCurrentSetting(n);
            this.soundGroupComboBox.setSelectedIndex(nArray[0] + 1);
            String[] stringArray = this.getComboBoxList(2);
            this.instrumentComboBox.removeAllItems();
            for (int i = 0; i < stringArray.length; ++i) {
                this.instrumentComboBox.addItem(stringArray[i]);
            }
            if (nArray[0] == -1) {
                this.instrumentComboBox.setSelectedIndex(0);
            } else if (nArray[0] == 16) {
                this.instrumentComboBox.setSelectedIndex(nArray[1]);
            } else {
                this.instrumentComboBox.setSelectedIndex(nArray[1] % 8);
            }
            this.enableEvent(true);
        }
        this.enableSelectionListener(true);
    }

    public void selectSoundGroup() {
        this.enableEvent(false);
        String[] stringArray = this.getComboBoxList(2);
        this.instrumentComboBox.removeAllItems();
        for (int i = 0; i < stringArray.length; ++i) {
            this.instrumentComboBox.addItem(stringArray[i]);
        }
        int n = this.soundGroupComboBox.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        String string = def.getSoundGroupAll()[n];
        String string2 = (String)this.instrumentComboBox.getSelectedItem();
        int n2 = this.channelComboBox.getSelectedIndex();
        if (n2 < 0) {
            n2 = 0;
        }
        this.tableModel.setValueAt(string, n2, 1);
        this.tableModel.setValueAt(string2, n2, 2);
        this.update(n2);
        this.enableEvent(true);
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }

    public void selectInstrument() {
        int n;
        this.enableEvent(false);
        int n2 = this.soundGroupComboBox.getSelectedIndex();
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = this.instrumentComboBox.getSelectedIndex()) < 0) {
            n = 0;
        }
        if (n2 == 0) {
            int n3;
            int n4;
            if (n <= 0) {
                n4 = -1;
                n3 = 0;
            } else if (n <= 128) {
                n4 = (n - 1) / 8;
                n3 = (n - 1) % 8;
            } else {
                n4 = 16;
                n3 = n - 128 - 1;
            }
            this.soundGroupComboBox.setSelectedIndex(n4 + 1);
            String[] stringArray = def.getInstrumentGropuInfo(n4);
            this.instrumentComboBox.removeAllItems();
            for (int i = 0; i < stringArray.length; ++i) {
                this.instrumentComboBox.addItem(stringArray[i]);
            }
            this.instrumentComboBox.setSelectedIndex(n3);
        }
        String string = (String)this.soundGroupComboBox.getSelectedItem();
        int n5 = this.channelComboBox.getSelectedIndex();
        if (n5 < 0) {
            n5 = 0;
        }
        this.tableModel.setValueAt(string, n5, 1);
        string = (String)this.instrumentComboBox.getSelectedItem();
        this.tableModel.setValueAt(string, n5, 2);
        this.update(n5);
        this.enableEvent(true);
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }

    private void update(int n) {
        int[] nArray;
        int n2 = this.instrumentComboBox.getSelectedIndex();
        int n3 = this.soundGroupComboBox.getSelectedIndex();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        nArray = new int[]{n3 - 1, nArray[0] == -1 ? -1 : (nArray[0] == 16 ? n2 : nArray[0] * 8 + n2)};
        int n4 = this.modeChangeComboBox.getSelectedIndex();
        if (n4 < 0) {
            n4 = 0;
        }
        setting.setPlayMode(n4);
        setting.setCurrentSetting(n, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        if (def != null) {
            String[] stringArray;
            setting.setPlayMode(this.oldMode);
            String[] stringArray2 = def.getSoundLibIndexString();
            if (stringArray2 != null && this.oldSoundLib < stringArray2.length && stringArray2[this.oldSoundLib] != null) {
                setting.setLibraryIndex(stringArray2[this.oldSoundLib]);
            }
            if ((stringArray = def.getSoundDeviceGUID()) != null) {
                setting.setDevice(stringArray[this.oldDevice]);
            }
            setting.setCurrentSetting(this.oldSetting);
            try {
                setting.saveCurrentSetting();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, Resource.getString("SOUND_SETTING_ERR_WRITE_SET"), Resource.getString("WNG"), 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean set() {
        boolean bl = true;
        if (def != null) {
            try {
                setting.saveCurrentSetting();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, Resource.getString("SOUND_SETTING_ERR_WRITE_SET"), Resource.getString("WNG"), 2);
                bl = false;
            }
            this.oldMode = this.curMode;
            this.oldSoundLib = this.curSoundLib;
            this.oldDevice = this.deviceComboBox.getSelectedIndex();
            int[][] nArray = setting.getCurrentSetting();
            this.oldSetting = new int[nArray.length][2];
            for (int i = 0; i < nArray.length; ++i) {
                this.oldSetting[i][0] = nArray[i][0];
                this.oldSetting[i][1] = nArray[i][1];
            }
        }
        return bl;
    }

    private Vector getSubSoundSetting() {
        int n;
        Vector<String[]> vector = new Vector<String[]>();
        int[][] nArray = setting.getCurrentSetting();
        this.oldSetting = new int[nArray.length][2];
        for (n = 0; n < nArray.length; ++n) {
            this.oldSetting[n][0] = nArray[n][0];
            this.oldSetting[n][1] = nArray[n][1];
        }
        for (n = 0; n < 16; ++n) {
            String[] stringArray = new String[]{Integer.toString(n + 1), def.getSoundGroupInfo(this.oldSetting[n][0]), def.getInstrumentInfo(this.oldSetting[n][0], this.oldSetting[n][1])};
            this.oldData[n][1] = stringArray[1];
            this.oldData[n][2] = stringArray[2];
            vector.addElement(stringArray);
        }
        return vector;
    }

    private JTable createComponetTable() {
        this.tableModel = new SelectCompTblModel();
        JTable jTable = new JTable(this.tableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = SoundSettingWindow.class$("java.lang.Object")) : class$java$lang$Object, new SelectCompTblRenderer());
        jTable.setSelectionMode(0);
        for (int i = 0; i < this.columnNames.length; ++i) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
            int n = (int)((double)this.getPreferredSize().width * ((double)this.CEL_WIDTH[i] / 10.0));
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(n);
            tableColumn.setResizable(false);
        }
        jTable.addRowSelectionInterval(0, 0);
        this.lsmodel = jTable.getSelectionModel();
        this.enableSelectionListener(true);
        jTable.setGridColor(Color.gray);
        jTable.setShowGrid(true);
        return jTable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            def = new SoundDefinition();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            setting = new SoundSetting(soundSettingFilePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class SelectCompTblRenderer
    extends JLabel
    implements TableCellRenderer {
        SelectCompTblRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = false;
            if (n2 > 0 && !SoundSettingWindow.this.oldData[n][n2].equals((String)object)) {
                bl3 = true;
            }
            this.setOpaque(true);
            if (n2 == 0) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            if (SoundSettingWindow.this.curMode == 0) {
                if (def.isUcsEnabled(SoundSettingWindow.this.curSoundLib)) {
                    this.setBackground(SoundSettingWindow.this.bc);
                } else {
                    if (n % 2 == 0) {
                        this.setBackground(Color.white);
                    } else {
                        this.setBackground(new Color(238, 238, 238));
                    }
                    this.setForeground(Color.black);
                }
            } else {
                this.setBackground(SoundSettingWindow.this.bc);
            }
            if (bl && SoundSettingWindow.this.curMode == 0 && !def.isUcsEnabled(SoundSettingWindow.this.curSoundLib)) {
                this.setBackground(Color.black);
                if (bl3) {
                    this.setForeground(Color.red);
                } else {
                    this.setForeground(Color.gray);
                }
            } else if (object instanceof String && ((String)object).equals(Resource.getString("SOUND_SETTING_UNSETTING"))) {
                if (bl3) {
                    this.setForeground(Color.red);
                } else {
                    this.setForeground(Color.gray);
                }
            } else if (bl3) {
                this.setForeground(Color.red);
            } else {
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            this.setToolTipText((String)object);
            return this;
        }
    }

    class SelectCompTblModel
    extends AbstractTableModel
    implements TableModelListener {
        SelectCompTblModel() {
            this.addTableModelListener(this);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public int getRowCount() {
            return SoundSettingWindow.this.compItemVector != null ? SoundSettingWindow.this.compItemVector.size() : 0;
        }

        public int getColumnCount() {
            return SoundSettingWindow.this.columnNames.length;
        }

        public String getColumnName(int n) {
            if (n < SoundSettingWindow.this.columnNames.length) {
                return SoundSettingWindow.this.columnNames[n];
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            if (n < SoundSettingWindow.this.compItemVector.size()) {
                String[] stringArray = (String[])SoundSettingWindow.this.compItemVector.get(n);
                return stringArray[n2];
            }
            return new Object();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void setValueAt(Object object, int n, int n2) {
            String[] stringArray = (String[])SoundSettingWindow.this.compItemVector.get(n);
            stringArray[n2] = (String)object;
            this.fireTableCellUpdated(n, n2);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getColumn();
            int n2 = tableModelEvent.getLastRow();
            if (n2 < SoundSettingWindow.this.compItemVector.size()) {
                String[] stringArray = (String[])SoundSettingWindow.this.compItemVector.get(n2);
            }
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        public synchronized void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            SoundSettingWindow.this.enableEvent(false);
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
            int n = defaultListSelectionModel.getMaxSelectionIndex();
            if (n < 0) {
                n = 0;
            }
            SoundSettingWindow.this.channelComboBox.setSelectedIndex(n);
            int[] nArray = setting.getCurrentSetting(n);
            SoundSettingWindow.this.soundGroupComboBox.setSelectedIndex(nArray[0] + 1);
            String[] stringArray = SoundSettingWindow.this.getComboBoxList(2);
            SoundSettingWindow.this.instrumentComboBox.removeAllItems();
            for (int i = 0; i < stringArray.length; ++i) {
                SoundSettingWindow.this.instrumentComboBox.addItem(stringArray[i]);
            }
            if (nArray[0] == -1) {
                SoundSettingWindow.this.instrumentComboBox.setSelectedIndex(0);
            } else if (nArray[0] == 16) {
                SoundSettingWindow.this.instrumentComboBox.setSelectedIndex(nArray[1]);
            } else {
                SoundSettingWindow.this.instrumentComboBox.setSelectedIndex(nArray[1] % 8);
            }
            SoundSettingWindow.this.enableEvent(true);
        }
    }
}

