/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.ExportListener;
import com.nttdocomo.dojaemu.ktoolbar.ImExportDialog;
import com.nttdocomo.dojaemu.ktoolbar.ImportException;
import com.nttdocomo.dojaemu.ktoolbar.ImportListener;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SurveyDataWindow;
import com.nttdocomo.dojaemu.ktoolbar.SurveyEntry;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import com.nttdocomo.dojaemu.ktoolbar.VerifySurveyData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class SurveyEntryWindow
extends TabPanel
implements ImportListener,
ExportListener {
    private static final int FRAME_WIDTH = 605;
    private static final int FRAME_HEIGHT = 200;
    private static String[] surveyFiles;
    private JTable surveyTable;
    private int[] idList = null;
    private int next = 0;
    private JScrollPane scrollpane;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;
    private JButton exButton;
    static /* synthetic */ Class class$java$lang$Object;

    SurveyEntryWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.upButton = new JButton(Resource.getString("SURVEY_UP"));
        this.downButton = new JButton(Resource.getString("SURVEY_DOWN"));
        JButton jButton = new JButton(Resource.getString("COMMON_IMPORT"));
        this.exButton = new JButton(Resource.getString("COMMON_EXPORT"));
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        this.upButton.setActionCommand("up");
        this.downButton.setActionCommand("down");
        jButton.setActionCommand("importData");
        this.exButton.setActionCommand("exportData");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        this.upButton.addActionListener(actionDispatcher);
        this.downButton.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        this.exButton.addActionListener(actionDispatcher);
        jPanel2.add(this.addButton);
        jPanel2.add(this.editButton);
        jPanel2.add(this.deleteButton);
        jPanel2.add(this.upButton);
        jPanel2.add(this.downButton);
        jPanel2.add(new JLabel("  "));
        jPanel2.add(jButton);
        jPanel2.add(this.exButton);
        this.surveyTable = this.createSurveyTable();
        this.scrollpane = new JScrollPane(this.surveyTable);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel2);
    }

    public Dimension getPreferredSize() {
        return new Dimension(605, 200);
    }

    private JTable createSurveyTable() {
        int n;
        JTable jTable = null;
        BufferedReader bufferedReader = null;
        Vector<Integer> vector = new Vector<Integer>();
        String[] stringArray = new String[]{Resource.getString("GPS_LATITUDE"), Resource.getString("GPS_LONGITUDE"), Resource.getString("GPS_ALTITUDE"), Resource.getString("GPS_ACCURACY_LEVEL"), Resource.getString("SURVEY_TIME"), Resource.getString("GPS_DATUM_TYPE"), Resource.getString("SURVEY_METHOD")};
        SurveyTableModel surveyTableModel = new SurveyTableModel(stringArray, 0);
        if (SurveyEntry.SURVEY_ORDER.exists()) {
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(SurveyEntry.SURVEY_ORDER)));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    n = 0;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    String string2 = SurveyEntry.SURVEY_DIR.getPath() + File.separator + string + ".srv";
                    SurveyEntry surveyEntry = new SurveyEntry();
                    surveyEntry.setEntryId(n);
                    boolean bl = surveyEntry.load(string2);
                    if (!bl) continue;
                    vector.addElement(new Integer(n));
                    Vector<String> vector2 = new Vector<String>();
                    vector2.addElement(surveyEntry.getLatitude());
                    vector2.addElement(surveyEntry.getLongitude());
                    vector2.addElement(surveyEntry.getAltitude());
                    vector2.addElement(Integer.toString(surveyEntry.getLevel()));
                    vector2.addElement(surveyEntry.getTime());
                    String string3 = null;
                    if (surveyEntry.getDatum() == 0) {
                        string3 = Resource.getString("GPS_DATUM_WGS84");
                    } else if (surveyEntry.getDatum() == 1) {
                        string3 = Resource.getString("GPS_DATUM_TOKYO");
                    }
                    vector2.addElement(string3);
                    String string4 = null;
                    if (surveyEntry.getMethod() == 0) {
                        string4 = Resource.getString("SURVEY_METHOD_GPS");
                    }
                    vector2.addElement(string4);
                    surveyTableModel.addRow(vector2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        jTable = new JTable(surveyTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = SurveyEntryWindow.class$("java.lang.Object")) : class$java$lang$Object, new SurveyTableCellRenderer());
        jTable.setSelectionMode(2);
        this.idList = new int[vector.size()];
        for (int i = 0; i < this.idList.length; ++i) {
            this.idList[i] = (Integer)vector.get(i);
        }
        int[] nArray = new int[vector.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = this.idList[n];
        }
        Arrays.sort(nArray);
        this.next = nArray.length > 0 ? nArray[nArray.length - 1] + 1 : 1;
        this.changeButtonEnabled();
        jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    SurveyEntryWindow.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SurveyEntryWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    void add() {
        SurveyEntry surveyEntry = new SurveyEntry();
        surveyEntry.setEntryId(this.next);
        surveyEntry.init();
        SurveyDataWindow surveyDataWindow = new SurveyDataWindow(this.parent, surveyEntry, true);
        surveyDataWindow.setLocation(this.parent.getShowLocation(surveyDataWindow.getWidth(), surveyDataWindow.getHeight(), this.tabwin));
        surveyDataWindow.setVisible(true);
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.surveyTable = null;
        this.surveyTable = this.createSurveyTable();
        this.scrollpane = new JScrollPane(this.surveyTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void edit() {
        int[] nArray = this.surveyTable.getSelectedRows();
        if (this.surveyTable.getSelectedRowCount() == 1) {
            int n = this.idList[nArray[0]];
            String string = SurveyEntry.SURVEY_DIR.getPath() + File.separator + Integer.toString(n) + ".srv";
            SurveyEntry surveyEntry = new SurveyEntry();
            surveyEntry.setEntryId(n);
            try {
                boolean bl = surveyEntry.load(string);
                if (bl) {
                    SurveyDataWindow surveyDataWindow = new SurveyDataWindow(this.parent, surveyEntry, false);
                    surveyDataWindow.setLocation(this.parent.getShowLocation(surveyDataWindow.getWidth(), surveyDataWindow.getHeight(), this.tabwin));
                    surveyDataWindow.setVisible(true);
                    this.setVisible(false);
                    this.remove(this.scrollpane);
                    this.scrollpane = null;
                    this.surveyTable = null;
                    this.surveyTable = this.createSurveyTable();
                    this.scrollpane = new JScrollPane(this.surveyTable);
                    this.add("Center", this.scrollpane);
                    this.setVisible(true);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    void delete() {
        int[] nArray = this.surveyTable.getSelectedRows();
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        if (this.surveyTable.getSelectedRowCount() != 0) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("SURVEY_DELETE_WNG", String.valueOf(this.surveyTable.getSelectedRowCount())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                String string = null;
                try {
                    for (int i = 0; i < this.surveyTable.getSelectedRowCount(); ++i) {
                        int n = nArray[i];
                        string = Integer.toString(this.idList[n]) + ".srv";
                        File file = new File(SurveyEntry.SURVEY_DIR, string);
                        bufferedReader = new BufferedReader(new FileReader(SurveyEntry.SURVEY_ORDER));
                        String string2 = null;
                        String string3 = "";
                        while ((string2 = bufferedReader.readLine()) != null) {
                            string2 = string2.equals(Integer.toString(this.idList[n])) ? "" : string2 + "\n";
                            string3 = string3 + string2;
                        }
                        bufferedWriter = new BufferedWriter(new FileWriter(SurveyEntry.SURVEY_ORDER, false));
                        bufferedWriter.write(string3);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    System.err.println(Resource.format("SURVEY_DELETE_ERR", string));
                    return;
                }
                this.setVisible(false);
                this.remove(this.scrollpane);
                this.scrollpane = null;
                this.surveyTable = null;
                this.surveyTable = this.createSurveyTable();
                this.scrollpane = new JScrollPane(this.surveyTable);
                this.add("Center", this.scrollpane);
                this.setVisible(true);
            }
        }
    }

    void up() {
        int[] nArray = this.surveyTable.getSelectedRows();
        BufferedWriter bufferedWriter = null;
        if (this.surveyTable.getSelectedRowCount() == 1) {
            int n = nArray[0];
            if (n == 0) {
                return;
            }
            try {
                String string = "";
                for (int i = 0; i < this.idList.length; ++i) {
                    string = i == n - 1 ? string + Integer.toString(this.idList[i + 1]) + '\n' : (i == n ? string + Integer.toString(this.idList[i - 1]) + '\n' : string + Integer.toString(this.idList[i]) + '\n');
                }
                bufferedWriter = new BufferedWriter(new FileWriter(SurveyEntry.SURVEY_ORDER, false));
                bufferedWriter.write(string);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                return;
            }
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.surveyTable = null;
            this.surveyTable = this.createSurveyTable();
            this.scrollpane = new JScrollPane(this.surveyTable);
            this.add("Center", this.scrollpane);
            this.surveyTable.setRowSelectionInterval(n - 1, n - 1);
            this.setVisible(true);
        }
    }

    void down() {
        int[] nArray = this.surveyTable.getSelectedRows();
        BufferedWriter bufferedWriter = null;
        if (this.surveyTable.getSelectedRowCount() == 1) {
            int n = nArray[0];
            if (n == this.idList.length - 1) {
                return;
            }
            try {
                String string = "";
                for (int i = 0; i < this.idList.length; ++i) {
                    string = i == n + 1 ? string + Integer.toString(this.idList[i - 1]) + '\n' : (i == n ? string + Integer.toString(this.idList[i + 1]) + '\n' : string + Integer.toString(this.idList[i]) + '\n');
                }
                bufferedWriter = new BufferedWriter(new FileWriter(SurveyEntry.SURVEY_ORDER, false));
                bufferedWriter.write(string);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                return;
            }
            this.setVisible(false);
            this.remove(this.scrollpane);
            this.scrollpane = null;
            this.surveyTable = null;
            this.surveyTable = this.createSurveyTable();
            this.scrollpane = new JScrollPane(this.surveyTable);
            this.add("Center", this.scrollpane);
            this.surveyTable.setRowSelectionInterval(n + 1, n + 1);
            this.setVisible(true);
        }
    }

    void cancel() {
    }

    boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.idList != null && this.idList.length > 0) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.exButton.setEnabled(true);
            if (this.idList.length > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.exButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    public void check(String[] stringArray, int n) throws ImportException {
        VerifySurveyData.verify(stringArray);
    }

    public int add(String[] stringArray, int n) throws ImportException {
        Object[] objectArray = VerifySurveyData.adjust(stringArray);
        SurveyEntry surveyEntry = new SurveyEntry();
        surveyEntry.setEntryId(this.next);
        surveyEntry.init();
        String string = "0," + objectArray[0] + "," + objectArray[1] + "," + objectArray[2] + "," + objectArray[3] + "," + objectArray[4] + "," + "0";
        String string2 = surveyEntry.getEntryId() + ".srv";
        try {
            surveyEntry.save(string, string2, true);
        }
        catch (IOException iOException) {
            throw new ImportException(-1, -1, Resource.format("WRITE_ERR", string2));
        }
        ++this.next;
        objectArray[5] = Resource.getString("GPS_DATUM_WGS84");
        objectArray[6] = Resource.getString("SURVEY_METHOD_GPS");
        this.paintRow(this.surveyTable, objectArray);
        return surveyEntry.getEntryId();
    }

    public void paintRow(final JTable jTable, final Object[] objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (jTable != null && SurveyEntryWindow.this.surveyTable != null && jTable.equals(SurveyEntryWindow.this.surveyTable)) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
                    defaultTableModel.addRow(objectArray);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int delete(int n) throws ImportException {
        int n2 = n;
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = "";
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(SurveyEntry.SURVEY_ORDER));
                while ((string = bufferedReader.readLine()) != null && !string.equals(Integer.toString(n))) {
                    string2 = string2 + string + "\n";
                }
                bufferedReader.close();
                bufferedReader = null;
                bufferedWriter = new BufferedWriter(new FileWriter(SurveyEntry.SURVEY_ORDER, false));
                bufferedWriter.write(string2);
                bufferedWriter.flush();
            }
            catch (Exception exception) {
                throw new ImportException(-1, -1, Resource.format("WRITE_ERR", SurveyEntry.SURVEY_ORDER.getName()));
            }
            Object var9_7 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter == null) throw throwable;
                bufferedWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        if (bufferedWriter != null) {
            bufferedWriter.close();
        }
        while (true) {
            string = Integer.toString(n2++) + ".srv";
            try {
                File file = new File(SurveyEntry.SURVEY_DIR, string);
                if (!file.exists()) {
                    return n2 - n;
                }
                file.delete();
            }
            catch (Exception exception) {
                throw new ImportException(-1, -1, Resource.format("SURVEY_DELETE_ERR", string));
            }
        }
    }

    public ArrayList get() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.surveyTable.getModel();
        Vector<Vector> vector = defaultTableModel.getDataVector();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = "";
            Vector vector2 = vector.elementAt(i);
            String[] stringArray = vector2.toArray(new String[0]);
            for (int j = 0; j < 5; ++j) {
                string = string + stringArray[j] + ",";
            }
            string = string + "0,0";
            arrayList.add(string);
        }
        return arrayList;
    }

    void importData() {
        ImExportDialog imExportDialog = new ImExportDialog(this.tabwin, this, 0);
        imExportDialog.open();
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.surveyTable = null;
        this.surveyTable = this.createSurveyTable();
        this.scrollpane = new JScrollPane(this.surveyTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void exportData() {
        ImExportDialog imExportDialog = new ImExportDialog(this.tabwin, this, 1);
        imExportDialog.open();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SurveyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        SurveyTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class SurveyTableModel
    extends DefaultTableModel {
        SurveyTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

