/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.StringDocument;
import com.nttdocomo.dojaemu.ktoolbar.ToruCaEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.plaf.ColorUIResource;

public class ToruCaEditDialog
extends AbstractWindow {
    private JPanel jContentPane = null;
    private JPanel inputPanel = null;
    private JPanel versionPanel = null;
    private JPanel buttonPanel = null;
    private JLabel typeLabel = null;
    private JLabel categoryGenreLabel = null;
    private JLabel categoryCodeLabel = null;
    private JLabel versionLabel = null;
    private JLabel ipIDLabel = null;
    private JLabel sortIDLabel = null;
    private JLabel redistributionIDLabel = null;
    private JLabel colorIDLabel = null;
    private JLabel expirationDateLabel = null;
    private JLabel urlLabel = null;
    private JLabel data1Label = null;
    private JLabel data2Label = null;
    private JLabel data3Label = null;
    private JLabel bodyLabel = null;
    private JComboBox typeComboBox = null;
    private JComboBox categoryGenreComboBox = null;
    private JComboBox categoryCodeComboBox = null;
    private JTextField version1TextField = null;
    private JTextField version2TextField = null;
    private JTextField ipIDTextField = null;
    private JTextField sortIDTextField = null;
    private JTextField redistributionIDTextField = null;
    private JTextField colorIDTextField = null;
    private JTextField expirationDateTextField = null;
    private JTextField urlTextField = null;
    private JTextField data1TextField = null;
    private JScrollPane data2ScrollPane = null;
    private JTextArea data2TextArea = null;
    private JTextField data3TextField = null;
    private JScrollPane bodyScrollPane = null;
    private JTextArea bodyTextArea = null;
    private JButton setButton = null;
    private JButton cancelButton = null;
    private ToruCaEntity targetEntity = null;
    private ActionDispatcher actionListener;

    public ToruCaEditDialog(MainWindow mainWindow, ToruCaEntity toruCaEntity, String string) {
        super(mainWindow, string);
        this.targetEntity = toruCaEntity;
        this.initialize();
        this.setToruCaData();
    }

    private void initialize() {
        this.actionListener = new ActionDispatcher(this);
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    private void setToruCaData() {
        this.typeComboBox.setSelectedIndex(this.targetEntity.getType());
        this.updateEditable();
        String string = this.targetEntity.getCategory();
        int n = 0;
        int n2 = 0;
        block0: for (int i = 0; i < ToruCaEntity.CATEGORY_CODE_ITEMS.length; ++i) {
            for (int j = 0; j < ToruCaEntity.CATEGORY_CODE_ITEMS[i].length; ++j) {
                if (!string.equals(ToruCaEntity.CATEGORY_CODE_ITEMS[i][j])) continue;
                n = i;
                n2 = j;
                continue block0;
            }
        }
        this.categoryGenreComboBox.setSelectedIndex(n);
        this.updateCodeItems();
        this.categoryCodeComboBox.setSelectedIndex(n2);
        String[] stringArray = this.targetEntity.getVersion();
        this.version1TextField.setText(stringArray[0]);
        this.version1TextField.setCaretPosition(0);
        this.version2TextField.setText(stringArray[1]);
        this.version2TextField.setCaretPosition(0);
        this.ipIDTextField.setText(this.targetEntity.getIPID());
        this.ipIDTextField.setCaretPosition(0);
        this.sortIDTextField.setText(this.targetEntity.getSortID());
        this.sortIDTextField.setCaretPosition(0);
        this.redistributionIDTextField.setText(this.targetEntity.getRedistributionID());
        this.redistributionIDTextField.setCaretPosition(0);
        this.colorIDTextField.setText(this.targetEntity.getColorID());
        this.colorIDTextField.setCaretPosition(0);
        this.expirationDateTextField.setText(this.targetEntity.getExpirationDate());
        this.expirationDateTextField.setCaretPosition(0);
        this.urlTextField.setText(this.targetEntity.getURL());
        this.urlTextField.setCaretPosition(0);
        this.data1TextField.setText(this.targetEntity.getData1());
        this.data1TextField.setCaretPosition(0);
        this.data2TextArea.setText(this.targetEntity.getData2());
        this.data2TextArea.setCaretPosition(0);
        this.data3TextField.setText(this.targetEntity.getData3());
        this.data3TextField.setCaretPosition(0);
        this.bodyTextArea.setText(this.targetEntity.getBody());
        this.bodyTextArea.setCaretPosition(0);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getInputPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getInputPanel() {
        if (this.inputPanel == null) {
            this.typeLabel = new JLabel();
            this.typeLabel.setText(Resource.getString("TORUCA_TYPE"));
            this.categoryGenreLabel = new JLabel();
            this.categoryGenreLabel.setText(Resource.getString("TORUCA_CAT_GENRE"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            this.categoryCodeLabel = new JLabel();
            this.categoryCodeLabel.setText(Resource.getString("TORUCA_CAT_CODE"));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            this.versionLabel = new JLabel();
            this.versionLabel.setText(Resource.getString("TORUCA_VERSION"));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 3;
            this.ipIDLabel = new JLabel();
            this.ipIDLabel.setText(Resource.getString("TORUCA_IPID"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 4;
            this.sortIDLabel = new JLabel();
            this.sortIDLabel.setText(Resource.getString("TORUCA_SORTID"));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 5;
            this.redistributionIDLabel = new JLabel();
            this.redistributionIDLabel.setText(Resource.getString("TORUCA_DIST"));
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 6;
            this.colorIDLabel = new JLabel();
            this.colorIDLabel.setText(Resource.getString("TORUCA_COLORID"));
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 7;
            this.expirationDateLabel = new JLabel();
            this.expirationDateLabel.setText(Resource.getString("TORUCA_EXPIRES"));
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.gridy = 8;
            this.urlLabel = new JLabel();
            this.urlLabel.setText(Resource.getString("TORUCA_URL"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 9;
            this.data1Label = new JLabel();
            this.data1Label.setText(Resource.getString("TORUCA_DATA1"));
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.gridy = 10;
            this.data2Label = new JLabel();
            this.data2Label.setText(Resource.getString("TORUCA_DATA2"));
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 11;
            this.data3Label = new JLabel();
            this.data3Label.setText(Resource.getString("TORUCA_DATA3"));
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridy = 12;
            this.bodyLabel = new JLabel();
            this.bodyLabel.setText(Resource.getString("TORUCA_BODY"));
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.gridy = 13;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 0;
            gridBagConstraints14.anchor = 17;
            gridBagConstraints14.gridwidth = 1;
            gridBagConstraints14.weightx = 1.0;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 0;
            gridBagConstraints15.gridx = 1;
            gridBagConstraints15.gridy = 1;
            gridBagConstraints15.anchor = 17;
            gridBagConstraints15.insets = new Insets(1, 0, 0, 0);
            gridBagConstraints15.weightx = 1.0;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.fill = 0;
            gridBagConstraints16.gridx = 1;
            gridBagConstraints16.gridy = 2;
            gridBagConstraints16.anchor = 17;
            gridBagConstraints16.insets = new Insets(1, 0, 0, 0);
            gridBagConstraints16.weightx = 1.0;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.fill = 2;
            gridBagConstraints17.gridx = 1;
            gridBagConstraints17.gridy = 3;
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.insets = new Insets(4, 0, 0, 0);
            gridBagConstraints17.weightx = 1.0;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.fill = 0;
            gridBagConstraints18.gridx = 1;
            gridBagConstraints18.gridy = 4;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints18.weightx = 1.0;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.fill = 0;
            gridBagConstraints19.gridx = 1;
            gridBagConstraints19.gridy = 5;
            gridBagConstraints19.anchor = 17;
            gridBagConstraints19.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints19.weightx = 1.0;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.fill = 0;
            gridBagConstraints20.gridx = 1;
            gridBagConstraints20.gridy = 6;
            gridBagConstraints20.anchor = 17;
            gridBagConstraints20.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints20.weightx = 1.0;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.fill = 0;
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.gridy = 7;
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints21.weightx = 1.0;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.fill = 0;
            gridBagConstraints22.gridx = 1;
            gridBagConstraints22.gridy = 8;
            gridBagConstraints22.anchor = 17;
            gridBagConstraints22.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints22.weightx = 1.0;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.fill = 2;
            gridBagConstraints23.gridx = 1;
            gridBagConstraints23.gridy = 9;
            gridBagConstraints23.insets = new Insets(4, 0, 0, 0);
            gridBagConstraints23.weightx = 1.0;
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.fill = 2;
            gridBagConstraints24.gridx = 1;
            gridBagConstraints24.gridy = 10;
            gridBagConstraints24.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints24.weightx = 1.0;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.fill = 1;
            gridBagConstraints25.gridx = 1;
            gridBagConstraints25.gridy = 11;
            gridBagConstraints25.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.weighty = 1.0;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.fill = 2;
            gridBagConstraints26.gridx = 1;
            gridBagConstraints26.gridy = 12;
            gridBagConstraints26.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints26.weightx = 1.0;
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.fill = 1;
            gridBagConstraints27.weighty = 1.0;
            gridBagConstraints27.gridx = 1;
            gridBagConstraints27.gridy = 13;
            gridBagConstraints27.insets = new Insets(2, 0, 0, 0);
            gridBagConstraints27.weightx = 1.0;
            this.inputPanel = new JPanel();
            this.inputPanel.setLayout(new GridBagLayout());
            this.inputPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("TORUCA_DETAIL"), 0, 0, new Font("MS UI Gothic", 0, 12), Color.black));
            this.inputPanel.add((Component)this.typeLabel, new GridBagConstraints());
            this.inputPanel.add((Component)this.categoryGenreLabel, gridBagConstraints);
            this.inputPanel.add((Component)this.categoryCodeLabel, gridBagConstraints2);
            this.inputPanel.add((Component)this.versionLabel, gridBagConstraints3);
            this.inputPanel.add((Component)this.ipIDLabel, gridBagConstraints4);
            this.inputPanel.add((Component)this.sortIDLabel, gridBagConstraints5);
            this.inputPanel.add((Component)this.redistributionIDLabel, gridBagConstraints6);
            this.inputPanel.add((Component)this.colorIDLabel, gridBagConstraints7);
            this.inputPanel.add((Component)this.expirationDateLabel, gridBagConstraints8);
            this.inputPanel.add((Component)this.urlLabel, gridBagConstraints9);
            this.inputPanel.add((Component)this.data1Label, gridBagConstraints10);
            this.inputPanel.add((Component)this.data2Label, gridBagConstraints11);
            this.inputPanel.add((Component)this.data3Label, gridBagConstraints12);
            this.inputPanel.add((Component)this.bodyLabel, gridBagConstraints13);
            this.inputPanel.add((Component)this.getTypeComboBox(), gridBagConstraints14);
            this.inputPanel.add((Component)this.getCategoryGenreComboBox(), gridBagConstraints15);
            this.inputPanel.add((Component)this.getCategoryCodeComboBox(), gridBagConstraints16);
            this.inputPanel.add((Component)this.getVersionPanel(), gridBagConstraints17);
            this.inputPanel.add((Component)this.getIPIDTextField(), gridBagConstraints18);
            this.inputPanel.add((Component)this.getSortIDTextField(), gridBagConstraints19);
            this.inputPanel.add((Component)this.getRedistributionIDTextField(), gridBagConstraints20);
            this.inputPanel.add((Component)this.getColorIDTextField(), gridBagConstraints21);
            this.inputPanel.add((Component)this.getExpirationDateTextField(), gridBagConstraints22);
            this.inputPanel.add((Component)this.getUrlTextField(), gridBagConstraints23);
            this.inputPanel.add((Component)this.getData1TextField(), gridBagConstraints24);
            this.inputPanel.add((Component)this.getData2ScrollPane(), gridBagConstraints25);
            this.inputPanel.add((Component)this.getData3TextField(), gridBagConstraints26);
            this.inputPanel.add((Component)this.getBodyScrollPane(), gridBagConstraints27);
        }
        return this.inputPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getSetButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JComboBox getTypeComboBox() {
        if (this.typeComboBox == null) {
            this.typeComboBox = new JComboBox<String>(ToruCaEntity.TYPE_ITEMS);
            this.typeComboBox.setActionCommand("selectType");
            this.typeComboBox.addActionListener(this.actionListener);
        }
        return this.typeComboBox;
    }

    private JComboBox getCategoryGenreComboBox() {
        if (this.categoryGenreComboBox == null) {
            this.categoryGenreComboBox = new JComboBox<String>(ToruCaEntity.CATEGORY_GENRE_ITEMS);
            this.categoryGenreComboBox.setActionCommand("selectCategoryGenre");
            this.categoryGenreComboBox.addActionListener(this.actionListener);
        }
        return this.categoryGenreComboBox;
    }

    private JComboBox getCategoryCodeComboBox() {
        if (this.categoryCodeComboBox == null) {
            this.categoryCodeComboBox = new JComboBox<String>(ToruCaEntity.CATEGORY_CODE_ITEMS[0]);
            this.categoryCodeComboBox.setPreferredSize(new Dimension(54, 19));
        }
        return this.categoryCodeComboBox;
    }

    private JPanel getVersionPanel() {
        if (this.versionPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            flowLayout.setVgap(2);
            flowLayout.setHgap(0);
            this.versionPanel = new JPanel();
            this.versionPanel.setLayout(flowLayout);
            this.versionPanel.add((Component)this.getVersion1TextField(), null);
            this.versionPanel.add((Component)new JLabel("."), null);
            this.versionPanel.add((Component)this.getVersion2TextField(), null);
        }
        return this.versionPanel;
    }

    private JTextField getVersion1TextField() {
        if (this.version1TextField == null) {
            this.version1TextField = new JTextField(1);
            this.version1TextField.setDocument(new HalfNumberDocument(1));
        }
        return this.version1TextField;
    }

    private JTextField getVersion2TextField() {
        if (this.version2TextField == null) {
            this.version2TextField = new JTextField(1);
            this.version2TextField.setDocument(new HalfNumberDocument(1));
        }
        return this.version2TextField;
    }

    private JTextField getIPIDTextField() {
        if (this.ipIDTextField == null) {
            this.ipIDTextField = new JTextField(10);
        }
        return this.ipIDTextField;
    }

    private JTextField getSortIDTextField() {
        if (this.sortIDTextField == null) {
            this.sortIDTextField = new JTextField(4);
            this.sortIDTextField.setDocument(new StringDocument(2));
        }
        return this.sortIDTextField;
    }

    private JTextField getRedistributionIDTextField() {
        if (this.redistributionIDTextField == null) {
            this.redistributionIDTextField = new JTextField(1);
            this.redistributionIDTextField.setDocument(new HalfNumberDocument(1));
        }
        return this.redistributionIDTextField;
    }

    private JTextField getColorIDTextField() {
        if (this.colorIDTextField == null) {
            this.colorIDTextField = new JTextField(1);
            this.colorIDTextField.setDocument(new HalfNumberDocument(1));
        }
        return this.colorIDTextField;
    }

    private JTextField getExpirationDateTextField() {
        if (this.expirationDateTextField == null) {
            this.expirationDateTextField = new JTextField(6);
            this.expirationDateTextField.setDocument(new HalfNumberDocument(6));
        }
        return this.expirationDateTextField;
    }

    private JTextField getUrlTextField() {
        if (this.urlTextField == null) {
            this.urlTextField = new JTextField(30);
        }
        return this.urlTextField;
    }

    private JTextField getData1TextField() {
        if (this.data1TextField == null) {
            this.data1TextField = new JTextField(30);
        }
        return this.data1TextField;
    }

    private JScrollPane getData2ScrollPane() {
        if (this.data2ScrollPane == null) {
            this.data2ScrollPane = new JScrollPane();
            this.data2ScrollPane.setViewportView(this.getData2TextArea());
            this.data2ScrollPane.setPreferredSize(this.data2ScrollPane.getPreferredSize());
        }
        return this.data2ScrollPane;
    }

    private JTextArea getData2TextArea() {
        if (this.data2TextArea == null) {
            this.data2TextArea = new JTextArea(4, 30);
        }
        return this.data2TextArea;
    }

    private JTextField getData3TextField() {
        if (this.data3TextField == null) {
            this.data3TextField = new JTextField(30);
        }
        return this.data3TextField;
    }

    private JScrollPane getBodyScrollPane() {
        if (this.bodyScrollPane == null) {
            this.bodyScrollPane = new JScrollPane();
            this.bodyScrollPane.setViewportView(this.getBodyTextArea());
            this.bodyScrollPane.setPreferredSize(this.bodyScrollPane.getPreferredSize());
        }
        return this.bodyScrollPane;
    }

    private JTextArea getBodyTextArea() {
        if (this.bodyTextArea == null) {
            this.bodyTextArea = new JTextArea(8, 30);
        }
        return this.bodyTextArea;
    }

    private JButton getSetButton() {
        if (this.setButton == null) {
            this.setButton = new JButton();
            this.setButton.setText(Resource.getString("SET"));
            this.setButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToruCaEditDialog.this.set();
                }
            });
        }
        return this.setButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText(Resource.getString("CANCEL"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToruCaEditDialog.this.cancel();
                }
            });
        }
        return this.cancelButton;
    }

    public void selectType() {
        this.updateEditable();
    }

    public void selectCategoryGenre() {
        this.updateCodeItems();
        this.categoryCodeComboBox.setSelectedIndex(0);
    }

    private void updateEditable() {
        if (this.typeComboBox.getSelectedIndex() == 0) {
            this.expirationDateTextField.setEditable(false);
            this.bodyTextArea.setEditable(false);
            this.bodyTextArea.setBackground(new ColorUIResource(236, 233, 216));
        } else {
            this.expirationDateTextField.setEditable(true);
            this.bodyTextArea.setEditable(true);
            this.bodyTextArea.setBackground(new ColorUIResource(255, 255, 255));
        }
    }

    private void updateCodeItems() {
        int n = this.categoryGenreComboBox.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.categoryCodeComboBox.removeAllItems();
        for (int i = 0; i < ToruCaEntity.CATEGORY_CODE_ITEMS[n].length; ++i) {
            this.categoryCodeComboBox.addItem(ToruCaEntity.CATEGORY_CODE_ITEMS[n][i]);
        }
    }

    private void set() {
        int n;
        String[] stringArray = new String[]{this.version1TextField.getText(), this.version2TextField.getText()};
        this.targetEntity.setVersion(stringArray);
        int n2 = this.typeComboBox.getSelectedIndex();
        if (n2 == -1) {
            n2 = 0;
        }
        this.targetEntity.setType(n2);
        this.targetEntity.setURL(this.urlTextField.getText());
        this.targetEntity.setData1(this.data1TextField.getText());
        this.targetEntity.setData2(this.data2TextArea.getText());
        this.targetEntity.setData3(this.data3TextField.getText());
        int n3 = this.categoryGenreComboBox.getSelectedIndex();
        if (n3 == -1) {
            n3 = 0;
        }
        if ((n = this.categoryCodeComboBox.getSelectedIndex()) == -1) {
            n = 0;
        }
        this.targetEntity.setCategory(ToruCaEntity.CATEGORY_CODE_ITEMS[n3][n]);
        this.targetEntity.setIPID(this.ipIDTextField.getText());
        this.targetEntity.setSortID(this.sortIDTextField.getText());
        this.targetEntity.setRedistributionID(this.redistributionIDTextField.getText());
        this.targetEntity.setColorID(this.colorIDTextField.getText());
        this.targetEntity.setExpirationDate(this.expirationDateTextField.getText());
        this.targetEntity.setBody(this.bodyTextArea.getText());
        int n4 = this.targetEntity.getRemainingBytes();
        if (n4 < 0) {
            Object[] objectArray = new String[]{this.targetEntity.getTypeName(), String.valueOf(n4 * -1)};
            this.parent.showDialog(Resource.format("TORUCA_OVER_WNG", objectArray), this, 2);
            return;
        }
        String string = ToruCaEntity.entryNum2fName(this.targetEntity.getEntryID());
        try {
            this.targetEntity.save(string);
        }
        catch (IOException iOException) {
            this.parent.showDialog(Resource.format("WRITE_ERR", string), this, 2);
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }
}

