/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import com.nttdocomo.dojaemu.ktoolbar.ToruCaEditDialog;
import com.nttdocomo.dojaemu.ktoolbar.ToruCaEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ToruCaManageWindow
extends TabPanel {
    private JPanel jContentPane = null;
    private JPanel torucaViewPanel = null;
    private JPanel torucaInfoPanel = null;
    private JScrollPane jScrollPane = null;
    private ToruCaTable torucaTable = null;
    private JLabel urlLabel = null;
    private JTextField urlInfo = null;
    private JLabel data1Label = null;
    private JTextField data1Info = null;
    private JLabel data2Label = null;
    private JScrollPane data2ScrollPane = null;
    private JTextArea data2Info = null;
    private JLabel data3Label = null;
    private JTextField data3Info = null;
    private JLabel bodyLabel = null;
    private JScrollPane bodyScrollPane = null;
    private JTextArea bodyTextArea = null;
    private JPanel buttonPanel = null;
    private JButton addButton = null;
    private JLabel typeLabel = null;
    private JLabel categoryLabel = null;
    private JButton editButton = null;
    private JButton deleteButton = null;
    private JLabel typeInfo = null;
    private JLabel categoryInfo = null;
    private int[] idList;
    private Hashtable toruCaHash;
    static /* synthetic */ Class class$java$lang$Object;

    public ToruCaManageWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.initialize();
    }

    private void initialize() {
        this.add(this.getJContentPane());
        this.loadTableData();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getToruCaViewPanel(), "North");
            this.jContentPane.add((Component)this.getToruCaInfoPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getToruCaViewPanel() {
        if (this.torucaViewPanel == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(5);
            this.torucaViewPanel = new JPanel();
            this.torucaViewPanel.setLayout(borderLayout);
            this.torucaViewPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("TORUCA_LIST"), 0, 0, new Font("MS UI Gothic", 0, 12), null));
            this.torucaViewPanel.add((Component)this.getJScrollPane(), "Center");
            this.torucaViewPanel.add((Component)this.getButtonPanel(), "East");
        }
        return this.torucaViewPanel;
    }

    private JPanel getToruCaInfoPanel() {
        if (this.torucaInfoPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 4, 0, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 4, 0, 0);
            gridBagConstraints2.gridy = 1;
            this.categoryInfo = new JLabel();
            this.typeInfo = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(2, 0, 0, 0);
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            this.categoryLabel = new JLabel();
            this.categoryLabel.setText(Resource.getString("TORUCA_CAT"));
            this.typeLabel = new JLabel();
            this.typeLabel.setText(Resource.getString("TORUCA_TYPE"));
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 9;
            gridBagConstraints5.insets = new Insets(2, 0, 2, 2);
            gridBagConstraints5.weightx = 1.0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints6.gridy = 9;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints7.gridy = 8;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints8.gridy = 5;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints9.gridy = 4;
            this.bodyLabel = new JLabel();
            this.bodyLabel.setText(Resource.getString("TORUCA_BODY"));
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.gridx = 1;
            gridBagConstraints10.gridy = 8;
            gridBagConstraints10.insets = new Insets(0, 0, 0, 2);
            gridBagConstraints10.weightx = 1.0;
            this.data3Label = new JLabel();
            this.data3Label.setText(Resource.getString("TORUCA_DATA3"));
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridy = 5;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 2);
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            this.data2Label = new JLabel();
            this.data2Label.setText(Resource.getString("TORUCA_DATA2"));
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.gridy = 4;
            gridBagConstraints12.insets = new Insets(0, 0, 0, 2);
            gridBagConstraints12.weightx = 1.0;
            this.data1Label = new JLabel();
            this.data1Label.setText(Resource.getString("TORUCA_DATA1"));
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints13.gridy = 3;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridx = 1;
            gridBagConstraints14.gridy = 3;
            gridBagConstraints14.insets = new Insets(2, 0, 0, 2);
            gridBagConstraints14.weightx = 1.0;
            this.urlLabel = new JLabel();
            this.urlLabel.setText(Resource.getString("TORUCA_URL"));
            this.torucaInfoPanel = new JPanel();
            this.torucaInfoPanel.setLayout(new GridBagLayout());
            this.torucaInfoPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("TORUCA_DETAIL"), 0, 0, new Font("MS UI Gothic", 0, 12), null));
            this.torucaInfoPanel.add((Component)this.urlLabel, gridBagConstraints13);
            this.torucaInfoPanel.add((Component)this.getUrlInfo(), gridBagConstraints14);
            this.torucaInfoPanel.add((Component)this.data1Label, gridBagConstraints9);
            this.torucaInfoPanel.add((Component)this.getData1Info(), gridBagConstraints12);
            this.torucaInfoPanel.add((Component)this.data2Label, gridBagConstraints8);
            this.torucaInfoPanel.add((Component)this.getData2ScrollPane(), gridBagConstraints11);
            this.torucaInfoPanel.add((Component)this.data3Label, gridBagConstraints7);
            this.torucaInfoPanel.add((Component)this.getData3Info(), gridBagConstraints10);
            this.torucaInfoPanel.add((Component)this.bodyLabel, gridBagConstraints6);
            this.torucaInfoPanel.add((Component)this.getBodyScrollPane(), gridBagConstraints5);
            this.torucaInfoPanel.add((Component)this.typeLabel, gridBagConstraints4);
            this.torucaInfoPanel.add((Component)this.categoryLabel, gridBagConstraints3);
            this.torucaInfoPanel.add((Component)this.typeInfo, gridBagConstraints);
            this.torucaInfoPanel.add((Component)this.categoryInfo, gridBagConstraints2);
        }
        return this.torucaInfoPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getToruCaTable());
            this.jScrollPane.setPreferredSize(new Dimension(400, 120));
        }
        return this.jScrollPane;
    }

    private JTable getToruCaTable() {
        if (this.torucaTable == null) {
            this.torucaTable = new ToruCaTable(this);
        }
        this.torucaTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    ToruCaManageWindow.this.edit();
                }
            }
        });
        this.torucaTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ToruCaManageWindow.this.edit();
                }
            }
        });
        return this.torucaTable;
    }

    private JTextField getUrlInfo() {
        if (this.urlInfo == null) {
            this.urlInfo = new JTextField(30);
            this.urlInfo.setEditable(false);
        }
        return this.urlInfo;
    }

    private JTextField getData1Info() {
        if (this.data1Info == null) {
            this.data1Info = new JTextField(30);
            this.data1Info.setEditable(false);
        }
        return this.data1Info;
    }

    private JScrollPane getData2ScrollPane() {
        if (this.data2ScrollPane == null) {
            this.data2ScrollPane = new JScrollPane();
            this.data2ScrollPane.setViewportView(this.getData2Info());
            this.data2ScrollPane.setPreferredSize(this.data2ScrollPane.getPreferredSize());
        }
        return this.data2ScrollPane;
    }

    private JTextArea getData2Info() {
        if (this.data2Info == null) {
            this.data2Info = new JTextArea(3, 30);
            this.data2Info.setEditable(false);
            this.data2Info.setBackground(new ColorUIResource(236, 233, 216));
        }
        return this.data2Info;
    }

    private JTextField getData3Info() {
        if (this.data3Info == null) {
            this.data3Info = new JTextField(30);
            this.data3Info.setEditable(false);
        }
        return this.data3Info;
    }

    private JScrollPane getBodyScrollPane() {
        if (this.bodyScrollPane == null) {
            this.bodyScrollPane = new JScrollPane();
            this.bodyScrollPane.setViewportView(this.getBodyTextArea());
            this.bodyScrollPane.setPreferredSize(this.bodyScrollPane.getPreferredSize());
        }
        return this.bodyScrollPane;
    }

    private JTextArea getBodyTextArea() {
        if (this.bodyTextArea == null) {
            this.bodyTextArea = new JTextArea(6, 30);
            this.bodyTextArea.setEditable(false);
            this.bodyTextArea.setBackground(new ColorUIResource(236, 233, 216));
        }
        return this.bodyTextArea;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(5);
            gridLayout.setVgap(2);
            gridLayout.setHgap(0);
            gridLayout.setColumns(1);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(gridLayout);
            this.buttonPanel.add((Component)this.getAddButton(), null);
            this.buttonPanel.add((Component)this.getEditButton(), null);
            this.buttonPanel.add((Component)this.getDeleteButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText(Resource.getString("ADD"));
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToruCaManageWindow.this.add();
                }
            });
        }
        return this.addButton;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText(Resource.getString("EDIT"));
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToruCaManageWindow.this.edit();
                }
            });
        }
        return this.editButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton();
            this.deleteButton.setText(Resource.getString("DELETE"));
            this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToruCaManageWindow.this.delete();
                }
            });
        }
        return this.deleteButton;
    }

    private void add() {
        ToruCaEntity toruCaEntity = new ToruCaEntity();
        int n = 1;
        if (this.idList.length > 0) {
            n = this.idList[this.idList.length - 1] + 1;
        }
        toruCaEntity.setEntryID(n);
        ToruCaEditDialog toruCaEditDialog = new ToruCaEditDialog(this.parent, toruCaEntity, Resource.getString("TORUCA_ADD_TITLE"));
        toruCaEditDialog.setLocation(this.parent.getShowLocation(toruCaEditDialog.getWidth(), toruCaEditDialog.getHeight(), this.tabwin));
        toruCaEditDialog.setVisible(true);
        this.loadTableData();
    }

    private void edit() {
        int n = this.torucaTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        ToruCaEntity toruCaEntity = (ToruCaEntity)this.toruCaHash.get(new Integer(this.idList[n]));
        ToruCaEditDialog toruCaEditDialog = new ToruCaEditDialog(this.parent, toruCaEntity, Resource.getString("TORUCA_EDIT_TITLE"));
        toruCaEditDialog.setLocation(this.parent.getShowLocation(toruCaEditDialog.getWidth(), toruCaEditDialog.getHeight(), this.tabwin));
        toruCaEditDialog.setVisible(true);
        this.loadTableData();
    }

    private void delete() {
        int n = this.torucaTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        int n2 = JOptionPane.showConfirmDialog(this, Resource.getString("TORUCA_DELETE_WNG"), Resource.getString("CONFIRM"), 0);
        if (n2 == 0) {
            ToruCaEntity toruCaEntity = (ToruCaEntity)this.toruCaHash.get(new Integer(this.idList[n]));
            toruCaEntity.remove(ToruCaEntity.entryNum2fName(toruCaEntity.getEntryID()));
            this.loadTableData();
        }
    }

    void cancel() {
    }

    boolean set() {
        return true;
    }

    private void loadTableData() {
        Object object;
        this.toruCaHash = new Hashtable();
        String[] stringArray = new File(ToruCaEntity.TORUCA_DIR).list(new ToruCaFilter());
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    ToruCaEntity toruCaEntity = new ToruCaEntity();
                    toruCaEntity.setEntryID(ToruCaEntity.fName2entryNum(stringArray[i]));
                    toruCaEntity.load(stringArray[i]);
                    this.toruCaHash.put(new Integer(toruCaEntity.getEntryID()), toruCaEntity);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.idList = new int[this.toruCaHash.size()];
        Enumeration enumeration = this.toruCaHash.keys();
        for (int i = 0; i < this.idList.length; ++i) {
            this.idList[i] = (Integer)enumeration.nextElement();
        }
        Arrays.sort(this.idList);
        ToruCaModel toruCaModel = new ToruCaModel();
        for (int i = 0; i < this.idList.length; ++i) {
            object = (ToruCaEntity)this.toruCaHash.get(new Integer(this.idList[i]));
            toruCaModel.addRow(((ToruCaEntity)object).getRowData());
        }
        this.getToruCaTable().setModel(toruCaModel);
        TableColumn tableColumn = this.getToruCaTable().getColumnModel().getColumn(0);
        tableColumn.setMinWidth(60);
        tableColumn.setMaxWidth(60);
        tableColumn.setResizable(false);
        object = this.getToruCaTable().getColumnModel().getColumn(1);
        ((TableColumn)object).setMinWidth(60);
        ((TableColumn)object).setMaxWidth(60);
        ((TableColumn)object).setResizable(false);
        this.updateButtonEnabled();
        this.clearInfo();
    }

    protected void display() {
        int n = this.torucaTable.getSelectedRow();
        if (n == -1) {
            this.clearInfo();
            return;
        }
        if (this.idList.length < 1) {
            this.clearInfo();
            return;
        }
        ToruCaEntity toruCaEntity = (ToruCaEntity)this.toruCaHash.get(new Integer(this.idList[n]));
        this.typeInfo.setText(toruCaEntity.getTypeName());
        this.categoryInfo.setText(toruCaEntity.getCategory());
        this.urlInfo.setText(toruCaEntity.getURL());
        this.urlInfo.setCaretPosition(0);
        this.data1Info.setText(toruCaEntity.getData1());
        this.data1Info.setCaretPosition(0);
        this.data2Info.setText(toruCaEntity.getData2());
        this.data2Info.setCaretPosition(0);
        this.data3Info.setText(toruCaEntity.getData3());
        this.data3Info.setCaretPosition(0);
        this.bodyTextArea.setText(toruCaEntity.getBody());
        this.bodyTextArea.setCaretPosition(0);
    }

    protected void clearInfo() {
        this.typeInfo.setText("");
        this.categoryInfo.setText("");
        this.urlInfo.setText("");
        this.data1Info.setText("");
        this.data2Info.setText("");
        this.data3Info.setText("");
        this.bodyTextArea.setText("");
    }

    private void updateButtonEnabled() {
        if (this.torucaTable.getRowCount() >= 1) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ToruCaTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ToruCaTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    private static class ToruCaFilter
    implements FilenameFilter {
        private ToruCaFilter() {
        }

        public boolean accept(File file, String string) {
            if (file.equals(new File(ToruCaEntity.TORUCA_DIR))) {
                return string.endsWith(".dat");
            }
            return false;
        }
    }

    private class ToruCaModel
    extends DefaultTableModel {
        public ToruCaModel() {
            super(new String[]{Resource.getString("TORUCA_TYPE"), Resource.getString("TORUCA_CAT"), Resource.getString("TORUCA_URL"), Resource.getString("TORUCA_DATA1")}, 0);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private class ToruCaTable
    extends JTable {
        ToruCaManageWindow parentWindow;

        public ToruCaTable(ToruCaManageWindow toruCaManageWindow2) {
            this.parentWindow = toruCaManageWindow2;
            this.initialize();
        }

        private void initialize() {
            this.setSize(new Dimension(300, 240));
            this.setCellSelectionEnabled(true);
            this.setRowSelectionAllowed(true);
            this.setSelectionMode(0);
            this.setColumnSelectionAllowed(false);
            this.setAutoResizeMode(2);
            this.setShowGrid(true);
            this.setEnabled(true);
            this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ToruCaManageWindow.class$("java.lang.Object")) : class$java$lang$Object, new ToruCaTableCellRenderer());
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setReorderingAllowed(false);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            super.valueChanged(listSelectionEvent);
            if (this.parentWindow != null) {
                this.parentWindow.display();
            }
        }
    }
}

