/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ImportException;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.StringChecker;

class VerifyGestureTekData {
    static final int TYPE_ROLL = 0;
    static final int TYPE_SHAKE = 1;
    private static final int INDEX_DIR_X = 0;
    private static final int INDEX_DIR_Y = 1;
    private static final int INDEX_QUALITY = 2;
    private static final int INDEX_SHAKE = 0;

    VerifyGestureTekData() {
    }

    static void verify(String[] stringArray, int n) throws ImportException {
        if (n == 0 && stringArray.length != 3 || n == 1 && stringArray.length != 1) {
            throw new ImportException(-1, 1, Resource.getString("IMPORT_EMES_INVALID_VALUE_NUM"));
        }
        if (n == 0) {
            VerifyGestureTekData.verifyRoll(stringArray[0], 0);
            VerifyGestureTekData.verifyRoll(stringArray[1], 1);
            VerifyGestureTekData.verifyQuality(stringArray[2], 2);
        } else {
            VerifyGestureTekData.verifyShake(stringArray[0], 0);
        }
    }

    static String[] adjust(String[] stringArray, int n) {
        String[] stringArray2 = new String[stringArray.length];
        if (n == 0) {
            stringArray2[0] = VerifyGestureTekData.adjustRoll(stringArray[0], 0);
            stringArray2[1] = VerifyGestureTekData.adjustRoll(stringArray[1], 1);
            stringArray2[2] = VerifyGestureTekData.adjustQuality(stringArray[2], 2);
        } else {
            stringArray2[0] = VerifyGestureTekData.adjustShake(stringArray[0], 0);
        }
        return stringArray2;
    }

    private static void verifyRoll(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        long l = 0L;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n2 > 11) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!new StringChecker(string.trim()).isAscii()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (l < Integer.MIN_VALUE || Integer.MAX_VALUE < l) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustRoll(String string, int n) {
        return VerifyGestureTekData.zeroSuppress(string);
    }

    private static void verifyQuality(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        int n3 = 0;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n2 > 1) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!new StringChecker(string.trim()).isHalfNumber()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        try {
            n3 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (n3 < 0 || 3 < n3) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustQuality(String string, int n) {
        return VerifyGestureTekData.zeroSuppress(string);
    }

    private static void verifyShake(String string, int n) throws ImportException {
        int n2 = string.trim().length();
        int n3 = 0;
        if (n2 <= 0) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_NONE_VALUE"));
        }
        if (n2 > 3) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_STRING_NUM_OVER"));
        }
        if (!new StringChecker(string.trim()).isHalfNumber()) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        try {
            n3 = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException(n, 1, Resource.getString("IMPORT_EMES_INVALID_FORMAT"));
        }
        if (n3 < 0 || 511 < n3) {
            throw new ImportException(n, 2, Resource.getString("IMPORT_EMES_VALUE_OUTSIDE_RANGE"));
        }
    }

    private static String adjustShake(String string, int n) {
        return VerifyGestureTekData.zeroSuppress(string);
    }

    private static String zeroSuppress(String string) {
        int n;
        boolean bl = false;
        String string2 = string.trim();
        char[] cArray = string2.toCharArray();
        for (n = 0; n < cArray.length - 1; ++n) {
            if (n == 0 && cArray[n] == '-') {
                bl = true;
                continue;
            }
            if (cArray[n] != '0') break;
        }
        return (bl ? "-" : "") + string2.substring(n, cArray.length);
    }
}

