/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.FeliCaFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.HostInfoDocument;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class VirtualFeliCaSettingWindow
extends TabPanel
implements DocumentListener {
    private JPanel mainContainer = null;
    private JPanel serverSettingPanel = null;
    private JPanel listenSettingPanel = null;
    private JPanel chipSettingPanel = null;
    private JLabel felicaFilePathLabel = null;
    private JTextField felicaFilePathInfo = null;
    private JButton fileChooserButton = null;
    private JLabel chipVersionLabel = null;
    private JComboBox chipVersionList = null;
    private JPanel portPanel = null;
    private JLabel listenPortLabel = null;
    private JTextField listenPortInfo = null;
    private JPanel connectHostPanel = null;
    private JPanel connectPortPanel = null;
    private JLabel hostLabel = null;
    private JTextField hostInfo = null;
    private JLabel portLabel = null;
    private JTextField portInfo = null;
    private String fcFilePath;
    private final String[] VERSION_ITEMS = new String[2];
    private final int TAB_WIDTH = 350;
    private static final int TYPE_NOT_INPUT = 0;
    private static final int TYPE_INVALID_FORMAT = 1;
    private AbstractWindow tabwin;
    private static final String DEFAULT_PATH = "external.fc";
    private int emuFelicaDiv;

    public VirtualFeliCaSettingWindow(AbstractWindow abstractWindow, int n) {
        super(abstractWindow);
        this.tabwin = abstractWindow;
        this.emuFelicaDiv = n;
        this.VERSION_ITEMS[0] = Resource.getString("SET_FELICA_CHIP_VER1");
        this.VERSION_ITEMS[1] = Resource.getString("SET_FELICA_CHIP_VER2");
        this.initialize();
        this.loadValue();
    }

    private void loadValue() {
        String string = "";
        this.hostInfo.setText(JAMManager.getFeliCaServerHost());
        int n = JAMManager.getFeliCaServerPort();
        if (n != -1) {
            string = "" + n;
        }
        this.portInfo.setText(string);
        n = JAMManager.getFeliCaListenPort();
        string = n != -1 ? "" + n : "";
        this.listenPortInfo.setText(string);
        if (this.emuFelicaDiv != 4) {
            this.fcFilePath = new String(JAMManager.getFeliCaDataFilePath());
            if (this.fcFilePath == null || "".equals(this.fcFilePath)) {
                this.fcFilePath = System.getProperty("emu.home") + File.separator + "lib" + File.separator + DEFAULT_PATH;
                String string2 = this.fcFilePath + '\u0000';
                JAMManager.setFeliCaDataFilePath(string2.getBytes());
            }
            this.felicaFilePathInfo.setText(this.fcFilePath);
            this.felicaFilePathInfo.getDocument().addDocumentListener(this);
        }
        if ((n = JAMManager.getFeliCaChipVersion()) == -1) {
            n = 0;
        }
        this.chipVersionList.setSelectedIndex(n);
        this.listenPortInfo.getDocument().addDocumentListener(this);
        this.hostInfo.getDocument().addDocumentListener(this);
        this.portInfo.getDocument().addDocumentListener(this);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    boolean set() {
        int n = 0;
        boolean bl = true;
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("SET_FELICA_WNG_APP_RUNNING"), this.tabwin, 2);
            return false;
        }
        if (!this.doValidate()) {
            return false;
        }
        try {
            String string = this.hostInfo.getText();
            int n2 = Integer.parseInt(this.portInfo.getText());
            n = JAMManager.setFeliCaServerInfo(string, n2);
            int n3 = Integer.parseInt(this.listenPortInfo.getText());
            if (this.emuFelicaDiv != 4) {
                String string2 = this.felicaFilePathInfo.getText() + '\u0000';
                n = JAMManager.setFeliCaDataFilePath(string2.getBytes());
            }
            n = JAMManager.setFeliCaListenPort(n3);
            int n4 = this.chipVersionList.getSelectedIndex();
            n = JAMManager.setFeliCaChipVersion(n4);
            if (n != 0) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            this.parent.showDialog(Resource.getString("REGISTRY_ERR"), this, 0);
        }
        return true;
    }

    private boolean doValidate() {
        String string = null;
        string = this.hostInfo.getText();
        if (!this.checkInput(string)) {
            this.showDialog(0);
            return false;
        }
        if (!VirtualFeliCaSettingWindow.checkHalf(string)) {
            this.showDialog(1);
            return false;
        }
        string = this.portInfo.getText();
        if (!this.checkInput(string)) {
            this.showDialog(0);
            return false;
        }
        if (!VirtualFeliCaSettingWindow.checkNumber(string)) {
            this.showDialog(1);
            return false;
        }
        string = this.listenPortInfo.getText();
        if (!this.checkInput(string)) {
            this.showDialog(0);
            return false;
        }
        if (!VirtualFeliCaSettingWindow.checkNumber(string)) {
            this.showDialog(1);
            return false;
        }
        if (this.emuFelicaDiv != 4 && !this.checkInput(string = this.felicaFilePathInfo.getText())) {
            this.showDialog(0);
            return false;
        }
        return true;
    }

    private void showDialog(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = Resource.getString("SET_FELICA_WNG_NOT_INPUT");
                break;
            }
            case 1: {
                string = Resource.getString("SET_FELICA_WNG_INVALID_INPUT");
                break;
            }
            default: {
                string = "";
            }
        }
        JOptionPane.showMessageDialog(this.tabwin, string, Resource.getString("WNG"), 2);
    }

    void cancel() {
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainContainer(), "North");
    }

    private JPanel getMainContainer() {
        if (this.mainContainer == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.ipady = 0;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.anchor = 10;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.ipadx = 0;
            gridBagConstraints3.ipady = 0;
            gridBagConstraints3.anchor = 11;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.weightx = 0.5;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.gridheight = 1;
            gridBagConstraints3.gridy = 0;
            this.mainContainer = new JPanel();
            this.mainContainer.setLayout(new GridBagLayout());
            this.mainContainer.add((Component)this.getServerSettingPanel(), gridBagConstraints3);
            this.mainContainer.add((Component)this.getListenSettingPanel(), gridBagConstraints2);
            this.mainContainer.add((Component)this.getChipSettingPanel(), gridBagConstraints);
        }
        return this.mainContainer;
    }

    private JPanel getServerSettingPanel() {
        if (this.serverSettingPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.fill = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.gridwidth = 4;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.weightx = 0.1;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints2.anchor = 17;
            this.serverSettingPanel = new JPanel();
            this.serverSettingPanel.setLayout(new GridBagLayout());
            if (this.emuFelicaDiv == 4) {
                this.serverSettingPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("SET_FELICA_ADHOC_CLIENT_TITLE"), 0, 0, null, null));
            } else {
                this.serverSettingPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("SET_FELICA_EXT_ADHOC_CLIENT_TITLE"), 0, 0, null, null));
                this.serverSettingPanel.setPreferredSize(new Dimension(350, 100));
            }
            this.serverSettingPanel.add((Component)this.getConnectHostPanel(), gridBagConstraints2);
            this.serverSettingPanel.add((Component)this.getConnectPortPanel(), gridBagConstraints);
        }
        return this.serverSettingPanel;
    }

    private JPanel getListenSettingPanel() {
        if (this.listenSettingPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.anchor = 17;
            if (this.emuFelicaDiv == 4) {
                gridBagConstraints.ipadx = 350;
            }
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(0, 2, 2, 2);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints4.weightx = 1.0;
            this.felicaFilePathLabel = new JLabel();
            this.felicaFilePathLabel.setText(Resource.getString("SET_FELICA_EXT_ADHOC_SERVER_FILEPATH"));
            this.listenSettingPanel = new JPanel();
            this.listenSettingPanel.setLayout(new GridBagLayout());
            if (this.emuFelicaDiv == 4) {
                this.listenSettingPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("SET_FELICA_ADHOC_SERVER_TITLE"), 0, 0, null, null));
            } else {
                this.listenSettingPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("SET_FELICA_EXT_ADHOC_SERVER_TITLE"), 0, 0, null, null));
                this.listenSettingPanel.setPreferredSize(new Dimension(350, 100));
            }
            if (this.emuFelicaDiv != 4) {
                this.listenSettingPanel.add((Component)this.felicaFilePathLabel, gridBagConstraints3);
                this.listenSettingPanel.add((Component)this.getFelicaFilePathInfo(), gridBagConstraints4);
                this.listenSettingPanel.add((Component)this.getFileChooserButton(), gridBagConstraints2);
            }
            this.listenSettingPanel.add((Component)this.getPortPanel(), gridBagConstraints);
        }
        return this.listenSettingPanel;
    }

    private JPanel getChipSettingPanel() {
        if (this.chipSettingPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 3, 5, 56);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 5, 0, 2);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 10;
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridx = 0;
            this.chipVersionLabel = new JLabel();
            this.chipVersionLabel.setText(Resource.getString("SET_FELICA_CHIP_VERSION"));
            this.chipSettingPanel = new JPanel();
            this.chipSettingPanel.setLayout(new GridBagLayout());
            this.chipSettingPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getString("SET_FELICA_CHIPSET_TITLE"), 0, 0, null, null));
            this.chipSettingPanel.setPreferredSize(new Dimension(350, 61));
            this.chipSettingPanel.add((Component)this.chipVersionLabel, gridBagConstraints2);
            this.chipSettingPanel.add((Component)this.getChipVersionList(), gridBagConstraints);
        }
        return this.chipSettingPanel;
    }

    private JTextField getFelicaFilePathInfo() {
        if (this.felicaFilePathInfo == null) {
            this.felicaFilePathInfo = new JTextField();
            this.felicaFilePathInfo.setColumns(22);
        }
        return this.felicaFilePathInfo;
    }

    private JButton getFileChooserButton() {
        if (this.fileChooserButton == null) {
            this.fileChooserButton = new JButton();
            this.fileChooserButton.setText(Resource.getString("SET_FELICA_EXT_ADHOC_SERVER_REF_BUTTON"));
            this.fileChooserButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(new File(VirtualFeliCaSettingWindow.this.fcFilePath).getParent());
                    jFileChooser.setDialogTitle(Resource.getString("FELICA_DATAFILE_DIALOG"));
                    jFileChooser.setDialogType(0);
                    jFileChooser.setFileSelectionMode(2);
                    jFileChooser.setFileFilter(new FeliCaFileFilter());
                    jFileChooser.setMultiSelectionEnabled(false);
                    int n = jFileChooser.showOpenDialog(VirtualFeliCaSettingWindow.this);
                    if (n == 0) {
                        VirtualFeliCaSettingWindow.this.felicaFilePathInfo.setText(jFileChooser.getSelectedFile().toString());
                    }
                }
            });
        }
        return this.fileChooserButton;
    }

    private JComboBox getChipVersionList() {
        if (this.chipVersionList == null) {
            this.chipVersionList = new JComboBox<String>(this.VERSION_ITEMS);
            this.chipVersionList.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (VirtualFeliCaSettingWindow.this.listener != null) {
                        VirtualFeliCaSettingWindow.this.listener.tabPanelEvent(VirtualFeliCaSettingWindow.this, 1, 0);
                    }
                }
            });
        }
        return this.chipVersionList;
    }

    private JPanel getPortPanel() {
        if (this.portPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.listenPortLabel = new JLabel();
            this.listenPortLabel.setText(Resource.getString("SET_FELICA_EXT_ADHOC_SERVER_PORT"));
            this.portPanel = new JPanel();
            this.portPanel.setLayout(flowLayout);
            this.portPanel.add((Component)this.listenPortLabel, null);
            this.portPanel.add((Component)this.getListenPortInfo(), null);
        }
        return this.portPanel;
    }

    private JTextField getListenPortInfo() {
        if (this.listenPortInfo == null) {
            this.listenPortInfo = new JTextField();
            this.listenPortInfo.setColumns(5);
            this.listenPortInfo.setDocument(new HalfNumberDocument(5));
        }
        return this.listenPortInfo;
    }

    private JPanel getConnectHostPanel() {
        if (this.connectHostPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.hostLabel = new JLabel();
            this.hostLabel.setText(Resource.getString("SET_FELICA_EXT_ADHOC_CLIENT_HOST"));
            this.connectHostPanel = new JPanel();
            this.connectHostPanel.setLayout(flowLayout);
            this.connectHostPanel.setPreferredSize(new Dimension(200, 30));
            this.connectHostPanel.add((Component)this.hostLabel, null);
            this.connectHostPanel.add((Component)this.getHostInfo(), null);
        }
        return this.connectHostPanel;
    }

    private JPanel getConnectPortPanel() {
        if (this.connectPortPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.portLabel = new JLabel();
            this.portLabel.setText(Resource.getString("SET_FELICA_EXT_ADHOC_CLIENT_PORT"));
            this.connectPortPanel = new JPanel();
            this.connectPortPanel.setLayout(flowLayout);
            this.connectPortPanel.setPreferredSize(new Dimension(200, 30));
            this.connectPortPanel.add((Component)this.portLabel, null);
            this.connectPortPanel.add((Component)this.getPortInfo(), null);
        }
        return this.connectPortPanel;
    }

    private JTextField getHostInfo() {
        if (this.hostInfo == null) {
            this.hostInfo = new JTextField();
            this.hostInfo.setDocument(new HostInfoDocument(255));
            this.hostInfo.setColumns(15);
        }
        return this.hostInfo;
    }

    private JTextField getPortInfo() {
        if (this.portInfo == null) {
            this.portInfo = new JTextField();
            this.portInfo.setColumns(5);
            this.portInfo.setDocument(new HalfNumberDocument(5));
        }
        return this.portInfo;
    }

    private static boolean checkNumber(String string) {
        boolean bl = false;
        try {
            int n = Integer.parseInt(string);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bl;
    }

    private static boolean checkHalf(String string) {
        byte[] byArray = string.getBytes();
        int n = string.length();
        return n == byArray.length;
    }

    public boolean checkInput(String string) {
        String string2;
        boolean bl = false;
        if (!(string == null && "".equals(string) || (string2 = string.trim()).equals(""))) {
            bl = true;
        }
        return bl;
    }

    public class LimitedDocument
    extends PlainDocument {
        int limit;

        LimitedDocument(int n) {
            this.limit = n;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) {
            if (this.getLength() >= this.limit) {
                return;
            }
            try {
                super.insertString(n, string, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                System.out.println(badLocationException);
            }
        }
    }
}

