/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.classFileStructure;

import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.JavaClass;
import java.util.Vector;

public class ConstantPool {
    private static final int CP_UTF8 = 1;
    private static final int CP_INTEGER = 3;
    private static final int CP_FLOAT = 4;
    private static final int CP_LONG = 5;
    private static final int CP_DOUBLE = 6;
    private static final int CP_CLASS = 7;
    private static final int CP_STRING = 8;
    private static final int CP_FIELD_REF = 9;
    private static final int CP_METHOD_REF = 10;
    private static final int CP_INTERFACE_METHOD_REF = 11;
    private static final int CP_NAME_AND_TYPE = 12;
    private static final String[] CP_NAMES = new String[]{"VM RESERVED", "CONSTANT_Utf8", "undefine", "CONSTANT_Integer", "CONSTANT_Float", "CONSTANT_Long", "CONSTANT_Double", "CONSTANT_Class", "CONSTANT_String", "CONSTANT_FieldRef", "CONSTANT_MethodRef", "CONSTANT_InterfaceMethodRef", "CONSTANT_NameAndType"};
    private int tag = 0;
    private Vector info = null;
    private JavaClass jc = null;

    private ConstantPool() {
    }

    ConstantPool(JavaClass javaClass) {
        this.jc = javaClass;
        this.info = new Vector();
        this.tag = this.jc.getBytes(1)[0];
        switch (this.tag) {
            case 1: {
                this.info.add(this.jc.getString(this.jc.getInt(2)));
                break;
            }
            case 3: {
                this.info.add(new Integer(this.jc.getInt(4)));
                break;
            }
            case 4: {
                this.info.add(new Float(this.jc.getFloat(4)));
                break;
            }
            case 5: {
                this.info.add(new Long(this.jc.getLong(8)));
                break;
            }
            case 6: {
                this.info.add(new Double(this.jc.getDouble(8)));
                break;
            }
            case 7: {
                this.info.add(new Integer(this.jc.getInt(2)));
                break;
            }
            case 8: {
                this.info.add(new Integer(this.jc.getInt(2)));
                break;
            }
            case 9: {
                this.info.add(new Integer(this.jc.getInt(2)));
                this.info.add(new Integer(this.jc.getInt(2)));
                break;
            }
            case 10: {
                this.info.add(new Integer(this.jc.getInt(2)));
                this.info.add(new Integer(this.jc.getInt(2)));
                break;
            }
            case 11: {
                this.info.add(new Integer(this.jc.getInt(2)));
                this.info.add(new Integer(this.jc.getInt(2)));
                break;
            }
            case 12: {
                this.info.add(new Integer(this.jc.getInt(2)));
                this.info.add(new Integer(this.jc.getInt(2)));
                break;
            }
        }
    }

    public int getTag() {
        return this.tag;
    }

    public String getDetailString() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.tag) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.info.get(0).toString();
            }
            case 7: {
                n = (Integer)this.info.get(0);
                return this.jc.getConstantPoolInfo(n);
            }
            case 8: {
                n = (Integer)this.info.get(0);
                return "\"" + this.jc.getConstantPoolInfo(n) + "\"";
            }
            case 9: 
            case 10: 
            case 11: {
                n = (Integer)this.info.get(0);
                stringBuffer.append(this.jc.getConstantPoolInfo(n) + ".");
                n = (Integer)this.info.get(1);
                stringBuffer.append(this.jc.getConstantPoolInfo(n));
                return stringBuffer.toString();
            }
            case 12: {
                n = (Integer)this.info.get(0);
                stringBuffer.append(this.jc.getConstantPoolInfo(n) + " ");
                n = (Integer)this.info.get(1);
                stringBuffer.append(this.jc.getConstantPoolInfo(n));
                return stringBuffer.toString();
            }
        }
        return null;
    }

    public Vector getDetailArray() {
        int n = 0;
        Vector<String> vector = new Vector<String>();
        switch (this.tag) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                vector.add(this.info.get(0).toString());
                break;
            }
            case 7: {
                n = (Integer)this.info.get(0);
                vector.addAll(this.jc.getConstantPool(n).getDetailArray());
                break;
            }
            case 8: {
                n = (Integer)this.info.get(0);
                vector.addAll(this.jc.getConstantPool(n).getDetailArray());
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n = (Integer)this.info.get(0);
                vector.addAll(this.jc.getConstantPool(n).getDetailArray());
                n = (Integer)this.info.get(1);
                vector.addAll(this.jc.getConstantPool(n).getDetailArray());
                break;
            }
            case 12: {
                n = (Integer)this.info.get(0);
                vector.addAll(this.jc.getConstantPool(n).getDetailArray());
                n = (Integer)this.info.get(1);
                vector.addAll(this.jc.getConstantPool(n).getDetailArray());
            }
        }
        return vector;
    }
}

