/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica;

import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipData;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipFactory;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewButtonListener;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewColor;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewDocument;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewPane;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewPopup;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewWindowAdapter;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerLabelController;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerLabelInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FaverChipViewer
extends JFrame {
    private final int FAVER_VIEW_COLUMN = 16;
    static final int BYTE_PER_ROW = 16;
    private FaverChipViewPane fcTextPane;
    private FaverChipViewDocument doc;
    private FaverChipData fcd;
    private MainWindow parent = null;
    private File fcFile = null;
    private JComboBox areaBox;
    private JButton updateButton;
    private JButton reloadButton;
    private JButton closeButton;
    private FaverChipViewPopup rightClickMenu;
    private ComboActionListener comboListener;
    private TextPaneKeyListener textPaneListener;
    FaverChipViewerBlock[] blocks;
    private FaverChipViewerLabelInfo[] labels;
    private FaverChipViewerLabelController lblctrl;
    private int felicaEmuDiv;
    private FaverChipViewColor fcColor;
    private String chipVersion;

    public FaverChipViewer(MainWindow mainWindow, File file, int n, int n2) throws FileNotFoundException, IOException {
        this.parent = mainWindow;
        this.fcFile = file;
        this.felicaEmuDiv = n;
        this.chipVersion = n2 == 1 ? "ver20" : "ver10";
        this.makeFaverChipViewer();
    }

    private synchronized void makeFaverChipViewer() throws FileNotFoundException, IOException {
        this.setTitle(Resource.getString("FC_WINDOW_TITLE") + " - " + this.fcFile.getName());
        this.fcd = FaverChipFactory.create(this.fcFile, this.chipVersion, this.felicaEmuDiv);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.areaBox = new JComboBox();
        String[] stringArray = this.fcd.getBlockName();
        for (int i = 0; i < stringArray.length; ++i) {
            this.areaBox.addItem(stringArray[i]);
        }
        this.doc = new FaverChipViewDocument();
        this.fcTextPane = new FaverChipViewPane(this.doc);
        this.fcTextPane.setFont(new Font("monospaced", 0, 14));
        this.fcTextPane.setEditable(true);
        this.fcTextPane.setBackground(Color.black);
        this.fcTextPane.setForeground(Color.lightGray);
        this.updateButton = new JButton(Resource.getString("UPDATE"));
        this.reloadButton = new JButton(Resource.getString("RELOAD"));
        this.closeButton = new JButton(Resource.getString("CLOSE"));
        this.updateButton.setActionCommand("update");
        this.reloadButton.setActionCommand("reload");
        this.closeButton.setActionCommand("close");
        JScrollPane jScrollPane = new JScrollPane(this.fcTextPane);
        JPanel jPanel = new JPanel();
        jPanel.add(this.updateButton);
        jPanel.add(this.reloadButton);
        jPanel.add(this.closeButton);
        container.add("North", this.areaBox);
        container.add("Center", jScrollPane);
        container.add("South", jPanel);
        this.labels = this.fcd.getLabelInfo();
        this.blocks = this.fcd.getBlockInfo();
        StringBuffer[] stringBufferArray = new StringBuffer[this.fcd.realDataSize / 16];
        this.lblctrl = new FaverChipViewerLabelController(this.doc, this.labels, stringBufferArray, this.fcTextPane);
        this.lblctrl.initViewLines(this.fcd);
        this.lblctrl.setDataToView();
        this.fcColor = new FaverChipViewColor(this.doc, this.blocks, this.fcTextPane, this.fcd.realDataSize);
        this.comboListener = new ComboActionListener();
        this.rightClickMenu = FaverChipFactory.createPopup(this.chipVersion, this.fcd, this.blocks, this.labels, this.fcColor, this.fcTextPane, this.doc);
        FaverChipViewButtonListener faverChipViewButtonListener = new FaverChipViewButtonListener(this);
        this.addWindowListener(new FaverChipViewWindowAdapter(this));
        this.fcTextPane.addKeyListener(new TextPaneKeyListener());
        this.fcTextPane.addMouseListener(new TextPaneMouseListener());
        this.fcTextPane.setUnderLinePos(this.lblctrl.getLineString(0), 1);
        this.areaBox.addActionListener(this.comboListener);
        this.updateButton.addActionListener(faverChipViewButtonListener);
        this.reloadButton.addActionListener(faverChipViewButtonListener);
        this.closeButton.addActionListener(faverChipViewButtonListener);
        this.fcColor.coloring(this.labels);
        this.areaBox.setSelectedIndex(0);
        this.pack();
        this.setSize(500, 400);
    }

    void reload() {
        this.fcd = null;
        try {
            this.fcd = FaverChipFactory.create(this.fcFile, this.chipVersion, this.felicaEmuDiv);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fcd.resetBlockInfo(this.blocks);
        this.fcd.resetEditFlag(this.blocks);
        this.lblctrl.resetView(this.fcColor, this.fcd);
        this.rightClickMenu = FaverChipFactory.createPopup(this.chipVersion, this.fcd, this.blocks, this.labels, this.fcColor, this.fcTextPane, this.doc);
        this.fcColor.coloring(this.labels);
    }

    void close() {
        this.parent.closeWindow(this);
    }

    void update() {
        try {
            this.fcd.update(this.lblctrl.viewStrToHexStr(), this.fcd.getBlockToByte(this.blocks));
            if (this.felicaEmuDiv != 4) {
                if (this.fcd.editflag) {
                    if (!this.fcd.verification()) {
                        return;
                    }
                    this.fcd.setSaveData();
                    this.fcd.save();
                    this.fcd.resetEditFlag(this.blocks);
                    this.fcd.editflag = false;
                    this.reload();
                }
            } else if (this.fcd.editflag) {
                this.fcd.save();
                this.fcd.resetEditFlag(this.blocks);
                this.fcd.editflag = false;
                this.reload();
                JOptionPane.showMessageDialog(this, Resource.getString("FC_SAVE_DIALOG_MESSAGE"), Resource.getString("CONFIRM"), 1);
            }
            this.fcColor.coloring(this.labels);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class TextPaneMouseListener
    implements MouseListener {
        TextPaneMouseListener() {
        }

        public synchronized void mouseReleased(MouseEvent mouseEvent) {
        }

        public synchronized void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 4) == 4) {
                int n = FaverChipViewer.this.fcTextPane.getCaretPosition();
                FaverChipViewer.this.rightClickMenu.setMenuItemEnabled(FaverChipViewPopup.MENUITEM_ALL, true);
                int n2 = FaverChipViewer.this.lblctrl.getLineNumber(n);
                if (((FaverChipViewer)FaverChipViewer.this).fcd.beginEditArea <= FaverChipViewer.this.blocks[n2].begin && FaverChipViewer.this.blocks[n2].begin <= ((FaverChipViewer)FaverChipViewer.this).fcd.endEditArea) {
                    switch (FaverChipViewer.this.blocks[n2].getBlockType()) {
                        case 0: {
                            FaverChipViewer.this.rightClickMenu.setMenuItemEnabled(FaverChipViewPopup.MENUITEM_UNUSED, false);
                            break;
                        }
                        case 4: {
                            FaverChipViewer.this.rightClickMenu.setMenuItemEnabled(FaverChipViewPopup.MENUITEM_AREA, false);
                            break;
                        }
                        case 5: {
                            FaverChipViewer.this.rightClickMenu.setMenuItemEnabled(FaverChipViewPopup.MENUITEM_SERVICE, false);
                            break;
                        }
                        case 6: {
                            FaverChipViewer.this.rightClickMenu.setMenuItemEnabled(FaverChipViewPopup.MENUITEM_DATA, false);
                            break;
                        }
                    }
                } else {
                    FaverChipViewer.this.rightClickMenu.setMenuItemEnabled(FaverChipViewPopup.MENUITEM_AREA, false);
                    FaverChipViewer.this.rightClickMenu.setMenuItemEnabled(FaverChipViewPopup.MENUITEM_SERVICE, false);
                    FaverChipViewer.this.rightClickMenu.setMenuItemEnabled(FaverChipViewPopup.MENUITEM_DATA, false);
                    FaverChipViewer.this.rightClickMenu.setMenuItemEnabled(FaverChipViewPopup.MENUITEM_UNUSED, false);
                }
                if (FaverChipViewer.this.fcd.isEnabledRightClick()) {
                    FaverChipViewer.this.rightClickMenu.show(FaverChipViewer.this.fcTextPane, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = FaverChipViewer.this.fcTextPane.getCaretPosition();
            for (int i = FaverChipViewer.this.labels.length - 1; i >= 0; --i) {
                if (((FaverChipViewer)FaverChipViewer.this).labels[i].viewbeginpos > n || ((FaverChipViewer)FaverChipViewer.this).labels[i].viewendpos < n) continue;
                if (FaverChipViewer.this.areaBox.getSelectedIndex() != ((FaverChipViewer)FaverChipViewer.this).labels[i].labelIndex) {
                    FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                    FaverChipViewer.this.areaBox.setSelectedIndex(((FaverChipViewer)FaverChipViewer.this).labels[i].labelIndex);
                    FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                }
                FaverChipViewer.this.fcTextPane.setCaretPosition(n);
                FaverChipViewer.this.fcTextPane.setUnderY(n);
            }
            FaverChipViewer.this.fcTextPane.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }
    }

    class TextPaneKeyListener
    implements KeyListener {
        TextPaneKeyListener() {
        }

        public synchronized void keyPressed(KeyEvent keyEvent) {
            int n = FaverChipViewer.this.fcTextPane.getCaretPosition();
            int n2 = keyEvent.getKeyCode();
            char c = keyEvent.getKeyChar();
            int n3 = keyEvent.getModifiers();
            if (FaverChipViewer.this.rightClickMenu.isVisible()) {
                FaverChipViewer.this.rightClickMenu.setVisible(false);
                FaverChipViewer.this.rightClickMenu.setPopupMenuVisible(false);
            }
            if (n2 == 10) {
                for (int i = FaverChipViewer.this.labels.length - 1; i >= 0; --i) {
                    if (((FaverChipViewer)FaverChipViewer.this).labels[i].viewbeginpos > n || ((FaverChipViewer)FaverChipViewer.this).labels[i].viewendpos < n) continue;
                    if (n3 == 1) {
                        if (i > 0) {
                            FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                            FaverChipViewer.this.fcTextPane.setCaretPosition(((FaverChipViewer)FaverChipViewer.this).labels[i - 1].viewbeginpos);
                            FaverChipViewer.this.areaBox.setSelectedIndex(((FaverChipViewer)FaverChipViewer.this).labels[i - 1].labelIndex);
                            FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                            break;
                        }
                        FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                        FaverChipViewer.this.fcTextPane.setCaretPosition(((FaverChipViewer)FaverChipViewer.this).labels[((FaverChipViewer)FaverChipViewer.this).labels.length - 1].viewbeginpos);
                        FaverChipViewer.this.areaBox.setSelectedIndex(((FaverChipViewer)FaverChipViewer.this).labels[((FaverChipViewer)FaverChipViewer.this).labels.length - 1].labelIndex);
                        FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                        break;
                    }
                    if (i < FaverChipViewer.this.labels.length - 1) {
                        FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                        FaverChipViewer.this.fcTextPane.setCaretPosition(((FaverChipViewer)FaverChipViewer.this).labels[i + 1].viewbeginpos);
                        FaverChipViewer.this.areaBox.setSelectedIndex(((FaverChipViewer)FaverChipViewer.this).labels[i + 1].labelIndex);
                        FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                        break;
                    }
                    FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                    FaverChipViewer.this.fcTextPane.setCaretPosition(((FaverChipViewer)FaverChipViewer.this).labels[0].viewbeginpos);
                    FaverChipViewer.this.areaBox.setSelectedIndex(0);
                    FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                    break;
                }
                keyEvent.consume();
            } else if (n2 == 9) {
                if (n3 == 1) {
                    FaverChipViewer.this.areaBox.requestFocus();
                } else {
                    FaverChipViewer.this.closeButton.requestFocus();
                }
                keyEvent.consume();
            } else if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                ((FaverChipViewer)FaverChipViewer.this).fcd.editflag = true;
                FaverChipViewer.this.blocks[((FaverChipViewer)FaverChipViewer.this).lblctrl.getLineNumber((int)n)].editflag = true;
            }
            FaverChipViewer.this.fcTextPane.setUnderY(n);
            FaverChipViewer.this.fcTextPane.repaint();
        }

        public synchronized void keyReleased(KeyEvent keyEvent) {
            int n;
            block4: {
                block3: {
                    n = FaverChipViewer.this.fcTextPane.getCaretPosition();
                    int n2 = keyEvent.getKeyCode();
                    if (n2 == 37) break block3;
                    if (n2 == 39) break block3;
                    if (n2 == 38) break block3;
                    if (n2 == 40) break block3;
                    if (n2 == 33) break block3;
                    if (n2 == 34) break block3;
                    if (n2 == 36) break block3;
                    if (n2 != 35) break block4;
                }
                for (int i = FaverChipViewer.this.labels.length - 1; i >= 0; --i) {
                    if (((FaverChipViewer)FaverChipViewer.this).labels[i].viewbeginpos > n || ((FaverChipViewer)FaverChipViewer.this).labels[i].viewendpos < n) continue;
                    FaverChipViewer.this.areaBox.removeActionListener(FaverChipViewer.this.comboListener);
                    FaverChipViewer.this.areaBox.setSelectedIndex(((FaverChipViewer)FaverChipViewer.this).labels[i].labelIndex);
                    FaverChipViewer.this.areaBox.addActionListener(FaverChipViewer.this.comboListener);
                }
            }
            FaverChipViewer.this.fcTextPane.setCaretPosition(n);
            FaverChipViewer.this.fcTextPane.setUnderY(n);
            FaverChipViewer.this.fcTextPane.repaint();
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    class ComboActionListener
    implements ActionListener {
        ComboActionListener() {
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            int n = FaverChipViewer.this.areaBox.getSelectedIndex();
            if (FaverChipViewer.this.rightClickMenu.isVisible()) {
                FaverChipViewer.this.rightClickMenu.setVisible(false);
                FaverChipViewer.this.rightClickMenu.setPopupMenuVisible(false);
            }
            for (int i = 0; i < FaverChipViewer.this.labels.length; ++i) {
                if (((FaverChipViewer)FaverChipViewer.this).labels[i].labelIndex != n) continue;
                FaverChipViewer.this.fcTextPane.setCaretPosition(((FaverChipViewer)FaverChipViewer.this).labels[i].viewbeginpos);
                FaverChipViewer.this.fcTextPane.setUnderY(((FaverChipViewer)FaverChipViewer.this).labels[i].viewbeginpos);
                break;
            }
            FaverChipViewer.this.fcTextPane.repaint();
        }
    }
}

