/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver10;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipBlockManager;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver10.FaverChipUserData;
import java.util.Vector;

class FaverChipCheck {
    private final String ERR_NOT_FIND_PARENT = "FC_ERR_NOT_FIND_PARENT";
    private final String ERR_INVALID_ATTR = "FC_ERR_INVALID_ATTR";
    private final String ERR_OVERLAP_CODE = "FC_ERR_OVERLAP_CODE";
    private final String ERR_INVALID_ENDCODE = "FC_ERR_INVALID_ENDCODE";
    private final String ERR_INVALID_BLOCK_NUM = "FC_ERR_INVALID_BLOCK_NUM";
    private final String ERR_INVALID_PIN_ATTR = "FC_ERR_INVALID_PIN_ATTR";
    private final String ERR_NO_SERVICE = "FC_ERR_NO_SERVICE";
    private final String ERR_NO_BELONG = "FC_ERR_NO_BELONG";
    private final String ERR_NO_USER_DATA = "FC_ERR_NO_USER_DATA";
    private final String ERR_DATA_BREAKS = "FC_ERR_DATA_BREAKS";
    private final String E_SV = "_SV";
    private final String E_AR = "_AR";
    private String errorMessage = null;
    private int detectPos = -1;
    private Vector vBlock = new Vector();
    private FaverChipBlockManager manager;

    FaverChipCheck(byte[] byArray) {
        this.manager = new FaverChipBlockManager(byArray);
        this.vBlock = this.manager.makeBlocks();
    }

    boolean verification() {
        boolean bl = true;
        this.detectPos = -1;
        this.errorMessage = null;
        if (!this.preCheckAreaOverlap()) {
            return false;
        }
        for (int i = 0; i < this.vBlock.size(); ++i) {
            FaverChipBlock faverChipBlock = (FaverChipBlock)this.vBlock.get(i);
            faverChipBlock.setInfo(0, 0, 4);
            switch (faverChipBlock.division) {
                case 4: {
                    if (i == 3 || i == 289) break;
                    bl = this.checkArea((FaverChipArea)faverChipBlock);
                    break;
                }
                case 5: {
                    bl = this.checkService((FaverChipService)faverChipBlock);
                    break;
                }
                case 6: {
                    bl = this.checkUserData((FaverChipUserData)faverChipBlock);
                    break;
                }
                case 0: {
                    break;
                }
            }
            if (bl) continue;
            if (this.errorMessage.equals("FC_ERR_DATA_BREAKS")) {
                this.detectPos = -1;
                break;
            }
            this.detectPos = i;
            break;
        }
        return bl;
    }

    byte[] getUpdatedData() {
        return this.manager.getFaverData();
    }

    private int getAccessMethod(FaverChipService faverChipService) {
        int n = 0;
        int n2 = faverChipService.code & 0x1F;
        if (8 <= n2 && n2 <= 11) {
            n = 1;
        } else if (12 <= n2 && n2 <= 15) {
            n = 2;
        } else if (16 <= n2 && n2 <= 23) {
            n = 3;
        }
        return n;
    }

    private boolean preCheckAreaOverlap() {
        Vector vector = this.manager.getAreaVector();
        for (int i = 0; i < vector.size(); ++i) {
            FaverChipArea faverChipArea = (FaverChipArea)vector.get(i);
            for (int j = i + 1; j < vector.size(); ++j) {
                FaverChipArea faverChipArea2 = (FaverChipArea)vector.get(j);
                if (!this.isBlockInTheSameArea(faverChipArea, faverChipArea2) || faverChipArea.code != faverChipArea2.code) continue;
                this.errorMessage = "FC_ERR_OVERLAP_CODE_AR";
                this.detectPos = faverChipArea.position == 3 || faverChipArea.position == 289 ? faverChipArea2.position : faverChipArea.position;
                return false;
            }
        }
        return true;
    }

    private boolean checkArea(FaverChipArea faverChipArea) {
        if (!this.checkCode(faverChipArea)) {
            return false;
        }
        if (!this.checkAttribute(faverChipArea)) {
            return false;
        }
        if (!this.checkCodeOverlap(faverChipArea)) {
            return false;
        }
        if (!this.checkEndServiceCode(faverChipArea)) {
            return false;
        }
        return this.checkAreaBlockNum(faverChipArea);
    }

    private boolean checkService(FaverChipService faverChipService) {
        boolean bl = true;
        if (!this.checkCode(faverChipService)) {
            return false;
        }
        if (!this.checkAttribute(faverChipService)) {
            return false;
        }
        if (!this.checkCodeOverlap(faverChipService)) {
            return false;
        }
        if ((faverChipService.code & 0x20) != 0) {
            FaverChipBlock faverChipBlock;
            int n = faverChipService.code;
            FaverChipService faverChipService2 = new FaverChipService(faverChipService.position, faverChipService.data, faverChipService.info);
            faverChipService2.code = faverChipService.code & 0xFFDF;
            if (this.checkCodeOverlap(faverChipService2)) {
                faverChipBlock = new FaverChipArea(faverChipService.position, faverChipService.data, faverChipService.info);
                ((FaverChipArea)faverChipBlock).code = faverChipService.code & 0xFFCD;
                if (this.checkCodeOverlap(faverChipBlock)) {
                    this.errorMessage = "FC_ERR_NO_SERVICE";
                    return false;
                }
            }
            faverChipBlock = (FaverChipBlock)this.vBlock.get(faverChipService.position + 1);
            if (faverChipBlock.division != 6) {
                this.errorMessage = "FC_ERR_NO_USER_DATA";
                return false;
            }
            faverChipBlock.parentCode = faverChipService.code;
        } else {
            int n = 0;
            block0: for (n = faverChipService.position + 1; n < this.vBlock.size(); ++n) {
                FaverChipBlock faverChipBlock = (FaverChipBlock)this.vBlock.get(n);
                if (!this.isBlockInTheSameArea(faverChipBlock, faverChipService)) continue;
                if (faverChipBlock.division == 6) {
                    int n2 = n;
                    while (true) {
                        faverChipBlock = (FaverChipBlock)this.vBlock.get(n2);
                        if (faverChipBlock.division != 6) break block0;
                        faverChipBlock.parentCode = faverChipService.code & 0xFFC0;
                        ++n2;
                    }
                }
                if (faverChipBlock.division == 5) {
                    if ((((FaverChipService)faverChipBlock).code & 0x20) != 0) {
                        ++n;
                        continue;
                    }
                    if ((((FaverChipService)faverChipBlock).code & 0xFFC0) == (faverChipService.code & 0xFFC0) && this.getAccessMethod((FaverChipService)faverChipBlock) == this.getAccessMethod(faverChipService)) continue;
                    this.errorMessage = "FC_ERR_NO_USER_DATA";
                    return false;
                }
                if (faverChipBlock.division == 0) continue;
                this.errorMessage = "FC_ERR_NO_USER_DATA";
                return false;
            }
            if (n == this.vBlock.size()) {
                this.errorMessage = "FC_ERR_NO_USER_DATA";
                return false;
            }
        }
        return bl;
    }

    private boolean checkUserData(FaverChipUserData faverChipUserData) {
        int n;
        boolean bl = false;
        for (n = faverChipUserData.position - 1; n >= 0; --n) {
            FaverChipBlock faverChipBlock = (FaverChipBlock)this.vBlock.get(n);
            if (!this.isBlockInTheSameArea(faverChipBlock, faverChipUserData)) continue;
            if (faverChipBlock.division == 5) {
                if ((((FaverChipService)faverChipBlock).code & 0x20) != 0) {
                    if (faverChipUserData.position - n > 1) {
                        int n2 = n - 1;
                        while (n >= 0) {
                            FaverChipBlock faverChipBlock2 = (FaverChipBlock)this.vBlock.get(n);
                            if (faverChipBlock2.division == 5) {
                                if ((((FaverChipService)faverChipBlock2).code & 0x20) == 0) {
                                    faverChipUserData.parentCode = ((FaverChipService)faverChipBlock2).code & 0xFFC0;
                                    faverChipUserData.accessMethod = this.getAccessMethod((FaverChipService)faverChipBlock2);
                                    bl = true;
                                    break;
                                }
                            } else if (faverChipBlock2.division != 0 && faverChipBlock2.division != 6) {
                                this.errorMessage = "FC_ERR_NO_BELONG";
                                break;
                            }
                            --n;
                        }
                        if (n2 != -1) break;
                        this.errorMessage = "FC_ERR_NO_BELONG";
                        break;
                    }
                    faverChipUserData.parentCode = ((FaverChipService)faverChipBlock).code;
                    faverChipUserData.accessMethod = 0;
                    bl = true;
                    break;
                }
                faverChipUserData.parentCode = ((FaverChipService)faverChipBlock).code & 0xFFC0;
                faverChipUserData.accessMethod = this.getAccessMethod((FaverChipService)faverChipBlock);
                bl = true;
                break;
            }
            if (faverChipBlock.division == 0 || faverChipBlock.division == 6) continue;
            this.errorMessage = "FC_ERR_NO_BELONG";
            break;
        }
        if (n == -1) {
            this.errorMessage = "FC_ERR_NO_BELONG";
        }
        return bl;
    }

    private boolean checkEndServiceCode(FaverChipArea faverChipArea) {
        boolean bl = false;
        Vector vector = this.manager.getAreaVector();
        int n = 65535;
        for (int i = 0; i < vector.size(); ++i) {
            FaverChipArea faverChipArea2 = (FaverChipArea)vector.get(i);
            if (!this.isBlockInTheSameArea(faverChipArea, faverChipArea2) || faverChipArea2.code == faverChipArea.code) continue;
            if (faverChipArea.code > faverChipArea.endService) break;
            if (faverChipArea2.code != faverChipArea.parentCode) continue;
            if (faverChipArea2.code >= faverChipArea.code || faverChipArea.endService > faverChipArea2.endService) break;
            bl = true;
            break;
        }
        if (!bl) {
            this.errorMessage = "FC_ERR_INVALID_ENDCODE";
        }
        return bl;
    }

    private boolean checkAreaBlockNum(FaverChipArea faverChipArea) {
        boolean bl = false;
        Vector vector = this.manager.getAreaVector();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            FaverChipArea faverChipArea2 = (FaverChipArea)vector.get(i);
            if (!this.isBlockInTheSameArea(faverChipArea, faverChipArea2)) continue;
            if (faverChipArea2.parentCode == faverChipArea.parentCode && faverChipArea2.code != faverChipArea.code && faverChipArea2.position != 3 && faverChipArea2.position != 289) {
                n += faverChipArea2.blockNum;
            }
            if (faverChipArea2.code != faverChipArea.parentCode) continue;
            n2 = faverChipArea2.blockNum;
        }
        if (faverChipArea.blockNum <= n2 - n) {
            bl = true;
        }
        if (!bl) {
            this.errorMessage = "FC_ERR_INVALID_BLOCK_NUM";
        }
        return bl;
    }

    private boolean checkCode(FaverChipBlock faverChipBlock) {
        int n;
        boolean bl = false;
        Vector vector = this.manager.getAreaVector();
        int n2 = 65535;
        int n3 = 0;
        if (faverChipBlock.division == 4) {
            n = ((FaverChipArea)faverChipBlock).code;
        } else if (faverChipBlock.division == 5) {
            n = ((FaverChipService)faverChipBlock).code;
        } else {
            this.errorMessage = "FC_ERR_DATA_BREAKS";
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            FaverChipArea faverChipArea = (FaverChipArea)vector.get(i);
            if (!this.isBlockInTheSameArea(faverChipBlock, faverChipArea) || faverChipBlock.division == 4 && faverChipArea.code == n || faverChipArea.code >= n || n > faverChipArea.endService || n2 <= faverChipArea.endService - faverChipArea.code) continue;
            n2 = faverChipArea.endService - faverChipArea.code;
            n3 = faverChipArea.code;
            bl = true;
        }
        if (!bl) {
            this.errorMessage = "FC_ERR_NOT_FIND_PARENT" + (faverChipBlock.division == 4 ? "_AR" : "_SV");
        } else if (faverChipBlock.division == 4) {
            ((FaverChipArea)faverChipBlock).parentCode = n3;
        } else if (faverChipBlock.division == 5) {
            ((FaverChipService)faverChipBlock).parentCode = n3;
        }
        return bl;
    }

    private boolean checkAttribute(FaverChipBlock faverChipBlock) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (faverChipBlock.division == 4) {
            n = 0x1F & ((FaverChipArea)faverChipBlock).code;
            if (n == 0 || n == 1) {
                bl = true;
            }
        } else if (faverChipBlock.division == 5) {
            n = 0x1F & ((FaverChipService)faverChipBlock).code;
            if (8 <= n && n <= 23) {
                bl = true;
            } else if ((n == 0 || n == 1) && (0x20 & ((FaverChipService)faverChipBlock).code) != 0) {
                bl = true;
            }
            if (!bl && (0x20 & ((FaverChipService)faverChipBlock).code) != 0) {
                bl2 = true;
            }
        } else {
            this.errorMessage = "FC_ERR_DATA_BREAKS";
            return false;
        }
        if (!bl) {
            this.errorMessage = bl2 ? "FC_ERR_INVALID_PIN_ATTR" : "FC_ERR_INVALID_ATTR" + (faverChipBlock.division == 4 ? "_AR" : "_SV");
        }
        return bl;
    }

    private boolean checkCodeOverlap(FaverChipBlock faverChipBlock) {
        boolean bl = true;
        if (faverChipBlock.division == 4) {
            Vector vector = this.manager.getAreaVector();
            for (int i = 0; i < vector.size(); ++i) {
                FaverChipArea faverChipArea = (FaverChipArea)vector.get(i);
                if (!this.isBlockInTheSameArea(faverChipBlock, faverChipArea) || faverChipArea.position == faverChipBlock.position || faverChipArea.code != ((FaverChipArea)faverChipBlock).code) continue;
                bl = false;
                break;
            }
        } else if (faverChipBlock.division == 5) {
            Vector vector = this.manager.getServiceVector();
            for (int i = 0; i < vector.size(); ++i) {
                FaverChipService faverChipService = (FaverChipService)vector.get(i);
                if (!this.isBlockInTheSameArea(faverChipBlock, faverChipService) || faverChipService.position == faverChipBlock.position || faverChipService.code != ((FaverChipService)faverChipBlock).code) continue;
                bl = false;
                break;
            }
        } else {
            this.errorMessage = "FC_ERR_DATA_BREAKS";
            return false;
        }
        if (!bl) {
            this.errorMessage = "FC_ERR_OVERLAP_CODE" + (faverChipBlock.division == 4 ? "_AR" : "_SV");
        }
        return bl;
    }

    private boolean isBlockInTheSameArea(FaverChipBlock faverChipBlock, FaverChipBlock faverChipBlock2) {
        boolean bl = true;
        if (faverChipBlock.position < 286) {
            if (286 <= faverChipBlock2.position) {
                bl = false;
            }
        } else if (faverChipBlock2.position < 286) {
            bl = false;
        }
        return bl;
    }

    String getErrorMessage() {
        String string = "";
        String string2 = "";
        if (this.detectPos == -1) {
            if (this.errorMessage != null) {
                string = Resource.getString(this.errorMessage);
            }
        } else {
            string2 = this.int2HexString(this.detectPos * 16, 65535, 4);
            if (this.errorMessage != null) {
                string = Resource.format(this.errorMessage, string2);
            }
        }
        return string;
    }

    private String int2HexString(int n, int n2, int n3) {
        if (n3 < 1 || 8 < n3) {
            return null;
        }
        String string = Integer.toHexString(n2 & n);
        for (int i = string.length(); i < n3; ++i) {
            string = "0" + string;
        }
        string = "0x" + string;
        return string;
    }
}

