/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.iapplibrary;

import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.Code;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.ConstantPool;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.JavaClass;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.Method;
import com.nttdocomo.dojaemu.ktoolbar.iapplibrary.IAppLibFileList;
import com.nttdocomo.dojaemu.ktoolbar.iapplibrary.IAppLibManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class IAppLibInclude {
    private IAppLibManager libManager = null;
    private TreeSet needClass = new TreeSet();
    private TreeSet needClassName = new TreeSet();
    private Vector classList = new Vector();
    private static int REMAINS_LIST = 1;
    private static int INCLUDE_LIST = 2;
    private static final String CLASS_EXTENSION = ".class";

    public void setClassesList(String string, String string2) throws Exception {
        JavaClass javaClass = null;
        this.libManager = new IAppLibManager(string2);
        if (this.libManager.size() == 0) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        IAppLibFileList iAppLibFileList = new IAppLibFileList(string);
        ArrayList arrayList = iAppLibFileList.getFileList(CLASS_EXTENSION);
        if (arrayList.size() == 0) {
            return;
        }
        treeSet.addAll(arrayList);
        while (true) {
            this.classList.clear();
            this.createJavaClass(treeSet);
            for (int i = 0; i < this.classList.size(); ++i) {
                javaClass = (JavaClass)this.classList.get(i);
                this.analysis(javaClass);
                if (this.libManager.size(REMAINS_LIST) == 0) break;
            }
            if (this.libManager.size(INCLUDE_LIST) <= 0) break;
            String[] stringArray = this.libManager.getList(INCLUDE_LIST);
            String[] stringArray2 = this.libManager.getListForCompare(INCLUDE_LIST);
            treeSet.clear();
            treeSet.addAll(Arrays.asList(stringArray));
            this.needClass.addAll(Arrays.asList(stringArray));
            this.needClassName.addAll(Arrays.asList(stringArray2));
            this.libManager.clearList(INCLUDE_LIST);
        }
    }

    private void createJavaClass(Collection collection) throws Exception {
        BufferedInputStream bufferedInputStream = null;
        byte[] byArray = null;
        long l = 0L;
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            l = new File(string).length();
            byArray = new byte[(int)l];
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            n = 0;
            while ((long)(n += bufferedInputStream.read(byArray, n, (int)l - n)) < l) {
            }
            bufferedInputStream.close();
            this.classList.add(new JavaClass(byArray));
        }
    }

    private void createJavaClass(String string) throws Exception {
        IAppLibFileList iAppLibFileList = new IAppLibFileList(string);
        ArrayList arrayList = iAppLibFileList.getFileList(CLASS_EXTENSION);
        this.createJavaClass(arrayList);
    }

    private void analysis(JavaClass javaClass) {
        ConstantPool constantPool;
        for (int i = 1; !(i >= javaClass.getConstantPoolCount() || (constantPool = javaClass.getConstantPool(i)) != null && constantPool.getTag() == 7 && this.checkLibrary(constantPool.getDetailString()) && this.libManager.size(REMAINS_LIST) == 0); ++i) {
        }
        if (this.libManager.size(REMAINS_LIST) == 0) {
            return;
        }
        Method[] methodArray = javaClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Code code = methodArray[i].getCodes();
            if (code == null) continue;
            Vector vector = code.getDetailArray();
            Iterator iterator = vector.iterator();
            String string = "";
            while (iterator.hasNext()) {
                Vector vector2 = (Vector)iterator.next();
                if (vector2.get(1).toString().startsWith("invoke")) {
                    string = (String)vector2.get(2);
                }
                if (!this.checkLibrary(string) || this.libManager.size(REMAINS_LIST) != 0) continue;
            }
        }
    }

    private boolean checkLibrary(String string) {
        boolean bl = false;
        if (string == null || string.length() == 0) {
            return bl;
        }
        if (this.libManager == null) {
            return bl;
        }
        if (this.libManager.size(REMAINS_LIST) == 0) {
            return bl;
        }
        if (this.libManager.containsCmp(INCLUDE_LIST, string)) {
            return bl;
        }
        if (this.needClassName.contains(string)) {
            return bl;
        }
        if (!this.libManager.containsCmp(REMAINS_LIST, string)) {
            return bl;
        }
        String[] stringArray = this.libManager.getList(REMAINS_LIST);
        String[] stringArray2 = this.libManager.getListForCompare(REMAINS_LIST);
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!string.equals(stringArray2[i])) continue;
            this.libManager.forwarding(stringArray[i]);
            bl = true;
            break;
        }
        return bl;
    }

    public Collection getNeedLibraryClass() {
        if (this.libManager == null) {
            return null;
        }
        return this.needClass;
    }

    public Collection getNeedClassName() {
        if (this.libManager == null) {
            return null;
        }
        return this.needClassName;
    }

    public Collection getNoUseClass() {
        if (this.libManager == null) {
            return null;
        }
        String[] stringArray = this.libManager.getList(REMAINS_LIST);
        return Arrays.asList(stringArray);
    }

    public Collection getNoUseClassName() {
        if (this.libManager == null) {
            return null;
        }
        String[] stringArray = this.libManager.getListForCompare(REMAINS_LIST);
        return Arrays.asList(stringArray);
    }

    Collection getAllLibraryClass() {
        if (this.libManager == null) {
            return null;
        }
        String[] stringArray = this.libManager.getList(0);
        return Arrays.asList(stringArray);
    }
}

