/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.makejavadoc;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.makejavadoc.AssortOptions;
import com.nttdocomo.dojaemu.ktoolbar.makejavadoc.ExecuteProcess;
import com.nttdocomo.dojaemu.ktoolbar.makejavadoc.MakeDocActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.makejavadoc.MakeDocWindowAdapter;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MakeDocWindow
extends JDialog {
    private MainWindow parent;
    private JTextField sourceDirField;
    private JTextField outputDocField;
    private JTextField windowTitleField;
    private JComboBox outputLevelComboBox;
    private JTextArea consoleTextArea;
    private final String JAVADOC_PROP = "javadoc.properties";
    private final String entryListName = "component.list";
    private AssortOptions assortOptions;
    private ADF adf;
    private String projectPath;
    private String bootClassPath;
    private final String[] OUTPUT_LEVEL = new String[]{"public", "protected", "package", "private"};

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        MakeDocWindow makeDocWindow = new MakeDocWindow();
    }

    private MakeDocWindow() {
        this.makeWindow();
        this.setVisible(true);
    }

    public MakeDocWindow(MainWindow mainWindow, ADF aDF, String string, String string2) {
        super(mainWindow, Resource.getString("JDOC_WINDOW_TITLE"), true);
        this.parent = mainWindow;
        this.adf = aDF;
        this.projectPath = string;
        this.bootClassPath = string2;
        this.makeWindow();
    }

    private void makeWindow() {
        String string;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        MakeDocActionDispatcher makeDocActionDispatcher = new MakeDocActionDispatcher(this);
        this.addWindowListener(new MakeDocWindowAdapter(this));
        this.assortOptions = new AssortOptions(this.projectPath + File.separator + "javadoc.properties");
        String string2 = this.assortOptions.getOptionValue("srcdir");
        String string3 = this.assortOptions.getOptionValue("windowtitle");
        String string4 = this.assortOptions.getOptionValue("level");
        String string5 = this.assortOptions.getOptionValue("d");
        this.sourceDirField = new JTextField(50);
        this.outputDocField = new JTextField(50);
        this.windowTitleField = new JTextField(50);
        if (string2 != null && !string2.equals("")) {
            this.sourceDirField.setText(string2);
        } else {
            string = this.projectPath + File.separator + "src";
            this.sourceDirField.setText(string);
        }
        if (string5 != null && !string5.equals("")) {
            this.outputDocField.setText(string5);
        } else {
            string = this.projectPath + File.separator + "doc";
            this.outputDocField.setText(string);
        }
        if (string3 != null) {
            this.windowTitleField.setText(string3);
        } else {
            string = this.adf.getProperty("AppName");
            if (string != null) {
                this.windowTitleField.setText(string);
            }
        }
        this.outputLevelComboBox = new JComboBox<String>(this.OUTPUT_LEVEL);
        int n = 1;
        if (string4.equals("private")) {
            n = 3;
        } else if (string4.equals("package")) {
            n = 2;
        } else if (string4.equals("public")) {
            n = 0;
        }
        this.outputLevelComboBox.setSelectedIndex(n);
        JButton jButton = new JButton(Resource.getString("SELECT_DIR"));
        JButton jButton2 = new JButton(Resource.getString("SELECT_DIR"));
        JButton jButton3 = new JButton(Resource.getString("SET_UP"));
        JButton jButton4 = new JButton(Resource.getString("CLOSE"));
        JButton jButton5 = new JButton(Resource.getString("MAKE"));
        JButton jButton6 = new JButton(Resource.getString("CLEAR"));
        jButton.setActionCommand("selectSource");
        jButton2.setActionCommand("selectOutputDoc");
        jButton3.setActionCommand("save");
        jButton4.setActionCommand("close");
        jButton5.setActionCommand("doJavadoc");
        jButton6.setActionCommand("clear");
        jButton.addActionListener(makeDocActionDispatcher);
        jButton2.addActionListener(makeDocActionDispatcher);
        jButton3.addActionListener(makeDocActionDispatcher);
        jButton4.addActionListener(makeDocActionDispatcher);
        jButton5.addActionListener(makeDocActionDispatcher);
        jButton6.addActionListener(makeDocActionDispatcher);
        this.consoleTextArea = new JTextArea(10, 0);
        this.consoleTextArea.setEditable(false);
        JLabel jLabel = new JLabel(Resource.getString("JDOC_LABEL_SRC_DIR"));
        JLabel jLabel2 = new JLabel(Resource.getString("JDOC_LABEL_WINDOW_TITLE"));
        JLabel jLabel3 = new JLabel(Resource.getString("JDOC_LABEL_OUTPUT_LEVEL"));
        JLabel jLabel4 = new JLabel(Resource.getString("JDOC_LABEL_OUTPUT_DIR"));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.consoleTextArea);
        jPanel.setLayout(new FlowLayout(1));
        jPanel2.setLayout(new FlowLayout(1));
        jPanel7.setLayout(new FlowLayout(0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel4.setLayout(new FlowLayout(0));
        jPanel5.setLayout(new FlowLayout(0));
        jPanel6.setLayout(new FlowLayout(0));
        jPanel4.add(jLabel);
        jPanel4.add(this.sourceDirField);
        jPanel4.add(jButton);
        jPanel5.add(jLabel2);
        jPanel5.add(this.windowTitleField);
        jPanel6.add(jLabel3);
        jPanel6.add(this.outputLevelComboBox);
        jPanel7.add(jLabel4);
        jPanel7.add(this.outputDocField);
        jPanel7.add(jButton2);
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel6);
        jPanel3.add(jPanel7);
        jPanel.add(jPanel3);
        jPanel2.add(jButton6);
        jPanel2.add(jButton3);
        jPanel2.add(jButton4);
        jPanel2.add(jButton5);
        container.add("North", jPanel);
        container.add("Center", jScrollPane);
        container.add("South", jPanel2);
        int n2 = jLabel.getPreferredSize().width;
        if (n2 < jLabel2.getPreferredSize().width) {
            n2 = jLabel2.getPreferredSize().width;
        }
        if (n2 < jLabel3.getPreferredSize().width) {
            n2 = jLabel3.getPreferredSize().width;
        }
        if (n2 < jLabel4.getPreferredSize().width) {
            n2 = jLabel4.getPreferredSize().width;
        }
        Dimension dimension = new Dimension(n2, jLabel.getPreferredSize().height);
        jLabel.setPreferredSize(dimension);
        jLabel2.setPreferredSize(dimension);
        jLabel3.setPreferredSize(dimension);
        jLabel4.setPreferredSize(dimension);
        this.pack();
    }

    private String openFileDialog(String string, String string2) {
        String string3 = null;
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setDialogTitle(string2);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            string3 = jFileChooser.getSelectedFile().toString();
        }
        return string3;
    }

    void selectSource() {
        String string;
        String string2 = new File(this.sourceDirField.getText()).getAbsolutePath();
        String string3 = this.openFileDialog(string2, string = Resource.getString("JDOC_FDLG_TITLE_SRC"));
        if (string3 != null) {
            this.sourceDirField.setText(string3);
        }
    }

    void selectOutputDoc() {
        String string;
        String string2 = new File(this.outputDocField.getText()).getAbsolutePath();
        String string3 = this.openFileDialog(string2, string = Resource.getString("JDOC_FDLG_TITLE_HTML"));
        if (string3 != null) {
            this.outputDocField.setText(string3);
        }
    }

    void close() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.parent.closeWindow(this);
        }
    }

    void clear() {
        this.consoleTextArea.setText("");
    }

    void save() {
        String string;
        int n;
        String string2;
        String string3 = this.sourceDirField.getText();
        if (string3 != null) {
            this.assortOptions.setOptionValue("srcdir", string3);
        }
        if ((string2 = this.outputDocField.getText()) != null) {
            this.assortOptions.setOptionValue("d", string2);
        }
        if ((n = this.outputLevelComboBox.getSelectedIndex()) != -1) {
            this.assortOptions.setOptionValue("level", this.OUTPUT_LEVEL[n]);
        }
        if ((string = this.windowTitleField.getText()) != null) {
            this.assortOptions.setOptionValue("windowtitle", string);
        }
        if (this.assortOptions.save()) {
            this.consoleTextArea.append(Resource.format("UPDATE_FILE", Resource.getString("JDOC_SETTING_FILE")) + "\n");
        } else {
            this.consoleTextArea.append(Resource.format("WRITE_ERR", Resource.getString("JDOC_SETTING_FILE")) + "\n");
        }
    }

    private boolean checkTextField() {
        String string = this.sourceDirField.getText();
        if (string != null && !string.equals("")) {
            if (!new File(string).exists()) {
                this.consoleTextArea.append(Resource.getString("JDOC_MSG_NONEXISTENT_DIR"));
                return false;
            }
        } else {
            this.consoleTextArea.append(Resource.getString("JDOC_MSG_INVALID_SRC_DIR"));
            return false;
        }
        String string2 = this.outputDocField.getText();
        if (string2 == null || string2.equals("")) {
            this.consoleTextArea.append(Resource.getString("JDOC_MSG_INVALID_DOC_DIR"));
            return false;
        }
        return true;
    }

    void doJavadoc() {
        Object object;
        Vector vector;
        String string = System.getProperty("jdk.home") + File.separator + "bin" + File.separator + "javadoc.exe";
        if (!new File(string).exists()) {
            this.consoleTextArea.append(Resource.getString("JDOC_MSG_NOTFIND_EXEFILE") + Resource.getString("JDOC_MSG_DISCONTINUE"));
            return;
        }
        if (!this.checkTextField()) {
            this.consoleTextArea.append(Resource.getString("JDOC_MSG_DISCONTINUE"));
            return;
        }
        Vector<String> vector2 = new Vector<String>();
        vector2.add(string);
        String string2 = this.assortOptions.getOptionValue("locale");
        if (string2 != null) {
            vector2.add("-locale");
            vector2.add(string2);
        }
        vector2.add("-bootclasspath");
        vector2.add(this.bootClassPath);
        int n = this.outputLevelComboBox.getSelectedIndex();
        if (n != -1) {
            vector2.add("-" + this.OUTPUT_LEVEL[n]);
        }
        vector2.add("-d");
        vector2.add(this.outputDocField.getText());
        String string3 = this.windowTitleField.getText();
        if (string3 != null && !string3.equals("")) {
            vector2.add("-windowtitle");
            vector2.add(string3);
        }
        if ((vector = this.assortOptions.getCommandOptions(this.consoleTextArea)).size() > 0) {
            vector2.addAll(vector);
        }
        String string4 = this.assortOptions.getOptionValue("packagenames");
        String string5 = this.assortOptions.getOptionValue("subpackages");
        if (string4 != null && !string4.equals("") || string5 != null && !string5.equals("")) {
            object = this.assortOptions.getOptionValue("sourcepath");
            if (object == null) {
                vector2.add("-sourcepath");
                vector2.add(this.sourceDirField.getText());
            }
        } else {
            object = this.assortOptions.getFileList(this.sourceDirField.getText());
            if (object.size() > 0) {
                vector2.addAll((Collection<String>)object);
            } else {
                this.consoleTextArea.append(Resource.getString("JDOC_MSG_INVALID_SRC_DIR") + Resource.getString("JDOC_MSG_DISCONTINUE"));
                return;
            }
        }
        if ((string5 == null || string5.equals("")) && string4 != null && !string4.equals("") && (object = this.assortOptions.getPackages()) != null) {
            for (int i = 0; i < ((String[])object).length; ++i) {
                vector2.add(object[i]);
            }
        }
        object = vector2.toArray(new String[0]);
        this.consoleTextArea.append(Resource.getString("JDOC_MSG_RUN_MAKING"));
        try {
            ExecuteProcess executeProcess = new ExecuteProcess((String[])object, this.consoleTextArea);
            if (executeProcess.execute() != 0) {
                this.consoleTextArea.append(Resource.getString("JDOC_MSG_ABNORMAL_MAKING"));
                return;
            }
            this.save();
        }
        catch (Exception exception) {
            this.consoleTextArea.append(Resource.getString("JDOC_MSG_ABNORMAL_END"));
            return;
        }
        this.consoleTextArea.append(Resource.getString("JDOC_MSG_FINISH_MAKING"));
    }

    private void showDialog(String string, int n) {
        JOptionPane jOptionPane = new JOptionPane(string, n);
        JDialog jDialog = jOptionPane.createDialog(this, n == 0 ? Resource.getString("ERR") : Resource.getString("WNG"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
    }
}

